/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector;

import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasBaseClient;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSAuditCode;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSMetadataCollection;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheAtlasOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    private static final Logger log = LoggerFactory.getLogger(ApacheAtlasOMRSRepositoryConnector.class);
    public static final String EP_ENTITY = "/api/atlas/v2/entity/guid/";
    private String url;
    private AtlasClientV2 atlasClient;
    private boolean successfulInit = false;

    public OMRSMetadataCollection getMetadataCollection() throws RepositoryErrorException {
        String methodName = "getMetadataCollection";
        if (this.metadataCollection == null) {
            try {
                this.connectToAtlas("getMetadataCollection");
            }
            catch (ConnectorCheckedException e) {
                this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.REST_CLIENT_FAILURE, "getMetadataCollection", e, this.getServerName());
            }
        }
        return super.getMetadataCollection();
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        ApacheAtlasOMRSAuditCode auditCode = ApacheAtlasOMRSAuditCode.REPOSITORY_SERVICE_STARTING;
        this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        if (this.metadataCollection == null) {
            this.connectToAtlas("start");
        }
        auditCode = ApacheAtlasOMRSAuditCode.REPOSITORY_SERVICE_STARTED;
        this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.getServerName()), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    public void disconnect() {
        ApacheAtlasOMRSAuditCode auditCode = ApacheAtlasOMRSAuditCode.REPOSITORY_SERVICE_SHUTDOWN;
        this.auditLog.logRecord("disconnect", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.getServerName()), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    public String getBaseURL() {
        return this.url;
    }

    public boolean typeDefExistsByName(String name) {
        return this.atlasClient.typeWithNameExists(name);
    }

    public AtlasStructDef getTypeDefByName(String name, TypeDefCategory typeDefCategory) throws AtlasServiceException {
        AtlasClassificationDef result = null;
        switch (typeDefCategory) {
            case CLASSIFICATION_DEF: {
                result = this.atlasClient.getClassificationDefByName(name);
                break;
            }
            case ENTITY_DEF: {
                result = this.atlasClient.getEntityDefByName(name);
                break;
            }
            case RELATIONSHIP_DEF: {
                String atlasPath = "relationshipdef";
                AtlasBaseClient.API api = new AtlasBaseClient.API(String.format("api/atlas/v2/types/%s/name/%s", atlasPath, name), "GET", Response.Status.OK);
                result = (AtlasStructDef)this.atlasClient.callAPI(api, AtlasRelationshipDef.class, null);
                break;
            }
        }
        return result;
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityByGUID(String guid) throws AtlasServiceException {
        return this.getEntityByGUID(guid, false, true);
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityByGUID(String guid, boolean minimalExtraInfo, boolean ignoreRelationships) throws AtlasServiceException {
        return this.atlasClient.getEntityByGuid(guid, minimalExtraInfo, ignoreRelationships);
    }

    public AtlasRelationship.AtlasRelationshipWithExtInfo getRelationshipByGUID(String guid) throws AtlasServiceException {
        return this.getRelationshipByGUID(guid, false);
    }

    public AtlasRelationship.AtlasRelationshipWithExtInfo getRelationshipByGUID(String guid, boolean extendedInfo) throws AtlasServiceException {
        return this.atlasClient.getRelationshipByGuid(guid, extendedInfo);
    }

    public AtlasTypesDef createTypeDef(AtlasTypesDef typeDefs) throws AtlasServiceException {
        return this.atlasClient.createAtlasTypeDefs(typeDefs);
    }

    public AtlasSearchResult searchForEntities(SearchParameters searchParameters) throws AtlasServiceException {
        log.debug("Searching Atlas with: {}", (Object)searchParameters);
        return this.atlasClient.facetedSearch(searchParameters);
    }

    public AtlasSearchResult searchWithDSL(String dslQuery) throws AtlasServiceException {
        log.debug("Searching Atlas with: {}", (Object)dslQuery);
        return this.atlasClient.dslSearch(dslQuery);
    }

    public EntityMutationResponse saveEntity(AtlasEntity.AtlasEntityWithExtInfo atlasEntity, boolean create) throws AtlasServiceException {
        EntityMutationResponse result = create ? this.atlasClient.createEntity(atlasEntity) : this.atlasClient.updateEntity(atlasEntity);
        return result;
    }

    private void connectToAtlas(String methodName) throws ConnectorCheckedException {
        EndpointProperties endpointProperties = this.connectionProperties.getEndpoint();
        if (endpointProperties == null) {
            this.raiseConnectorCheckedException(ApacheAtlasOMRSErrorCode.REST_CLIENT_FAILURE, methodName, null, "null");
        } else {
            this.url = endpointProperties.getProtocol() + "://" + endpointProperties.getAddress();
            ApacheAtlasOMRSAuditCode auditCode = ApacheAtlasOMRSAuditCode.CONNECTING_TO_ATLAS;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.getBaseURL()), null, auditCode.getSystemAction(), auditCode.getUserAction());
            String username = this.connectionProperties.getUserId();
            String password = this.connectionProperties.getClearPassword();
            this.atlasClient = new AtlasClientV2(new String[]{this.getBaseURL()}, new String[]{username, password});
            AtlasTypesDef atlasTypes = null;
            try {
                atlasTypes = this.atlasClient.getAllTypeDefs(new SearchFilter());
                this.successfulInit = atlasTypes != null && atlasTypes.hasEntityDef("Referenceable");
            }
            catch (AtlasServiceException e) {
                this.raiseConnectorCheckedException(ApacheAtlasOMRSErrorCode.REST_CLIENT_FAILURE, methodName, e, this.getBaseURL());
            }
            if (!this.successfulInit) {
                this.raiseConnectorCheckedException(ApacheAtlasOMRSErrorCode.REST_CLIENT_FAILURE, methodName, null, this.getBaseURL());
            } else {
                auditCode = ApacheAtlasOMRSAuditCode.CONNECTED_TO_ATLAS;
                this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.getBaseURL()), null, auditCode.getSystemAction(), auditCode.getUserAction());
                this.metadataCollection = new ApacheAtlasOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, this.metadataCollectionId);
            }
        }
    }

    private void raiseConnectorCheckedException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws ConnectorCheckedException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }

    private void raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }
}

