/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.BaseTypeDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.ClassificationDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;

public abstract class EntityDefMapping
extends BaseTypeDefMapping {
    private EntityDefMapping() {
    }

    public static void addEntityTypeToAtlas(EntityDef omrsEntityDef, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore, ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector) throws TypeDefNotSupportedException {
        String methodName = "addEntityTypeToAtlas";
        String omrsTypeDefName = omrsEntityDef.getName();
        boolean fullyCovered = true;
        AtlasEntityDef entityTypeDef = new AtlasEntityDef();
        EntityDefMapping.setupBaseMapping((TypeDef)omrsEntityDef, (AtlasBaseTypeDef)entityTypeDef);
        TypeDefLink supertype = omrsEntityDef.getSuperType();
        if (supertype != null) {
            String atlasSupertypeName = typeDefStore.getMappedAtlasTypeDefName(supertype.getName(), null);
            if (atlasSupertypeName != null) {
                HashSet<String> supertypes = new HashSet<String>();
                supertypes.add(atlasSupertypeName);
                entityTypeDef.setSuperTypes(supertypes);
            } else {
                fullyCovered = false;
            }
        }
        boolean bl = fullyCovered = fullyCovered && EntityDefMapping.setupPropertyMappings((TypeDef)omrsEntityDef, (AtlasStructDef)entityTypeDef, attributeDefStore);
        if (fullyCovered) {
            AtlasTypesDef atlasTypesDef = new AtlasTypesDef();
            ArrayList<AtlasEntityDef> entityList = new ArrayList<AtlasEntityDef>();
            entityList.add(entityTypeDef);
            atlasTypesDef.setEntityDefs(entityList);
            try {
                atlasRepositoryConnector.createTypeDef(atlasTypesDef);
                typeDefStore.addTypeDef((TypeDef)omrsEntityDef);
            }
            catch (AtlasServiceException e) {
                typeDefStore.addUnimplementedTypeDef((TypeDef)omrsEntityDef);
                EntityDefMapping.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "addEntityTypeToAtlas", e, omrsTypeDefName, atlasRepositoryConnector.getRepositoryName());
            }
        } else {
            typeDefStore.addUnimplementedTypeDef((TypeDef)omrsEntityDef);
            EntityDefMapping.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "addEntityTypeToAtlas", null, omrsTypeDefName, atlasRepositoryConnector.getRepositoryName());
        }
    }

    private static void raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws TypeDefNotSupportedException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new TypeDefNotSupportedException(errorCode.getHTTPErrorCode(), ClassificationDefMapping.class.getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }
}

