/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSMetadataCollection;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.AttributeMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.SequencingUtils;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMappingAtlas2OMRS {
    private static final Logger log = LoggerFactory.getLogger(EntityMappingAtlas2OMRS.class);
    private ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector;
    private TypeDefStore typeDefStore;
    private AttributeTypeDefStore attributeDefStore;
    private AtlasEntity.AtlasEntityWithExtInfo atlasEntityWithExtInfo;
    private AtlasEntity atlasEntity;
    private String prefix;
    private String userId;

    public EntityMappingAtlas2OMRS(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore, AtlasEntity.AtlasEntityWithExtInfo instance, String prefix, String userId) {
        this.atlasRepositoryConnector = atlasRepositoryConnector;
        this.typeDefStore = typeDefStore;
        this.attributeDefStore = attributeDefStore;
        this.atlasEntityWithExtInfo = instance;
        this.atlasEntity = this.atlasEntityWithExtInfo.getEntity();
        this.prefix = prefix;
        this.userId = userId;
    }

    public EntitySummary getEntitySummary() throws RepositoryErrorException {
        EntitySummary summary = this.getSkeletonEntitySummary(this.prefix);
        this.setModAndVersionDetails(summary);
        this.addClassifications(summary);
        return summary;
    }

    public EntityDetail getEntityDetail() throws RepositoryErrorException {
        String methodName = "getEntityDetail";
        String atlasTypeDefName = this.atlasEntity.getTypeName();
        String omrsTypeDefName = this.typeDefStore.getMappedOMRSTypeDefName(atlasTypeDefName, this.prefix);
        if (log.isInfoEnabled()) {
            log.info("Found mapped type for Atlas type '{}' with prefix '{}': {}", new Object[]{atlasTypeDefName, this.prefix, omrsTypeDefName});
        }
        EntityDetail detail = null;
        if (omrsTypeDefName != null) {
            detail = this.getSkeletonEntityDetail(omrsTypeDefName, this.prefix);
            if (detail != null) {
                InstanceProperties instanceProperties = new InstanceProperties();
                OMRSRepositoryHelper omrsRepositoryHelper = this.atlasRepositoryConnector.getRepositoryHelper();
                String repositoryName = this.atlasRepositoryConnector.getRepositoryName();
                Map<String, TypeDefAttribute> omrsAttributeMap = this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeDefName);
                Map<String, String> atlasToOmrsProperties = this.typeDefStore.getPropertyMappingsForAtlasTypeDef(atlasTypeDefName, this.prefix);
                Map atlasProperties = this.atlasEntity.getAttributes();
                if (atlasProperties != null) {
                    HashSet<String> alreadyMapped = new HashSet<String>();
                    for (Map.Entry<String, String> property : atlasToOmrsProperties.entrySet()) {
                        String atlasProperty = property.getKey();
                        String omrsProperty = property.getValue();
                        if (omrsAttributeMap.containsKey(omrsProperty)) {
                            TypeDefAttribute typeDefAttribute = omrsAttributeMap.get(omrsProperty);
                            instanceProperties = AttributeMapping.addPropertyToInstance(omrsRepositoryHelper, repositoryName, typeDefAttribute, instanceProperties, this.attributeDefStore, atlasProperties.get(atlasProperty), "getEntityDetail");
                            if (instanceProperties.getPropertyValue(omrsProperty) == null) continue;
                            alreadyMapped.add(atlasProperty);
                            continue;
                        }
                        if (!log.isWarnEnabled()) continue;
                        log.warn("No OMRS attribute {} defined for asset type {} -- skipping mapping.", (Object)omrsProperty, (Object)omrsTypeDefName);
                    }
                    HashMap<String, String> additionalProperties = new HashMap<String, String>();
                    Set nonRelationshipSet = atlasProperties.keySet();
                    nonRelationshipSet.removeAll(alreadyMapped);
                    for (String propertyName : nonRelationshipSet) {
                        Object propertyValue = atlasProperties.get(propertyName);
                        if (propertyValue == null) continue;
                        additionalProperties.put(propertyName, propertyValue.toString());
                    }
                    instanceProperties = omrsRepositoryHelper.addStringMapPropertyToInstance(repositoryName, instanceProperties, "additionalProperties", additionalProperties, "getEntityDetail");
                }
                detail.setProperties(instanceProperties);
                this.addClassifications((EntitySummary)detail);
            }
        } else if (log.isWarnEnabled()) {
            log.warn("No mapping defined from Atlas type '{}' with prefix '{}'", (Object)atlasTypeDefName, (Object)this.prefix);
        }
        return detail;
    }

    public List<Relationship> getRelationships(String relationshipTypeGUID, int fromRelationshipElement, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        Comparator<Relationship> comparator;
        String methodName = "getRelationships";
        ArrayList<Relationship> omrsRelationships = new ArrayList<Relationship>();
        String repositoryName = this.atlasRepositoryConnector.getRepositoryName();
        Map atlasRelationships = this.atlasEntity.getRelationshipAttributes();
        for (Map.Entry entry : atlasRelationships.entrySet()) {
            String string = (String)entry.getKey();
            ArrayList<LinkedHashMap> relationshipAssignments = null;
            Object atlasRelationshipValue = entry.getValue();
            if (atlasRelationshipValue instanceof List) {
                relationshipAssignments = (ArrayList<LinkedHashMap>)atlasRelationshipValue;
            } else if (atlasRelationshipValue instanceof LinkedHashMap) {
                relationshipAssignments = new ArrayList<LinkedHashMap>();
                relationshipAssignments.add((LinkedHashMap)atlasRelationshipValue);
            }
            if (relationshipAssignments == null) continue;
            for (LinkedHashMap valueToTranslate : relationshipAssignments) {
                String prefixForSelf;
                AtlasRelatedObjectId relationshipAssignment = new AtlasRelatedObjectId((Map)valueToTranslate);
                String atlasRelationshipType = relationshipAssignment.getRelationshipType();
                String omrsRelationshipType = this.typeDefStore.getMappedOMRSTypeDefName(atlasRelationshipType, null);
                if (omrsRelationshipType == null) continue;
                TypeDef omrsTypeDef = this.typeDefStore.getTypeDefByName(omrsRelationshipType);
                String omrsTypeDefGuid = omrsTypeDef.getGUID();
                if (relationshipTypeGUID != null && !omrsTypeDefGuid.equals(relationshipTypeGUID)) continue;
                TypeDefStore.Endpoint endpointOfRelated = this.typeDefStore.getMappedEndpointFromAtlasName(atlasRelationshipType, string, null);
                TypeDefStore.EndpointMapping mapping = this.typeDefStore.getEndpointMappingFromAtlasName(atlasRelationshipType, null);
                EntityProxy ep1 = null;
                EntityProxy ep2 = null;
                switch (endpointOfRelated) {
                    case ONE: {
                        try {
                            ep1 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasRepositoryConnector.getEntityByGUID(relationshipAssignment.getGuid(), true, true).getEntity(), mapping == null ? null : mapping.getPrefixOne(), this.userId);
                        }
                        catch (AtlasServiceException e) {
                            this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationships", e, relationshipAssignment.getGuid(), "getRelationships", repositoryName);
                        }
                        prefixForSelf = mapping == null ? null : mapping.getPrefixTwo();
                        ep2 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasEntity, prefixForSelf, this.userId);
                        break;
                    }
                    case TWO: {
                        prefixForSelf = mapping == null ? null : mapping.getPrefixOne();
                        ep1 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasEntity, prefixForSelf, this.userId);
                        try {
                            ep2 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasRepositoryConnector.getEntityByGUID(relationshipAssignment.getGuid(), true, true).getEntity(), mapping == null ? null : mapping.getPrefixTwo(), this.userId);
                        }
                        catch (AtlasServiceException e) {
                            this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationships", e, relationshipAssignment.getGuid(), "getRelationships", repositoryName);
                        }
                        break;
                    }
                    default: {
                        OMRSErrorCode errorCode = OMRSErrorCode.INVALID_RELATIONSHIP_ENDS;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getRelationships", repositoryName, omrsRelationshipType, string, null});
                        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), EntityMappingAtlas2OMRS.class.getName(), "getRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    }
                }
                if ((prefixForSelf != null || this.prefix != null) && (prefixForSelf == null || !prefixForSelf.equals(this.prefix))) continue;
                AtlasStruct attrsOnAtlasReln = relationshipAssignment.getRelationshipAttributes();
                Map atlasRelationshipProperties = null;
                if (attrsOnAtlasReln != null) {
                    atlasRelationshipProperties = attrsOnAtlasReln.getAttributes();
                }
                Relationship omrsRelationship = RelationshipMapping.getRelationship(this.atlasRepositoryConnector, this.typeDefStore, this.attributeDefStore, atlasRelationshipType, relationshipAssignment.getRelationshipGuid(), relationshipAssignment.getRelationshipStatus(), ep1, ep2, this.atlasEntity.getCreatedBy(), this.atlasEntity.getUpdatedBy(), this.atlasEntity.getCreateTime(), this.atlasEntity.getUpdateTime(), atlasRelationshipProperties);
                omrsRelationships.add(omrsRelationship);
            }
        }
        if (relationshipTypeGUID == null) {
            Map<String, TypeDefStore.EndpointMapping> mappedRelationships = this.typeDefStore.getAllEndpointMappingsFromAtlasName(this.atlasEntity.getTypeName());
            for (Map.Entry<String, TypeDefStore.EndpointMapping> entry : mappedRelationships.entrySet()) {
                String relationshipPrefix = entry.getKey();
                TypeDefStore.EndpointMapping mapping = entry.getValue();
                if (relationshipPrefix == null) continue;
                EntityProxy ep1 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasEntity, mapping.getPrefixOne(), this.userId);
                EntityProxy ep2 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasEntity, mapping.getPrefixTwo(), this.userId);
                String relationshipGUID = ApacheAtlasOMRSMetadataCollection.generateGuidWithPrefix(relationshipPrefix, this.atlasEntity.getGuid());
                Relationship omrsRelationship = RelationshipMapping.getRelationship(this.atlasRepositoryConnector, this.typeDefStore, mapping.getOmrsRelationshipTypeName(), relationshipGUID, InstanceStatus.ACTIVE, ep1, ep2, this.atlasEntity.getCreatedBy(), this.atlasEntity.getUpdatedBy(), this.atlasEntity.getCreateTime(), this.atlasEntity.getUpdateTime(), null);
                omrsRelationships.add(omrsRelationship);
            }
        } else {
            TypeDef typeDef = this.typeDefStore.getTypeDefByGUID(relationshipTypeGUID);
            if (typeDef != null) {
                String string = typeDef.getName();
                Map<String, String> map = this.typeDefStore.getAllMappedAtlasTypeDefNames(string);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String prefixForType = entry.getKey();
                    String atlasTypeName = entry.getValue();
                    if (prefixForType == null) continue;
                    log.info("Have not yet implemented this relationship: ({}) {}", (Object)prefixForType, (Object)atlasTypeName);
                }
            }
        }
        if ((comparator = SequencingUtils.getRelationshipComparator(sequencingOrder, sequencingProperty)) != null) {
            omrsRelationships.sort(comparator);
        }
        int n = Math.min(fromRelationshipElement + pageSize, omrsRelationships.size());
        if (fromRelationshipElement != 0 || n < omrsRelationships.size()) {
            omrsRelationships = omrsRelationships.subList(fromRelationshipElement, n);
        }
        return omrsRelationships.isEmpty() ? null : omrsRelationships;
    }

    private EntitySummary getSkeletonEntitySummary(String prefix) {
        EntitySummary summary = new EntitySummary();
        String guid = this.atlasEntity.getGuid();
        prefix = prefix == null ? "" : ApacheAtlasOMRSMetadataCollection.generateTypePrefix(prefix);
        summary.setGUID(prefix + guid);
        summary.setInstanceURL(this.getInstanceURL(guid));
        return summary;
    }

    private EntityDetail getSkeletonEntityDetail(String omrsTypeDefName, String prefix) {
        EntityDetail detail = null;
        try {
            detail = this.atlasRepositoryConnector.getRepositoryHelper().getSkeletonEntity(this.atlasRepositoryConnector.getRepositoryName(), this.atlasRepositoryConnector.getMetadataCollectionId(), InstanceProvenanceType.LOCAL_COHORT, this.userId, omrsTypeDefName);
            switch (this.atlasEntity.getStatus()) {
                case ACTIVE: {
                    detail.setStatus(InstanceStatus.ACTIVE);
                    break;
                }
                case DELETED: {
                    detail.setStatus(InstanceStatus.DELETED);
                    break;
                }
                default: {
                    log.warn("Unhandled status: {}", (Object)this.atlasEntity.getStatus());
                }
            }
            String guid = this.atlasEntity.getGuid();
            prefix = prefix == null ? "" : ApacheAtlasOMRSMetadataCollection.generateTypePrefix(prefix);
            detail.setGUID(prefix + guid);
            detail.setInstanceURL(this.getInstanceURL(guid));
            this.setModAndVersionDetails((EntitySummary)detail);
        }
        catch (TypeErrorException e) {
            log.error("Unable to get skeleton detail entity.", (Throwable)e);
        }
        return detail;
    }

    private String getInstanceURL(String guid) {
        return this.atlasRepositoryConnector.getBaseURL() + "/api/atlas/v2/entity/guid/" + guid;
    }

    private void setModAndVersionDetails(EntitySummary omrsObj) {
        omrsObj.setCreatedBy(this.atlasEntity.getCreatedBy());
        omrsObj.setCreateTime(this.atlasEntity.getCreateTime());
        omrsObj.setUpdatedBy(this.atlasEntity.getUpdatedBy());
        omrsObj.setUpdateTime(this.atlasEntity.getUpdateTime());
        omrsObj.setVersion(this.atlasEntity.getVersion().longValue());
    }

    private void addClassifications(EntitySummary omrsObj) throws RepositoryErrorException {
        String methodName = "addClassifications";
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        List classificationAssignments = this.atlasEntity.getClassifications();
        if (classificationAssignments != null) {
            OMRSRepositoryHelper omrsRepositoryHelper = this.atlasRepositoryConnector.getRepositoryHelper();
            String repositoryName = this.atlasRepositoryConnector.getRepositoryName();
            String atlasTypeDefName = this.atlasEntity.getTypeName();
            String omrsTypeDefName = this.typeDefStore.getMappedOMRSTypeDefName(atlasTypeDefName, this.prefix);
            for (AtlasClassification classificationAssignment : classificationAssignments) {
                String atlasClassificationName = classificationAssignment.getTypeName();
                TypeDef classificationDef = this.typeDefStore.getTypeDefByName(atlasClassificationName);
                if (classificationDef != null) {
                    Map atlasClassificationProperties = classificationAssignment.getAttributes();
                    Map<String, TypeDefAttribute> classificationAttributeMap = this.typeDefStore.getAllTypeDefAttributesForName(atlasClassificationName);
                    InstanceProperties omrsClassificationProperties = new InstanceProperties();
                    if (atlasClassificationProperties != null) {
                        for (Map.Entry property : atlasClassificationProperties.entrySet()) {
                            String propertyName = (String)property.getKey();
                            Object propertyValue = property.getValue();
                            if (classificationAttributeMap.containsKey(propertyName)) {
                                TypeDefAttribute typeDefAttribute = classificationAttributeMap.get(propertyName);
                                omrsClassificationProperties = AttributeMapping.addPropertyToInstance(omrsRepositoryHelper, repositoryName, typeDefAttribute, omrsClassificationProperties, this.attributeDefStore, propertyValue, "addClassifications");
                                continue;
                            }
                            if (!log.isWarnEnabled()) continue;
                            log.warn("No OMRS attribute {} defined for asset type {} -- skipping mapping.", (Object)propertyName, (Object)atlasClassificationName);
                        }
                    }
                    try {
                        Classification classification = this.atlasRepositoryConnector.getRepositoryHelper().getNewClassification(repositoryName, this.userId, atlasClassificationName, omrsTypeDefName, ClassificationOrigin.ASSIGNED, null, omrsClassificationProperties);
                        classification.setCreatedBy(omrsObj.getCreatedBy());
                        classification.setCreateTime(omrsObj.getCreateTime());
                        classification.setUpdatedBy(omrsObj.getUpdatedBy());
                        classification.setUpdateTime(omrsObj.getUpdateTime());
                        classification.setVersion(omrsObj.getUpdateTime().getTime());
                        classifications.add(classification);
                        continue;
                    }
                    catch (TypeErrorException e) {
                        log.error("Unable to create a new classification.", (Throwable)e);
                        OMRSErrorCode errorCode = OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{atlasClassificationName, omrsTypeDefName});
                        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), EntityMappingAtlas2OMRS.class.getName(), "addClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    }
                }
                log.warn("Classification {} unknown to repository -- skipping.", (Object)atlasClassificationName);
            }
        }
        if (!classifications.isEmpty()) {
            omrsObj.setClassifications(classifications);
        }
    }

    private void raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }
}

