/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.ArrayList;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.BaseTypeDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationshipDefMapping
extends BaseTypeDefMapping {
    private static final Logger log = LoggerFactory.getLogger(RelationshipDefMapping.class);

    private RelationshipDefMapping() {
    }

    public static void addRelationshipTypeToAtlas(RelationshipDef omrsRelationshipDef, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore, ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector) throws TypeDefNotSupportedException {
        String methodName = "addRelationshipTypeToAtlas";
        String omrsTypeDefName = omrsRelationshipDef.getName();
        AtlasRelationshipDef relationshipTypeDef = new AtlasRelationshipDef();
        RelationshipDefMapping.setupBaseMapping((TypeDef)omrsRelationshipDef, (AtlasBaseTypeDef)relationshipTypeDef);
        boolean fullyCovered = RelationshipDefMapping.setupRelationshipEnds(omrsRelationshipDef, relationshipTypeDef, typeDefStore);
        if (fullyCovered) {
            switch (omrsRelationshipDef.getPropagationRule()) {
                case NONE: {
                    relationshipTypeDef.setPropagateTags(AtlasRelationshipDef.PropagateTags.NONE);
                    break;
                }
                case BOTH: {
                    relationshipTypeDef.setPropagateTags(AtlasRelationshipDef.PropagateTags.BOTH);
                    break;
                }
                case ONE_TO_TWO: {
                    relationshipTypeDef.setPropagateTags(AtlasRelationshipDef.PropagateTags.ONE_TO_TWO);
                    break;
                }
                case TWO_TO_ONE: {
                    relationshipTypeDef.setPropagateTags(AtlasRelationshipDef.PropagateTags.TWO_TO_ONE);
                }
            }
        }
        if (fullyCovered) {
            RelationshipDefMapping.setupCardinality(relationshipTypeDef);
        }
        boolean bl = fullyCovered = fullyCovered && RelationshipDefMapping.setupPropertyMappings((TypeDef)omrsRelationshipDef, (AtlasStructDef)relationshipTypeDef, attributeDefStore);
        if (fullyCovered) {
            AtlasTypesDef atlasTypesDef = new AtlasTypesDef();
            ArrayList<AtlasRelationshipDef> relationshipList = new ArrayList<AtlasRelationshipDef>();
            relationshipList.add(relationshipTypeDef);
            atlasTypesDef.setRelationshipDefs(relationshipList);
            try {
                atlasRepositoryConnector.createTypeDef(atlasTypesDef);
                typeDefStore.addTypeDef((TypeDef)omrsRelationshipDef);
            }
            catch (AtlasServiceException e) {
                typeDefStore.addUnimplementedTypeDef((TypeDef)omrsRelationshipDef);
                RelationshipDefMapping.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "addRelationshipTypeToAtlas", e, omrsTypeDefName, atlasRepositoryConnector.getServerName());
            }
        } else {
            typeDefStore.addUnimplementedTypeDef((TypeDef)omrsRelationshipDef);
            RelationshipDefMapping.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "addRelationshipTypeToAtlas", null, omrsTypeDefName, atlasRepositoryConnector.getServerName());
        }
    }

    private static boolean setupRelationshipEnds(RelationshipDef omrsRelationshipDef, AtlasRelationshipDef atlasRelationshipDef, TypeDefStore typeDefStore) {
        RelationshipEndDef omrs1 = omrsRelationshipDef.getEndDef1();
        RelationshipEndDef omrs2 = omrsRelationshipDef.getEndDef2();
        AtlasRelationshipEndDef atlas1 = new AtlasRelationshipEndDef();
        AtlasRelationshipEndDef atlas2 = new AtlasRelationshipEndDef();
        String omrsTypeName1 = omrs1.getEntityType().getName();
        String omrsTypeName2 = omrs2.getEntityType().getName();
        String atlasTypeName1 = typeDefStore.getMappedAtlasTypeDefName(omrsTypeName1, null);
        String atlasTypeName2 = typeDefStore.getMappedAtlasTypeDefName(omrsTypeName2, null);
        String attrNameForAtlas1 = omrs2.getAttributeName();
        String attrDescForAtlas1 = omrs2.getAttributeDescription();
        RelationshipEndCardinality cardinalityForAtlas1 = omrs2.getAttributeCardinality();
        String attrNameForAtlas2 = omrs1.getAttributeName();
        String attrDescForAtlas2 = omrs1.getAttributeDescription();
        RelationshipEndCardinality cardinalityForAtlas2 = omrs1.getAttributeCardinality();
        boolean fullyCovered = RelationshipDefMapping.setupRelationshipEnd(omrsRelationshipDef, atlas1, atlasTypeName1, attrNameForAtlas1, attrDescForAtlas1, cardinalityForAtlas1);
        boolean bl = fullyCovered = fullyCovered && RelationshipDefMapping.setupRelationshipEnd(omrsRelationshipDef, atlas2, atlasTypeName2, attrNameForAtlas2, attrDescForAtlas2, cardinalityForAtlas2);
        if (fullyCovered) {
            atlasRelationshipDef.setEndDef1(atlas1);
            atlasRelationshipDef.setEndDef2(atlas2);
        }
        return fullyCovered;
    }

    private static boolean setupRelationshipEnd(RelationshipDef omrsRelationshipDef, AtlasRelationshipEndDef atlasRelEnd, String atlasTypeName, String atlasAttrName, String atlasAttrDescription, RelationshipEndCardinality atlasAttributeCardinality) {
        boolean fullyCovered = true;
        if (atlasTypeName != null) {
            atlasRelEnd.setType(atlasTypeName);
            atlasRelEnd.setName(atlasAttrName);
            atlasRelEnd.setDescription(atlasAttrDescription);
            switch (atlasAttributeCardinality) {
                case ANY_NUMBER: {
                    atlasRelEnd.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SET);
                    break;
                }
                case AT_MOST_ONE: {
                    atlasRelEnd.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
                    break;
                }
                case UNKNOWN: {
                    fullyCovered = false;
                    if (!log.isWarnEnabled()) break;
                    log.warn("Unable to determine cardinality of relationship end -- skipping the relationship: {}", (Object)omrsRelationshipDef);
                }
            }
        } else {
            fullyCovered = false;
        }
        return fullyCovered;
    }

    private static void setupCardinality(AtlasRelationshipDef relationshipTypeDef) {
        AtlasRelationshipEndDef e1 = relationshipTypeDef.getEndDef1();
        AtlasRelationshipEndDef e2 = relationshipTypeDef.getEndDef2();
        AtlasStructDef.AtlasAttributeDef.Cardinality c1 = e1.getCardinality();
        AtlasStructDef.AtlasAttributeDef.Cardinality c2 = e2.getCardinality();
        if (c1 == AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE && c2 == AtlasStructDef.AtlasAttributeDef.Cardinality.SET || c2 == AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE && c1 == AtlasStructDef.AtlasAttributeDef.Cardinality.SET) {
            relationshipTypeDef.setRelationshipCategory(AtlasRelationshipDef.RelationshipCategory.AGGREGATION);
            if (c1 == AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE) {
                e1.setIsContainer(true);
            } else {
                e2.setIsContainer(true);
            }
        } else {
            relationshipTypeDef.setRelationshipCategory(AtlasRelationshipDef.RelationshipCategory.ASSOCIATION);
        }
    }

    private static void raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws TypeDefNotSupportedException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new TypeDefNotSupportedException(errorCode.getHTTPErrorCode(), RelationshipDefMapping.class.getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }
}

