/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.Date;
import java.util.Map;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSMetadataCollection;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.AttributeMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.EntityMappingAtlas2OMRS;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(RelationshipMapping.class);
    private ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector;
    private TypeDefStore typeDefStore;
    private AttributeTypeDefStore attributeDefStore;
    private AtlasRelationship atlasRelationship;
    private String userId;

    public RelationshipMapping(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore, AtlasRelationship.AtlasRelationshipWithExtInfo instance, String userId) {
        this.atlasRepositoryConnector = atlasRepositoryConnector;
        this.typeDefStore = typeDefStore;
        this.attributeDefStore = attributeDefStore;
        this.atlasRelationship = instance.getRelationship();
        this.userId = userId;
    }

    public Relationship getRelationship() throws RepositoryErrorException {
        String methodName = "getRelationship";
        String repositoryName = this.atlasRepositoryConnector.getRepositoryName();
        String atlasRelationshipType = this.atlasRelationship.getTypeName();
        String omrsRelationshipType = this.typeDefStore.getMappedOMRSTypeDefName(atlasRelationshipType, null);
        Relationship omrsRelationship = null;
        if (omrsRelationshipType != null) {
            AtlasObjectId atlasEp1 = this.atlasRelationship.getEnd1();
            AtlasObjectId atlasEp2 = this.atlasRelationship.getEnd2();
            EntityProxy ep1 = null;
            EntityProxy ep2 = null;
            try {
                ep1 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasRepositoryConnector.getEntityByGUID(atlasEp1.getGuid(), true, true).getEntity(), null, this.userId);
            }
            catch (AtlasServiceException e) {
                this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationship", e, atlasEp1.getGuid(), "getRelationship", repositoryName);
            }
            try {
                ep2 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasRepositoryConnector.getEntityByGUID(atlasEp2.getGuid(), true, true).getEntity(), null, this.userId);
            }
            catch (AtlasServiceException e) {
                this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationship", e, atlasEp2.getGuid(), "getRelationship", repositoryName);
            }
            if (ep1 != null && ep2 != null) {
                omrsRelationship = RelationshipMapping.getRelationship(this.atlasRepositoryConnector, this.typeDefStore, this.attributeDefStore, atlasRelationshipType, this.atlasRelationship.getGuid(), this.atlasRelationship.getStatus(), ep1, ep2, this.atlasRelationship.getCreatedBy(), this.atlasRelationship.getUpdatedBy(), this.atlasRelationship.getCreateTime(), this.atlasRelationship.getUpdateTime(), this.atlasRelationship.getAttributes());
            }
        }
        return omrsRelationship;
    }

    public static Relationship getRelationship(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore, String atlasRelationshipType, String relationshipGUID, AtlasRelationship.Status relationshipStatus, EntityProxy ep1, EntityProxy ep2, String createdBy, String updatedBy, Date createTime, Date updateTime, Map<String, Object> atlasRelationshipProperties) throws RepositoryErrorException {
        String methodName = "getRelationship";
        OMRSRepositoryHelper omrsRepositoryHelper = atlasRepositoryConnector.getRepositoryHelper();
        String repositoryName = atlasRepositoryConnector.getRepositoryName();
        String omrsRelationshipType = typeDefStore.getMappedOMRSTypeDefName(atlasRelationshipType, null);
        InstanceStatus omrsRelationshipStatus = null;
        switch (relationshipStatus) {
            case ACTIVE: {
                omrsRelationshipStatus = InstanceStatus.ACTIVE;
                break;
            }
            case DELETED: {
                omrsRelationshipStatus = InstanceStatus.DELETED;
                break;
            }
            default: {
                if (log.isWarnEnabled()) {
                    log.warn("Unhandled relationship status, defaulting to ACTIVE: {}", (Object)relationshipStatus);
                }
                omrsRelationshipStatus = InstanceStatus.ACTIVE;
            }
        }
        InstanceProperties omrsRelationshipProperties = null;
        if (atlasRelationshipProperties != null) {
            Map<String, TypeDefAttribute> relationshipAttributeMap = typeDefStore.getAllTypeDefAttributesForName(omrsRelationshipType);
            Map<String, String> atlasToOmrsProperties = typeDefStore.getPropertyMappingsForAtlasTypeDef(atlasRelationshipType, null);
            omrsRelationshipProperties = new InstanceProperties();
            if (atlasToOmrsProperties != null) {
                for (Map.Entry<String, String> property : atlasToOmrsProperties.entrySet()) {
                    String atlasProperty = property.getKey();
                    String omrsProperty = property.getValue();
                    if (relationshipAttributeMap.containsKey(omrsProperty)) {
                        TypeDefAttribute typeDefAttribute = relationshipAttributeMap.get(omrsProperty);
                        omrsRelationshipProperties = AttributeMapping.addPropertyToInstance(omrsRepositoryHelper, repositoryName, typeDefAttribute, omrsRelationshipProperties, attributeDefStore, atlasRelationshipProperties.get(atlasProperty), "getRelationship");
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn("No OMRS attribute {} defined for asset type {} -- skipping mapping.", (Object)omrsProperty, (Object)omrsRelationshipType);
                }
            }
        }
        return RelationshipMapping.getRelationship(atlasRepositoryConnector, typeDefStore, omrsRelationshipType, relationshipGUID, omrsRelationshipStatus, ep1, ep2, createdBy, updatedBy, createTime, updateTime, omrsRelationshipProperties);
    }

    public static Relationship getRelationship(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, String omrsRelationshipType, String relationshipGUID, InstanceStatus relationshipStatus, EntityProxy ep1, EntityProxy ep2, String createdBy, String updatedBy, Date createTime, Date updateTime, InstanceProperties omrsRelationshipProperties) throws RepositoryErrorException {
        String methodName = "getRelationship";
        String repositoryName = atlasRepositoryConnector.getRepositoryName();
        Relationship omrsRelationship = RelationshipMapping.getSkeletonRelationship(atlasRepositoryConnector, (RelationshipDef)typeDefStore.getTypeDefByName(omrsRelationshipType));
        omrsRelationship.setGUID(relationshipGUID);
        omrsRelationship.setMetadataCollectionId(atlasRepositoryConnector.getMetadataCollectionId());
        omrsRelationship.setStatus(relationshipStatus);
        omrsRelationship.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
        omrsRelationship.setVersion(updateTime.getTime());
        omrsRelationship.setCreateTime(createTime);
        omrsRelationship.setCreatedBy(createdBy);
        omrsRelationship.setUpdatedBy(updatedBy);
        omrsRelationship.setUpdateTime(updateTime);
        if (ep1 == null || ep2 == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_RELATIONSHIP_ENDS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getRelationship", repositoryName, omrsRelationshipType, ep1 == null ? null : ep1.getGUID(), ep2 == null ? null : ep2.getGUID()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), RelationshipMapping.class.getName(), "getRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        omrsRelationship.setEntityOneProxy(ep1);
        omrsRelationship.setEntityTwoProxy(ep2);
        if (omrsRelationshipProperties != null) {
            omrsRelationship.setProperties(omrsRelationshipProperties);
        }
        return omrsRelationship;
    }

    public static EntityProxy getEntityProxyForObject(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, AtlasEntity atlasObj, String entityPrefix, String userId) {
        String methodName = "getEntityProxyForObject";
        EntityProxy entityProxy = null;
        if (atlasObj != null) {
            String repositoryName = atlasRepositoryConnector.getRepositoryName();
            OMRSRepositoryHelper repositoryHelper = atlasRepositoryConnector.getRepositoryHelper();
            String metadataCollectionId = atlasRepositoryConnector.getMetadataCollectionId();
            String atlasTypeName = atlasObj.getTypeName();
            String omrsTypeDefName = typeDefStore.getMappedOMRSTypeDefName(atlasTypeName, entityPrefix);
            Map attributes = atlasObj.getAttributes();
            if (!attributes.containsKey("qualifiedName")) {
                log.error("No qualifiedName found for object -- cannot create EntityProxy: {}", (Object)atlasObj);
                throw new NullPointerException("No qualifiedName found for object -- cannot create EntityProxy.");
            }
            String qualifiedName = (String)attributes.get("qualifiedName");
            InstanceProperties uniqueProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, null, "qualifiedName", qualifiedName, "getEntityProxyForObject");
            try {
                entityProxy = repositoryHelper.getNewEntityProxy(repositoryName, metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, omrsTypeDefName, uniqueProperties, null);
                entityPrefix = entityPrefix == null ? "" : ApacheAtlasOMRSMetadataCollection.generateTypePrefix(entityPrefix);
                entityProxy.setGUID(entityPrefix + atlasObj.getGuid());
                entityProxy.setCreatedBy(atlasObj.getCreatedBy());
                entityProxy.setCreateTime(atlasObj.getCreateTime());
                entityProxy.setUpdatedBy(atlasObj.getUpdatedBy());
                entityProxy.setUpdateTime(atlasObj.getUpdateTime());
                entityProxy.setVersion(atlasObj.getVersion().longValue());
            }
            catch (TypeErrorException e) {
                log.error("Unable to create new EntityProxy.", (Throwable)e);
            }
        } else if (log.isErrorEnabled()) {
            log.error("No Apache Atlas object provided (was null).");
        }
        return entityProxy;
    }

    static Relationship getSkeletonRelationship(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, RelationshipDef omrsRelationshipDef) throws RepositoryErrorException {
        String methodName = "getSkeletonRelationship";
        Relationship relationship = new Relationship();
        try {
            InstanceType instanceType = atlasRepositoryConnector.getRepositoryHelper().getNewInstanceType(atlasRepositoryConnector.getRepositoryName(), (TypeDefSummary)omrsRelationshipDef);
            relationship.setType(instanceType);
        }
        catch (TypeErrorException e) {
            if (log.isErrorEnabled()) {
                log.error("Unable to construct and set InstanceType -- skipping relationship: {}", (Object)omrsRelationshipDef.getName());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getSkeletonRelationship", omrsRelationshipDef.getName()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), EntityMappingAtlas2OMRS.class.getName(), "getSkeletonRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relationship;
    }

    private void raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }
}

