/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.MappingFromFile;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class AttributeTypeDefStore {
    private static final Logger log = LoggerFactory.getLogger(AttributeTypeDefStore.class);
    private Map<String, String> omrsNameToAtlasName = new HashMap<String, String>();
    private Map<String, String> atlasNameToOmrsName = new HashMap<String, String>();
    private Map<String, AttributeTypeDef> omrsGuidToTypeDef = new HashMap<String, AttributeTypeDef>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();
    private Map<String, AttributeTypeDef> unimplementedTypeDefs = new HashMap<String, AttributeTypeDef>();
    private Map<String, Map<String, String>> atlasNameToElementMap = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> omrsNameToElementMap = new HashMap<String, Map<String, String>>();
    private ObjectMapper mapper = new ObjectMapper();

    public AttributeTypeDefStore() {
        this.loadMappings();
    }

    private void loadMappings() {
        ClassPathResource mappingResource = new ClassPathResource("EnumDefMappings.json");
        try {
            InputStream stream = mappingResource.getInputStream();
            List mappings = (List)this.mapper.readValue(stream, (TypeReference)new TypeReference<List<MappingFromFile>>(){});
            for (MappingFromFile mapping : mappings) {
                String atlasName = mapping.getAtlasName();
                String omrsName = mapping.getOMRSName();
                this.omrsNameToAtlasName.put(omrsName, atlasName);
                this.atlasNameToOmrsName.put(atlasName, omrsName);
                List<MappingFromFile> elements = mapping.getPropertyMappings();
                if (elements == null) continue;
                HashMap<String, String> elementMapOmrsToAtlas = new HashMap<String, String>();
                HashMap<String, String> elementMapAtlasToOmrs = new HashMap<String, String>();
                for (MappingFromFile element : elements) {
                    String atlasElement = element.getAtlasName();
                    String omrsElement = element.getOMRSName();
                    elementMapOmrsToAtlas.put(omrsElement, atlasElement);
                    elementMapAtlasToOmrs.put(atlasElement, omrsElement);
                }
                this.atlasNameToElementMap.put(atlasName, elementMapAtlasToOmrs);
                this.omrsNameToElementMap.put(omrsName, elementMapOmrsToAtlas);
            }
        }
        catch (IOException e) {
            log.error("Unable to load mapping file EnumDefMappings.json from jar file -- no mappings will exist.");
        }
    }

    public boolean isTypeDefMapped(String omrsName) {
        return this.omrsNameToAtlasName.containsKey(omrsName);
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String guid) {
        return this.getAttributeTypeDefByGUID(guid, true);
    }

    private AttributeTypeDef getAttributeTypeDefByGUID(String guid, boolean warnIfNotFound) {
        if (this.omrsGuidToTypeDef.containsKey(guid)) {
            return this.omrsGuidToTypeDef.get(guid);
        }
        if (warnIfNotFound && log.isWarnEnabled()) {
            log.warn("Unable to find OMRS AttributeTypeDef by GUID: {}", (Object)guid);
        }
        return null;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String name) {
        return this.getAttributeTypeDefByName(name, true);
    }

    private AttributeTypeDef getAttributeTypeDefByName(String name, boolean warnIfNotFound) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getAttributeTypeDefByGUID(guid, warnIfNotFound);
        }
        if (warnIfNotFound && log.isWarnEnabled()) {
            log.warn("Unable to find OMRS AttributeTypeDef by Name: {}", (Object)name);
        }
        return null;
    }

    public Map<String, String> getElementMappingsForAtlasTypeDef(String atlasName) {
        return this.atlasNameToElementMap.getOrDefault(atlasName, null);
    }

    public Map<String, String> getElementMappingsForOMRSTypeDef(String omrsName) {
        return this.omrsNameToElementMap.getOrDefault(omrsName, null);
    }

    public String getMappedAtlasTypeDefName(String omrsName) {
        if (this.isTypeDefMapped(omrsName)) {
            return this.omrsNameToAtlasName.get(omrsName);
        }
        return null;
    }

    public String getMappedOMRSTypeDefName(String atlasName) {
        return this.atlasNameToOmrsName.getOrDefault(atlasName, null);
    }

    public void addTypeDef(AttributeTypeDef typeDef) {
        String guid = typeDef.getGUID();
        String name = typeDef.getName();
        this.omrsGuidToTypeDef.put(guid, typeDef);
        this.omrsNameToGuid.put(name, guid);
        if (!this.omrsNameToAtlasName.containsKey(name)) {
            this.omrsNameToAtlasName.put(name, name);
            this.atlasNameToOmrsName.put(name, name);
        }
        if (typeDef.getCategory().equals((Object)AttributeTypeDefCategory.ENUM_DEF) && !this.omrsNameToElementMap.containsKey(name)) {
            EnumDef enumDef = (EnumDef)typeDef;
            HashMap<String, String> elementMap = new HashMap<String, String>();
            for (EnumElementDef elementDef : enumDef.getElementDefs()) {
                elementMap.put(elementDef.getValue(), elementDef.getValue());
            }
            this.omrsNameToElementMap.put(name, elementMap);
            this.atlasNameToElementMap.put(name, elementMap);
        }
    }

    public void addUnimplementedTypeDef(AttributeTypeDef typeDef) {
        String guid = typeDef.getGUID();
        this.unimplementedTypeDefs.put(guid, typeDef);
    }

    public List<AttributeTypeDef> getAllAttributeTypeDefs() {
        return new ArrayList<AttributeTypeDef>(this.omrsGuidToTypeDef.values());
    }
}

