/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.AttributeMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.SequencingUtils;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.model.AtlasGuid;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMappingAtlas2OMRS {
    private static final Logger log = LoggerFactory.getLogger(EntityMappingAtlas2OMRS.class);
    private ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector;
    private TypeDefStore typeDefStore;
    private AttributeTypeDefStore attributeDefStore;
    private AtlasEntity.AtlasEntityWithExtInfo atlasEntityWithExtInfo;
    private AtlasEntity atlasEntity;
    private String prefix;
    private String userId;

    public EntityMappingAtlas2OMRS(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore, AtlasEntity.AtlasEntityWithExtInfo instance, String prefix, String userId) {
        this.atlasRepositoryConnector = atlasRepositoryConnector;
        this.typeDefStore = typeDefStore;
        this.attributeDefStore = attributeDefStore;
        this.atlasEntityWithExtInfo = instance;
        this.atlasEntity = this.atlasEntityWithExtInfo.getEntity();
        this.prefix = prefix;
        this.userId = userId;
    }

    public EntitySummary getEntitySummary() throws RepositoryErrorException {
        String atlasTypeDefName = this.atlasEntity.getTypeName();
        String omrsTypeDefName = this.typeDefStore.getMappedOMRSTypeDefName(atlasTypeDefName, this.prefix);
        log.info("Found mapped type for Atlas type '{}' with prefix '{}': {}", new Object[]{atlasTypeDefName, this.prefix, omrsTypeDefName});
        EntitySummary summary = null;
        if (omrsTypeDefName != null) {
            summary = this.getSkeletonEntitySummary(omrsTypeDefName, this.prefix);
            if (summary != null) {
                this.addClassifications(summary);
            }
        } else {
            log.warn("No mapping defined from Atlas type '{}' with prefix '{}'", (Object)atlasTypeDefName, (Object)this.prefix);
        }
        return summary;
    }

    public EntityDetail getEntityDetail() throws RepositoryErrorException {
        String methodName = "getEntityDetail";
        String atlasTypeDefName = this.atlasEntity.getTypeName();
        String omrsTypeDefName = this.typeDefStore.getMappedOMRSTypeDefName(atlasTypeDefName, this.prefix);
        log.info("Found mapped type for Atlas type '{}' with prefix '{}': {}", new Object[]{atlasTypeDefName, this.prefix, omrsTypeDefName});
        EntityDetail detail = null;
        if (omrsTypeDefName != null) {
            detail = this.getSkeletonEntityDetail(omrsTypeDefName, this.prefix);
            if (detail != null) {
                InstanceProperties instanceProperties = new InstanceProperties();
                OMRSRepositoryHelper omrsRepositoryHelper = this.atlasRepositoryConnector.getRepositoryHelper();
                String repositoryName = this.atlasRepositoryConnector.getRepositoryName();
                Map<String, TypeDefAttribute> omrsAttributeMap = this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeDefName);
                Map<String, String> atlasToOmrsProperties = this.typeDefStore.getPropertyMappingsForAtlasTypeDef(atlasTypeDefName, this.prefix);
                Map atlasProperties = this.atlasEntity.getAttributes();
                if (atlasProperties != null) {
                    HashSet<String> alreadyMapped = new HashSet<String>();
                    for (Map.Entry<String, String> property : atlasToOmrsProperties.entrySet()) {
                        String atlasProperty = property.getKey();
                        String omrsProperty = property.getValue();
                        if (omrsAttributeMap.containsKey(omrsProperty)) {
                            TypeDefAttribute typeDefAttribute = omrsAttributeMap.get(omrsProperty);
                            instanceProperties = AttributeMapping.addPropertyToInstance(omrsRepositoryHelper, repositoryName, typeDefAttribute, instanceProperties, this.attributeDefStore, atlasProperties.get(atlasProperty), "getEntityDetail");
                            if (instanceProperties.getPropertyValue(omrsProperty) == null) continue;
                            alreadyMapped.add(atlasProperty);
                            continue;
                        }
                        log.warn("No OMRS attribute {} defined for asset type {} -- skipping mapping.", (Object)omrsProperty, (Object)omrsTypeDefName);
                    }
                    HashMap<String, String> additionalProperties = new HashMap<String, String>();
                    Set nonRelationshipSet = atlasProperties.keySet();
                    nonRelationshipSet.removeAll(alreadyMapped);
                    for (String propertyName : nonRelationshipSet) {
                        Object propertyValue = atlasProperties.get(propertyName);
                        if (propertyValue == null) continue;
                        additionalProperties.put(propertyName, propertyValue.toString());
                    }
                    instanceProperties = omrsRepositoryHelper.addStringMapPropertyToInstance(repositoryName, instanceProperties, "additionalProperties", additionalProperties, "getEntityDetail");
                }
                detail.setProperties(instanceProperties);
                this.addClassifications((EntitySummary)detail);
            }
        } else {
            log.warn("No mapping defined from Atlas type '{}' with prefix '{}'", (Object)atlasTypeDefName, (Object)this.prefix);
        }
        return detail;
    }

    /*
     * WARNING - void declaration
     */
    public List<Relationship> getRelationships(String relationshipTypeGUID, int fromRelationshipElement, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        Comparator<Relationship> comparator;
        String methodName = "getRelationships";
        ArrayList<Relationship> omrsRelationships = new ArrayList<Relationship>();
        String repositoryName = this.atlasRepositoryConnector.getRepositoryName();
        Map atlasRelationships = this.atlasEntity.getRelationshipAttributes();
        for (Map.Entry entry : atlasRelationships.entrySet()) {
            void var12_16;
            Object var12_17 = null;
            Object atlasRelationshipValue = entry.getValue();
            if (atlasRelationshipValue instanceof List) {
                List list = (List)atlasRelationshipValue;
            } else if (atlasRelationshipValue instanceof LinkedHashMap) {
                ArrayList<LinkedHashMap> arrayList = new ArrayList<LinkedHashMap>();
                arrayList.add((LinkedHashMap)atlasRelationshipValue);
            }
            if (var12_16 == null) continue;
            for (LinkedHashMap valueToTranslate : var12_16) {
                AtlasRelatedObjectId relationshipAssignment = new AtlasRelatedObjectId((Map)valueToTranslate);
                String atlasRelationshipType = relationshipAssignment.getRelationshipType();
                String atlasRelationshipGuid = relationshipAssignment.getRelationshipGuid();
                Map<String, String> omrsPrefixToType = this.typeDefStore.getMappedOMRSTypeDefNameWithPrefixes(atlasRelationshipType);
                for (Map.Entry<String, String> entry2 : omrsPrefixToType.entrySet()) {
                    String relationshipPrefix = entry2.getKey();
                    String omrsRelationshipType = entry2.getValue();
                    TypeDef omrsTypeDef = this.typeDefStore.getTypeDefByName(omrsRelationshipType);
                    String omrsTypeDefGuid = omrsTypeDef.getGUID();
                    if (relationshipTypeGUID != null && !omrsTypeDefGuid.equals(relationshipTypeGUID)) continue;
                    try {
                        RelationshipMapping mapping = new RelationshipMapping(this.atlasRepositoryConnector, this.typeDefStore, this.attributeDefStore, new AtlasGuid(atlasRelationshipGuid, relationshipPrefix), this.atlasRepositoryConnector.getRelationshipByGUID(atlasRelationshipGuid), this.userId);
                        Relationship omrsRelationship = mapping.getRelationship();
                        if (omrsRelationship == null) continue;
                        omrsRelationships.add(omrsRelationship);
                    }
                    catch (AtlasServiceException e) {
                        this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationships", e, atlasRelationshipGuid, "getRelationships", repositoryName);
                    }
                }
            }
        }
        if (relationshipTypeGUID == null) {
            Map<String, TypeDefStore.EndpointMapping> mappedRelationships = this.typeDefStore.getAllEndpointMappingsFromAtlasName(this.atlasEntity.getTypeName());
            for (Map.Entry<String, TypeDefStore.EndpointMapping> entry : mappedRelationships.entrySet()) {
                String relationshipPrefix = entry.getKey();
                TypeDefStore.EndpointMapping mapping = entry.getValue();
                if (relationshipPrefix == null) continue;
                AtlasGuid atlasGuid = new AtlasGuid(this.atlasEntity.getGuid(), relationshipPrefix);
                Relationship omrsRelationship = RelationshipMapping.getSelfReferencingRelationship(this.atlasRepositoryConnector, this.typeDefStore, atlasGuid, this.atlasEntity);
                if (omrsRelationship != null) {
                    omrsRelationships.add(omrsRelationship);
                    continue;
                }
                this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationships", null, atlasGuid.toString(), "getRelationships", repositoryName);
            }
        } else {
            TypeDef typeDef = this.typeDefStore.getTypeDefByGUID(relationshipTypeGUID);
            if (typeDef != null) {
                String string = typeDef.getName();
                Map<String, String> map = this.typeDefStore.getAllMappedAtlasTypeDefNames(string);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String prefixForType = entry.getKey();
                    String atlasTypeName = entry.getValue();
                    if (prefixForType == null) continue;
                    log.info("Have not yet implemented this relationship: ({}) {}", (Object)prefixForType, (Object)atlasTypeName);
                }
            }
        }
        if ((comparator = SequencingUtils.getRelationshipComparator(sequencingOrder, sequencingProperty)) != null) {
            omrsRelationships.sort(comparator);
        }
        int n = Math.min(fromRelationshipElement + pageSize, omrsRelationships.size());
        if (fromRelationshipElement != 0 || n < omrsRelationships.size()) {
            omrsRelationships = omrsRelationships.subList(fromRelationshipElement, n);
        }
        return omrsRelationships.isEmpty() ? null : omrsRelationships;
    }

    private EntitySummary getSkeletonEntitySummary(String omrsTypeDefName, String prefix) {
        EntitySummary summary = null;
        try {
            summary = this.atlasRepositoryConnector.getRepositoryHelper().getSkeletonEntitySummary(this.atlasRepositoryConnector.getRepositoryName(), this.atlasRepositoryConnector.getMetadataCollectionId(), InstanceProvenanceType.LOCAL_COHORT, this.userId, omrsTypeDefName);
            String guid = this.atlasEntity.getGuid();
            AtlasGuid atlasGuid = new AtlasGuid(guid, prefix);
            summary.setGUID(atlasGuid.toString());
            summary.setInstanceURL(this.getInstanceURL(guid));
            this.setModAndVersionDetails(summary);
        }
        catch (TypeErrorException e) {
            log.error("Unable to get skeleton summary entity.", (Throwable)e);
        }
        return summary;
    }

    private EntityDetail getSkeletonEntityDetail(String omrsTypeDefName, String prefix) {
        EntityDetail detail = null;
        try {
            detail = this.atlasRepositoryConnector.getRepositoryHelper().getSkeletonEntity(this.atlasRepositoryConnector.getRepositoryName(), this.atlasRepositoryConnector.getMetadataCollectionId(), InstanceProvenanceType.LOCAL_COHORT, this.userId, omrsTypeDefName);
            switch (this.atlasEntity.getStatus()) {
                case ACTIVE: {
                    detail.setStatus(InstanceStatus.ACTIVE);
                    break;
                }
                case DELETED: {
                    detail.setStatus(InstanceStatus.DELETED);
                    break;
                }
                default: {
                    log.warn("Unhandled status: {}", (Object)this.atlasEntity.getStatus());
                }
            }
            String guid = this.atlasEntity.getGuid();
            AtlasGuid atlasGuid = new AtlasGuid(guid, prefix);
            detail.setGUID(atlasGuid.toString());
            detail.setInstanceURL(this.getInstanceURL(guid));
            this.setModAndVersionDetails((EntitySummary)detail);
        }
        catch (TypeErrorException e) {
            log.error("Unable to get skeleton detail entity.", (Throwable)e);
        }
        return detail;
    }

    private String getInstanceURL(String guid) {
        return this.atlasRepositoryConnector.getBaseURL() + "/api/atlas/v2/entity/guid/" + guid;
    }

    private void setModAndVersionDetails(EntitySummary omrsObj) {
        omrsObj.setCreatedBy(this.atlasEntity.getCreatedBy());
        omrsObj.setCreateTime(this.atlasEntity.getCreateTime());
        omrsObj.setUpdatedBy(this.atlasEntity.getUpdatedBy());
        omrsObj.setUpdateTime(this.atlasEntity.getUpdateTime());
        omrsObj.setVersion(this.atlasEntity.getVersion().longValue());
    }

    private void addClassifications(EntitySummary omrsObj) throws RepositoryErrorException {
        String methodName = "addClassifications";
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        List classificationAssignments = this.atlasEntity.getClassifications();
        if (classificationAssignments != null) {
            OMRSRepositoryHelper omrsRepositoryHelper = this.atlasRepositoryConnector.getRepositoryHelper();
            String repositoryName = this.atlasRepositoryConnector.getRepositoryName();
            String atlasTypeDefName = this.atlasEntity.getTypeName();
            String omrsTypeDefName = this.typeDefStore.getMappedOMRSTypeDefName(atlasTypeDefName, this.prefix);
            for (AtlasClassification classificationAssignment : classificationAssignments) {
                String atlasClassificationName = classificationAssignment.getTypeName();
                TypeDef classificationDef = this.typeDefStore.getTypeDefByName(atlasClassificationName);
                if (classificationDef != null) {
                    Map atlasClassificationProperties = classificationAssignment.getAttributes();
                    Map<String, TypeDefAttribute> classificationAttributeMap = this.typeDefStore.getAllTypeDefAttributesForName(atlasClassificationName);
                    InstanceProperties omrsClassificationProperties = new InstanceProperties();
                    if (atlasClassificationProperties != null) {
                        for (Map.Entry property : atlasClassificationProperties.entrySet()) {
                            String propertyName = (String)property.getKey();
                            Object propertyValue = property.getValue();
                            if (classificationAttributeMap.containsKey(propertyName)) {
                                TypeDefAttribute typeDefAttribute = classificationAttributeMap.get(propertyName);
                                omrsClassificationProperties = AttributeMapping.addPropertyToInstance(omrsRepositoryHelper, repositoryName, typeDefAttribute, omrsClassificationProperties, this.attributeDefStore, propertyValue, "addClassifications");
                                continue;
                            }
                            log.warn("No OMRS attribute {} defined for asset type {} -- skipping mapping.", (Object)propertyName, (Object)atlasClassificationName);
                        }
                    }
                    try {
                        Classification classification = this.atlasRepositoryConnector.getRepositoryHelper().getNewClassification(repositoryName, this.userId, atlasClassificationName, omrsTypeDefName, ClassificationOrigin.ASSIGNED, null, omrsClassificationProperties);
                        classification.setCreatedBy(omrsObj.getCreatedBy());
                        classification.setCreateTime(omrsObj.getCreateTime());
                        classification.setUpdatedBy(omrsObj.getUpdatedBy());
                        classification.setUpdateTime(omrsObj.getUpdateTime());
                        classification.setVersion(omrsObj.getUpdateTime().getTime());
                        classifications.add(classification);
                    }
                    catch (TypeErrorException e) {
                        this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY, "addClassifications", e, atlasClassificationName, omrsTypeDefName);
                    }
                    continue;
                }
                log.warn("Classification {} unknown to repository -- skipping.", (Object)atlasClassificationName);
            }
        }
        if (!classifications.isEmpty()) {
            omrsObj.setClassifications(classifications);
        }
    }

    private void raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        if (cause == null) {
            throw new RepositoryErrorException(errorCode.getMessageDefinition(params), this.getClass().getName(), methodName);
        }
        throw new RepositoryErrorException(errorCode.getMessageDefinition(params), this.getClass().getName(), methodName, cause);
    }
}

