/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;

public abstract class EnumDefMapping {
    private EnumDefMapping() {
    }

    public static void addEnumToAtlas(EnumDef omrsEnumDef, AttributeTypeDefStore attributeDefStore, ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector) throws TypeDefNotSupportedException {
        String methodName = "addEnumToAtlas";
        String omrsTypeDefName = omrsEnumDef.getName();
        AtlasEnumDef enumTypeDef = new AtlasEnumDef();
        enumTypeDef.setGuid(omrsEnumDef.getGUID());
        enumTypeDef.setName(omrsTypeDefName);
        enumTypeDef.setServiceType("omrs");
        enumTypeDef.setCreatedBy("ODPi Egeria (OMRS)");
        enumTypeDef.setCreateTime(new Date());
        enumTypeDef.setVersion(Long.valueOf(omrsEnumDef.getVersion()));
        enumTypeDef.setDescription(omrsEnumDef.getDescription());
        List omrsElements = omrsEnumDef.getElementDefs();
        if (omrsElements != null) {
            for (EnumElementDef omrsElement : omrsElements) {
                AtlasEnumDef.AtlasEnumElementDef atlasElement = new AtlasEnumDef.AtlasEnumElementDef();
                atlasElement.setValue(omrsElement.getValue());
                atlasElement.setDescription(omrsElement.getDescription());
                atlasElement.setOrdinal(Integer.valueOf(omrsElement.getOrdinal()));
                enumTypeDef.addElement(atlasElement);
            }
        }
        AtlasTypesDef atlasTypesDef = new AtlasTypesDef();
        ArrayList<AtlasEnumDef> enumList = new ArrayList<AtlasEnumDef>();
        enumList.add(enumTypeDef);
        atlasTypesDef.setEnumDefs(enumList);
        try {
            atlasRepositoryConnector.createTypeDef(atlasTypesDef);
            attributeDefStore.addTypeDef((AttributeTypeDef)omrsEnumDef);
        }
        catch (AtlasServiceException e) {
            attributeDefStore.addUnimplementedTypeDef((AttributeTypeDef)omrsEnumDef);
            throw new TypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED.getMessageDefinition(omrsTypeDefName, atlasRepositoryConnector.getServerName()), EnumDefMapping.class.getName(), "addEnumToAtlas", (Throwable)e);
        }
    }
}

