/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.Comparator;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.AttributeMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class SequencingUtils {
    private SequencingUtils() {
    }

    public static Comparator<Relationship> getRelationshipComparator(SequencingOrder sequencingOrder, String sequencingProperty) {
        Comparator comparator = null;
        if (sequencingOrder != null) {
            switch (sequencingOrder) {
                case GUID: {
                    comparator = Comparator.comparing(InstanceHeader::getGUID);
                    break;
                }
                case LAST_UPDATE_OLDEST: {
                    comparator = Comparator.comparing(InstanceAuditHeader::getUpdateTime);
                    break;
                }
                case LAST_UPDATE_RECENT: {
                    comparator = Comparator.comparing(InstanceAuditHeader::getUpdateTime).reversed();
                    break;
                }
                case CREATION_DATE_OLDEST: {
                    comparator = Comparator.comparing(InstanceAuditHeader::getCreateTime);
                    break;
                }
                case CREATION_DATE_RECENT: {
                    comparator = Comparator.comparing(InstanceAuditHeader::getCreateTime).reversed();
                    break;
                }
                case PROPERTY_ASCENDING: {
                    if (sequencingProperty == null) break;
                    comparator = (a, b) -> {
                        InstanceProperties p1 = a.getProperties();
                        InstanceProperties p2 = b.getProperties();
                        InstancePropertyValue v1 = null;
                        InstancePropertyValue v2 = null;
                        if (p1 != null) {
                            v1 = p1.getPropertyValue(sequencingProperty);
                        }
                        if (p2 != null) {
                            v2 = p2.getPropertyValue(sequencingProperty);
                        }
                        return AttributeMapping.compareInstanceProperty(v1, v2);
                    };
                    break;
                }
                case PROPERTY_DESCENDING: {
                    if (sequencingProperty == null) break;
                    comparator = (b, a) -> {
                        InstanceProperties p1 = a.getProperties();
                        InstanceProperties p2 = b.getProperties();
                        InstancePropertyValue v1 = null;
                        InstancePropertyValue v2 = null;
                        if (p1 != null) {
                            v1 = p1.getPropertyValue(sequencingProperty);
                        }
                        if (p2 != null) {
                            v2 = p2.getPropertyValue(sequencingProperty);
                        }
                        return AttributeMapping.compareInstanceProperty(v1, v2);
                    };
                    break;
                }
            }
        }
        return comparator;
    }

    public static Comparator<EntityDetail> getEntityDetailComparator(SequencingOrder sequencingOrder, String sequencingProperty) {
        Comparator comparator = null;
        if (sequencingOrder != null) {
            switch (sequencingOrder) {
                case GUID: {
                    comparator = Comparator.comparing(InstanceHeader::getGUID);
                    break;
                }
                case LAST_UPDATE_OLDEST: {
                    comparator = Comparator.comparing(InstanceAuditHeader::getUpdateTime);
                    break;
                }
                case LAST_UPDATE_RECENT: {
                    comparator = Comparator.comparing(InstanceAuditHeader::getUpdateTime).reversed();
                    break;
                }
                case CREATION_DATE_OLDEST: {
                    comparator = Comparator.comparing(InstanceAuditHeader::getCreateTime);
                    break;
                }
                case CREATION_DATE_RECENT: {
                    comparator = Comparator.comparing(InstanceAuditHeader::getCreateTime).reversed();
                    break;
                }
                case PROPERTY_ASCENDING: {
                    if (sequencingProperty == null) break;
                    comparator = (a, b) -> {
                        InstanceProperties p1 = a.getProperties();
                        InstanceProperties p2 = b.getProperties();
                        InstancePropertyValue v1 = null;
                        InstancePropertyValue v2 = null;
                        if (p1 != null) {
                            v1 = p1.getPropertyValue(sequencingProperty);
                        }
                        if (p2 != null) {
                            v2 = p2.getPropertyValue(sequencingProperty);
                        }
                        return AttributeMapping.compareInstanceProperty(v1, v2);
                    };
                    break;
                }
                case PROPERTY_DESCENDING: {
                    if (sequencingProperty == null) break;
                    comparator = (b, a) -> {
                        InstanceProperties p1 = a.getProperties();
                        InstanceProperties p2 = b.getProperties();
                        InstancePropertyValue v1 = null;
                        InstancePropertyValue v2 = null;
                        if (p1 != null) {
                            v1 = p1.getPropertyValue(sequencingProperty);
                        }
                        if (p2 != null) {
                            v2 = p2.getPropertyValue(sequencingProperty);
                        }
                        return AttributeMapping.compareInstanceProperty(v1, v2);
                    };
                    break;
                }
            }
        }
        return comparator;
    }
}

