/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.MappingFromFile;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class TypeDefStore {
    private static final Logger log = LoggerFactory.getLogger(TypeDefStore.class);
    private Map<String, TypeDef> omrsGuidToTypeDef = new HashMap<String, TypeDef>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();
    private Map<String, Map<String, TypeDefAttribute>> omrsGuidToAttributeMap = new HashMap<String, Map<String, TypeDefAttribute>>();
    private Map<String, TypeDef> unimplementedTypeDefs;
    private Map<String, String> prefixToOmrsTypeName = new HashMap<String, String>();
    private Map<String, Map<String, String>> omrsNameToAtlasNamesByPrefix = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> atlasNameToOmrsNamesByPrefix = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, Map<String, String>>> omrsNameToAttributeMapByPrefix;
    private Map<String, Map<String, Map<String, String>>> atlasNameToAttributeMapByPrefix;
    private Map<String, Map<String, EndpointMapping>> omrsNameToEndpointMapByPrefix;
    private Map<String, Map<String, EndpointMapping>> atlasNameToEndpointMapByPrefix;
    private Set<String> unmappedTypes;
    private ObjectMapper mapper;

    public TypeDefStore() {
        this.unimplementedTypeDefs = new HashMap<String, TypeDef>();
        this.omrsNameToAttributeMapByPrefix = new HashMap<String, Map<String, Map<String, String>>>();
        this.atlasNameToAttributeMapByPrefix = new HashMap<String, Map<String, Map<String, String>>>();
        this.omrsNameToEndpointMapByPrefix = new HashMap<String, Map<String, EndpointMapping>>();
        this.atlasNameToEndpointMapByPrefix = new HashMap<String, Map<String, EndpointMapping>>();
        this.unmappedTypes = new HashSet<String>();
        this.mapper = new ObjectMapper();
        this.loadMappings();
        this.loadUnmapped();
    }

    private void loadMappings() {
        ClassPathResource mappingResource = new ClassPathResource("TypeDefMappings.json");
        try {
            InputStream stream = mappingResource.getInputStream();
            List mappings = (List)this.mapper.readValue(stream, (TypeReference)new TypeReference<List<MappingFromFile>>(){});
            for (MappingFromFile mapping : mappings) {
                List<MappingFromFile> endpoints;
                List<MappingFromFile> properties;
                String atlasName = mapping.getAtlasName();
                String omrsName = mapping.getOMRSName();
                String prefix = mapping.getPrefix();
                if (!this.omrsNameToAtlasNamesByPrefix.containsKey(omrsName)) {
                    this.omrsNameToAtlasNamesByPrefix.put(omrsName, new HashMap());
                }
                this.omrsNameToAtlasNamesByPrefix.get(omrsName).put(prefix, atlasName);
                if (!this.atlasNameToOmrsNamesByPrefix.containsKey(atlasName)) {
                    this.atlasNameToOmrsNamesByPrefix.put(atlasName, new HashMap());
                }
                this.atlasNameToOmrsNamesByPrefix.get(atlasName).put(prefix, omrsName);
                if (prefix != null) {
                    this.prefixToOmrsTypeName.put(prefix, omrsName);
                }
                if ((properties = mapping.getPropertyMappings()) != null) {
                    HashMap<String, String> propertyMapOmrsToAtlas = new HashMap<String, String>();
                    HashMap<String, String> propertyMapAtlasToOmrs = new HashMap<String, String>();
                    for (MappingFromFile property : properties) {
                        String atlasProperty = property.getAtlasName();
                        String omrsProperty = property.getOMRSName();
                        propertyMapOmrsToAtlas.put(omrsProperty, atlasProperty);
                        propertyMapAtlasToOmrs.put(atlasProperty, omrsProperty);
                    }
                    if (!this.omrsNameToAttributeMapByPrefix.containsKey(omrsName)) {
                        this.omrsNameToAttributeMapByPrefix.put(omrsName, new HashMap());
                    }
                    this.omrsNameToAttributeMapByPrefix.get(omrsName).put(prefix, propertyMapOmrsToAtlas);
                    if (!this.atlasNameToAttributeMapByPrefix.containsKey(atlasName)) {
                        this.atlasNameToAttributeMapByPrefix.put(atlasName, new HashMap());
                    }
                    this.atlasNameToAttributeMapByPrefix.get(atlasName).put(prefix, propertyMapAtlasToOmrs);
                }
                if ((endpoints = mapping.getEndpointMappings()) == null) continue;
                if (endpoints.size() != 2) {
                    log.warn("Skipping mapping as found other than exactly 2 endpoints defined for the relationship '{}': {}", (Object)atlasName, endpoints);
                    continue;
                }
                MappingFromFile endpoint1 = endpoints.get(0);
                MappingFromFile endpoint2 = endpoints.get(1);
                EndpointMapping endpointMapping = new EndpointMapping(atlasName, omrsName, endpoint1.getAtlasName(), endpoint1.getOMRSName(), endpoint1.getPrefix(), endpoint2.getAtlasName(), endpoint2.getOMRSName(), endpoint2.getPrefix());
                if (!this.omrsNameToEndpointMapByPrefix.containsKey(omrsName)) {
                    this.omrsNameToEndpointMapByPrefix.put(omrsName, new HashMap());
                }
                this.omrsNameToEndpointMapByPrefix.get(omrsName).put(prefix, endpointMapping);
                if (!this.atlasNameToEndpointMapByPrefix.containsKey(atlasName)) {
                    this.atlasNameToEndpointMapByPrefix.put(atlasName, new HashMap());
                }
                this.atlasNameToEndpointMapByPrefix.get(atlasName).put(prefix, endpointMapping);
            }
        }
        catch (IOException e) {
            log.error("Unable to load mapping file TypeDefMappings.json from jar file -- no mappings will exist.");
        }
    }

    private void loadUnmapped() {
        ClassPathResource mappingResource = new ClassPathResource("Unmapped_OMRS.json");
        try {
            InputStream stream = mappingResource.getInputStream();
            List omrsTypeNames = (List)this.mapper.readValue(stream, (TypeReference)new TypeReference<List<String>>(){});
            this.unmappedTypes.addAll(omrsTypeNames);
        }
        catch (IOException e) {
            log.error("Unable to load reserved type file Unmapped_OMRS.json from jar file -- no types will be reserved for later mapping.");
        }
    }

    public boolean isTypeDefMapped(String omrsName) {
        return this.omrsNameToAtlasNamesByPrefix.containsKey(omrsName);
    }

    public boolean isReserved(String omrsName) {
        return this.unmappedTypes.contains(omrsName);
    }

    public Map<String, String> getPropertyMappingsForAtlasTypeDef(String atlasName, String prefix) {
        if (this.atlasNameToAttributeMapByPrefix.containsKey(atlasName)) {
            if (this.atlasNameToAttributeMapByPrefix.get(atlasName).containsKey(prefix)) {
                return this.atlasNameToAttributeMapByPrefix.get(atlasName).get(prefix);
            }
            return this.getPropertyMappingsForOMRSTypeDef(atlasName, prefix);
        }
        return this.getPropertyMappingsForOMRSTypeDef(atlasName, prefix);
    }

    public Map<String, String> getPropertyMappingsForOMRSTypeDef(String omrsName, String prefix) {
        if (this.omrsNameToAttributeMapByPrefix.containsKey(omrsName)) {
            return this.omrsNameToAttributeMapByPrefix.get(omrsName).getOrDefault(prefix, null);
        }
        return null;
    }

    public EndpointMapping getEndpointMappingFromAtlasName(String atlasTypeName, String relationshipPrefix) {
        if (this.atlasNameToEndpointMapByPrefix.containsKey(atlasTypeName)) {
            return this.atlasNameToEndpointMapByPrefix.get(atlasTypeName).getOrDefault(relationshipPrefix, null);
        }
        return null;
    }

    public Map<String, EndpointMapping> getAllEndpointMappingsFromAtlasName(String atlasTypeName) {
        return this.atlasNameToEndpointMapByPrefix.getOrDefault(atlasTypeName, Collections.emptyMap());
    }

    public Map<String, String> getAllMappedAtlasTypeDefNames(String omrsName) {
        if (this.isTypeDefMapped(omrsName)) {
            return this.omrsNameToAtlasNamesByPrefix.get(omrsName);
        }
        if (this.omrsNameToGuid.containsKey(omrsName)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(null, omrsName);
            return map;
        }
        return Collections.emptyMap();
    }

    public String getMappedAtlasTypeDefName(String omrsName, String prefix) {
        if (this.isTypeDefMapped(omrsName)) {
            return this.omrsNameToAtlasNamesByPrefix.get(omrsName).getOrDefault(prefix, null);
        }
        if (this.omrsNameToGuid.containsKey(omrsName)) {
            return omrsName;
        }
        return null;
    }

    public TypeDef getTypeDefByPrefix(String prefix) {
        String omrsTypeName = this.getMappedOMRSTypeDefNameForPrefix(prefix);
        TypeDef typeDef = null;
        if (omrsTypeName != null) {
            typeDef = this.getTypeDefByName(omrsTypeName);
        }
        return typeDef;
    }

    private String getMappedOMRSTypeDefNameForPrefix(String prefix) {
        return this.prefixToOmrsTypeName.getOrDefault(prefix, null);
    }

    public Map<String, String> getAllMappedOMRSTypeDefNames(String atlasName) {
        return this.atlasNameToOmrsNamesByPrefix.getOrDefault(atlasName, null);
    }

    public String getMappedOMRSTypeDefName(String atlasName, String prefix) {
        if (this.atlasNameToOmrsNamesByPrefix.containsKey(atlasName)) {
            return this.atlasNameToOmrsNamesByPrefix.get(atlasName).getOrDefault(prefix, null);
        }
        if (this.omrsNameToGuid.containsKey(atlasName)) {
            return atlasName;
        }
        return null;
    }

    public Map<String, String> getMappedOMRSTypeDefNameWithPrefixes(String atlasName) {
        if (this.atlasNameToOmrsNamesByPrefix.containsKey(atlasName)) {
            return this.atlasNameToOmrsNamesByPrefix.getOrDefault(atlasName, Collections.emptyMap());
        }
        if (this.omrsNameToGuid.containsKey(atlasName)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(null, atlasName);
            return map;
        }
        return Collections.emptyMap();
    }

    public void addTypeDef(TypeDef typeDef) {
        String guid = typeDef.getGUID();
        this.omrsGuidToTypeDef.put(guid, typeDef);
        this.omrsNameToGuid.put(typeDef.getName(), guid);
        this.addAttributes(typeDef.getPropertiesDefinition(), guid, typeDef.getName());
    }

    public void addUnimplementedTypeDef(TypeDef typeDef) {
        String guid = typeDef.getGUID();
        this.unimplementedTypeDefs.put(guid, typeDef);
        this.addAttributes(typeDef.getPropertiesDefinition(), guid, typeDef.getName());
    }

    private void addAttributes(List<TypeDefAttribute> attributes, String guid, String name) {
        if (!this.omrsGuidToAttributeMap.containsKey(guid)) {
            this.omrsGuidToAttributeMap.put(guid, new HashMap());
        }
        if (attributes != null) {
            HashMap<String, String> oneToOne = new HashMap<String, String>();
            for (TypeDefAttribute attribute : attributes) {
                String propertyName = attribute.getAttributeName();
                this.omrsGuidToAttributeMap.get(guid).put(propertyName, attribute);
                oneToOne.put(propertyName, propertyName);
            }
            if (!this.omrsNameToAttributeMapByPrefix.containsKey(name)) {
                this.omrsNameToAttributeMapByPrefix.put(name, new HashMap());
                this.omrsNameToAttributeMapByPrefix.get(name).put(null, oneToOne);
            }
        }
    }

    public TypeDef getUnimplementedTypeDefByGUID(String guid) {
        if (this.unimplementedTypeDefs.containsKey(guid)) {
            return this.unimplementedTypeDefs.get(guid);
        }
        log.warn("Unable to find unimplemented OMRS TypeDef: {}", (Object)guid);
        return null;
    }

    public TypeDef getTypeDefByGUID(String guid) {
        return this.getTypeDefByGUID(guid, true);
    }

    public TypeDef getTypeDefByGUID(String guid, boolean warnIfNotFound) {
        if (this.omrsGuidToTypeDef.containsKey(guid)) {
            return this.omrsGuidToTypeDef.get(guid);
        }
        if (warnIfNotFound && log.isWarnEnabled()) {
            log.warn("Unable to find OMRS TypeDef by GUID: {}", (Object)guid);
        }
        return null;
    }

    public TypeDef getTypeDefByName(String name) {
        return this.getTypeDefByName(name, true);
    }

    private TypeDef getTypeDefByName(String name, boolean warnIfNotFound) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getTypeDefByGUID(guid, warnIfNotFound);
        }
        if (warnIfNotFound && log.isWarnEnabled()) {
            log.warn("Unable to find OMRS TypeDef by Name: {}", (Object)name);
        }
        return null;
    }

    private Map<String, TypeDefAttribute> getTypeDefAttributesByGUID(String guid) {
        if (this.omrsGuidToAttributeMap.containsKey(guid)) {
            return this.omrsGuidToAttributeMap.get(guid);
        }
        log.warn("Unable to find attributes for OMRS TypeDef by GUID: {}", (Object)guid);
        return null;
    }

    private Map<String, TypeDefAttribute> getAllTypeDefAttributesForGUID(String guid) {
        Map<String, TypeDefAttribute> all = this.getTypeDefAttributesByGUID(guid);
        if (all != null) {
            TypeDefLink superType;
            TypeDef typeDef = this.getTypeDefByGUID(guid, false);
            if (typeDef == null) {
                typeDef = this.getUnimplementedTypeDefByGUID(guid);
            }
            if ((superType = typeDef.getSuperType()) != null) {
                all.putAll(this.getAllTypeDefAttributesForGUID(superType.getGUID()));
            }
        }
        return all;
    }

    public Map<String, TypeDefAttribute> getAllTypeDefAttributesForName(String name) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getAllTypeDefAttributesForGUID(guid);
        }
        log.warn("Unable to find attributes for OMRS TypeDef by Name: {}", (Object)name);
        return null;
    }

    public List<TypeDef> getAllTypeDefs() {
        return new ArrayList<TypeDef>(this.omrsGuidToTypeDef.values());
    }

    public final class EndpointMapping {
        private String atlasRelationshipTypeName;
        private String omrsRelationshipTypeName;
        private String atlas1;
        private String atlas2;
        private String omrs1;
        private String omrs2;
        private String prefix1;
        private String prefix2;

        EndpointMapping(String atlasRelationshipTypeName, String omrsRelationshipTypeName, String atlas1, String omrs1, String prefix1, String atlas2, String omrs2, String prefix2) {
            this.atlasRelationshipTypeName = atlasRelationshipTypeName;
            this.omrsRelationshipTypeName = omrsRelationshipTypeName;
            this.atlas1 = atlas1;
            this.atlas2 = atlas2;
            this.omrs1 = omrs1;
            this.omrs2 = omrs2;
            this.prefix1 = prefix1;
            this.prefix2 = prefix2;
        }

        public String getPrefixOne() {
            return this.prefix1;
        }

        public String getPrefixTwo() {
            return this.prefix2;
        }

        public String getAtlasRelationshipTypeName() {
            return this.atlasRelationshipTypeName;
        }

        public String getOmrsRelationshipTypeName() {
            return this.omrsRelationshipTypeName;
        }
    }

    public static enum Endpoint {
        ONE,
        TWO,
        UNDEFINED;

    }
}

