/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.eventmapper.ApacheAtlasOMRSRepositoryEventMapper;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.AttributeMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.ClassificationDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.EntityMappingAtlas2OMRS;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.EnumDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.RelationshipDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.SequencingUtils;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.model.AtlasGuid;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheAtlasOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(ApacheAtlasOMRSMetadataCollection.class);
    private final SimpleDateFormat atlasDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector;
    private TypeDefStore typeDefStore;
    private AttributeTypeDefStore attributeTypeDefStore;
    private Set<InstanceStatus> availableStates;
    private ApacheAtlasOMRSRepositoryEventMapper eventMapper = null;

    public ApacheAtlasOMRSMetadataCollection(ApacheAtlasOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        parentConnector.setRepositoryName(repositoryName);
        this.atlasRepositoryConnector = parentConnector;
        this.typeDefStore = new TypeDefStore();
        this.attributeTypeDefStore = new AttributeTypeDefStore();
        this.availableStates = new HashSet<InstanceStatus>();
        this.availableStates.add(InstanceStatus.ACTIVE);
        this.availableStates.add(InstanceStatus.DELETED);
    }

    public TypeDefGallery getAllTypes(String userId) throws RepositoryErrorException, InvalidParameterException {
        String methodName = "getAllTypes";
        super.basicRequestValidation(userId, "getAllTypes");
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        log.debug("Retrieved {} implemented TypeDefs for this repository.", (Object)typeDefs.size());
        typeDefGallery.setTypeDefs(typeDefs);
        List<AttributeTypeDef> attributeTypeDefs = this.attributeTypeDefStore.getAllAttributeTypeDefs();
        log.debug("Retrieved {} implemented AttributeTypeDefs for this repository.", (Object)attributeTypeDefs.size());
        typeDefGallery.setAttributeTypeDefs(attributeTypeDefs);
        return typeDefGallery;
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        super.typeDefCategoryParameterValidation(userId, category, "category", "findTypeDefsByCategory");
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>();
        for (TypeDef candidate : this.typeDefStore.getAllTypeDefs()) {
            if (!candidate.getCategory().equals((Object)category)) continue;
            typeDefs.add(candidate);
        }
        return typeDefs;
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        super.attributeTypeDefCategoryParameterValidation(userId, category, "category", "findAttributeTypeDefsByCategory");
        ArrayList<AttributeTypeDef> typeDefs = new ArrayList<AttributeTypeDef>();
        for (AttributeTypeDef candidate : this.attributeTypeDefStore.getAllAttributeTypeDefs()) {
            if (!candidate.getCategory().equals((Object)category)) continue;
            typeDefs.add(candidate);
        }
        return typeDefs;
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        super.typeDefPropertyParameterValidation(userId, matchCriteria, "matchCriteria", "findTypeDefsByProperty");
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        ArrayList<TypeDef> results = new ArrayList();
        if (matchCriteria != null) {
            Map properties = matchCriteria.getTypeDefProperties();
            for (TypeDef candidate : typeDefs) {
                List candidateProperties = candidate.getPropertiesDefinition();
                if (candidateProperties == null) continue;
                for (TypeDefAttribute candidateAttribute : candidateProperties) {
                    String candidateName = candidateAttribute.getAttributeName();
                    if (!properties.containsKey(candidateName)) continue;
                    results.add(candidate);
                }
            }
        } else {
            results = typeDefs;
        }
        return results;
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        super.typeDefSearchParameterValidation(userId, searchCriteria, "searchCriteria", "searchForTypeDefs");
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>();
        for (TypeDef candidate : this.typeDefStore.getAllTypeDefs()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        return typeDefs;
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getTypeDefByGUID");
        TypeDef found = this.typeDefStore.getTypeDefByGUID(guid);
        if (found == null) {
            this.raiseTypeDefNotKnownException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "getTypeDefByGUID", null, guid, this.repositoryName);
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getAttributeTypeDefByGUID");
        AttributeTypeDef found = this.attributeTypeDefStore.getAttributeTypeDefByGUID(guid);
        if (found == null) {
            this.raiseTypeDefNotKnownException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "getAttributeTypeDefByGUID", null, guid, this.repositoryName);
        }
        return found;
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getTypeDefByName");
        TypeDef found = this.typeDefStore.getTypeDefByName(name);
        if (found == null) {
            this.raiseTypeDefNotKnownException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "getTypeDefByName", null, name, this.repositoryName);
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getAttributeTypeDefByName");
        AttributeTypeDef found = this.attributeTypeDefStore.getAttributeTypeDefByName(name);
        if (found == null) {
            this.raiseTypeDefNotKnownException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "getAttributeTypeDefByName", null, name, this.repositoryName);
        }
        return found;
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException {
        String methodName = "addTypeDef";
        String typeDefParameterName = "newTypeDef";
        super.newTypeDefParameterValidation(userId, newTypeDef, "newTypeDef", "addTypeDef");
        TypeDefCategory typeDefCategory = newTypeDef.getCategory();
        String omrsTypeDefName = newTypeDef.getName();
        log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)typeDefCategory.getName());
        if (this.typeDefStore.isTypeDefMapped(omrsTypeDefName)) {
            this.typeDefStore.addTypeDef(newTypeDef);
        } else if (this.typeDefStore.isUnimplementedSupertype(omrsTypeDefName)) {
            this.typeDefStore.addTypeDef(newTypeDef);
        } else if (!this.typeDefStore.isReserved(omrsTypeDefName)) {
            if (this.atlasRepositoryConnector.typeDefExistsByName(omrsTypeDefName)) {
                this.typeDefStore.addTypeDef(newTypeDef);
            } else {
                switch (newTypeDef.getCategory()) {
                    case RELATIONSHIP_DEF: {
                        RelationshipDefMapping.addRelationshipTypeToAtlas((RelationshipDef)newTypeDef, this.typeDefStore, this.attributeTypeDefStore, this.atlasRepositoryConnector);
                        break;
                    }
                    case CLASSIFICATION_DEF: {
                        ClassificationDefMapping.addClassificationTypeToAtlas((ClassificationDef)newTypeDef, this.typeDefStore, this.attributeTypeDefStore, this.atlasRepositoryConnector);
                        break;
                    }
                    default: {
                        this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
                        this.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "addTypeDef", null, omrsTypeDefName, this.repositoryName);
                        break;
                    }
                }
            }
        } else {
            this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
            this.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "addTypeDef", null, omrsTypeDefName, this.repositoryName);
        }
        if (this.eventMapper != null) {
            this.eventMapper.sendNewTypeDefEvent(newTypeDef);
        }
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        this.validateRepositoryConnector("addAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("addAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, "newAttributeTypeDef", newAttributeTypeDef, "addAttributeTypeDef");
        this.repositoryValidator.validateUnknownAttributeTypeDef(this.repositoryName, "newAttributeTypeDef", newAttributeTypeDef, "addAttributeTypeDef");
        AttributeTypeDefCategory attributeTypeDefCategory = newAttributeTypeDef.getCategory();
        String omrsTypeDefName = newAttributeTypeDef.getName();
        log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)attributeTypeDefCategory.getName());
        if (this.attributeTypeDefStore.isTypeDefMapped(omrsTypeDefName)) {
            this.attributeTypeDefStore.addTypeDef(newAttributeTypeDef);
        } else if (newAttributeTypeDef.getCategory().equals((Object)AttributeTypeDefCategory.ENUM_DEF)) {
            if (this.atlasRepositoryConnector.typeDefExistsByName(omrsTypeDefName)) {
                this.attributeTypeDefStore.addTypeDef(newAttributeTypeDef);
            } else {
                EnumDefMapping.addEnumToAtlas((EnumDef)newAttributeTypeDef, this.attributeTypeDefStore, this.atlasRepositoryConnector);
            }
        } else {
            this.attributeTypeDefStore.addUnimplementedTypeDef(newAttributeTypeDef);
            this.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "addAttributeTypeDef", null, omrsTypeDefName, this.repositoryName);
        }
        if (this.eventMapper != null) {
            this.eventMapper.sendNewAttributeTypeDefEvent(newAttributeTypeDef);
        }
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, InvalidTypeDefException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        this.validateRepositoryConnector("verifyTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyTypeDef");
        this.repositoryValidator.validateTypeDef(this.repositoryName, "typeDef", typeDef, "verifyTypeDef");
        String guid = typeDef.getGUID();
        if (this.typeDefStore.getUnimplementedTypeDefByGUID(guid) != null) {
            this.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "verifyTypeDef", null, typeDef.getName(), this.repositoryName);
        }
        return this.typeDefStore.getTypeDefByGUID(guid) != null;
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        boolean bImplemented;
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        this.validateRepositoryConnector("verifyAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, "attributeTypeDef", attributeTypeDef, "verifyAttributeTypeDef");
        switch (attributeTypeDef.getCategory()) {
            case PRIMITIVE: 
            case COLLECTION: {
                bImplemented = true;
                break;
            }
            case ENUM_DEF: {
                bImplemented = this.attributeTypeDefStore.isTypeDefMapped(attributeTypeDef.getName());
                break;
            }
            default: {
                bImplemented = false;
            }
        }
        return bImplemented;
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateTypeDef";
        super.updateTypeDefParameterValidation(userId, typeDefPatch, "updateTypeDef");
        String omrsTypeDefName = typeDefPatch.getTypeDefName();
        String omrsTypeDefGUID = typeDefPatch.getTypeDefGUID();
        TypeDef existing = this.typeDefStore.getTypeDefByGUID(omrsTypeDefGUID);
        TypeDef revised = null;
        if (existing != null) {
            log.info("Updating TypeDef '{}' based on patch.", (Object)omrsTypeDefName);
            revised = this.repositoryHelper.applyPatch(this.atlasRepositoryConnector.getServerName(), existing, typeDefPatch);
            switch (revised.getCategory()) {
                case ENTITY_DEF: {
                    break;
                }
                case RELATIONSHIP_DEF: {
                    RelationshipDefMapping.updateRelationshipTypeInAtlas((RelationshipDef)revised, this.typeDefStore, this.attributeTypeDefStore, this.atlasRepositoryConnector);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    ClassificationDefMapping.updateClassificationTypeInAtlas((ClassificationDef)revised, this.typeDefStore, this.attributeTypeDefStore, this.atlasRepositoryConnector);
                    break;
                }
                default: {
                    this.typeDefStore.addUnimplementedTypeDef(revised);
                    this.raiseTypeDefNotKnownException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "updateTypeDef", null, omrsTypeDefName, this.repositoryName);
                }
            }
            this.typeDefStore.addTypeDef(revised);
            if (this.eventMapper != null) {
                this.eventMapper.sendUpdatedTypeDefEvent(typeDefPatch);
            }
        } else {
            log.info("Updating unmapped TypeDef '{}' based on patch.", (Object)omrsTypeDefName);
            TypeDef unimplemented = this.typeDefStore.getUnimplementedTypeDefByGUID(omrsTypeDefGUID);
            if (unimplemented != null) {
                revised = this.repositoryHelper.applyPatch(this.atlasRepositoryConnector.getServerName(), unimplemented, typeDefPatch);
            }
            this.raiseTypeDefNotKnownException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "updateTypeDef", null, omrsTypeDefName, this.repositoryName);
        }
        return revised;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "isEntityKnown";
        super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        EntityDetail detail = null;
        try {
            detail = this.getEntityDetail(userId, guid);
        }
        catch (EntityNotKnownException e) {
            log.info("Entity {} not known to the repository, or only a proxy.", (Object)guid, (Object)e);
        }
        return detail;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        AtlasGuid atlasGuid = AtlasGuid.fromGuid(guid);
        String prefix = atlasGuid.getGeneratedPrefix();
        AtlasEntity.AtlasEntityWithExtInfo entity = this.getAtlasEntitySafe(atlasGuid.getAtlasGuid(), "getEntitySummary");
        EntityMappingAtlas2OMRS mapping = new EntityMappingAtlas2OMRS(this.atlasRepositoryConnector, this.typeDefStore, this.attributeTypeDefStore, entity, prefix, userId);
        return mapping.getEntitySummary();
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        AtlasGuid atlasGuid = AtlasGuid.fromGuid(guid);
        String prefix = atlasGuid.getGeneratedPrefix();
        AtlasEntity.AtlasEntityWithExtInfo entity = this.getAtlasEntitySafe(atlasGuid.getAtlasGuid(), "getEntityDetail");
        EntityMappingAtlas2OMRS mapping = new EntityMappingAtlas2OMRS(this.atlasRepositoryConnector, this.typeDefStore, this.attributeTypeDefStore, entity, prefix, userId);
        return mapping.getEntityDetail();
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        this.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<Relationship> alRelationships = null;
        if (asOfTime != null) {
            this.raiseFunctionNotSupportedException(ApacheAtlasOMRSErrorCode.NO_HISTORY, "getRelationshipsForEntity", this.repositoryName);
        } else if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            AtlasGuid atlasGuid = AtlasGuid.fromGuid(entityGUID);
            String prefix = atlasGuid.getGeneratedPrefix();
            AtlasEntity.AtlasEntityWithExtInfo asset = null;
            try {
                asset = this.atlasRepositoryConnector.getEntityByGUID(atlasGuid.getAtlasGuid(), false, false);
            }
            catch (AtlasServiceException e) {
                this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationshipsForEntity", e, entityGUID, "getRelationshipsForEntity", this.repositoryName);
            }
            if (asset == null) {
                this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationshipsForEntity", null, entityGUID, "getRelationshipsForEntity", this.repositoryName);
            } else {
                EntityMappingAtlas2OMRS entityMap = new EntityMappingAtlas2OMRS(this.atlasRepositoryConnector, this.typeDefStore, this.attributeTypeDefStore, asset, prefix, userId);
                alRelationships = entityMap.getRelationships(relationshipTypeGUID, fromRelationshipElement, sequencingProperty, sequencingOrder, pageSize);
            }
        }
        return alRelationships;
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        this.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<AtlasEntityHeader> results = null;
        if (asOfTime != null) {
            this.raiseFunctionNotSupportedException(ApacheAtlasOMRSErrorCode.NO_HISTORY, "findEntitiesByProperty", this.repositoryName);
        } else {
            results = sequencingOrder != null || limitResultsByClassification != null && limitResultsByClassification.size() > 1 ? this.buildAndRunDSLSearch("findEntitiesByProperty", entityTypeGUID, limitResultsByClassification, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize, userId) : this.buildAndRunBasicSearch("findEntitiesByProperty", entityTypeGUID, limitResultsByClassification == null ? null : limitResultsByClassification.get(0), matchProperties, matchCriteria, null, fromEntityElement, limitResultsByStatus, pageSize, userId);
        }
        List<EntityDetail> entityDetails = null;
        if (results != null) {
            entityDetails = this.sortAndLimitFinalResults(results, entityTypeGUID, fromEntityElement, sequencingProperty, sequencingOrder, pageSize, userId);
        }
        return entityDetails == null || entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchClassificationCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        this.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchClassificationCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<AtlasEntityHeader> results = null;
        if (asOfTime != null) {
            this.raiseFunctionNotSupportedException(ApacheAtlasOMRSErrorCode.NO_HISTORY, "findEntitiesByClassification", this.repositoryName);
        } else if (sequencingOrder != null) {
            ArrayList<String> limitResultsByClassification = new ArrayList<String>();
            limitResultsByClassification.add(classificationName);
            results = this.buildAndRunDSLSearch("findEntitiesByClassification", entityTypeGUID, limitResultsByClassification, null, matchClassificationCriteria, fromEntityElement, limitResultsByStatus, sequencingProperty, sequencingOrder, matchClassificationProperties == null ? pageSize : pageSize * 2, userId);
        } else {
            results = this.buildAndRunBasicSearch("findEntitiesByClassification", entityTypeGUID, classificationName, null, matchClassificationCriteria, null, fromEntityElement, limitResultsByStatus, matchClassificationProperties == null ? pageSize : pageSize * 2, userId);
        }
        List<Object> atlasEntities = new ArrayList();
        if (results != null && matchClassificationProperties != null) {
            Map propertiesToMatch = matchClassificationProperties.getInstanceProperties();
            if (propertiesToMatch != null) {
                for (AtlasEntityHeader candidateEntity : results) {
                    List classificationsForEntity = candidateEntity.getClassifications();
                    for (AtlasClassification candidateClassification : classificationsForEntity) {
                        if (!candidateClassification.getTypeName().equals(classificationName)) continue;
                        boolean bMatchesAny = false;
                        boolean bMatchesAll = true;
                        for (Map.Entry propertyToMatch : propertiesToMatch.entrySet()) {
                            String propertyName = (String)propertyToMatch.getKey();
                            InstancePropertyValue omrsPropertyValueToMatch = (InstancePropertyValue)propertyToMatch.getValue();
                            Object atlasClassificationValue = candidateClassification.getAttribute(propertyName);
                            boolean bMatchesThisOne = AttributeMapping.valuesMatch(omrsPropertyValueToMatch, atlasClassificationValue);
                            bMatchesAll = bMatchesAll && bMatchesThisOne;
                            bMatchesAny = bMatchesAny || bMatchesThisOne;
                        }
                        if (matchClassificationCriteria != null) {
                            switch (matchClassificationCriteria) {
                                case NONE: {
                                    if (bMatchesAny) break;
                                    atlasEntities.add(candidateEntity);
                                    break;
                                }
                                case ALL: {
                                    if (!bMatchesAll) break;
                                    atlasEntities.add(candidateEntity);
                                    break;
                                }
                                case ANY: {
                                    if (!bMatchesAny) break;
                                    atlasEntities.add(candidateEntity);
                                }
                            }
                            continue;
                        }
                        if (bMatchesAll) {
                            atlasEntities.add(candidateEntity);
                            continue;
                        }
                        log.debug("Unable to match properties '{}' for entity, dropping from results: {}", (Object)matchClassificationProperties, (Object)candidateEntity);
                    }
                }
            } else {
                atlasEntities = results;
            }
            int endOfPageMarker = Math.min(fromEntityElement + pageSize, atlasEntities.size());
            if (fromEntityElement != 0 || endOfPageMarker < atlasEntities.size()) {
                atlasEntities = atlasEntities.subList(fromEntityElement, endOfPageMarker);
            }
        } else if (results != null) {
            atlasEntities = results;
        }
        List<EntityDetail> entityDetails = this.sortAndLimitFinalResults(atlasEntities, entityTypeGUID, fromEntityElement, sequencingProperty, sequencingOrder, pageSize, userId);
        return entityDetails == null || entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        this.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<AtlasEntityHeader> results = new ArrayList();
        if (asOfTime != null) {
            this.raiseFunctionNotSupportedException(ApacheAtlasOMRSErrorCode.NO_HISTORY, "findEntitiesByPropertyValue", this.repositoryName);
        }
        InstanceProperties matchProperties = null;
        if (this.repositoryHelper.isContainsRegex(searchCriteria) && sequencingOrder == null && (limitResultsByClassification == null || limitResultsByClassification.size() == 1)) {
            results = this.buildAndRunBasicSearch("findEntitiesByPropertyValue", entityTypeGUID, limitResultsByClassification == null ? null : limitResultsByClassification.get(0), null, null, searchCriteria, fromEntityElement, limitResultsByStatus, pageSize, userId);
        } else {
            matchProperties = new InstanceProperties();
            Map<String, Map<String, String>> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (Map.Entry<String, Map<String, String>> entryToSearch : mappingsToSearch.entrySet()) {
                List<AtlasEntityHeader> innerResults;
                String omrsTypeName = entryToSearch.getKey();
                String omrsTypeGUID = this.typeDefStore.getTypeDefByName(omrsTypeName).getGUID();
                Map<String, TypeDefAttribute> typeDefAttributeMap = this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeName);
                if (typeDefAttributeMap != null) {
                    for (Map.Entry<String, TypeDefAttribute> attributeEntry : typeDefAttributeMap.entrySet()) {
                        String attributeName = attributeEntry.getKey();
                        TypeDefAttribute typeDefAttribute = attributeEntry.getValue();
                        AttributeTypeDef attributeTypeDef = typeDefAttribute.getAttributeType();
                        if (attributeTypeDef.getCategory().equals((Object)AttributeTypeDefCategory.PRIMITIVE)) {
                            PrimitiveDefCategory primitiveDefCategory = ((PrimitiveDef)attributeTypeDef).getPrimitiveDefCategory();
                            if (primitiveDefCategory.equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) || primitiveDefCategory.equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE) || primitiveDefCategory.equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR)) {
                                matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.repositoryName, matchProperties, attributeName, searchCriteria, "findEntitiesByPropertyValue");
                                continue;
                            }
                            log.debug("Skipping inclusion of non-string attribute: {}", (Object)attributeName);
                            continue;
                        }
                        log.debug("Skipping inclusion of non-string attribute: {}", (Object)attributeName);
                    }
                }
                if ((innerResults = sequencingOrder != null || limitResultsByClassification != null && limitResultsByClassification.size() > 1 ? this.buildAndRunDSLSearch("findEntitiesByPropertyValue", omrsTypeGUID, limitResultsByClassification, matchProperties, MatchCriteria.ANY, fromEntityElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize, userId) : this.buildAndRunBasicSearch("findEntitiesByPropertyValue", omrsTypeGUID, limitResultsByClassification == null ? null : limitResultsByClassification.get(0), matchProperties, MatchCriteria.ANY, null, fromEntityElement, limitResultsByStatus, pageSize, userId)) == null) continue;
                results.addAll(innerResults);
            }
        }
        List<EntityDetail> entityDetails = null;
        if (results != null) {
            entityDetails = this.sortAndLimitFinalResults(results, entityTypeGUID, fromEntityElement, sequencingProperty, sequencingOrder, pageSize, userId);
        }
        return entityDetails == null || entityDetails.isEmpty() ? null : entityDetails;
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        Relationship relationship = null;
        try {
            relationship = this.getRelationship(userId, guid);
        }
        catch (RelationshipNotKnownException e) {
            log.info("Relationship {} not known to the repository.", (Object)guid, (Object)e);
        }
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        AtlasGuid atlasGuid = AtlasGuid.fromGuid(guid);
        if (atlasGuid.isGeneratedInstanceGuid()) {
            Relationship relationship = null;
            try {
                AtlasEntity.AtlasEntityWithExtInfo entity = this.atlasRepositoryConnector.getEntityByGUID(atlasGuid.getAtlasGuid(), true, true);
                if (entity != null) {
                    relationship = RelationshipMapping.getSelfReferencingRelationship(this.atlasRepositoryConnector, this.typeDefStore, atlasGuid, entity.getEntity());
                } else {
                    this.raiseRelationshipNotKnownException(ApacheAtlasOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationship", null, guid, "getRelationship", this.repositoryName);
                }
            }
            catch (AtlasServiceException e) {
                this.raiseRelationshipNotKnownException(ApacheAtlasOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationship", e, guid, "getRelationship", this.repositoryName);
            }
            return relationship;
        }
        AtlasRelationship.AtlasRelationshipWithExtInfo relationship = null;
        try {
            relationship = this.atlasRepositoryConnector.getRelationshipByGUID(atlasGuid.getAtlasGuid());
        }
        catch (AtlasServiceException e) {
            this.raiseRelationshipNotKnownException(ApacheAtlasOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationship", e, guid, "getRelationship", this.repositoryName);
        }
        if (relationship == null) {
            this.raiseRelationshipNotKnownException(ApacheAtlasOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationship", null, guid, "getRelationship", this.repositoryName);
        }
        RelationshipMapping mapping = new RelationshipMapping(this.atlasRepositoryConnector, this.typeDefStore, this.attributeTypeDefStore, atlasGuid, relationship, userId);
        return mapping.getRelationship();
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeEntityException, UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshEntityReferenceCopy");
        if (this.eventMapper != null) {
            EntityDetail entity = this.isEntityKnown(userId, entityGUID);
            if (entity != null && this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
                throw new HomeEntityException(ApacheAtlasOMRSErrorCode.HOME_REFRESH.getMessageDefinition("refreshEntityReferenceCopy", entityGUID, this.metadataCollectionId, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "refreshEntityReferenceCopy");
            }
            this.eventMapper.sendRefreshEntityRequest(typeDefGUID, typeDefName, entityGUID, homeMetadataCollectionId);
        }
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeRelationshipException, UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshRelationshipReferenceCopy");
        if (this.eventMapper != null) {
            Relationship relationship = this.isRelationshipKnown(userId, relationshipGUID);
            if (relationship != null && this.metadataCollectionId.equals(relationship.getMetadataCollectionId())) {
                throw new HomeRelationshipException(ApacheAtlasOMRSErrorCode.HOME_REFRESH.getMessageDefinition("refreshRelationshipReferenceCopy", relationshipGUID, this.metadataCollectionId, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "refreshRelationshipReferenceCopy");
            }
            this.eventMapper.sendRefreshRelationshipRequest(typeDefGUID, typeDefName, relationshipGUID, homeMetadataCollectionId);
        }
    }

    public void setEventMapper(ApacheAtlasOMRSRepositoryEventMapper eventMapper) {
        this.eventMapper = eventMapper;
    }

    public TypeDefStore getTypeDefStore() {
        return this.typeDefStore;
    }

    public AttributeTypeDefStore getAttributeTypeDefStore() {
        return this.attributeTypeDefStore;
    }

    public Set<InstanceStatus> getAvailableStates() {
        return this.availableStates;
    }

    private Map<String, Map<String, String>> getMappingsToSearch(String entityTypeGUID, String userId) throws RepositoryErrorException {
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        Map<Object, String> atlasTypeNamesByPrefix = new HashMap<Object, String>();
        String requestedTypeName = null;
        if (entityTypeGUID != null) {
            TypeDef typeDef = this.typeDefStore.getTypeDefByGUID(entityTypeGUID, false);
            if (typeDef != null) {
                String omrsTypeName = typeDef.getName();
                if (this.typeDefStore.isUnimplementedSupertype(omrsTypeName)) {
                    requestedTypeName = omrsTypeName;
                } else {
                    atlasTypeNamesByPrefix = this.typeDefStore.getAllMappedAtlasTypeDefNames(omrsTypeName);
                    results.put(omrsTypeName, atlasTypeNamesByPrefix);
                }
            } else {
                TypeDef unimplemented = this.typeDefStore.getUnimplementedTypeDefByGUID(entityTypeGUID);
                requestedTypeName = unimplemented.getName();
            }
        } else {
            atlasTypeNamesByPrefix.put(null, "Referenceable");
            results.put("Referenceable", atlasTypeNamesByPrefix);
        }
        if (requestedTypeName != null) {
            try {
                List<TypeDef> allEntityTypes = this.findTypeDefsByCategory(userId, TypeDefCategory.ENTITY_DEF);
                for (TypeDef typeDef : allEntityTypes) {
                    Map<String, String> mappings;
                    String typeDefName = typeDef.getName();
                    if (typeDefName.equals("Referenceable") || this.typeDefStore.isUnimplementedSupertype(typeDefName) || !this.repositoryHelper.isTypeOf(this.metadataCollectionId, typeDefName, requestedTypeName) || (mappings = this.typeDefStore.getAllMappedAtlasTypeDefNames(typeDefName)).isEmpty()) continue;
                    results.put(typeDefName, mappings);
                }
            }
            catch (InvalidParameterException e) {
                log.error("An invalid parameter was provided to findTypeDefsByCategory, cannot determine types to include in search.", (Throwable)e);
            }
        }
        return results;
    }

    private List<AtlasEntityHeader> buildAndRunDSLSearch(String methodName, String entityTypeGUID, List<String> limitResultsByClassification, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) throws FunctionNotSupportedException, RepositoryErrorException {
        boolean skipSearch = false;
        StringBuilder sb = new StringBuilder();
        Map<String, Map<String, String>> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
        ArrayList<AtlasSearchResult> totalResults = new ArrayList<AtlasSearchResult>();
        for (Map.Entry<String, Map<String, String>> entryToSearch : mappingsToSearch.entrySet()) {
            String omrsTypeName = entryToSearch.getKey();
            Map<String, String> atlasTypeNamesByPrefix = entryToSearch.getValue();
            for (Map.Entry<String, String> entry : atlasTypeNamesByPrefix.entrySet()) {
                String prefix = entry.getKey();
                String atlasTypeName = entry.getValue();
                Map<String, String> omrsPropertyMap = this.typeDefStore.getPropertyMappingsForOMRSTypeDef(omrsTypeName, prefix);
                sb.append("from ");
                sb.append(atlasTypeName);
                boolean bWhereClauseAdded = false;
                if (limitResultsByClassification != null) {
                    ArrayList<String> classifications = new ArrayList<String>();
                    for (String classificationName : limitResultsByClassification) {
                        classifications.add(atlasTypeName + " isa " + classificationName);
                    }
                    if (!classifications.isEmpty()) {
                        sb.append(" where ");
                        sb.append(String.join((CharSequence)" and ", classifications));
                        bWhereClauseAdded = true;
                    }
                }
                if (matchProperties != null) {
                    ArrayList propertyCriteria = new ArrayList();
                    Map properties = matchProperties.getInstanceProperties();
                    Map<String, TypeDefAttribute> omrsAttrTypeDefs = this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeName);
                    if (properties != null) {
                        for (Map.Entry entry2 : properties.entrySet()) {
                            InstancePropertyValue value;
                            String omrsPropertyName = (String)entry2.getKey();
                            boolean added = this.addSearchConditionFromValue(propertyCriteria, omrsPropertyName, value = (InstancePropertyValue)entry2.getValue(), omrsPropertyMap, omrsAttrTypeDefs, matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.NONE), true);
                            if (added || matchCriteria != null && !matchCriteria.equals((Object)MatchCriteria.ALL)) continue;
                            skipSearch = true;
                            log.info("Skipping search ({}) -- ALL criteria should match, but this one is unmapped: {}", (Object)entityTypeGUID, (Object)omrsPropertyName);
                        }
                    }
                    if (!propertyCriteria.isEmpty()) {
                        String propertyMatchDelim = " and ";
                        if (matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.ANY)) {
                            propertyMatchDelim = " or ";
                        }
                        if (!bWhereClauseAdded) {
                            sb.append(" where");
                        }
                        sb.append(" ");
                        sb.append(String.join((CharSequence)propertyMatchDelim, propertyCriteria));
                    }
                }
                boolean unsupportedStatusRequested = false;
                if (limitResultsByStatus != null) {
                    ArrayList<String> states = new ArrayList<String>();
                    HashSet<InstanceStatus> limitSet = new HashSet<InstanceStatus>(limitResultsByStatus);
                    block19: for (InstanceStatus instanceStatus : limitSet) {
                        switch (instanceStatus) {
                            case ACTIVE: {
                                states.add("__state = 'ACTIVE'");
                                continue block19;
                            }
                            case DELETED: {
                                states.add("__state = 'DELETED'");
                                continue block19;
                            }
                        }
                        unsupportedStatusRequested = true;
                    }
                    if (!states.isEmpty()) {
                        if (!bWhereClauseAdded) {
                            sb.append(" where");
                        }
                        sb.append(" ");
                        sb.append(String.join((CharSequence)" or ", states));
                    } else if (unsupportedStatusRequested) {
                        skipSearch = true;
                        log.info("Skipping search ({}) -- one or more unsupported statuses requested: {}", (Object)entityTypeGUID, limitSet);
                    }
                }
                if (skipSearch) continue;
                if (sequencingOrder != null) {
                    switch (sequencingOrder) {
                        case GUID: {
                            sb.append(" orderby __guid asc");
                            break;
                        }
                        case LAST_UPDATE_OLDEST: {
                            sb.append(" orderby __modificationTimestamp asc");
                            break;
                        }
                        case LAST_UPDATE_RECENT: {
                            sb.append(" orderby __modificationTimestamp desc");
                            break;
                        }
                        case CREATION_DATE_OLDEST: {
                            sb.append(" orderby __timestamp asc");
                            break;
                        }
                        case CREATION_DATE_RECENT: {
                            sb.append(" orderby __timestamp desc");
                            break;
                        }
                        case PROPERTY_ASCENDING: {
                            String atlasPropertyName;
                            if (sequencingProperty != null) {
                                atlasPropertyName = omrsPropertyMap.get(sequencingProperty);
                                if (atlasPropertyName != null) {
                                    sb.append(" orderby ");
                                    sb.append(atlasPropertyName);
                                    sb.append(" asc");
                                    break;
                                }
                                log.warn("Unable to find mapped Atlas property for sorting for: {}", (Object)sequencingProperty);
                                sb.append(" orderby __guid asc");
                                break;
                            }
                            log.warn("No property for sorting provided, defaulting to GUID.");
                            sb.append(" orderby __guid asc");
                            break;
                        }
                        case PROPERTY_DESCENDING: {
                            String atlasPropertyName;
                            if (sequencingProperty != null) {
                                atlasPropertyName = omrsPropertyMap.get(sequencingProperty);
                                if (atlasPropertyName != null) {
                                    sb.append(" orderby ");
                                    sb.append(atlasPropertyName);
                                    sb.append(" desc");
                                    break;
                                }
                                log.warn("Unable to find mapped Atlas property for sorting for: {}", (Object)sequencingProperty);
                                sb.append(" orderby __guid asc");
                                break;
                            }
                            log.warn("No property for sorting provided, defaulting to GUID.");
                            sb.append(" orderby __guid desc");
                            break;
                        }
                    }
                }
                if (pageSize > 0) {
                    sb.append(" limit ");
                    sb.append(pageSize);
                }
                if (fromEntityElement > 0) {
                    sb.append(" offset ");
                    sb.append(fromEntityElement);
                }
                AtlasSearchResult results = null;
                try {
                    results = this.atlasRepositoryConnector.searchWithDSL(sb.toString());
                }
                catch (AtlasServiceException e) {
                    this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.INVALID_SEARCH, methodName, e, sb.toString());
                }
                if (results == null) continue;
                totalResults.add(results);
            }
        }
        return this.combineMultipleResults(totalResults);
    }

    private List<AtlasEntityHeader> buildAndRunBasicSearch(String methodName, String entityTypeGUID, String limitResultsByClassification, InstanceProperties matchProperties, MatchCriteria matchCriteria, String fullTextQuery, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, int pageSize, String userId) throws FunctionNotSupportedException, RepositoryErrorException {
        Map<String, Map<String, String>> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
        ArrayList<AtlasSearchResult> totalResults = new ArrayList<AtlasSearchResult>();
        for (Map.Entry<String, Map<String, String>> entryToSearch : mappingsToSearch.entrySet()) {
            String omrsTypeName = entryToSearch.getKey();
            Map<String, String> atlasTypeNamesByPrefix = entryToSearch.getValue();
            for (Map.Entry<String, String> entry : atlasTypeNamesByPrefix.entrySet()) {
                String omrsPropertyName;
                String prefix = entry.getKey();
                String atlasTypeName = entry.getValue();
                SearchParameters searchParameters = new SearchParameters();
                if (atlasTypeName != null) {
                    searchParameters.setTypeName(atlasTypeName);
                }
                searchParameters.setIncludeClassificationAttributes(true);
                searchParameters.setIncludeSubClassifications(true);
                searchParameters.setIncludeSubTypes(true);
                searchParameters.setOffset(fromEntityElement);
                searchParameters.setLimit(pageSize);
                Map<String, String> omrsPropertyMap = this.typeDefStore.getPropertyMappingsForOMRSTypeDef(omrsTypeName, prefix);
                Map<String, TypeDefAttribute> omrsAttrTypeDefs = this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeName);
                ArrayList criteria = new ArrayList();
                boolean skipSearch = false;
                if (matchProperties != null) {
                    Map properties = matchProperties.getInstanceProperties();
                    if (properties != null) {
                        for (Map.Entry entry2 : properties.entrySet()) {
                            InstancePropertyValue value;
                            omrsPropertyName = (String)entry2.getKey();
                            boolean added = this.addSearchConditionFromValue(criteria, omrsPropertyName, value = (InstancePropertyValue)entry2.getValue(), omrsPropertyMap, omrsAttrTypeDefs, matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.NONE), false);
                            if (added || matchCriteria != null && !matchCriteria.equals((Object)MatchCriteria.ALL)) continue;
                            skipSearch = true;
                            log.info("Skipping search ({}) -- ALL criteria should match, but this one is unmapped: {}", (Object)entityTypeGUID, (Object)omrsPropertyName);
                        }
                    }
                } else if (fullTextQuery != null) {
                    PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    primitivePropertyValue.setPrimitiveValue((Object)fullTextQuery);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    for (Map.Entry<Object, Object> entry3 : omrsAttrTypeDefs.entrySet()) {
                        PrimitiveDef primitiveDef;
                        omrsPropertyName = (String)entry3.getKey();
                        TypeDefAttribute typeDefAttribute = (TypeDefAttribute)entry3.getValue();
                        log.debug("Considering attribute: {}", (Object)omrsPropertyName);
                        AttributeTypeDef attributeTypeDef = typeDefAttribute.getAttributeType();
                        if (!attributeTypeDef.getCategory().equals((Object)AttributeTypeDefCategory.PRIMITIVE) || !(primitiveDef = (PrimitiveDef)attributeTypeDef).getPrimitiveDefCategory().equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING)) continue;
                        log.debug(" ... attribute is a String, continuing ...");
                        if (!omrsPropertyMap.containsKey(omrsPropertyName)) continue;
                        String atlasPropertyName = omrsPropertyMap.get(omrsPropertyName);
                        log.debug(" ... attribute is mapped, to: {}", (Object)atlasPropertyName);
                        if (atlasPropertyName == null) continue;
                        log.debug(" ... adding criterion for value: {}", (Object)primitivePropertyValue);
                        boolean added = this.addSearchConditionFromValue(criteria, omrsPropertyName, (InstancePropertyValue)primitivePropertyValue, omrsPropertyMap, omrsAttrTypeDefs, matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.NONE), false);
                        if (added || matchCriteria != null && !matchCriteria.equals((Object)MatchCriteria.ALL)) continue;
                        skipSearch = true;
                        log.info("Skipping search ({}) -- ALL criteria should match, but this one is unmapped: {}", (Object)entityTypeGUID, (Object)omrsPropertyName);
                    }
                }
                SearchParameters.FilterCriteria entityFilters = new SearchParameters.FilterCriteria();
                if (criteria.size() > 1) {
                    entityFilters.setCriterion(criteria);
                    if (matchCriteria != null) {
                        switch (matchCriteria) {
                            case NONE: 
                            case ALL: {
                                entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
                                break;
                            }
                            case ANY: {
                                entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
                            }
                        }
                    } else if (fullTextQuery != null) {
                        entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
                    } else {
                        entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
                    }
                } else if (criteria.size() == 1) {
                    entityFilters = (SearchParameters.FilterCriteria)criteria.get(0);
                }
                searchParameters.setEntityFilters(entityFilters);
                if (limitResultsByStatus != null) {
                    HashSet<InstanceStatus> limitSet = new HashSet<InstanceStatus>(limitResultsByStatus);
                    if (limitSet.equals(this.availableStates) || limitSet.size() == 1 && limitSet.contains(InstanceStatus.DELETED)) {
                        searchParameters.setExcludeDeletedEntities(false);
                    } else if (limitSet.size() == 1 && limitSet.contains(InstanceStatus.ACTIVE)) {
                        searchParameters.setExcludeDeletedEntities(true);
                    } else if (!limitSet.isEmpty()) {
                        skipSearch = true;
                        log.info("Skipping search ({}) -- searching for unsupported states: {}", (Object)entityTypeGUID, limitSet);
                    }
                }
                if (skipSearch) continue;
                if (limitResultsByClassification != null) {
                    searchParameters.setClassification(limitResultsByClassification);
                }
                AtlasSearchResult results = null;
                try {
                    results = this.atlasRepositoryConnector.searchForEntities(searchParameters);
                }
                catch (AtlasServiceException atlasServiceException) {
                    this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.INVALID_SEARCH, methodName, atlasServiceException, searchParameters.toString());
                }
                if (results == null) continue;
                totalResults.add(results);
            }
        }
        return this.combineMultipleResults(totalResults);
    }

    private List<AtlasEntityHeader> combineMultipleResults(List<AtlasSearchResult> resultsList) {
        if (resultsList == null || resultsList.isEmpty()) {
            return null;
        }
        if (resultsList.size() == 1) {
            return resultsList.get(0).getEntities();
        }
        ArrayList<AtlasEntityHeader> totalResults = new ArrayList<AtlasEntityHeader>();
        for (AtlasSearchResult result : resultsList) {
            List entityResults;
            if (result == null || (entityResults = result.getEntities()) == null) continue;
            totalResults.addAll(entityResults);
        }
        return totalResults;
    }

    private List<EntityDetail> sortAndLimitFinalResults(List<AtlasEntityHeader> results, String entityTypeGUID, int fromElement, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        if (entityTypeGUID == null) {
            entityTypeGUID = this.typeDefStore.getTypeDefByName("Referenceable").getGUID();
        }
        List<Object> totalResults = new ArrayList<EntityDetail>(this.getEntityDetailsFromAtlasResults(results, entityTypeGUID, userId));
        Comparator<EntityDetail> comparator = SequencingUtils.getEntityDetailComparator(sequencingOrder, sequencingProperty);
        if (comparator != null) {
            totalResults.sort(comparator);
        }
        int endOfPageMarker = Math.min(fromElement + pageSize, totalResults.size());
        if (fromElement != 0 || endOfPageMarker < totalResults.size()) {
            totalResults = totalResults.subList(fromElement, endOfPageMarker);
        }
        return totalResults;
    }

    private List<EntityDetail> getEntityDetailsFromAtlasResults(List<AtlasEntityHeader> atlasEntities, String entityTypeGUID, String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        if (atlasEntities != null) {
            for (AtlasEntityHeader atlasEntityHeader : atlasEntities) {
                try {
                    EntityDetail detail = this.getEntityDetail(userId, atlasEntityHeader.getGuid());
                    if (detail != null) {
                        String typeName = detail.getType().getTypeDefName();
                        try {
                            TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "getEntityDetailsFromAtlasResults");
                            if (!this.repositoryHelper.isTypeOf(this.repositoryName, typeName, typeDef.getName())) continue;
                            entityDetails.add(detail);
                        }
                        catch (TypeErrorException e) {
                            log.error("Unable to find any TypeDef for entityTypeGUID: {}", (Object)entityTypeGUID);
                        }
                        continue;
                    }
                    log.error("Entity with GUID {} not mapped -- excluding from results.", (Object)atlasEntityHeader.getGuid());
                }
                catch (EntityNotKnownException e) {
                    log.error("Entity with GUID {} not known -- excluding from results.", (Object)atlasEntityHeader.getGuid());
                }
            }
        }
        return entityDetails;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> boolean addSearchConditionFromValue(List<T> criteria, String omrsPropertyName, InstancePropertyValue value, Map<String, String> omrsToAtlasPropertyMap, Map<String, TypeDefAttribute> omrsTypeDefAttrMap, boolean negateCondition, boolean dslQuery) throws FunctionNotSupportedException {
        Iterator<String> iterator;
        ArrayList<String> subCriteria;
        ArrayList<SearchParameters.FilterCriteria> subAtlasCriteria;
        String methodName = "addSearchConditionFromValue";
        boolean added = true;
        if (omrsPropertyName == null) {
            log.warn("Unable to add search condition, no OMRS property: {}", (Object)value);
            return false;
        }
        if (omrsToAtlasPropertyMap == null) {
            log.info("Unable to add search condition, no mapped Atlas property for property: {}", (Object)omrsPropertyName);
            return false;
        }
        String atlasPropertyName = omrsToAtlasPropertyMap.get(omrsPropertyName);
        if (atlasPropertyName == null) {
            log.warn("Unable to add search condition, no mapped Atlas property for '{}': {}", (Object)omrsPropertyName, (Object)value);
            return false;
        }
        SearchParameters.FilterCriteria atlasCriterion = new SearchParameters.FilterCriteria();
        StringBuilder sbCriterion = new StringBuilder();
        InstancePropertyCategory category = value.getInstancePropertyCategory();
        switch (category) {
            case PRIMITIVE: {
                PrimitivePropertyValue actualValue = (PrimitivePropertyValue)value;
                PrimitiveDefCategory primitiveType = actualValue.getPrimitiveDefCategory();
                switch (primitiveType) {
                    case OM_PRIMITIVE_TYPE_BOOLEAN: 
                    case OM_PRIMITIVE_TYPE_SHORT: 
                    case OM_PRIMITIVE_TYPE_INT: 
                    case OM_PRIMITIVE_TYPE_LONG: 
                    case OM_PRIMITIVE_TYPE_FLOAT: 
                    case OM_PRIMITIVE_TYPE_DOUBLE: 
                    case OM_PRIMITIVE_TYPE_BIGINTEGER: 
                    case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                        String nonString = actualValue.getPrimitiveValue().toString();
                        atlasCriterion.setAttributeName(atlasPropertyName);
                        sbCriterion.append(atlasPropertyName);
                        if (negateCondition) {
                            atlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                            sbCriterion.append(" != ");
                        } else {
                            atlasCriterion.setOperator(SearchParameters.Operator.EQ);
                            sbCriterion.append(" = ");
                        }
                        atlasCriterion.setAttributeValue(nonString);
                        sbCriterion.append(nonString);
                        if (dslQuery) {
                            criteria.add(sbCriterion.toString());
                            return added;
                        }
                        criteria.add(atlasCriterion);
                        return added;
                    }
                    case OM_PRIMITIVE_TYPE_BYTE: 
                    case OM_PRIMITIVE_TYPE_CHAR: {
                        String single = actualValue.getPrimitiveValue().toString();
                        atlasCriterion.setAttributeName(atlasPropertyName);
                        sbCriterion.append(atlasPropertyName);
                        if (negateCondition) {
                            atlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                            sbCriterion.append(" != \"");
                        } else {
                            atlasCriterion.setOperator(SearchParameters.Operator.EQ);
                            sbCriterion.append(" = \"");
                        }
                        atlasCriterion.setAttributeValue(single);
                        sbCriterion.append(single);
                        sbCriterion.append("\"");
                        if (dslQuery) {
                            criteria.add(sbCriterion.toString());
                            return added;
                        }
                        criteria.add(atlasCriterion);
                        return added;
                    }
                    case OM_PRIMITIVE_TYPE_DATE: {
                        Long epoch = (Long)actualValue.getPrimitiveValue();
                        String formattedDate = this.atlasDateFormat.format(new Date(epoch));
                        atlasCriterion.setAttributeName(atlasPropertyName);
                        if (atlasPropertyName.equals("createTime")) {
                            sbCriterion.append("__timestamp");
                        } else if (atlasPropertyName.equals("updateTime")) {
                            sbCriterion.append("__modificationTimestamp");
                        } else {
                            sbCriterion.append(atlasPropertyName);
                        }
                        if (negateCondition) {
                            atlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                            sbCriterion.append(" != \"");
                        } else {
                            atlasCriterion.setOperator(SearchParameters.Operator.EQ);
                            sbCriterion.append(" = \"");
                        }
                        atlasCriterion.setAttributeValue(formattedDate);
                        sbCriterion.append(epoch);
                        sbCriterion.append("\"");
                        if (dslQuery) {
                            criteria.add(sbCriterion.toString());
                            return added;
                        }
                        criteria.add(atlasCriterion);
                        return added;
                    }
                }
                atlasCriterion.setAttributeName(atlasPropertyName);
                sbCriterion.append(atlasPropertyName);
                String candidateValue = actualValue.getPrimitiveValue().toString();
                String unqualifiedValue = this.repositoryHelper.getUnqualifiedLiteralString(candidateValue);
                if (this.repositoryHelper.isContainsRegex(candidateValue)) {
                    sbCriterion.append(" LIKE \"*");
                    sbCriterion.append(unqualifiedValue);
                    sbCriterion.append("\"*");
                    atlasCriterion.setOperator(SearchParameters.Operator.CONTAINS);
                } else if (this.repositoryHelper.isEndsWithRegex(candidateValue)) {
                    sbCriterion.append(" LIKE \"*");
                    sbCriterion.append(unqualifiedValue);
                    sbCriterion.append("\"");
                    atlasCriterion.setOperator(SearchParameters.Operator.ENDS_WITH);
                } else if (this.repositoryHelper.isStartsWithRegex(candidateValue)) {
                    sbCriterion.append(" LIKE \"");
                    sbCriterion.append(unqualifiedValue);
                    sbCriterion.append("*\"");
                    atlasCriterion.setOperator(SearchParameters.Operator.STARTS_WITH);
                } else if (this.repositoryHelper.isExactMatchRegex(candidateValue)) {
                    if (negateCondition) {
                        if (unqualifiedValue.equals("")) {
                            atlasCriterion.setOperator(SearchParameters.Operator.NOT_NULL);
                        } else {
                            atlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                        }
                        sbCriterion.append(" != \"");
                    } else {
                        if (unqualifiedValue.equals("")) {
                            atlasCriterion.setOperator(SearchParameters.Operator.IS_NULL);
                        } else {
                            atlasCriterion.setOperator(SearchParameters.Operator.EQ);
                        }
                        sbCriterion.append(" = \"");
                    }
                    sbCriterion.append(unqualifiedValue);
                    sbCriterion.append("\"");
                } else {
                    this.raiseFunctionNotSupportedException(ApacheAtlasOMRSErrorCode.REGEX_NOT_IMPLEMENTED, "addSearchConditionFromValue", this.repositoryName, candidateValue);
                }
                atlasCriterion.setAttributeValue(unqualifiedValue);
                if (dslQuery) {
                    criteria.add(sbCriterion.toString());
                    return added;
                }
                criteria.add(atlasCriterion);
                return added;
            }
            case ENUM: {
                String omrsEnumValue = ((EnumPropertyValue)value).getSymbolicName();
                TypeDefAttribute typeDefAttribute = omrsTypeDefAttrMap.get(omrsPropertyName);
                if (typeDefAttribute == null) {
                    log.warn("Unable to find enum with name: {}", (Object)omrsPropertyName);
                    return false;
                }
                Map<String, Set<String>> elementMap = this.attributeTypeDefStore.getElementMappingsForOMRSTypeDef(typeDefAttribute.getAttributeType().getName());
                if (elementMap == null) return added;
                Set<String> atlasEnumValues = elementMap.get(omrsEnumValue);
                if (atlasEnumValues != null && !atlasEnumValues.isEmpty()) {
                    subAtlasCriteria = new ArrayList<SearchParameters.FilterCriteria>();
                    subCriteria = new ArrayList<String>();
                    sbCriterion.append("(");
                    iterator = atlasEnumValues.iterator();
                    break;
                }
                log.warn("Unable to find mapped enum value for {}: {}", (Object)omrsPropertyName, (Object)omrsEnumValue);
                return false;
            }
            case MAP: {
                Map mapValues = ((MapPropertyValue)value).getMapValues().getInstanceProperties();
                Iterator atlasEnumValues = mapValues.entrySet().iterator();
                while (atlasEnumValues.hasNext()) {
                    Map.Entry nextEntry = atlasEnumValues.next();
                    added = added && this.addSearchConditionFromValue(criteria, (String)nextEntry.getKey(), (InstancePropertyValue)nextEntry.getValue(), omrsToAtlasPropertyMap, omrsTypeDefAttrMap, negateCondition, dslQuery);
                }
                return added;
            }
            case ARRAY: {
                Map arrayValues = ((ArrayPropertyValue)value).getArrayValues().getInstanceProperties();
                Iterator iterator2 = arrayValues.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry nextEntry = iterator2.next();
                    added = added && this.addSearchConditionFromValue(criteria, atlasPropertyName, (InstancePropertyValue)nextEntry.getValue(), omrsToAtlasPropertyMap, omrsTypeDefAttrMap, negateCondition, dslQuery);
                }
                return added;
            }
            default: {
                log.warn("Unable to handle search criteria for value type: {}", (Object)category);
                return false;
            }
        }
        while (iterator.hasNext()) {
            String atlasEnumValue = iterator.next();
            StringBuilder subCriterion = new StringBuilder();
            SearchParameters.FilterCriteria subAtlasCriterion = new SearchParameters.FilterCriteria();
            subAtlasCriterion.setAttributeName(atlasPropertyName);
            subCriterion.append(atlasPropertyName);
            if (negateCondition) {
                subAtlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                subCriterion.append(" != \"");
            } else {
                subAtlasCriterion.setOperator(SearchParameters.Operator.EQ);
                subCriterion.append(" = \"");
            }
            subAtlasCriterion.setAttributeValue(atlasEnumValue);
            subCriterion.append(atlasEnumValue);
            subCriterion.append("\"");
            subAtlasCriteria.add(subAtlasCriterion);
            subCriteria.add(subCriterion.toString());
        }
        sbCriterion.append(String.join((CharSequence)" OR ", subCriteria));
        sbCriterion.append(")");
        atlasCriterion.setCriterion(subAtlasCriteria);
        atlasCriterion.setCondition(SearchParameters.FilterCriteria.Condition.OR);
        if (dslQuery) {
            criteria.add(sbCriterion.toString());
            return added;
        }
        criteria.add(atlasCriterion);
        return added;
    }

    private AtlasEntity.AtlasEntityWithExtInfo getAtlasEntitySafe(String guid, String methodName) throws EntityNotKnownException {
        AtlasEntity.AtlasEntityWithExtInfo entity = null;
        try {
            entity = this.atlasRepositoryConnector.getEntityByGUID(guid, false, true);
        }
        catch (AtlasServiceException e) {
            this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, methodName, e, guid, methodName, this.repositoryName);
        }
        if (entity == null) {
            this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, methodName, null, guid, methodName, this.repositoryName);
        }
        return entity;
    }

    private void raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws EntityNotKnownException {
        if (cause == null) {
            throw new EntityNotKnownException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new EntityNotKnownException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, cause);
    }

    private void raiseRelationshipNotKnownException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RelationshipNotKnownException {
        if (cause == null) {
            throw new RelationshipNotKnownException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new RelationshipNotKnownException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, cause);
    }

    private void raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        if (cause == null) {
            throw new RepositoryErrorException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new RepositoryErrorException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, cause);
    }

    private void raiseTypeDefNotKnownException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws TypeDefNotKnownException {
        if (cause == null) {
            throw new TypeDefNotKnownException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new TypeDefNotKnownException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, cause);
    }

    private void raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws TypeDefNotSupportedException {
        if (cause == null) {
            throw new TypeDefNotSupportedException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new TypeDefNotSupportedException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, cause);
    }

    private void raiseFunctionNotSupportedException(ApacheAtlasOMRSErrorCode errorCode, String methodName, String ... params) throws FunctionNotSupportedException {
        throw new FunctionNotSupportedException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
    }
}

