/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSAuditCode;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSMetadataCollection;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheAtlasOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    private static final Logger log = LoggerFactory.getLogger(ApacheAtlasOMRSRepositoryConnector.class);
    public static final String EP_ENTITY = "/api/atlas/v2/entity/guid/";
    private String url;
    private AtlasClientV2 atlasClient;
    private Map<String, AtlasEntityDef> atlasEntityTypesByName = new HashMap<String, AtlasEntityDef>();
    private boolean successfulInit = false;

    public OMRSMetadataCollection getMetadataCollection() throws RepositoryErrorException {
        String methodName = "getMetadataCollection";
        if (this.metadataCollection == null) {
            try {
                this.connectToAtlas("getMetadataCollection");
            }
            catch (ConnectorCheckedException e) {
                this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.REST_CLIENT_FAILURE, "getMetadataCollection", e, this.getServerName());
            }
        }
        return super.getMetadataCollection();
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.auditLog.logMessage("start", ApacheAtlasOMRSAuditCode.REPOSITORY_SERVICE_STARTING.getMessageDefinition());
        if (this.metadataCollection == null) {
            this.connectToAtlas("start");
        }
        this.auditLog.logMessage("start", ApacheAtlasOMRSAuditCode.REPOSITORY_SERVICE_STARTED.getMessageDefinition(this.getServerName()));
    }

    public void disconnect() {
        String methodName = "disconnect";
        this.auditLog.logMessage("disconnect", ApacheAtlasOMRSAuditCode.REPOSITORY_SERVICE_SHUTDOWN.getMessageDefinition(this.getServerName()));
    }

    public String getBaseURL() {
        return this.url;
    }

    public boolean typeDefExistsByName(String name) {
        return this.atlasClient.typeWithNameExists(name);
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityByGUID(String guid, boolean minimalExtraInfo, boolean ignoreRelationships) throws AtlasServiceException {
        return this.atlasClient.getEntityByGuid(guid, minimalExtraInfo, ignoreRelationships);
    }

    public AtlasRelationship.AtlasRelationshipWithExtInfo getRelationshipByGUID(String guid) throws AtlasServiceException {
        return this.getRelationshipByGUID(guid, false);
    }

    public AtlasRelationship.AtlasRelationshipWithExtInfo getRelationshipByGUID(String guid, boolean extendedInfo) throws AtlasServiceException {
        return this.atlasClient.getRelationshipByGuid(guid, extendedInfo);
    }

    public AtlasTypesDef createTypeDef(AtlasTypesDef typeDefs) throws AtlasServiceException {
        return this.atlasClient.createAtlasTypeDefs(typeDefs);
    }

    public AtlasTypesDef updateTypeDef(AtlasTypesDef typeDefs) throws AtlasServiceException {
        return this.atlasClient.updateAtlasTypeDefs(typeDefs);
    }

    public AtlasSearchResult searchForEntities(SearchParameters searchParameters) throws AtlasServiceException {
        log.debug("Searching Atlas with: {}", (Object)searchParameters);
        return this.atlasClient.facetedSearch(searchParameters);
    }

    public AtlasSearchResult searchWithDSL(String dslQuery) throws AtlasServiceException {
        log.debug("Searching Atlas with: {}", (Object)dslQuery);
        return this.atlasClient.dslSearch(dslQuery);
    }

    public String getParentTypeForAtlasEntityType(String type) {
        Set superTypes;
        AtlasEntityDef atlasEntityDef = this.atlasEntityTypesByName.getOrDefault(type, null);
        if (atlasEntityDef != null && (superTypes = atlasEntityDef.getSuperTypes()) != null && !superTypes.isEmpty()) {
            return (String)superTypes.iterator().next();
        }
        return null;
    }

    private void connectToAtlas(String methodName) throws ConnectorCheckedException {
        EndpointProperties endpointProperties = this.connectionProperties.getEndpoint();
        if (endpointProperties == null) {
            this.raiseConnectorCheckedException(ApacheAtlasOMRSErrorCode.REST_CLIENT_FAILURE, methodName, null, "null");
        } else {
            this.url = endpointProperties.getProtocol() + "://" + endpointProperties.getAddress();
            this.auditLog.logMessage(methodName, ApacheAtlasOMRSAuditCode.CONNECTING_TO_ATLAS.getMessageDefinition(this.getBaseURL()));
            String username = this.connectionProperties.getUserId();
            String password = this.connectionProperties.getClearPassword();
            this.atlasClient = new AtlasClientV2(new String[]{this.getBaseURL()}, new String[]{username, password});
            AtlasTypesDef atlasTypes = null;
            try {
                atlasTypes = this.atlasClient.getAllTypeDefs(new SearchFilter());
                this.successfulInit = atlasTypes != null && atlasTypes.hasEntityDef("Referenceable");
            }
            catch (AtlasServiceException e) {
                this.raiseConnectorCheckedException(ApacheAtlasOMRSErrorCode.REST_CLIENT_FAILURE, methodName, e, this.getBaseURL());
            }
            if (!this.successfulInit) {
                this.raiseConnectorCheckedException(ApacheAtlasOMRSErrorCode.REST_CLIENT_FAILURE, methodName, null, this.getBaseURL());
            } else {
                List atlasEntityDefs = atlasTypes.getEntityDefs();
                if (atlasEntityDefs != null) {
                    for (AtlasEntityDef atlasEntityDef : atlasEntityDefs) {
                        String atlasEntityTypeName = atlasEntityDef.getName();
                        this.atlasEntityTypesByName.put(atlasEntityTypeName, atlasEntityDef);
                    }
                }
                this.auditLog.logMessage(methodName, ApacheAtlasOMRSAuditCode.CONNECTED_TO_ATLAS.getMessageDefinition(this.getBaseURL()));
                this.metadataCollection = new ApacheAtlasOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, this.metadataCollectionId);
            }
        }
    }

    private void raiseConnectorCheckedException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws ConnectorCheckedException {
        if (cause == null) {
            throw new ConnectorCheckedException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new ConnectorCheckedException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, cause);
    }

    private void raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        if (cause == null) {
            throw new RepositoryErrorException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new RepositoryErrorException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, cause);
    }
}

