/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttributeMapping {
    private static final Logger log = LoggerFactory.getLogger(AttributeMapping.class);

    private AttributeMapping() {
    }

    public static boolean valuesMatch(InstancePropertyValue omrsValue, Object atlasValue) {
        if (omrsValue == null && atlasValue == null) {
            return true;
        }
        if (omrsValue != null && atlasValue != null) {
            boolean bMatch = false;
            block0 : switch (omrsValue.getInstancePropertyCategory()) {
                case ENUM: {
                    EnumPropertyValue enumValue = (EnumPropertyValue)omrsValue;
                    bMatch = enumValue.getSymbolicName().equals(atlasValue);
                    break;
                }
                case PRIMITIVE: {
                    PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)omrsValue;
                    switch (primitivePropertyValue.getPrimitiveDefCategory()) {
                        case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                            BigDecimal bigDecimal = (BigDecimal)primitivePropertyValue.getPrimitiveValue();
                            bMatch = bigDecimal.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                            BigInteger bigInteger = (BigInteger)primitivePropertyValue.getPrimitiveValue();
                            bMatch = bigInteger.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_BOOLEAN: {
                            Boolean boolVal = (Boolean)primitivePropertyValue.getPrimitiveValue();
                            bMatch = boolVal.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_BYTE: {
                            Byte byteVal = (Byte)primitivePropertyValue.getPrimitiveValue();
                            bMatch = byteVal.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_CHAR: {
                            Character charVal = (Character)primitivePropertyValue.getPrimitiveValue();
                            bMatch = charVal.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DOUBLE: {
                            Double doubleVal = (Double)primitivePropertyValue.getPrimitiveValue();
                            bMatch = doubleVal.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_FLOAT: {
                            Float floatVal = (Float)primitivePropertyValue.getPrimitiveValue();
                            bMatch = floatVal.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_INT: {
                            Integer intVal = (Integer)primitivePropertyValue.getPrimitiveValue();
                            bMatch = intVal.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_LONG: {
                            Long longVal = (Long)primitivePropertyValue.getPrimitiveValue();
                            bMatch = longVal.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_SHORT: {
                            Short shortVal = (Short)primitivePropertyValue.getPrimitiveValue();
                            bMatch = shortVal.equals(atlasValue);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_STRING: {
                            String stringVal = (String)primitivePropertyValue.getPrimitiveValue();
                            if (stringVal == null) break block0;
                            String toCompare = (String)atlasValue;
                            bMatch = toCompare.matches(stringVal);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            Long dateVal = (Long)primitivePropertyValue.getPrimitiveValue();
                            if (atlasValue instanceof Date) {
                                bMatch = dateVal.equals(((Date)atlasValue).getTime());
                                break;
                            }
                            bMatch = dateVal.equals(atlasValue);
                            break;
                        }
                        default: {
                            log.warn("Unhandled type for mapping: {}", (Object)omrsValue);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    log.warn("Unhandled type for mapping: {}", (Object)omrsValue);
                }
            }
            return bMatch;
        }
        return false;
    }

    static InstanceProperties addPropertyToInstance(OMRSRepositoryHelper repositoryHelper, String repositoryName, TypeDefAttribute property, InstanceProperties properties, AttributeTypeDefStore attributeDefStore, Object propertyValue, String methodName) {
        InstanceProperties resultingProperties = properties;
        switch (property.getAttributeType().getCategory()) {
            case ENUM_DEF: {
                AttributeMapping.addEnumPropertyToInstance(resultingProperties, property, attributeDefStore.getElementMappingsForOMRSTypeDef(property.getAttributeType().getName()), propertyValue);
                break;
            }
            case PRIMITIVE: {
                resultingProperties = AttributeMapping.addPrimitivePropertyToInstance(repositoryHelper, repositoryName, resultingProperties, property, propertyValue, methodName);
                break;
            }
            default: {
                log.warn("Unhandled type for mapping: {}", (Object)property);
            }
        }
        return resultingProperties;
    }

    private static InstanceProperties addPrimitivePropertyToInstance(OMRSRepositoryHelper omrsRepositoryHelper, String sourceName, InstanceProperties properties, TypeDefAttribute property, Object propertyValue, String methodName) {
        InstanceProperties resultingProperties = properties;
        if (propertyValue != null) {
            String propertyName = property.getAttributeName();
            log.debug("Adding property {} for {}", (Object)propertyName, (Object)methodName);
            if (property.getAttributeType().getCategory() == AttributeTypeDefCategory.PRIMITIVE) {
                try {
                    PrimitiveDef primitiveDef = (PrimitiveDef)property.getAttributeType();
                    switch (primitiveDef.getPrimitiveDefCategory()) {
                        case OM_PRIMITIVE_TYPE_BOOLEAN: {
                            boolean booleanValue = propertyValue instanceof Boolean ? ((Boolean)propertyValue).booleanValue() : Boolean.valueOf(propertyValue.toString()).booleanValue();
                            resultingProperties = omrsRepositoryHelper.addBooleanPropertyToInstance(sourceName, properties, propertyName, booleanValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_INT: {
                            int intValue = propertyValue instanceof Integer ? (Integer)propertyValue : (propertyValue instanceof Number ? ((Number)propertyValue).intValue() : Integer.valueOf(propertyValue.toString()).intValue());
                            resultingProperties = omrsRepositoryHelper.addIntPropertyToInstance(sourceName, properties, propertyName, intValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_LONG: {
                            long longValue = propertyValue instanceof Long ? (Long)propertyValue : (propertyValue instanceof Number ? ((Number)propertyValue).longValue() : Long.valueOf(propertyValue.toString()).longValue());
                            resultingProperties = omrsRepositoryHelper.addLongPropertyToInstance(sourceName, properties, propertyName, longValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_FLOAT: {
                            float floatValue = propertyValue instanceof Float ? ((Float)propertyValue).floatValue() : (propertyValue instanceof Number ? ((Number)propertyValue).floatValue() : Float.valueOf(propertyValue.toString()).floatValue());
                            resultingProperties = omrsRepositoryHelper.addFloatPropertyToInstance(sourceName, properties, propertyName, floatValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_STRING: {
                            String stringValue = propertyValue instanceof String ? (String)propertyValue : propertyValue.toString();
                            resultingProperties = omrsRepositoryHelper.addStringPropertyToInstance(sourceName, properties, propertyName, stringValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            if (propertyValue instanceof Date) {
                                resultingProperties = omrsRepositoryHelper.addDatePropertyToInstance(sourceName, properties, propertyName, (Date)propertyValue, methodName);
                                break;
                            }
                            resultingProperties = omrsRepositoryHelper.addDatePropertyToInstance(sourceName, properties, propertyName, new Date((Long)propertyValue), methodName);
                            break;
                        }
                        default: {
                            log.error("Unhandled primitive type {} for {}", (Object)primitiveDef.getPrimitiveDefCategory(), (Object)propertyName);
                            break;
                        }
                    }
                }
                catch (ClassCastException e) {
                    log.error("Unable to cast {} to {} for {}", new Object[]{propertyValue, property.getAttributeType(), propertyName});
                }
                catch (NumberFormatException e) {
                    log.warn("Unable to convert {} to {} for {}", new Object[]{propertyValue, property.getAttributeType(), propertyName});
                }
            } else {
                log.error("Cannot translate non-primitive property {} this way.", (Object)propertyName);
            }
        } else {
            log.debug("Null property");
        }
        return resultingProperties;
    }

    private static InstanceProperties addEnumPropertyToInstance(InstanceProperties properties, TypeDefAttribute property, Map<String, Set<String>> atlasElementValueToOmrsElementValue, Object propertyValue) {
        String propertyName = property.getAttributeName();
        if (propertyValue != null) {
            String omrsValue = null;
            if (atlasElementValueToOmrsElementValue != null) {
                for (Map.Entry<String, Set<String>> entry : atlasElementValueToOmrsElementValue.entrySet()) {
                    String cAtlas = entry.getKey();
                    if (!cAtlas.equals(propertyValue)) continue;
                    Set<String> possibleValues = entry.getValue();
                    omrsValue = (String)possibleValues.iterator().next();
                    break;
                }
            }
            if (omrsValue != null) {
                EnumDef omrsEnumProperty = (EnumDef)property.getAttributeType();
                List omrsElements = omrsEnumProperty.getElementDefs();
                EnumElementDef omrsEnumValue = null;
                for (EnumElementDef omrsElement : omrsElements) {
                    String cOmrs = omrsElement.getValue();
                    if (!cOmrs.equals(omrsValue)) continue;
                    omrsEnumValue = omrsElement;
                    break;
                }
                if (omrsEnumValue != null) {
                    EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
                    enumPropertyValue.setDescription(omrsEnumValue.getDescription());
                    enumPropertyValue.setOrdinal(omrsEnumValue.getOrdinal());
                    enumPropertyValue.setSymbolicName(omrsEnumValue.getValue());
                    properties.setProperty(propertyName, (InstancePropertyValue)enumPropertyValue);
                } else {
                    log.warn("Unable to find mapped enumeration value for property '{}': {}", (Object)propertyName, propertyValue);
                }
            } else {
                log.warn("Unable to find mapped enumeration value for property '{}': {}", (Object)propertyName, propertyValue);
            }
        } else {
            log.debug("Null property");
        }
        return properties;
    }

    public static int compareInstanceProperty(InstancePropertyValue v1, InstancePropertyValue v2) {
        int result = 0;
        if (v1 == v2) {
            result = 0;
        } else if (v1 == null) {
            result = -1;
        } else if (v2 == null) {
            result = 1;
        } else {
            InstancePropertyCategory category = v1.getInstancePropertyCategory();
            if (category.equals((Object)InstancePropertyCategory.PRIMITIVE)) {
                PrimitivePropertyValue pv1 = (PrimitivePropertyValue)v1;
                PrimitivePropertyValue pv2 = (PrimitivePropertyValue)v2;
                PrimitiveDefCategory primitiveCategory = pv1.getPrimitiveDefCategory();
                switch (primitiveCategory) {
                    case OM_PRIMITIVE_TYPE_INT: {
                        result = (Integer)pv1.getPrimitiveValue() - (Integer)pv2.getPrimitiveValue();
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_BYTE: {
                        result = ((Byte)pv1.getPrimitiveValue()).compareTo((Byte)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_CHAR: {
                        result = ((Character)pv1.getPrimitiveValue()).compareTo((Character)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_STRING: {
                        result = ((String)pv1.getPrimitiveValue()).compareTo((String)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_LONG: 
                    case OM_PRIMITIVE_TYPE_DATE: {
                        result = ((Long)pv1.getPrimitiveValue()).compareTo((Long)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_FLOAT: {
                        result = ((Float)pv1.getPrimitiveValue()).compareTo((Float)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_SHORT: {
                        result = ((Short)pv1.getPrimitiveValue()).compareTo((Short)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_DOUBLE: {
                        result = ((Double)pv1.getPrimitiveValue()).compareTo((Double)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_BOOLEAN: {
                        result = ((Boolean)pv1.getPrimitiveValue()).compareTo((Boolean)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                        result = ((BigDecimal)pv1.getPrimitiveValue()).compareTo((BigDecimal)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                        result = ((BigInteger)pv1.getPrimitiveValue()).compareTo((BigInteger)pv2.getPrimitiveValue());
                        break;
                    }
                    default: {
                        result = pv1.getPrimitiveValue().toString().compareTo(pv2.getPrimitiveValue().toString());
                        break;
                    }
                }
            } else {
                log.warn("Unhandled instance value type for comparison: {}", (Object)category);
            }
        }
        return result;
    }
}

