/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.List;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.RelationshipDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseTypeDefMapping {
    private static final Logger log = LoggerFactory.getLogger(BaseTypeDefMapping.class);

    protected BaseTypeDefMapping() {
    }

    static void setupBaseMapping(TypeDef omrsTypeDef, AtlasBaseTypeDef atlasTypeDef) {
        atlasTypeDef.setGuid(omrsTypeDef.getGUID());
        atlasTypeDef.setName(omrsTypeDef.getName());
        atlasTypeDef.setServiceType("omrs");
        atlasTypeDef.setCreatedBy(omrsTypeDef.getCreatedBy());
        atlasTypeDef.setUpdatedBy(omrsTypeDef.getUpdatedBy());
        atlasTypeDef.setCreateTime(omrsTypeDef.getCreateTime());
        atlasTypeDef.setUpdateTime(omrsTypeDef.getUpdateTime());
        atlasTypeDef.setVersion(Long.valueOf(omrsTypeDef.getVersion()));
        atlasTypeDef.setDescription(omrsTypeDef.getDescription());
    }

    static boolean setupPropertyMappings(TypeDef omrsTypeDef, AtlasStructDef atlasTypeDef, AttributeTypeDefStore attributeDefStore) {
        boolean fullyCovered = true;
        List omrsProperties = omrsTypeDef.getPropertiesDefinition();
        if (omrsProperties != null) {
            log.debug("List of properties is not null...");
            for (TypeDefAttribute typeDefAttribute : omrsProperties) {
                log.debug(" ... checking property: {}", (Object)typeDefAttribute);
                AtlasStructDef.AtlasAttributeDef atlasAttribute = new AtlasStructDef.AtlasAttributeDef();
                AttributeCardinality omrsCardinality = typeDefAttribute.getAttributeCardinality();
                switch (omrsCardinality) {
                    case AT_MOST_ONE: 
                    case ONE_ONLY: {
                        atlasAttribute.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
                        break;
                    }
                    case ANY_NUMBER_UNORDERED: 
                    case AT_LEAST_ONE_UNORDERED: {
                        atlasAttribute.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SET);
                        break;
                    }
                    case ANY_NUMBER_ORDERED: 
                    case AT_LEAST_ONE_ORDERED: {
                        atlasAttribute.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.LIST);
                        break;
                    }
                    default: {
                        fullyCovered = false;
                        log.warn("Unknown cardinality for OMRS property: {}", (Object)typeDefAttribute.getAttributeName());
                    }
                }
                atlasAttribute.setDefaultValue(typeDefAttribute.getDefaultValue());
                atlasAttribute.setDescription(typeDefAttribute.getAttributeDescription());
                atlasAttribute.setIncludeInNotification(Boolean.valueOf(true));
                atlasAttribute.setIsIndexable(typeDefAttribute.isIndexable());
                int minValues = typeDefAttribute.getValuesMinCount();
                atlasAttribute.setIsOptional(minValues < 1);
                atlasAttribute.setIsUnique(typeDefAttribute.isUnique());
                atlasAttribute.setName(typeDefAttribute.getAttributeName());
                AttributeTypeDef attributeTypeDef = typeDefAttribute.getAttributeType();
                block5 : switch (attributeTypeDef.getCategory()) {
                    case PRIMITIVE: {
                        PrimitiveDef primitiveDef = (PrimitiveDef)attributeTypeDef;
                        atlasAttribute.setTypeName(primitiveDef.getName());
                        break;
                    }
                    case ENUM_DEF: {
                        EnumDef enumDef = (EnumDef)attributeTypeDef;
                        String omrsEnumName = enumDef.getName();
                        String atlasEnumName = attributeDefStore.getMappedAtlasTypeDefName(omrsEnumName);
                        if (atlasEnumName == null) {
                            atlasEnumName = omrsEnumName;
                        }
                        atlasAttribute.setTypeName(atlasEnumName);
                        break;
                    }
                    case COLLECTION: {
                        CollectionDef collectionDef = (CollectionDef)attributeTypeDef;
                        CollectionDefCategory collectionDefCategory = collectionDef.getCollectionDefCategory();
                        switch (collectionDefCategory) {
                            case OM_COLLECTION_MAP: {
                                List mapArgs = collectionDef.getArgumentTypes();
                                atlasAttribute.setTypeName("map<" + BaseTypeDefMapping.getAtlasPrimitiveNameFromOMRSPrimitiveName(((PrimitiveDefCategory)mapArgs.get(0)).getName()) + "," + BaseTypeDefMapping.getAtlasPrimitiveNameFromOMRSPrimitiveName(((PrimitiveDefCategory)mapArgs.get(1)).getName()) + ">");
                                break block5;
                            }
                            case OM_COLLECTION_ARRAY: {
                                List arrayArgs = collectionDef.getArgumentTypes();
                                atlasAttribute.setTypeName("array<" + BaseTypeDefMapping.getAtlasPrimitiveNameFromOMRSPrimitiveName(((PrimitiveDefCategory)arrayArgs.get(0)).getName()) + ">");
                                break block5;
                            }
                            case OM_COLLECTION_STRUCT: {
                                atlasAttribute.setTypeName("struct");
                                break block5;
                            }
                        }
                        fullyCovered = false;
                        log.warn("Unhandled collection attribute type for typedef: {}", (Object)attributeTypeDef.getName());
                        break;
                    }
                    default: {
                        fullyCovered = false;
                        log.warn("Unhandled attribute type for classification: {}", (Object)attributeTypeDef.getName());
                    }
                }
                atlasAttribute.setValuesMinCount(minValues);
                atlasAttribute.setValuesMaxCount(typeDefAttribute.getValuesMaxCount());
                atlasTypeDef.addAttribute(atlasAttribute);
            }
        }
        return fullyCovered;
    }

    private static String getAtlasPrimitiveNameFromOMRSPrimitiveName(String omrsPrimitiveName) {
        String lowercaseName;
        String atlasName = null;
        switch (lowercaseName = omrsPrimitiveName.toLowerCase()) {
            case "boolean": 
            case "string": 
            case "long": 
            case "int": 
            case "date": {
                atlasName = lowercaseName;
                break;
            }
            case "object": 
            case "char": 
            case "byte": 
            case "biginteger": 
            case "bigdecimal": {
                atlasName = "string";
                break;
            }
            case "short": {
                atlasName = "int";
                break;
            }
            case "float": 
            case "double": {
                atlasName = "long";
                log.warn("Actual type for OMRS is '{}', casting down to 'long' as no Atlas support decimal-based numbers?", (Object)lowercaseName);
            }
        }
        return atlasName;
    }

    protected static void raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws TypeDefNotSupportedException {
        if (cause == null) {
            throw new TypeDefNotSupportedException(errorCode.getMessageDefinition(params), RelationshipDefMapping.class.getName(), methodName);
        }
        throw new TypeDefNotSupportedException(errorCode.getMessageDefinition(params), RelationshipDefMapping.class.getName(), methodName, cause);
    }

    protected static void raisePatchErrorException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws PatchErrorException {
        if (cause == null) {
            throw new PatchErrorException(errorCode.getMessageDefinition(params), RelationshipDefMapping.class.getName(), methodName);
        }
        throw new PatchErrorException(errorCode.getMessageDefinition(params), RelationshipDefMapping.class.getName(), methodName, cause);
    }
}

