/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.BaseTypeDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassificationDefMapping
extends BaseTypeDefMapping {
    private static final Logger log = LoggerFactory.getLogger(ClassificationDefMapping.class);

    private ClassificationDefMapping() {
    }

    public static void addClassificationTypeToAtlas(ClassificationDef omrsClassificationDef, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore, ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector) throws TypeDefNotSupportedException {
        String methodName = "addClassificationTypeToAtlas";
        String omrsTypeDefName = omrsClassificationDef.getName();
        AtlasTypesDef atlasTypesDef = ClassificationDefMapping.setupClassificationType(omrsClassificationDef, typeDefStore, attributeDefStore);
        if (atlasTypesDef != null) {
            try {
                atlasRepositoryConnector.createTypeDef(atlasTypesDef);
                typeDefStore.addTypeDef((TypeDef)omrsClassificationDef);
            }
            catch (AtlasServiceException e) {
                typeDefStore.addUnimplementedTypeDef((TypeDef)omrsClassificationDef);
                ClassificationDefMapping.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "addClassificationTypeToAtlas", e, omrsTypeDefName, atlasRepositoryConnector.getServerName());
            }
        } else {
            typeDefStore.addUnimplementedTypeDef((TypeDef)omrsClassificationDef);
            ClassificationDefMapping.raiseTypeDefNotSupportedException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "addClassificationTypeToAtlas", null, omrsTypeDefName, atlasRepositoryConnector.getServerName());
        }
    }

    public static void updateClassificationTypeInAtlas(ClassificationDef omrsClassificationDef, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore, ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector) throws PatchErrorException {
        String methodName = "updateClassificationTypeInAtlas";
        String omrsTypeDefName = omrsClassificationDef.getName();
        AtlasTypesDef atlasTypesDef = ClassificationDefMapping.setupClassificationType(omrsClassificationDef, typeDefStore, attributeDefStore);
        if (atlasTypesDef != null) {
            try {
                atlasRepositoryConnector.updateTypeDef(atlasTypesDef);
                typeDefStore.addTypeDef((TypeDef)omrsClassificationDef);
            }
            catch (AtlasServiceException e) {
                typeDefStore.addUnimplementedTypeDef((TypeDef)omrsClassificationDef);
                ClassificationDefMapping.raisePatchErrorException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "updateClassificationTypeInAtlas", e, omrsTypeDefName, atlasRepositoryConnector.getServerName());
            }
        } else {
            typeDefStore.addUnimplementedTypeDef((TypeDef)omrsClassificationDef);
            ClassificationDefMapping.raisePatchErrorException(ApacheAtlasOMRSErrorCode.TYPEDEF_NOT_SUPPORTED, "updateClassificationTypeInAtlas", null, omrsTypeDefName, atlasRepositoryConnector.getServerName());
        }
    }

    private static AtlasTypesDef setupClassificationType(ClassificationDef omrsClassificationDef, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore) {
        String omrsTypeDefName = omrsClassificationDef.getName();
        boolean fullyCovered = true;
        AtlasClassificationDef classificationTypeDef = new AtlasClassificationDef();
        ClassificationDefMapping.setupBaseMapping((TypeDef)omrsClassificationDef, (AtlasBaseTypeDef)classificationTypeDef);
        HashSet<String> entitiesForAtlas = new HashSet<String>();
        List validEntities = omrsClassificationDef.getValidEntityDefs();
        for (TypeDefLink typeDefLink : validEntities) {
            String omrsEntityName = typeDefLink.getName();
            String atlasEntityName = typeDefStore.getMappedAtlasTypeDefName(omrsEntityName, null);
            if (atlasEntityName == null) continue;
            entitiesForAtlas.add(atlasEntityName);
        }
        if (entitiesForAtlas.isEmpty()) {
            log.warn("No relevant Atlas entities found for classification: {}", (Object)omrsTypeDefName);
            fullyCovered = false;
        }
        classificationTypeDef.setEntityTypes(entitiesForAtlas);
        fullyCovered = fullyCovered && ClassificationDefMapping.setupPropertyMappings((TypeDef)omrsClassificationDef, (AtlasStructDef)classificationTypeDef, attributeDefStore);
        AtlasTypesDef atlasTypesDef = null;
        if (fullyCovered) {
            atlasTypesDef = new AtlasTypesDef();
            ArrayList<AtlasClassificationDef> classificationList = new ArrayList<AtlasClassificationDef>();
            classificationList.add(classificationTypeDef);
            atlasTypesDef.setClassificationDefs(classificationList);
        }
        return atlasTypesDef;
    }
}

