/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping;

import java.util.Date;
import java.util.Map;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.AttributeMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.model.AtlasGuid;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(RelationshipMapping.class);
    private ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector;
    private TypeDefStore typeDefStore;
    private AttributeTypeDefStore attributeDefStore;
    private AtlasGuid atlasGuid;
    private AtlasRelationship atlasRelationship;
    private String userId;

    public RelationshipMapping(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, AttributeTypeDefStore attributeDefStore, AtlasGuid atlasGuid, AtlasRelationship.AtlasRelationshipWithExtInfo instance, String userId) {
        this.atlasRepositoryConnector = atlasRepositoryConnector;
        this.typeDefStore = typeDefStore;
        this.attributeDefStore = attributeDefStore;
        this.atlasGuid = atlasGuid;
        this.atlasRelationship = instance.getRelationship();
        this.userId = userId;
    }

    public Relationship getRelationship() throws RepositoryErrorException {
        String methodName = "getRelationship";
        String repositoryName = this.atlasRepositoryConnector.getRepositoryName();
        String atlasRelationshipType = this.atlasRelationship.getTypeName();
        String relationshipPrefix = this.atlasGuid.getGeneratedPrefix();
        TypeDefStore.EndpointMapping mapping = this.typeDefStore.getEndpointMappingFromAtlasName(atlasRelationshipType, relationshipPrefix);
        AtlasObjectId atlasEp1 = this.atlasRelationship.getEnd1();
        AtlasObjectId atlasEp2 = this.atlasRelationship.getEnd2();
        EntityProxy ep1 = null;
        EntityProxy ep2 = null;
        Relationship omrsRelationship = null;
        try {
            ep1 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasRepositoryConnector.getEntityByGUID(atlasEp1.getGuid(), true, true).getEntity(), mapping.getPrefixOne(), this.userId);
        }
        catch (AtlasServiceException e) {
            this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationship", e, atlasEp1.getGuid(), "getRelationship", repositoryName);
        }
        try {
            ep2 = RelationshipMapping.getEntityProxyForObject(this.atlasRepositoryConnector, this.typeDefStore, this.atlasRepositoryConnector.getEntityByGUID(atlasEp2.getGuid(), true, true).getEntity(), mapping.getPrefixTwo(), this.userId);
        }
        catch (AtlasServiceException e) {
            this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationship", e, atlasEp2.getGuid(), "getRelationship", repositoryName);
        }
        if (ep1 != null && ep2 != null) {
            omrsRelationship = this.getRelationship(atlasRelationshipType, ep1, ep2);
        }
        return omrsRelationship;
    }

    private Relationship getRelationship(String atlasRelationshipType, EntityProxy ep1, EntityProxy ep2) throws RepositoryErrorException {
        InstanceStatus omrsRelationshipStatus;
        String methodName = "getRelationship";
        OMRSRepositoryHelper omrsRepositoryHelper = this.atlasRepositoryConnector.getRepositoryHelper();
        String repositoryName = this.atlasRepositoryConnector.getRepositoryName();
        String omrsRelationshipType = this.typeDefStore.getMappedOMRSTypeDefName(atlasRelationshipType, this.atlasGuid.getGeneratedPrefix());
        AtlasRelationship.Status relationshipStatus = this.atlasRelationship.getStatus();
        switch (relationshipStatus) {
            case ACTIVE: {
                omrsRelationshipStatus = InstanceStatus.ACTIVE;
                break;
            }
            case DELETED: {
                omrsRelationshipStatus = InstanceStatus.DELETED;
                break;
            }
            default: {
                log.warn("Unhandled relationship status, defaulting to ACTIVE: {}", (Object)relationshipStatus);
                omrsRelationshipStatus = InstanceStatus.ACTIVE;
            }
        }
        Map atlasRelationshipProperties = this.atlasRelationship.getAttributes();
        InstanceProperties omrsRelationshipProperties = new InstanceProperties();
        if (atlasRelationshipProperties != null) {
            Map<String, TypeDefAttribute> relationshipAttributeMap = this.typeDefStore.getAllTypeDefAttributesForName(omrsRelationshipType);
            Map<String, String> atlasToOmrsProperties = this.typeDefStore.getPropertyMappingsForAtlasTypeDef(atlasRelationshipType, this.atlasGuid.getGeneratedPrefix());
            if (atlasToOmrsProperties != null) {
                for (Map.Entry<String, String> property : atlasToOmrsProperties.entrySet()) {
                    String atlasProperty = property.getKey();
                    String omrsProperty = property.getValue();
                    if (relationshipAttributeMap.containsKey(omrsProperty)) {
                        TypeDefAttribute typeDefAttribute = relationshipAttributeMap.get(omrsProperty);
                        omrsRelationshipProperties = AttributeMapping.addPropertyToInstance(omrsRepositoryHelper, repositoryName, typeDefAttribute, omrsRelationshipProperties, this.attributeDefStore, atlasRelationshipProperties.get(atlasProperty), "getRelationship");
                        continue;
                    }
                    log.warn("No OMRS attribute {} defined for asset type {} -- skipping mapping.", (Object)omrsProperty, (Object)omrsRelationshipType);
                }
            }
        }
        return RelationshipMapping.getRelationship(this.atlasRepositoryConnector, this.typeDefStore, omrsRelationshipType, this.atlasGuid, omrsRelationshipStatus, ep1, ep2, this.atlasRelationship.getCreatedBy(), this.atlasRelationship.getUpdatedBy(), this.atlasRelationship.getCreateTime(), this.atlasRelationship.getUpdateTime(), omrsRelationshipProperties);
    }

    public static Relationship getSelfReferencingRelationship(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, AtlasGuid relationshipGUID, AtlasEntity entity) throws RepositoryErrorException {
        Relationship omrsRelationship = null;
        String prefix = relationshipGUID.getGeneratedPrefix();
        if (prefix != null) {
            RelationshipDef relationshipDef = (RelationshipDef)typeDefStore.getTypeDefByPrefix(prefix);
            String omrsRelationshipType = relationshipDef.getName();
            TypeDefStore.EndpointMapping mapping = typeDefStore.getEndpointMappingFromAtlasName(entity.getTypeName(), prefix);
            EntityProxy ep1 = RelationshipMapping.getEntityProxyForObject(atlasRepositoryConnector, typeDefStore, entity, mapping.getPrefixOne(), null);
            EntityProxy ep2 = RelationshipMapping.getEntityProxyForObject(atlasRepositoryConnector, typeDefStore, entity, mapping.getPrefixTwo(), null);
            omrsRelationship = RelationshipMapping.getRelationship(atlasRepositoryConnector, typeDefStore, omrsRelationshipType, relationshipGUID, InstanceStatus.ACTIVE, ep1, ep2, entity.getCreatedBy(), entity.getUpdatedBy(), entity.getCreateTime(), entity.getUpdateTime(), new InstanceProperties());
        } else {
            log.error("A self-referencing, generated relationship was requested, but there is no prefix: {}", (Object)relationshipGUID);
        }
        return omrsRelationship;
    }

    private static Relationship getRelationship(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, String omrsRelationshipType, AtlasGuid relationshipGUID, InstanceStatus relationshipStatus, EntityProxy ep1, EntityProxy ep2, String createdBy, String updatedBy, Date createTime, Date updateTime, InstanceProperties omrsRelationshipProperties) throws RepositoryErrorException {
        String methodName = "getRelationship";
        String repositoryName = atlasRepositoryConnector.getRepositoryName();
        Relationship omrsRelationship = RelationshipMapping.getSkeletonRelationship(atlasRepositoryConnector, (RelationshipDef)typeDefStore.getTypeDefByName(omrsRelationshipType));
        omrsRelationship.setGUID(relationshipGUID.toString());
        omrsRelationship.setMetadataCollectionId(atlasRepositoryConnector.getMetadataCollectionId());
        omrsRelationship.setStatus(relationshipStatus);
        omrsRelationship.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
        omrsRelationship.setVersion(updateTime.getTime());
        omrsRelationship.setCreateTime(createTime);
        omrsRelationship.setCreatedBy(createdBy);
        omrsRelationship.setUpdatedBy(updatedBy);
        omrsRelationship.setUpdateTime(updateTime);
        if (ep1 == null || ep2 == null) {
            throw new RepositoryErrorException(ApacheAtlasOMRSErrorCode.INVALID_RELATIONSHIP_ENDS.getMessageDefinition("getRelationship", repositoryName, omrsRelationshipType, ep1 == null ? "null" : ep1.getGUID(), ep2 == null ? "null" : ep2.getGUID()), RelationshipMapping.class.getName(), "getRelationship");
        }
        omrsRelationship.setEntityOneProxy(ep1);
        omrsRelationship.setEntityTwoProxy(ep2);
        if (omrsRelationshipProperties != null) {
            omrsRelationship.setProperties(omrsRelationshipProperties);
        }
        return omrsRelationship;
    }

    public static EntityProxy getEntityProxyForObject(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, TypeDefStore typeDefStore, AtlasEntity atlasObj, String entityPrefix, String userId) {
        String methodName = "getEntityProxyForObject";
        EntityProxy entityProxy = null;
        if (atlasObj != null) {
            String repositoryName = atlasRepositoryConnector.getRepositoryName();
            OMRSRepositoryHelper repositoryHelper = atlasRepositoryConnector.getRepositoryHelper();
            String metadataCollectionId = atlasRepositoryConnector.getMetadataCollectionId();
            String atlasTypeName = atlasObj.getTypeName();
            String omrsTypeDefName = typeDefStore.getMappedOMRSTypeDefName(atlasTypeName, entityPrefix);
            Map attributes = atlasObj.getAttributes();
            if (!attributes.containsKey("qualifiedName")) {
                log.error("No qualifiedName found for object -- cannot create EntityProxy: {}", (Object)atlasObj);
                throw new NullPointerException("No qualifiedName found for object -- cannot create EntityProxy.");
            }
            String qualifiedName = (String)attributes.get("qualifiedName");
            InstanceProperties uniqueProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, null, "qualifiedName", qualifiedName, "getEntityProxyForObject");
            try {
                entityProxy = repositoryHelper.getNewEntityProxy(repositoryName, metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, omrsTypeDefName, uniqueProperties, null);
                AtlasGuid atlasGuid = new AtlasGuid(atlasObj.getGuid(), entityPrefix);
                entityProxy.setGUID(atlasGuid.toString());
                entityProxy.setCreatedBy(atlasObj.getCreatedBy());
                entityProxy.setCreateTime(atlasObj.getCreateTime());
                entityProxy.setUpdatedBy(atlasObj.getUpdatedBy());
                entityProxy.setUpdateTime(atlasObj.getUpdateTime());
                entityProxy.setVersion(atlasObj.getVersion().longValue());
            }
            catch (TypeErrorException e) {
                log.error("Unable to create new EntityProxy.", (Throwable)e);
            }
        } else {
            log.error("No Apache Atlas object provided (was null).");
        }
        return entityProxy;
    }

    static Relationship getSkeletonRelationship(ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector, RelationshipDef omrsRelationshipDef) throws RepositoryErrorException {
        String methodName = "getSkeletonRelationship";
        Relationship relationship = new Relationship();
        try {
            InstanceType instanceType = atlasRepositoryConnector.getRepositoryHelper().getNewInstanceType(atlasRepositoryConnector.getRepositoryName(), (TypeDefSummary)omrsRelationshipDef);
            relationship.setType(instanceType);
        }
        catch (TypeErrorException e) {
            throw new RepositoryErrorException(ApacheAtlasOMRSErrorCode.INVALID_INSTANCE.getMessageDefinition("getSkeletonRelationship", omrsRelationshipDef.getName()), RelationshipMapping.class.getName(), "getSkeletonRelationship", (Throwable)e);
        }
        return relationship;
    }

    private void raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        throw new RepositoryErrorException(errorCode.getMessageDefinition(params), RelationshipMapping.class.getName(), methodName, cause);
    }
}

