/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector.model;

import java.util.Objects;

public class AtlasGuid {
    private static final String GENERATED_TYPE_POSTFIX = "!";
    private String atlasGuid;
    private String generatedPrefix;

    public AtlasGuid(String atlasGuid, String prefix) {
        this.generatedPrefix = prefix;
        this.atlasGuid = atlasGuid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.generatedPrefix != null) {
            sb.append(this.generatedPrefix);
            sb.append(GENERATED_TYPE_POSTFIX);
        }
        sb.append(this.atlasGuid);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AtlasGuid)) {
            return false;
        }
        AtlasGuid that = (AtlasGuid)obj;
        return Objects.equals(this.getAtlasGuid(), that.getAtlasGuid()) && Objects.equals(this.getGeneratedPrefix(), that.getGeneratedPrefix());
    }

    public int hashCode() {
        return Objects.hash(this.getAtlasGuid(), this.getGeneratedPrefix());
    }

    public static AtlasGuid fromGuid(String guidToConvert) {
        if (guidToConvert == null) {
            return null;
        }
        String atlasGuid = guidToConvert;
        String generatedPrefix = null;
        int indexOfGeneratedPostfix = guidToConvert.indexOf(GENERATED_TYPE_POSTFIX);
        if (indexOfGeneratedPostfix > 0) {
            generatedPrefix = guidToConvert.substring(0, indexOfGeneratedPostfix);
            atlasGuid = guidToConvert.substring(indexOfGeneratedPostfix + 1);
        }
        return new AtlasGuid(atlasGuid, generatedPrefix);
    }

    public String getGeneratedPrefix() {
        return this.generatedPrefix;
    }

    public boolean isGeneratedInstanceGuid() {
        return this.generatedPrefix != null;
    }

    public String getAtlasGuid() {
        return this.atlasGuid;
    }
}

