/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.migration;

import crux.api.Crux;
import crux.api.ICruxAPI;
import java.io.File;
import org.odpi.egeria.connectors.juxt.crux.migration.model.UpgradeInitialTo2;
import org.odpi.egeria.connectors.juxt.crux.model.PersistenceLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    public static final int DEFAULT_BATCH_SIZE = 500;
    private static final Logger log = LoggerFactory.getLogger(Migrator.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            log.error("No configuration file path provided. The path to a JSON configuration file for the node must be provided.");
            System.exit(1);
        }
        String configFile = args[0];
        File config = new File(configFile);
        int batchSize = 500;
        if (args.length == 2) {
            try {
                batchSize = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to parse batch size '{}' as an integer -- falling back to default batch size.", (Object)args[1]);
            }
        }
        log.info("Starting a Crux node using configuration: {}", (Object)configFile);
        try (ICruxAPI cruxAPI = Crux.startNode((File)config);){
            log.info("... checking if migration is needed ({})", (Object)cruxAPI);
            if (PersistenceLayer.isLatestVersion((ICruxAPI)cruxAPI)) {
                log.info("This node is already at the latest version of the persistence layer ({}) -- no migration needed.", (Object)2L);
            } else {
                while (!PersistenceLayer.isLatestVersion((ICruxAPI)cruxAPI)) {
                    long currentVersion = PersistenceLayer.getVersion((ICruxAPI)cruxAPI);
                    log.info("The node is at version {}, while latest is {} -- migrating...", (Object)currentVersion, (Object)2L);
                    if (currentVersion != -1L) continue;
                    UpgradeInitialTo2 upgradeInitialTo2 = new UpgradeInitialTo2(cruxAPI, batchSize);
                    upgradeInitialTo2.migrate();
                }
            }
        }
        catch (Exception e) {
            log.error("Fatal error!", (Throwable)e);
        }
        log.info("Work complete -- exiting.");
    }
}

