/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.migration.model;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import crux.api.CruxDocument;
import crux.api.HistoryOptions;
import crux.api.ICruxAPI;
import crux.api.ICruxDatasource;
import crux.api.ICursor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.juxt.crux.mapping.Constants;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.crux.migration.model.UpgradePersistence;

public class UpgradeInitialTo2
extends UpgradePersistence {
    static final String TYPE_DEF_GUID = "type.guid";
    static final String SUPERTYPE_DEF_GUIDS = "type.supers";
    static final String TYPE_DEF_GUIDS = "type.guids";
    static final String ENTITY_ONE_PROXY = "entityOneProxy";
    static final String ENTITY_TWO_PROXY = "entityTwoProxy";
    static final String ENTITY_PROXIES = "entityProxies";

    public UpgradeInitialTo2(ICruxAPI cruxAPI, int batchSize) {
        super(cruxAPI, -1L, 2L, batchSize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void migrateMetadata() throws Exception {
        HistoryOptions options = HistoryOptions.create((HistoryOptions.SortOrder)HistoryOptions.SortOrder.DESC);
        ICruxDatasource db = this.cruxAPI.db();
        try (ICursor searchCursor = db.openQuery((Object)this.getAllInstancesQuery(), new Object[0]);){
            while (searchCursor.hasNext()) {
                ICursor historyCursor;
                block24: {
                    List next = (List)searchCursor.next();
                    String docId = (String)next.get(0);
                    historyCursor = db.openEntityHistory((Object)docId, options);
                    Throwable throwable = null;
                    try {
                        while (historyCursor.hasNext()) {
                            Map version = (Map)historyCursor.next();
                            Object oValid = version.get(Constants.CRUX_VALID_TIME);
                            Object oTxn = version.get(Constants.CRUX_TX_TIME);
                            if (!(oValid instanceof Date) || !(oTxn instanceof Date)) continue;
                            Date valid = (Date)oValid;
                            Date txn = (Date)oTxn;
                            CruxDocument doc = this.cruxAPI.db(valid, txn).entity((Object)docId);
                            CruxDocument upgraded = this.migrateInstanceAuditHeader(doc);
                            if (this.isRelationship(upgraded)) {
                                upgraded = this.migrateRelationship(upgraded);
                            }
                            this.putToBatch(upgraded, valid, null);
                        }
                        if (historyCursor == null) continue;
                        if (throwable == null) break block24;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (historyCursor == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    historyCursor.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            historyCursor.close();
                            throw throwable3;
                        }
                    }
                    try {
                        historyCursor.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                historyCursor.close();
            }
            return;
        }
    }

    private CruxDocument migrateInstanceAuditHeader(CruxDocument doc) {
        Object typeDefGuid = doc.get(TYPE_DEF_GUID);
        Object superTypeDefGuids = doc.get(SUPERTYPE_DEF_GUIDS);
        ArrayList<Object> types = new ArrayList<Object>();
        if (typeDefGuid != null) {
            types.add(typeDefGuid);
        }
        if (superTypeDefGuids instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)superTypeDefGuids;
            for (int i = 0; i < v.length(); ++i) {
                Object supertype = v.nth(i);
                if (supertype == null) continue;
                types.add(supertype);
            }
        }
        HashSet<String> remove = new HashSet<String>();
        remove.add(TYPE_DEF_GUID);
        remove.add(SUPERTYPE_DEF_GUIDS);
        return doc.minusAll(remove).plus(TYPE_DEF_GUIDS, (Object)PersistentVector.create(types));
    }

    private CruxDocument migrateRelationship(CruxDocument doc) {
        Object proxyOne = doc.get(ENTITY_ONE_PROXY);
        Object proxyTwo = doc.get(ENTITY_TWO_PROXY);
        ArrayList<Object> proxies = new ArrayList<Object>();
        if (proxyOne != null && proxyTwo != null) {
            proxies.add(proxyOne);
            proxies.add(proxyTwo);
        }
        HashSet<String> remove = new HashSet<String>();
        remove.add(ENTITY_ONE_PROXY);
        remove.add(ENTITY_TWO_PROXY);
        return doc.minusAll(remove).plus(ENTITY_PROXIES, (Object)PersistentVector.create(proxies));
    }

    private IPersistentMap getAllInstancesQuery() {
        Symbol docVar = Symbol.intern((String)"d");
        PersistentArrayMap query = PersistentArrayMap.EMPTY;
        PersistentVector conditions = PersistentVector.create((Object[])new Object[]{docVar, Keyword.intern((String)InstanceAuditHeaderMapping.METADATA_COLLECTION_ID), Symbol.intern((String)"_")});
        query = query.assoc((Object)Keyword.intern((String)"find"), (Object)PersistentVector.create((Object[])new Object[]{docVar}));
        query = query.assoc((Object)Keyword.intern((String)"where"), (Object)PersistentVector.create((Object[])new Object[]{conditions}));
        return query;
    }

    private boolean isRelationship(CruxDocument doc) {
        return doc != null && ((String)doc.getId()).startsWith("r_");
    }
}

