/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.migration.model;

import crux.api.CruxDocument;
import crux.api.ICruxAPI;
import crux.api.tx.Transaction;
import java.util.Date;
import org.odpi.egeria.connectors.juxt.crux.model.PersistenceLayer;

public abstract class UpgradePersistence {
    protected final ICruxAPI cruxAPI;
    private final long fromVersion;
    private final long toVersion;
    private final int batchSize;
    private Transaction.Builder tx;
    private int txSize;

    protected UpgradePersistence(ICruxAPI cruxAPI, long from, long to, int batchSize) {
        this.cruxAPI = cruxAPI;
        this.fromVersion = from;
        this.toVersion = to;
        this.batchSize = batchSize;
        this.setNewTransactionQueue();
    }

    public long getFromVersion() {
        return this.fromVersion;
    }

    public long getToVersion() {
        return this.toVersion;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public final void migrate() throws Exception {
        this.migrateMetadata();
        this.markUpdatedVersion();
    }

    public abstract void migrateMetadata() throws Exception;

    protected void putToBatch(CruxDocument doc, Date valid, Date txn) {
        if (doc != null) {
            this.tx.put(doc, valid, txn);
            ++this.txSize;
            if (this.txSize == this.batchSize) {
                this.submitBatch();
                this.setNewTransactionQueue();
            }
        }
    }

    private void submitBatch() {
        this.cruxAPI.submitTx(this.tx.build());
    }

    private void setNewTransactionQueue() {
        this.tx = Transaction.builder();
        this.txSize = 0;
    }

    private void markUpdatedVersion() {
        PersistenceLayer.setVersion((ICruxAPI)this.cruxAPI, (long)this.toVersion);
    }
}

