/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import clojure.lang.IPersistentVector;
import clojure.lang.PersistentVector;
import crux.api.CruxDocument;
import crux.api.ICruxDatasource;
import org.odpi.egeria.connectors.juxt.crux.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstanceHeaderMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstancePropertiesMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipMapping
extends InstanceHeaderMapping {
    private static final Logger log = LoggerFactory.getLogger(RelationshipMapping.class);
    public static final String INSTANCE_REF_PREFIX = "r";
    public static final String RELATIONSHIP_PROPERTIES_NS = "relationshipProperties";
    private static final String N_ENTITY_PROXIES = "entityProxies";
    public static final String ENTITY_PROXIES = RelationshipMapping.getKeyword("entityProxies");
    private ICruxDatasource db;

    public RelationshipMapping(CruxOMRSRepositoryConnector cruxConnector, Relationship relationship) {
        super(cruxConnector, (InstanceHeader)relationship);
    }

    public RelationshipMapping(CruxOMRSRepositoryConnector cruxConnector, CruxDocument cruxDoc, ICruxDatasource db) {
        super(cruxConnector, cruxDoc);
        this.db = db;
    }

    public Relationship toEgeria() {
        if (this.instanceHeader == null && this.cruxDoc != null) {
            this.instanceHeader = new Relationship();
            this.fromDoc();
        }
        if (this.instanceHeader != null) {
            return (Relationship)this.instanceHeader;
        }
        return null;
    }

    @Override
    protected CruxDocument.Builder toDoc() {
        CruxDocument.Builder builder = super.toDoc();
        Relationship relationship = (Relationship)this.instanceHeader;
        EntityProxy one = relationship.getEntityOneProxy();
        EntityProxy two = relationship.getEntityTwoProxy();
        builder.put(ENTITY_PROXIES, (Object)PersistentVector.create((Object[])new Object[]{EntityProxyMapping.getReference(one.getGUID()), EntityProxyMapping.getReference(two.getGUID())}));
        InstancePropertiesMapping.addToDoc(this.cruxConnector, builder, relationship.getType(), relationship.getProperties(), RELATIONSHIP_PROPERTIES_NS);
        return builder;
    }

    @Override
    protected void fromDoc() {
        super.fromDoc();
        try {
            IPersistentVector v;
            Object proxies = this.cruxDoc.get(ENTITY_PROXIES);
            if (proxies instanceof IPersistentVector && (v = (IPersistentVector)proxies).length() == 2) {
                EntityProxy one = this.getEntityProxyFromRef((String)v.nth(0));
                EntityProxy two = this.getEntityProxyFromRef((String)v.nth(1));
                if (one != null && two != null) {
                    ((Relationship)this.instanceHeader).setEntityOneProxy(one);
                    ((Relationship)this.instanceHeader).setEntityTwoProxy(two);
                }
            }
            InstanceProperties ip = InstancePropertiesMapping.getFromDoc(this.instanceHeader.getType(), this.cruxDoc, RELATIONSHIP_PROPERTIES_NS);
            ((Relationship)this.instanceHeader).setProperties(ip);
        }
        catch (RepositoryErrorException e) {
            log.error("Unable to retrieve entity proxy, nullifying the relationship.", (Throwable)e);
            this.instanceHeader = null;
        }
    }

    private EntityProxy getEntityProxyFromRef(String ref) throws RepositoryErrorException {
        CruxDocument epDoc = this.cruxConnector.getCruxObjectByReference(this.db, ref);
        return EntityProxyMapping.getFromDoc(this.cruxConnector, epDoc);
    }

    public static String getReference(String guid) {
        return RelationshipMapping.getReference(INSTANCE_REF_PREFIX, guid);
    }
}

