/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.model;

import crux.api.CruxDocument;
import crux.api.ICruxAPI;
import crux.api.TransactionInstant;
import crux.api.tx.Transaction;

public class PersistenceLayer {
    public static final long LATEST_VERSION = 2L;
    private static final String PERSISTENCE_DOC = "egeria-connector-crux/persistence-layer";
    private static final String VERSION = "egeria-connector-crux/persistence-layer.version";

    public static long getVersion(ICruxAPI cruxAPI) {
        Object version;
        CruxDocument doc = PersistenceLayer.getPersistenceDetails(cruxAPI);
        if (doc != null && (version = doc.get(VERSION)) instanceof Long) {
            return (Long)version;
        }
        return -1L;
    }

    public static void setVersion(ICruxAPI cruxAPI, long version) {
        CruxDocument.Builder builder = CruxDocument.builder((Object)PERSISTENCE_DOC);
        builder.put(VERSION, (Object)version);
        Transaction.Builder tx = Transaction.builder();
        tx.put(builder.build());
        TransactionInstant instant = cruxAPI.submitTx(tx.build());
        cruxAPI.awaitTx(instant, null);
    }

    public static boolean isLatestVersion(ICruxAPI cruxAPI) {
        return PersistenceLayer.getVersion(cruxAPI) == 2L;
    }

    protected static CruxDocument getPersistenceDetails(ICruxAPI cruxAPI) {
        return cruxAPI.db().entity((Object)PERSISTENCE_DOC);
    }
}

