/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.repositoryconnector;

import crux.api.tx.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.odpi.egeria.connectors.juxt.crux.auditlog.CruxOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.crux.auditlog.CruxOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.crux.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSDynamicTypeMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CruxOMRSMetadataCollection
extends OMRSDynamicTypeMetadataCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(CruxOMRSMetadataCollection.class);
    private final CruxOMRSRepositoryConnector cruxRepositoryConnector;

    public CruxOMRSMetadataCollection(CruxOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId, AuditLog auditLog) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        log.debug("Constructing CruxOMRSMetadataCollection with name: {}", (Object)repositoryName);
        parentConnector.setRepositoryName(repositoryName);
        this.cruxRepositoryConnector = parentConnector;
        this.setAuditLog(auditLog);
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "isEntityKnown";
        this.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        try {
            EntityDetail entity = this.cruxRepositoryConnector.getEntity(guid, null, false);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "isEntityKnown");
            return entity;
        }
        catch (EntityNotKnownException e) {
            log.info("Entity with GUID {} does not exist in the repository.", (Object)guid);
        }
        catch (EntityProxyOnlyException e) {
            log.info("Entity with GUID {} exists, but is only a proxy in the repository.", (Object)guid);
        }
        return null;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        EntityDetail summary = null;
        try {
            summary = this.cruxRepositoryConnector.getEntity(guid, null, true);
        }
        catch (EntityProxyOnlyException e) {
            log.error("Caught exception that should never be thrown given 'true' on acceptProxies.", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, (EntitySummary)summary, "getEntitySummary");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)summary, "getEntitySummary");
        return summary;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException {
        return this.getEntityDetail(userId, guid, null);
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        EntityDetail entity = this.cruxRepositoryConnector.getEntity(guid, asOfTime, false);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntityDetail");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getEntityDetail");
        return entity;
    }

    public List<EntityDetail> getEntityDetailHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetailHistory";
        super.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getEntityDetailHistory");
        return this.cruxRepositoryConnector.getPreviousVersionsOfEntity(guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder);
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PagingErrorException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "getRelationshipsForEntity");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getRelationshipsForEntity");
        List<Relationship> entityRelationships = this.cruxRepositoryConnector.findRelationshipsForEntity(entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId);
        return entityRelationships == null || entityRelationships.isEmpty() ? null : entityRelationships;
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        SearchProperties searchProperties = this.repositoryHelper.getSearchPropertiesFromInstanceProperties(this.repositoryName, matchProperties, matchCriteria);
        SearchClassifications searchClassifications = this.repositoryHelper.getSearchClassificationsFromList(limitResultsByClassification);
        return this.findEntities(userId, entityTypeGUID, null, searchProperties, fromEntityElement, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PagingErrorException {
        this.findEntitiesParameterValidation(userId, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.cruxRepositoryConnector.findEntities(entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId);
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        SearchProperties searchProperties = this.repositoryHelper.getSearchPropertiesFromInstanceProperties(this.repositoryName, matchClassificationProperties, matchCriteria);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition condition = new ClassificationCondition();
        condition.setName(classificationName);
        condition.setMatchProperties(searchProperties);
        classificationConditions.add(condition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findEntities(userId, entityTypeGUID, null, null, fromEntityElement, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        SearchClassifications searchClassifications = this.repositoryHelper.getSearchClassificationsFromList(limitResultsByClassification);
        return this.cruxRepositoryConnector.findEntitiesByText(entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId);
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        return this.cruxRepositoryConnector.getRelationship(guid, null);
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "getRelationship";
        this.getInstanceParameterValidation(userId, guid, "getRelationship");
        return this.getAndValidateRelationship(guid, null);
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "getRelationship";
        this.getInstanceParameterValidation(userId, guid, asOfTime, "getRelationship");
        return this.getAndValidateRelationship(guid, asOfTime);
    }

    private Relationship getAndValidateRelationship(String guid, Date asOfTime) throws RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "getAndValidateRelationship";
        Relationship relationship = this.cruxRepositoryConnector.getRelationship(guid, asOfTime);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "getAndValidateRelationship");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)relationship, "getAndValidateRelationship");
        return relationship;
    }

    public List<Relationship> getRelationshipHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "getRelationshipHistory";
        super.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getRelationshipHistory");
        return this.cruxRepositoryConnector.getPreviousVersionsOfRelationship(guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder);
    }

    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PagingErrorException {
        super.findRelationshipsParameterValidation(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.cruxRepositoryConnector.findRelationships(relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId);
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        SearchProperties searchProperties = this.repositoryHelper.getSearchPropertiesFromInstanceProperties(this.repositoryName, matchProperties, matchCriteria);
        return this.findRelationships(userId, relationshipTypeGUID, null, searchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.cruxRepositoryConnector.findRelationshipsByText(relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId);
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        this.getLinkingEntitiesParameterValidation(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        if (startEntityGUID.equals(endEntityGUID)) {
            try {
                InstanceGraph one = new InstanceGraph();
                ArrayList<EntityDetail> list = new ArrayList<EntityDetail>();
                EntityDetail entity = this.cruxRepositoryConnector.getEntity(startEntityGUID, asOfTime, false);
                list.add(entity);
                one.setEntities(list);
                return one;
            }
            catch (EntityProxyOnlyException e) {
                throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(startEntityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "getLinkingEntities", (Throwable)e);
            }
        }
        return this.cruxRepositoryConnector.getTraversalsBetweenEntities(startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, RepositoryErrorException, TypeErrorException {
        String methodName = "getEntityNeighborhood";
        String entityGUIDParameterName = "entityGUID";
        String entityTypeGUIDParameterName = "entityTypeGUIDs";
        String relationshipTypeGUIDParameterName = "relationshipTypeGUIDs";
        String limitedResultsByClassificationParameterName = "limitResultsByClassification";
        String asOfTimeParameter = "asOfTime";
        this.validateRepositoryConnector("getEntityNeighborhood");
        this.parentConnector.validateRepositoryIsActive("getEntityNeighborhood");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getEntityNeighborhood");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getEntityNeighborhood");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getEntityNeighborhood");
        if (entityTypeGUIDs != null) {
            for (String guid : entityTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "entityTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (relationshipTypeGUIDs != null) {
            for (String guid : relationshipTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "relationshipTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (limitResultsByClassification != null) {
            for (String classificationName : limitResultsByClassification) {
                this.repositoryValidator.validateClassificationName(this.repositoryName, "limitResultsByClassification", classificationName, "getEntityNeighborhood");
            }
        }
        return this.cruxRepositoryConnector.findNeighborhood(entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level, true);
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        InstanceGraph adjacent;
        this.getRelatedEntitiesParameterValidation(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        String methodName = "getRelatedEntities";
        String limitedResultsByClassificationParameterName = "limitResultsByClassification";
        this.validateRepositoryConnector("getRelatedEntities");
        this.parentConnector.validateRepositoryIsActive("getRelatedEntities");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getRelatedEntities");
        if (limitResultsByClassification != null) {
            for (String classificationName : limitResultsByClassification) {
                this.repositoryValidator.validateClassificationName(this.repositoryName, "limitResultsByClassification", classificationName, "getRelatedEntities");
            }
        }
        if ((adjacent = this.cruxRepositoryConnector.findNeighborhood(startEntityGUID, entityTypeGUIDs, null, limitResultsByStatus, limitResultsByClassification, asOfTime, -1, false)) != null) {
            return this.repositoryHelper.formatEntityResults(adjacent.getEntities(), fromEntityElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return null;
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException {
        String methodName = "addEntity";
        TypeDef typeDef = super.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
        EntityDetail newEntity = this.repositoryHelper.getNewEntity(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, typeDef.getName(), initialProperties, initialClassifications);
        newEntity.setMetadataCollectionName(this.metadataCollectionName);
        if (initialStatus != null) {
            newEntity.setStatus(initialStatus);
        }
        return this.cruxRepositoryConnector.createEntity(newEntity);
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        TypeDef typeDef = super.addExternalEntityParameterValidation(userId, entityTypeGUID, externalSourceGUID, initialProperties, initialClassifications, initialStatus, "addExternalEntity");
        EntityDetail newEntity = this.repositoryHelper.getNewEntity(this.repositoryName, externalSourceGUID, InstanceProvenanceType.EXTERNAL_SOURCE, userId, typeDef.getName(), initialProperties, initialClassifications);
        newEntity.setMetadataCollectionName(externalSourceName);
        newEntity.setReplicatedBy(this.metadataCollectionId);
        if (initialStatus != null) {
            newEntity.setStatus(initialStatus);
        }
        return this.cruxRepositoryConnector.createEntity(newEntity);
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException {
        super.addEntityProxyParameterValidation(userId, entityProxy);
        EntityDetail entity = this.isEntityKnown(userId, entityProxy.getGUID());
        if (entity == null) {
            log.debug("Adding a proxy for: {}", (Object)entityProxy);
            this.cruxRepositoryConnector.createEntityProxy(entityProxy);
        }
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException {
        EntityDetail entity;
        String methodName = "updateEntityStatus";
        String statusParameterName = "newStatus";
        this.updateInstanceStatusParameterValidation(userId, entityGUID, newStatus, "updateEntityStatus");
        try {
            entity = this.cruxRepositoryConnector.getEntity(entityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "updateEntityStatus", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityStatus");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityStatus");
        this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "updateEntityStatus");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        TypeDef typeDef = super.getTypeDefForInstance((InstanceHeader)entity, "updateEntityStatus");
        this.repositoryValidator.validateNewStatus(this.repositoryName, "newStatus", newStatus, typeDef, "updateEntityStatus");
        EntityDetail updatedEntity = new EntityDetail(entity);
        updatedEntity.setStatus(newStatus);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        return this.cruxRepositoryConnector.updateEntity(updatedEntity);
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException {
        EntityDetail entity;
        String methodName = "updateEntityProperties";
        String propertiesParameterName = "properties";
        this.updateInstancePropertiesPropertyValidation(userId, entityGUID, properties, "updateEntityProperties");
        try {
            entity = this.cruxRepositoryConnector.getEntity(entityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "updateEntityProperties", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityProperties");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityProperties");
        this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "updateEntityProperties");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        TypeDef typeDef = super.getTypeDefForInstance((InstanceHeader)entity, "updateEntityProperties");
        this.repositoryValidator.validateNewPropertiesForType(this.repositoryName, "properties", typeDef, properties, "updateEntityProperties");
        EntityDetail updatedEntity = new EntityDetail(entity);
        updatedEntity.setProperties(properties);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        return this.cruxRepositoryConnector.updateEntity(updatedEntity);
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "undoEntityUpdate";
        String parameterName = "entityGUID";
        super.manageInstanceParameterValidation(userId, entityGUID, "entityGUID", "undoEntityUpdate");
        EntityDetail restoredEntity = this.cruxRepositoryConnector.restorePreviousVersionOfEntity(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, restoredEntity, "undoEntityUpdate");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)restoredEntity, "undoEntityUpdate");
        return restoredEntity;
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        EntityDetail entity;
        String methodName = "deleteEntity";
        String parameterName = "obsoleteEntityGUID";
        super.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteEntityGUID, "obsoleteEntityGUID", "deleteEntity");
        try {
            entity = this.cruxRepositoryConnector.getEntity(obsoleteEntityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(obsoleteEntityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "deleteEntity", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, obsoleteEntityGUID, entity, "deleteEntity");
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)entity, "deleteEntity");
        this.repositoryValidator.validateInstanceStatusForDelete(this.repositoryName, (InstanceHeader)entity, "deleteEntity");
        Transaction.Builder tx = Transaction.builder();
        try {
            List<Relationship> relationships = this.cruxRepositoryConnector.findActiveRelationshipsForEntity(entity, userId);
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    String mcId = relationship.getMetadataCollectionId();
                    if (this.metadataCollectionId.equals(mcId)) {
                        Relationship toDelete = this.getDeletedRelationshipRepresentation(relationship, userId);
                        this.cruxRepositoryConnector.addUpdateRelationshipStatements(tx, toDelete);
                        continue;
                    }
                    this.cruxRepositoryConnector.addPurgeRelationshipStatements(tx, relationship.getGUID());
                }
            }
        }
        catch (Exception e) {
            this.auditLog.logException("deleteEntity", CruxOMRSAuditCode.FAILED_RELATIONSHIP_DELETE_CASCADE.getMessageDefinition(obsoleteEntityGUID), (Throwable)e);
        }
        EntityDetail updatedEntity = new EntityDetail(entity);
        updatedEntity.setStatusOnDelete(entity.getStatus());
        updatedEntity.setStatus(InstanceStatus.DELETED);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        this.cruxRepositoryConnector.addUpdateEntityStatements(tx, updatedEntity);
        this.cruxRepositoryConnector.runTx(tx.build());
        return updatedEntity;
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException {
        EntityDetail entity;
        String methodName = "purgeEntity";
        String parameterName = "deletedEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedEntityGUID, "deletedEntityGUID", "purgeEntity");
        try {
            entity = this.cruxRepositoryConnector.getEntity(deletedEntityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(deletedEntityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "purgeEntity", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, deletedEntityGUID, entity, "purgeEntity");
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)entity, "purgeEntity");
        this.repositoryValidator.validateEntityIsDeleted(this.repositoryName, (InstanceHeader)entity, "purgeEntity");
        Transaction.Builder tx = Transaction.builder();
        try {
            Collection<List<?>> relationshipRefs = this.cruxRepositoryConnector.findEntityRelationships(this.cruxRepositoryConnector.getCruxAPI().db(), deletedEntityGUID, userId, true);
            for (List<?> relationshipRef : relationshipRefs) {
                String docRef = (String)relationshipRef.get(0);
                String guid = RelationshipMapping.trimGuidFromReference(docRef);
                this.cruxRepositoryConnector.addPurgeRelationshipStatements(tx, guid);
            }
        }
        catch (Exception e) {
            this.auditLog.logException("purgeEntity", CruxOMRSAuditCode.FAILED_RELATIONSHIP_DELETE_CASCADE.getMessageDefinition(deletedEntityGUID), (Throwable)e);
        }
        this.cruxRepositoryConnector.addPurgeEntityStatements(tx, entity.getGUID());
        this.cruxRepositoryConnector.runTx(tx.build());
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException {
        EntityDetail entity;
        String methodName = "restoreEntity";
        String parameterName = "deletedEntityGUID";
        super.manageInstanceParameterValidation(userId, deletedEntityGUID, "deletedEntityGUID", "restoreEntity");
        try {
            entity = this.cruxRepositoryConnector.getEntity(deletedEntityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(deletedEntityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "restoreEntity", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, deletedEntityGUID, entity, "restoreEntity");
        this.repositoryValidator.validateEntityIsDeleted(this.repositoryName, (InstanceHeader)entity, "restoreEntity");
        EntityDetail restoredEntity = new EntityDetail(entity);
        restoredEntity.setStatus(entity.getStatusOnDelete());
        restoredEntity.setStatusOnDelete(null);
        restoredEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, restoredEntity);
        return this.cruxRepositoryConnector.updateEntity(restoredEntity);
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException {
        return this.classifyEntity(userId, entityGUID, classificationName, null, null, null, null, classificationProperties);
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException {
        Classification newClassification;
        EntityDetail entity;
        String methodName = "classifyEntity";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "classificationProperties";
        this.validateRepositoryConnector("classifyEntity");
        this.parentConnector.validateRepositoryIsActive("classifyEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity");
        try {
            entity = this.cruxRepositoryConnector.getEntity(entityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "classifyEntity", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "classifyEntity");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "classifyEntity");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        InstanceType entityType = entity.getType();
        this.repositoryValidator.validateClassification(this.repositoryName, "classificationName", classificationName, entityType.getTypeDefName(), "classifyEntity");
        try {
            this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "classificationProperties", classificationProperties, "classifyEntity");
            if (externalSourceGUID == null) {
                newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, entityType.getTypeDefName(), classificationOrigin == null ? ClassificationOrigin.ASSIGNED : classificationOrigin, classificationOriginGUID, classificationProperties);
            } else {
                newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, externalSourceGUID, externalSourceName, InstanceProvenanceType.EXTERNAL_SOURCE, userId, classificationName, entityType.getTypeDefName(), classificationOrigin == null ? ClassificationOrigin.ASSIGNED : classificationOrigin, classificationOriginGUID, classificationProperties);
                newClassification.setMetadataCollectionName(externalSourceName);
                newClassification.setReplicatedBy(this.metadataCollectionId);
            }
        }
        catch (TypeErrorException e) {
            throw new ClassificationErrorException(CruxOMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(this.repositoryName, classificationName, entityType.getTypeDefName()), ((Object)((Object)this)).getClass().getName(), "classifyEntity", (Throwable)e);
        }
        EntityDetail updatedEntity = this.repositoryHelper.addClassificationToEntity(this.repositoryName, entity, newClassification, "classifyEntity");
        return this.cruxRepositoryConnector.updateEntity(updatedEntity);
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException {
        EntityDetail entity;
        String methodName = "declassifyEntity";
        super.declassifyEntityParameterValidation(userId, entityGUID, classificationName, "declassifyEntity");
        try {
            entity = this.cruxRepositoryConnector.getEntity(entityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "declassifyEntity", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "declassifyEntity");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "declassifyEntity");
        EntityDetail updatedEntity = this.repositoryHelper.deleteClassificationFromEntity(this.repositoryName, entity, classificationName, "declassifyEntity");
        return this.cruxRepositoryConnector.updateEntity(updatedEntity);
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException {
        EntityDetail entity;
        String methodName = "updateEntityClassification";
        super.classifyEntityParameterValidation(userId, entityGUID, classificationName, properties, "updateEntityClassification");
        try {
            entity = this.cruxRepositoryConnector.getEntity(entityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "updateEntityClassification", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityClassification");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityClassification");
        Classification classification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entity, classificationName, "updateEntityClassification");
        Classification newClassification = new Classification(classification);
        newClassification.setProperties(properties);
        EntityDetail updatedEntity = this.repositoryHelper.updateClassificationInEntity(this.repositoryName, userId, entity, newClassification, "updateEntityClassification");
        return this.cruxRepositoryConnector.updateEntity(updatedEntity);
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        TypeDef typeDef = super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addRelationship");
        Relationship relationship = this.repositoryHelper.getNewRelationship(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, typeDef.getName(), initialProperties);
        return this.addRelationship(userId, relationship, typeDef, entityOneGUID, entityTwoGUID, initialStatus);
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalRelationship";
        TypeDef typeDef = super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addExternalRelationship");
        Relationship relationship = this.repositoryHelper.getNewRelationship(this.repositoryName, externalSourceGUID, InstanceProvenanceType.EXTERNAL_SOURCE, userId, typeDef.getName(), initialProperties);
        relationship.setMetadataCollectionName(externalSourceName);
        relationship.setReplicatedBy(this.metadataCollectionId);
        return this.addRelationship(userId, relationship, typeDef, entityOneGUID, entityTwoGUID, initialStatus);
    }

    private Relationship addRelationship(String userId, Relationship relationship, TypeDef typeDef, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "addRelationship";
        EntityProxy entityOneProxy = this.getEntityProxy(userId, entityOneGUID, "addRelationship");
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityOneGUID, (EntitySummary)entityOneProxy, "addRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityOneProxy, "addRelationship");
        EntityProxy entityTwoProxy = this.getEntityProxy(userId, entityTwoGUID, "addRelationship");
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityTwoGUID, (EntitySummary)entityTwoProxy, "addRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityTwoProxy, "addRelationship");
        this.repositoryValidator.validateRelationshipEnds(this.repositoryName, entityOneProxy, entityTwoProxy, typeDef, "addRelationship");
        relationship.setEntityOneProxy(entityOneProxy);
        relationship.setEntityTwoProxy(entityTwoProxy);
        if (initialStatus != null) {
            relationship.setStatus(initialStatus);
        }
        return this.cruxRepositoryConnector.createRelationship(relationship);
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException {
        String methodName = "updateRelationshipStatus";
        String statusParameterName = "newStatus";
        this.updateInstanceStatusParameterValidation(userId, relationshipGUID, newStatus, "updateRelationshipStatus");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "updateRelationshipStatus");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship);
        TypeDef typeDef = super.getTypeDefForInstance((InstanceHeader)relationship, "updateRelationshipStatus");
        this.repositoryValidator.validateNewStatus(this.repositoryName, "newStatus", newStatus, typeDef, "updateRelationshipStatus");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setStatus(newStatus);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        return this.cruxRepositoryConnector.updateRelationship(updatedRelationship);
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException {
        String methodName = "updateRelationshipProperties";
        String propertiesParameterName = "properties";
        this.updateInstancePropertiesPropertyValidation(userId, relationshipGUID, properties, "updateRelationshipProperties");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, relationshipGUID, relationship, "updateRelationshipProperties");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)relationship, "updateRelationshipProperties");
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "updateRelationshipProperties");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship);
        TypeDef typeDef = super.getTypeDefForInstance((InstanceHeader)relationship, "updateRelationshipProperties");
        this.repositoryValidator.validateNewPropertiesForType(this.repositoryName, "properties", typeDef, properties, "updateRelationshipProperties");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setProperties(properties);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        return this.cruxRepositoryConnector.updateRelationship(updatedRelationship);
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "undoRelationshipUpdate";
        String parameterName = "relationshipGUID";
        this.manageInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", "undoRelationshipUpdate");
        Relationship restoredRelationship = this.cruxRepositoryConnector.restorePreviousVersionOfRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, relationshipGUID, restoredRelationship, "undoRelationshipUpdate");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)restoredRelationship, "undoRelationshipUpdate");
        return restoredRelationship;
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "deleteRelationship";
        String parameterName = "obsoleteRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID, "obsoleteRelationshipGUID", "deleteRelationship");
        Relationship relationship = this.getRelationship(userId, obsoleteRelationshipGUID);
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)relationship, "deleteRelationship");
        Relationship updatedRelationship = this.getDeletedRelationshipRepresentation(relationship, userId);
        return this.cruxRepositoryConnector.updateRelationship(updatedRelationship);
    }

    private Relationship getDeletedRelationshipRepresentation(Relationship relationship, String userId) {
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setStatusOnDelete(relationship.getStatus());
        updatedRelationship.setStatus(InstanceStatus.DELETED);
        return this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException {
        String methodName = "purgeRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "deletedRelationshipGUID", "purgeRelationship");
        Relationship relationship = this.cruxRepositoryConnector.getRelationship(deletedRelationshipGUID, null);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, deletedRelationshipGUID, relationship, "purgeRelationship");
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)relationship, "purgeRelationship");
        this.repositoryValidator.validateRelationshipIsDeleted(this.repositoryName, (InstanceHeader)relationship, "purgeRelationship");
        this.cruxRepositoryConnector.purgeRelationship(relationship.getGUID());
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException {
        String methodName = "restoreRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, deletedRelationshipGUID, "deletedRelationshipGUID", "restoreRelationship");
        Relationship relationship = this.cruxRepositoryConnector.getRelationship(deletedRelationshipGUID, null);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, deletedRelationshipGUID, relationship, "restoreRelationship");
        this.repositoryValidator.validateRelationshipIsDeleted(this.repositoryName, (InstanceHeader)relationship, "restoreRelationship");
        Relationship restoredRelationship = new Relationship(relationship);
        restoredRelationship.setStatus(relationship.getStatusOnDelete());
        restoredRelationship.setStatusOnDelete(null);
        restoredRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, restoredRelationship);
        restoredRelationship = this.cruxRepositoryConnector.updateRelationship(restoredRelationship);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, deletedRelationshipGUID, restoredRelationship, "restoreRelationship");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)restoredRelationship, "restoreRelationship");
        return restoredRelationship;
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        EntityDetail entity;
        String methodName = "reIdentifyEntity";
        String instanceParameterName = "entityGUID";
        String newInstanceParameterName = "newEntityGUID";
        this.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, entityGUID, "entityGUID", newEntityGUID, "newEntityGUID", "reIdentifyEntity");
        try {
            entity = this.cruxRepositoryConnector.getEntity(entityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "reIdentifyEntity", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "reIdentifyEntity");
        this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "reIdentifyEntity");
        EntityDetail deletedEntity = new EntityDetail(entity);
        deletedEntity.setStatusOnDelete(entity.getStatus());
        deletedEntity.setStatus(InstanceStatus.DELETED);
        deletedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, deletedEntity);
        EntityDetail updatedEntity = new EntityDetail(entity);
        updatedEntity.setGUID(newEntityGUID);
        updatedEntity.setReIdentifiedFromGUID(entityGUID);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        Transaction.Builder tx = Transaction.builder();
        List<Relationship> relationships = this.cruxRepositoryConnector.findHomedRelationshipsForEntity(entity, userId);
        EntityProxy ep = this.repositoryHelper.getNewEntityProxy(this.repositoryName, updatedEntity);
        for (Relationship relationship : relationships) {
            if (relationship.getEntityOneProxy().getGUID().equals(entityGUID)) {
                relationship.setEntityOneProxy(ep);
            } else if (relationship.getEntityTwoProxy().getGUID().equals(entityGUID)) {
                relationship.setEntityTwoProxy(ep);
            }
            this.cruxRepositoryConnector.addUpdateRelationshipStatements(tx, relationship);
        }
        this.cruxRepositoryConnector.addCreateEntityStatements(tx, deletedEntity);
        this.cruxRepositoryConnector.addCreateEntityStatements(tx, updatedEntity);
        this.cruxRepositoryConnector.runTx(tx.build());
        return updatedEntity;
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException {
        EntityDetail entity;
        String methodName = "reTypeEntity";
        String entityParameterName = "entityGUID";
        String currentTypeDefParameterName = "currentTypeDefSummary";
        String newTypeDefParameterName = "newTypeDefSummary";
        super.reTypeInstanceParameterValidation(userId, entityGUID, "entityGUID", TypeDefCategory.ENTITY_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeEntity");
        try {
            entity = this.cruxRepositoryConnector.getEntity(entityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "reTypeEntity", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "reTypeEntity");
        this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "reTypeEntity");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity, "currentTypeDefSummary", "currentTypeDefSummary", currentTypeDefSummary.getGUID(), currentTypeDefSummary.getName());
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "newTypeDefSummary", newTypeDefSummary, entity.getProperties(), "reTypeEntity");
        this.repositoryValidator.validateClassificationList(this.repositoryName, "entityGUID", entity.getClassifications(), newTypeDefSummary.getName(), "reTypeEntity");
        EntityDetail updatedEntity = new EntityDetail(entity);
        InstanceType newInstanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, newTypeDefSummary);
        updatedEntity.setType(newInstanceType);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        return this.cruxRepositoryConnector.updateEntity(updatedEntity);
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        EntityDetail entity;
        String methodName = "reHomeEntity";
        String entityParameterName = "entityGUID";
        super.reHomeInstanceParameterValidation(userId, entityGUID, "entityGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeEntity");
        try {
            entity = this.cruxRepositoryConnector.getEntity(entityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "reHomeEntity", (Throwable)e);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "reHomeEntity");
        this.repositoryValidator.validateEntityCanBeRehomed(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "reHomeEntity");
        EntityDetail updatedEntity = new EntityDetail(entity);
        updatedEntity.setMetadataCollectionId(newHomeMetadataCollectionId);
        updatedEntity.setMetadataCollectionName(newHomeMetadataCollectionName);
        updatedEntity.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
        updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
        return this.cruxRepositoryConnector.updateEntity(updatedEntity);
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "reIdentifyRelationship";
        String instanceParameterName = "relationshipGUID";
        String newInstanceParameterName = "newRelationshipGUID";
        this.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, relationshipGUID, "relationshipGUID", newRelationshipGUID, "newRelationshipGUID", "reIdentifyRelationship");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "reIdentifyRelationship");
        Relationship deletedRelationship = new Relationship(relationship);
        deletedRelationship.setStatusOnDelete(relationship.getStatusOnDelete());
        deletedRelationship.setStatus(InstanceStatus.DELETED);
        deletedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, deletedRelationship);
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setGUID(newRelationshipGUID);
        updatedRelationship.setReIdentifiedFromGUID(relationshipGUID);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        Transaction.Builder tx = Transaction.builder();
        this.cruxRepositoryConnector.addUpdateRelationshipStatements(tx, deletedRelationship);
        this.cruxRepositoryConnector.addCreateRelationshipStatements(tx, updatedRelationship);
        this.cruxRepositoryConnector.runTx(tx.build());
        return updatedRelationship;
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException {
        String methodName = "reTypeRelationship";
        String relationshipParameterName = "relationshipGUID";
        String currentTypeDefParameterName = "currentTypeDefSummary";
        String newTypeDefParameterName = "newTypeDefSummary";
        super.reTypeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", TypeDefCategory.RELATIONSHIP_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeRelationship");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "reTypeRelationship");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship, "currentTypeDefSummary", "currentTypeDefSummary", currentTypeDefSummary.getGUID(), currentTypeDefSummary.getName());
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "newTypeDefSummary", newTypeDefSummary, relationship.getProperties(), "reTypeRelationship");
        Relationship updatedRelationship = new Relationship(relationship);
        InstanceType newInstanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, newTypeDefSummary);
        updatedRelationship.setType(newInstanceType);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        return this.cruxRepositoryConnector.updateRelationship(updatedRelationship);
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "reHomeRelationship";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        String newHomeParameterName = "newHomeMetadataCollectionId";
        this.validateRepositoryConnector("reHomeRelationship");
        this.parentConnector.validateRepositoryIsActive("reHomeRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reHomeRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "reHomeRelationship");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "reHomeRelationship");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, "reHomeRelationship");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "newHomeMetadataCollectionId", newHomeMetadataCollectionId, "reHomeRelationship");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeRehomed(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "reHomeRelationship");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setMetadataCollectionId(newHomeMetadataCollectionId);
        updatedRelationship.setMetadataCollectionName(newHomeMetadataCollectionName);
        updatedRelationship.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        return this.cruxRepositoryConnector.updateRelationship(updatedRelationship);
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, EntityConflictException {
        String methodName = "saveEntityReferenceCopy";
        String instanceParameterName = "entity";
        this.validateRepositoryConnector("saveEntityReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("saveEntityReferenceCopy");
        this.repositoryValidator.validateReferenceInstanceHeader(this.repositoryName, this.metadataCollectionId, "entity", (InstanceHeader)entity, "saveEntityReferenceCopy");
        this.cruxRepositoryConnector.saveReferenceCopy(entity);
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getHomeClassifications";
        String guidParameterName = "entityGUID";
        this.validateRepositoryConnector("getHomeClassifications");
        this.parentConnector.validateRepositoryIsActive("getHomeClassifications");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getHomeClassifications");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getHomeClassifications");
        EntityDetail retrievedEntity = null;
        try {
            retrievedEntity = this.cruxRepositoryConnector.getEntity(entityGUID, null, true);
        }
        catch (EntityProxyOnlyException e) {
            log.warn("Received an EntityProxyOnlyException despite allowing proxies.", (Throwable)e);
        }
        ArrayList<Classification> homeClassifications = new ArrayList<Classification>();
        if (retrievedEntity != null) {
            List retrievedClassifications = retrievedEntity.getClassifications();
            if (retrievedClassifications != null) {
                for (Classification retrievedClassification : retrievedClassifications) {
                    if (retrievedClassification == null || !this.metadataCollectionId.equals(retrievedClassification.getMetadataCollectionId())) continue;
                    homeClassifications.add(retrievedClassification);
                }
            }
        } else {
            super.reportEntityNotKnown(entityGUID, "getHomeClassifications");
        }
        return homeClassifications.isEmpty() ? null : homeClassifications;
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        EntityDetail entity;
        String methodName = "purgeEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeEntityReferenceCopy");
        try {
            entity = this.cruxRepositoryConnector.getEntity(entityGUID, null, false);
        }
        catch (EntityProxyOnlyException e) {
            log.error("Attempted to purgeEntityReferenceCopy on an EntityProxy -- should this actually work?", (Throwable)e);
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "purgeEntityReferenceCopy", (Throwable)e);
        }
        if (entity != null) {
            this.cruxRepositoryConnector.purgeEntity(entityGUID);
        } else {
            super.reportEntityNotKnown(entityGUID, "purgeEntityReferenceCopy");
        }
    }

    public void saveClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, PropertyErrorException {
        String methodName = "saveClassificationReferenceCopy";
        String classificationParameterName = "classification";
        String propertiesParameterName = "classification.getProperties()";
        this.validateRepositoryConnector("saveClassificationReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("saveClassificationReferenceCopy");
        EntityDetail retrievedEntity = null;
        try {
            retrievedEntity = this.cruxRepositoryConnector.getEntity(entity.getGUID(), null, false);
        }
        catch (EntityProxyOnlyException e) {
            log.debug("Entity with GUID {} only a proxy, continuing...", (Object)entity.getGUID());
        }
        if (retrievedEntity == null && !this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            retrievedEntity = entity;
        }
        if (retrievedEntity != null) {
            try {
                this.repositoryValidator.validateEntityFromStore(this.repositoryName, entity.getGUID(), retrievedEntity, "saveClassificationReferenceCopy");
                this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)retrievedEntity, "saveClassificationReferenceCopy");
                this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
                InstanceType entityType = entity.getType();
                this.repositoryValidator.validateClassification(this.repositoryName, "classification", classification.getName(), entityType.getTypeDefName(), "saveClassificationReferenceCopy");
                this.repositoryValidator.validateClassificationProperties(this.repositoryName, classification.getName(), "classification.getProperties()", classification.getProperties(), "saveClassificationReferenceCopy");
                EntityDetail updatedEntity = this.repositoryHelper.addClassificationToEntity(this.repositoryName, retrievedEntity, classification, "saveClassificationReferenceCopy");
                if (this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
                    this.cruxRepositoryConnector.updateEntity(updatedEntity);
                } else {
                    this.cruxRepositoryConnector.saveReferenceCopy(updatedEntity);
                }
            }
            catch (EntityNotKnownException e) {
                log.debug("Entity with GUID {} was not known, so classification not stored.", (Object)entity.getGUID());
            }
            catch (ClassificationErrorException e) {
                throw new TypeErrorException((OMRSCheckedExceptionBase)e);
            }
        }
    }

    public void purgeClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws EntityConflictException, RepositoryErrorException {
        String methodName = "purgeClassificationReferenceCopy";
        this.validateRepositoryConnector("purgeClassificationReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("purgeClassificationReferenceCopy");
        EntityDetail retrievedEntity = null;
        try {
            retrievedEntity = this.cruxRepositoryConnector.getEntity(entity.getGUID(), null, false);
        }
        catch (EntityProxyOnlyException e) {
            log.debug("Entity with GUID {} only a proxy, continuing...", (Object)entity.getGUID());
        }
        if (retrievedEntity == null && !this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            retrievedEntity = entity;
        }
        if (retrievedEntity != null) {
            try {
                EntityDetail updatedEntity = this.repositoryHelper.deleteClassificationFromEntity(this.repositoryName, entity, classification.getName(), "purgeClassificationReferenceCopy");
                if (this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
                    updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)retrievedEntity, updatedEntity);
                    this.cruxRepositoryConnector.updateEntity(updatedEntity);
                } else {
                    this.cruxRepositoryConnector.saveReferenceCopy(entity);
                }
            }
            catch (ClassificationErrorException e) {
                log.debug("Entity with GUID {} had no classification {}, nothing to purge.", (Object)entity.getGUID(), (Object)classification.getName());
            }
        }
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, RelationshipConflictException, UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "saveRelationshipReferenceCopy");
        EntityDetail one = null;
        try {
            one = this.getEntityDetail(userId, relationship.getEntityOneProxy().getGUID());
            log.debug("EntityProxyOne is already known and not a proxy, will not overwrite it.");
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.debug("EntityProxyOne is either not known or only a proxy, will overwrite it.");
        }
        EntityDetail two = null;
        try {
            two = this.getEntityDetail(userId, relationship.getEntityTwoProxy().getGUID());
            log.debug("EntityProxyTwo is already known and not a proxy, will not overwrite it.");
        }
        catch (EntityNotKnownException | EntityProxyOnlyException e) {
            log.debug("EntityProxyTwo is either not known or only a proxy, will overwrite it.");
        }
        Transaction.Builder tx = Transaction.builder();
        if (one == null) {
            this.cruxRepositoryConnector.addCreateEntityProxyStatements(tx, relationship.getEntityOneProxy());
        }
        if (two == null) {
            this.cruxRepositoryConnector.addCreateEntityProxyStatements(tx, relationship.getEntityTwoProxy());
        }
        this.cruxRepositoryConnector.addSaveReferenceCopyStatements(tx, relationship);
        this.cruxRepositoryConnector.runTx(tx.build());
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeRelationshipReferenceCopy");
        Relationship relationship = this.cruxRepositoryConnector.getRelationship(relationshipGUID, null);
        if (relationship != null) {
            this.cruxRepositoryConnector.purgeRelationship(relationshipGUID);
        } else {
            super.reportRelationshipNotKnown(relationshipGUID, "purgeRelationshipReferenceCopy");
        }
    }

    protected EntityProxy getEntityProxy(String userId, String entityGUID, String methodName) throws EntityNotKnownException {
        EntityProxy entityProxy = this.cruxRepositoryConnector.getEntityProxy(entityGUID);
        if (entityProxy == null) {
            this.reportEntityNotKnown(entityGUID, methodName);
        }
        return entityProxy;
    }
}

