/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapping {
    private static final Logger log = LoggerFactory.getLogger(AbstractMapping.class);
    protected final CruxOMRSRepositoryConnector cruxConnector;
    protected static final ObjectMapper mapper = new ObjectMapper();
    private static final Keyword EMBEDDED_JSON = Keyword.intern((String)"json");

    protected AbstractMapping(CruxOMRSRepositoryConnector cruxConnector) {
        this.cruxConnector = cruxConnector;
    }

    public static String getKeyword(String name) {
        return AbstractMapping.getKeyword(null, name);
    }

    public static String getKeyword(String namespace, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (namespace == null || namespace.length() == 0) {
            return name;
        }
        return namespace + "/" + name;
    }

    protected static IPersistentMap getEmbeddedSerializedForm(Object value) {
        IPersistentMap subMap = null;
        if (value != null) {
            try {
                String json = mapper.writeValueAsString(value);
                HashMap<Keyword, String> map = new HashMap<Keyword, String>();
                map.put(EMBEDDED_JSON, json);
                subMap = PersistentHashMap.create(map);
            }
            catch (IOException e) {
                log.error("Unable to serialize object into JSON: {}", value);
            }
        }
        return subMap;
    }

    protected static <T> T getDeserializedValue(IPersistentMap embedded, JavaType type) {
        Object deserialized = null;
        if (embedded != null && embedded.containsKey((Object)EMBEDDED_JSON)) {
            String value = (String)embedded.valAt((Object)EMBEDDED_JSON);
            try {
                deserialized = mapper.readValue(value, type);
            }
            catch (IOException e) {
                log.error("Unable to deserialize object from JSON: {}", (Object)value);
            }
        }
        return (T)deserialized;
    }
}

