/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.PersistentVector;
import crux.api.CruxDocument;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstancePropertiesMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationMapping
extends InstanceAuditHeaderMapping {
    private static final Logger log = LoggerFactory.getLogger(ClassificationMapping.class);
    private static final String N_CLASSIFICATION_ORIGIN = "classificationOrigin";
    private static final String N_CLASSIFICATION_ORIGIN_GUID = "classificationOriginGUID";
    public static final String CLASSIFICATION_PROPERTIES_NS = "classificationProperties";
    public static final String N_LAST_CLASSIFICATION_CHANGE = "lastClassificationChange";
    public static final Set<String> KNOWN_PROPERTIES = ClassificationMapping.createKnownProperties();
    private List<Classification> classifications;
    private CruxDocument cruxDoc;
    private final String namespace;

    private static Set<String> createKnownProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add(N_CLASSIFICATION_ORIGIN);
        set.add(N_CLASSIFICATION_ORIGIN_GUID);
        return set;
    }

    public ClassificationMapping(CruxOMRSRepositoryConnector cruxConnector, List<Classification> classifications, String namespace) {
        super(cruxConnector);
        this.classifications = classifications;
        this.namespace = namespace;
    }

    public ClassificationMapping(CruxOMRSRepositoryConnector cruxConnector, CruxDocument cruxDoc, String namespace) {
        super(cruxConnector);
        this.cruxDoc = cruxDoc;
        this.namespace = namespace;
    }

    public void addToCruxDoc(CruxDocument.Builder builder) {
        if (this.classifications != null) {
            Date latestChange = null;
            ArrayList<String> classificationNames = new ArrayList<String>();
            for (Classification classification : this.classifications) {
                String classificationName = classification.getName();
                classificationNames.add(classificationName);
                String qualifiedNamespace = this.getNamespaceForClassification(classificationName);
                Date latestClassification = super.buildDoc(builder, (InstanceAuditHeader)classification, qualifiedNamespace);
                if (latestChange == null || latestChange.before(latestClassification)) {
                    latestChange = latestClassification;
                }
                builder.put(ClassificationMapping.getKeyword(qualifiedNamespace, N_CLASSIFICATION_ORIGIN_GUID), (Object)classification.getClassificationOriginGUID());
                builder.put(ClassificationMapping.getKeyword(qualifiedNamespace, N_CLASSIFICATION_ORIGIN), (Object)ClassificationMapping.getSymbolicNameForClassificationOrigin(classification.getClassificationOrigin()));
                InstancePropertiesMapping.addToDoc(this.cruxConnector, builder, classification.getType(), classification.getProperties(), qualifiedNamespace + "." + CLASSIFICATION_PROPERTIES_NS);
            }
            builder.put(ClassificationMapping.getKeyword(this.namespace), (Object)PersistentVector.create(classificationNames));
            builder.put(ClassificationMapping.getKeyword(N_LAST_CLASSIFICATION_CHANGE), latestChange);
        }
    }

    public List<Classification> toEgeria() {
        if (this.classifications != null) {
            return this.classifications;
        }
        if (this.cruxDoc == null) {
            return null;
        }
        return this.fromDoc();
    }

    protected List<Classification> fromDoc() {
        ArrayList<Classification> list = new ArrayList<Classification>();
        IPersistentVector classificationNames = (IPersistentVector)this.cruxDoc.get(ClassificationMapping.getKeyword(this.namespace));
        if (classificationNames != null) {
            for (int i = 0; i < classificationNames.length(); ++i) {
                String classificationName = (String)classificationNames.nth(i);
                String namespaceForClassification = this.getNamespaceForClassification(classificationName);
                Classification classification = new Classification();
                classification.setName(classificationName);
                super.fromDoc((InstanceAuditHeader)classification, this.cruxDoc, namespaceForClassification);
                IPersistentMap embeddedType = (IPersistentMap)this.cruxDoc.get(ClassificationMapping.getKeyword(namespaceForClassification, "type"));
                InstanceType classificationType = (InstanceType)ClassificationMapping.getDeserializedValue(embeddedType, mapper.getTypeFactory().constructType(InstanceType.class));
                InstanceProperties ip = InstancePropertiesMapping.getFromDoc(classificationType, this.cruxDoc, namespaceForClassification + "." + CLASSIFICATION_PROPERTIES_NS);
                if (ip != null) {
                    classification.setProperties(ip);
                }
                list.add(classification);
            }
        }
        return list.isEmpty() ? null : list;
    }

    public static String getNamespaceForClassification(String root, String classificationName) {
        return root + "." + classificationName;
    }

    public static String getClassificationNameFromNamespace(String root, String qualifiedNamespace) {
        String remainder = qualifiedNamespace.substring(root.length() + 1);
        if (remainder.contains(".")) {
            int firstDot = remainder.indexOf(".");
            return remainder.substring(0, firstDot);
        }
        return remainder;
    }

    private String getNamespaceForClassification(String classificationName) {
        return ClassificationMapping.getNamespaceForClassification(this.namespace, classificationName);
    }

    public static ClassificationOrigin getClassificationOriginFromSymbolicName(String symbolicName) {
        for (ClassificationOrigin b : ClassificationOrigin.values()) {
            if (!b.getName().equals(symbolicName)) continue;
            return b;
        }
        log.warn("Non-existent ClassificationOrigin symbolicName -- returning null: {}", (Object)symbolicName);
        return null;
    }

    public static String getSymbolicNameForClassificationOrigin(ClassificationOrigin co) {
        return co == null ? null : co.getName();
    }
}

