/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import crux.api.CruxDocument;
import java.util.List;
import org.odpi.egeria.connectors.juxt.crux.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstanceHeaderMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;

public class EntitySummaryMapping
extends InstanceHeaderMapping {
    public static final String INSTANCE_REF_PREFIX = "e";
    public static final String N_CLASSIFICATIONS = "classifications";

    public EntitySummaryMapping(CruxOMRSRepositoryConnector cruxConnector, EntitySummary entitySummary) {
        super(cruxConnector, (InstanceHeader)entitySummary);
    }

    public EntitySummaryMapping(CruxOMRSRepositoryConnector cruxConnector, CruxDocument cruxDoc) {
        super(cruxConnector, cruxDoc);
    }

    public EntitySummary toEgeria() {
        if (this.instanceHeader == null && this.cruxDoc != null) {
            this.instanceHeader = new EntitySummary();
            this.fromDoc();
        }
        if (this.instanceHeader != null) {
            return (EntitySummary)this.instanceHeader;
        }
        return null;
    }

    @Override
    protected CruxDocument.Builder toDoc() {
        CruxDocument.Builder builder = super.toDoc();
        List classifications = ((EntitySummary)this.instanceHeader).getClassifications();
        ClassificationMapping cm = new ClassificationMapping(this.cruxConnector, classifications, N_CLASSIFICATIONS);
        cm.addToCruxDoc(builder);
        return builder;
    }

    @Override
    protected void fromDoc() {
        super.fromDoc();
        ClassificationMapping cm = new ClassificationMapping(this.cruxConnector, this.cruxDoc, N_CLASSIFICATIONS);
        List<Classification> classifications = cm.toEgeria();
        ((EntitySummary)this.instanceHeader).setClassifications(classifications);
    }

    public static String getReference(String guid) {
        return EntitySummaryMapping.getGuid(INSTANCE_REF_PREFIX, guid);
    }
}

