/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.PersistentVector;
import com.fasterxml.jackson.databind.JavaType;
import crux.api.CruxDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.juxt.crux.mapping.AbstractMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.EnumPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstanceAuditHeaderMapping
extends AbstractMapping {
    private static final Logger log = LoggerFactory.getLogger(InstanceAuditHeaderMapping.class);
    private static final String N_HEADER_VERSION = "headerVersion";
    private static final String N_TYPE = "type";
    private static final String N_INSTANCE_PROVENANCE_TYPE = "instanceProvenanceType";
    private static final String N_METADATA_COLLECTION_ID = "metadataCollectionId";
    private static final String N_METADATA_COLLECTION_NAME = "metadataCollectionName";
    private static final String N_REPLICATED_BY = "replicatedBy";
    private static final String N_INSTANCE_LICENSE = "instanceLicense";
    private static final String N_CREATED_BY = "createdBy";
    private static final String N_UPDATED_BY = "updatedBy";
    private static final String N_MAINTAINED_BY = "maintainedBy";
    private static final String N_CREATE_TIME = "createTime";
    private static final String N_UPDATE_TIME = "updateTime";
    private static final String N_VERSION = "version";
    private static final String N_CURRENT_STATUS = "currentStatus";
    private static final String N_STATUS_ON_DELETE = "statusOnDelete";
    private static final String N_MAPPING_PROPERTIES = "mappingProperties";
    public static final String METADATA_COLLECTION_ID = InstanceAuditHeaderMapping.getKeyword("metadataCollectionId");
    public static final String CREATE_TIME = InstanceAuditHeaderMapping.getKeyword("createTime");
    public static final String UPDATE_TIME = InstanceAuditHeaderMapping.getKeyword("updateTime");
    public static final String CURRENT_STATUS = InstanceAuditHeaderMapping.getKeyword("currentStatus");
    public static final String TYPE_DEF_GUIDS = InstanceAuditHeaderMapping.getKeyword("type.guids");
    public static final String TYPE_DEF_CATEGORY = InstanceAuditHeaderMapping.getKeyword("type.category");
    public static final Set<String> KNOWN_PROPERTIES = InstanceAuditHeaderMapping.createKnownProperties();

    private static Set<String> createKnownProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add(N_HEADER_VERSION);
        set.add(N_TYPE);
        set.add(N_INSTANCE_PROVENANCE_TYPE);
        set.add(N_METADATA_COLLECTION_ID);
        set.add(N_METADATA_COLLECTION_NAME);
        set.add(N_REPLICATED_BY);
        set.add(N_INSTANCE_LICENSE);
        set.add(N_CREATED_BY);
        set.add(N_UPDATED_BY);
        set.add(N_MAINTAINED_BY);
        set.add(N_CREATE_TIME);
        set.add(N_UPDATE_TIME);
        set.add(N_VERSION);
        set.add(N_CURRENT_STATUS);
        set.add(N_STATUS_ON_DELETE);
        set.add(N_MAPPING_PROPERTIES);
        return set;
    }

    protected InstanceAuditHeaderMapping(CruxOMRSRepositoryConnector cruxConnector) {
        super(cruxConnector);
    }

    protected void buildDoc(CruxDocument.Builder builder, InstanceAuditHeader iah) {
        this.buildDoc(builder, iah, null);
    }

    protected Date buildDoc(CruxDocument.Builder builder, InstanceAuditHeader iah, String namespace) {
        Date updateTime = iah.getUpdateTime();
        Date createTime = iah.getCreateTime();
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_HEADER_VERSION), (Object)iah.getHeaderVersion());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_METADATA_COLLECTION_ID), (Object)iah.getMetadataCollectionId());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_METADATA_COLLECTION_NAME), (Object)iah.getMetadataCollectionName());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_REPLICATED_BY), (Object)iah.getReplicatedBy());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_INSTANCE_LICENSE), (Object)iah.getInstanceLicense());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_CREATED_BY), (Object)iah.getCreatedBy());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_UPDATED_BY), (Object)iah.getUpdatedBy());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_MAINTAINED_BY), (Object)iah.getMaintainedBy());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_CREATE_TIME), (Object)createTime);
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_UPDATE_TIME), (Object)updateTime);
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_VERSION), (Object)iah.getVersion());
        ArrayList<String> typeList = new ArrayList<String>();
        InstanceType type = iah.getType();
        typeList.add(type.getTypeDefGUID());
        List superTypes = type.getTypeDefSuperTypes();
        if (superTypes != null) {
            for (TypeDefLink superType : superTypes) {
                typeList.add(superType.getGUID());
            }
        }
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, "type.guids"), (Object)PersistentVector.create(typeList));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, "type.category"), (Object)type.getTypeDefCategory().getOrdinal());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_TYPE), (Object)InstanceAuditHeaderMapping.getEmbeddedSerializedForm(type));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_INSTANCE_PROVENANCE_TYPE), (Object)EnumPropertyValueMapping.getOrdinalForInstanceProvenanceType(iah.getInstanceProvenanceType()));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_CURRENT_STATUS), (Object)EnumPropertyValueMapping.getOrdinalForInstanceStatus(iah.getStatus()));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_STATUS_ON_DELETE), (Object)EnumPropertyValueMapping.getOrdinalForInstanceStatus(iah.getStatusOnDelete()));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_MAPPING_PROPERTIES), (Object)InstanceAuditHeaderMapping.getEmbeddedSerializedForm(iah.getMappingProperties()));
        return updateTime == null ? createTime : updateTime;
    }

    protected void fromDoc(InstanceAuditHeader iah, CruxDocument doc) {
        this.fromDoc(iah, doc, null);
    }

    protected void fromDoc(InstanceAuditHeader iah, CruxDocument doc, String namespace) {
        block36: for (String propertyName : KNOWN_PROPERTIES) {
            String property = InstanceAuditHeaderMapping.getKeyword(namespace, propertyName);
            Object objValue = doc.get(property);
            String value = objValue == null ? null : objValue.toString();
            switch (propertyName) {
                case "headerVersion": {
                    iah.setHeaderVersion(objValue == null ? 0L : (Long)objValue);
                    continue block36;
                }
                case "type": {
                    iah.setType((InstanceType)InstanceAuditHeaderMapping.getDeserializedValue((IPersistentMap)objValue, mapper.getTypeFactory().constructType(InstanceType.class)));
                    continue block36;
                }
                case "instanceProvenanceType": {
                    iah.setInstanceProvenanceType(EnumPropertyValueMapping.getInstanceProvenanceTypeFromOrdinal((Integer)objValue));
                    continue block36;
                }
                case "metadataCollectionId": {
                    iah.setMetadataCollectionId(value);
                    continue block36;
                }
                case "metadataCollectionName": {
                    iah.setMetadataCollectionName(value);
                    continue block36;
                }
                case "replicatedBy": {
                    iah.setReplicatedBy(value);
                    continue block36;
                }
                case "instanceLicense": {
                    iah.setInstanceLicense(value);
                    continue block36;
                }
                case "createdBy": {
                    iah.setCreatedBy(value);
                    continue block36;
                }
                case "updatedBy": {
                    iah.setUpdatedBy(value);
                    continue block36;
                }
                case "maintainedBy": {
                    iah.setMaintainedBy(objValue == null ? null : (List)objValue);
                    continue block36;
                }
                case "createTime": {
                    iah.setCreateTime(objValue == null ? null : (Date)objValue);
                    continue block36;
                }
                case "updateTime": {
                    iah.setUpdateTime(objValue == null ? null : (Date)objValue);
                    continue block36;
                }
                case "version": {
                    iah.setVersion(objValue == null ? -1L : (Long)objValue);
                    continue block36;
                }
                case "currentStatus": {
                    iah.setStatus(EnumPropertyValueMapping.getInstanceStatusFromOrdinal((Integer)objValue));
                    continue block36;
                }
                case "statusOnDelete": {
                    iah.setStatusOnDelete(EnumPropertyValueMapping.getInstanceStatusFromOrdinal((Integer)objValue));
                    continue block36;
                }
                case "mappingProperties": {
                    iah.setMappingProperties((Map)InstanceAuditHeaderMapping.getDeserializedValue((IPersistentMap)objValue, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, String.class, Serializable.class)));
                    continue block36;
                }
            }
            log.warn("Unmapped InstanceAuditHeader property ({}): {}", (Object)property, objValue);
        }
    }
}

