/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.model.search;

import clojure.lang.IPersistentCollection;
import clojure.lang.Keyword;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.egeria.connectors.juxt.crux.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstancePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.crux.model.search.CruxQuery;
import org.odpi.egeria.connectors.juxt.crux.model.search.TextConditionBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConditionBuilder.class);
    public static final Symbol OR_OPERATOR = Symbol.intern((String)"or");
    public static final Symbol AND_OPERATOR = Symbol.intern((String)"and");
    public static final Symbol NOT_OPERATOR = Symbol.intern((String)"not");
    public static final Symbol OR_JOIN = Symbol.intern((String)"or-join");
    protected static final Symbol EQ_OPERATOR = Symbol.intern((String)"=");
    protected static final Symbol NEQ_OPERATOR = Symbol.intern((String)"not=");
    protected static final Symbol GT_OPERATOR = Symbol.intern((String)">");
    protected static final Symbol GTE_OPERATOR = Symbol.intern((String)">=");
    protected static final Symbol LT_OPERATOR = Symbol.intern((String)"<");
    protected static final Symbol LTE_OPERATOR = Symbol.intern((String)"<=");
    protected static final Symbol IS_NULL_OPERATOR = Symbol.intern((String)"nil?");
    protected static final Symbol NOT_NULL_OPERATOR = Symbol.intern((String)"some?");
    protected static final Symbol REGEX_OPERATOR = Symbol.intern((String)"re-matches");
    protected static final Symbol IN_OPERATOR = Symbol.intern((String)"contains?");
    public static final Symbol SET_OPERATOR = Symbol.intern((String)"hash-set");
    protected static final Map<PropertyComparisonOperator, Symbol> PCO_TO_SYMBOL = ConditionBuilder.createPropertyComparisonOperatorToSymbolMap();

    private static Map<PropertyComparisonOperator, Symbol> createPropertyComparisonOperatorToSymbolMap() {
        HashMap<PropertyComparisonOperator, Symbol> map = new HashMap<PropertyComparisonOperator, Symbol>();
        map.put(PropertyComparisonOperator.EQ, EQ_OPERATOR);
        map.put(PropertyComparisonOperator.NEQ, NEQ_OPERATOR);
        map.put(PropertyComparisonOperator.GT, GT_OPERATOR);
        map.put(PropertyComparisonOperator.GTE, GTE_OPERATOR);
        map.put(PropertyComparisonOperator.LT, LT_OPERATOR);
        map.put(PropertyComparisonOperator.LTE, LTE_OPERATOR);
        map.put(PropertyComparisonOperator.IS_NULL, IS_NULL_OPERATOR);
        map.put(PropertyComparisonOperator.NOT_NULL, NOT_NULL_OPERATOR);
        map.put(PropertyComparisonOperator.LIKE, REGEX_OPERATOR);
        map.put(PropertyComparisonOperator.IN, IN_OPERATOR);
        return map;
    }

    public static List<IPersistentCollection> buildPropertyConditions(SearchProperties searchProperties, String namespace, boolean orNested, Set<String> typeNames, OMRSRepositoryHelper repositoryHelper, String repositoryName, boolean luceneEnabled, boolean luceneRegexes) {
        if (searchProperties != null) {
            List propertyConditions = searchProperties.getConditions();
            MatchCriteria matchCriteria = searchProperties.getMatchCriteria();
            if (propertyConditions != null && !propertyConditions.isEmpty()) {
                ArrayList<List<IPersistentCollection>> allConditions = new ArrayList<List<IPersistentCollection>>();
                for (Object condition : propertyConditions) {
                    List<IPersistentCollection> list = ConditionBuilder.getSinglePropertyCondition((PropertyCondition)condition, namespace, typeNames, repositoryHelper, repositoryName, luceneEnabled, luceneRegexes);
                    if (list == null || list.isEmpty()) continue;
                    allConditions.add(list);
                }
                ArrayList<Object> predicatedConditions = new ArrayList<Object>();
                switch (matchCriteria) {
                    case ALL: {
                        if (orNested && allConditions.size() > 1) {
                            predicatedConditions.add(AND_OPERATOR);
                            predicatedConditions.addAll(allConditions);
                            break;
                        }
                        return allConditions.stream().flatMap(Collection::stream).collect(Collectors.toList());
                    }
                    case ANY: {
                        if (allConditions.size() == 1) {
                            return (List)allConditions.get(0);
                        }
                        predicatedConditions.add(OR_JOIN);
                        predicatedConditions.add(PersistentVector.create((Object[])new Object[]{CruxQuery.DOC_ID}));
                        for (List list : allConditions) {
                            if (list.size() == 1) {
                                predicatedConditions.addAll(list);
                                continue;
                            }
                            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
                            arrayList.add(AND_OPERATOR);
                            arrayList.addAll(list);
                            predicatedConditions.add(PersistentList.create(arrayList));
                        }
                        break;
                    }
                    case NONE: {
                        predicatedConditions.add(NOT_OPERATOR);
                        if (allConditions.size() == 1) {
                            predicatedConditions.addAll((Collection)allConditions.get(0));
                            break;
                        }
                        ArrayList<Object> or = new ArrayList<Object>();
                        or.add(OR_JOIN);
                        or.add(PersistentVector.create((Object[])new Object[]{CruxQuery.DOC_ID}));
                        for (List list : allConditions) {
                            if (list.size() == 1) {
                                or.addAll(list);
                                continue;
                            }
                            ArrayList<Symbol> and = new ArrayList<Symbol>();
                            and.add(AND_OPERATOR);
                            and.addAll(list);
                            or.add(PersistentList.create(and));
                        }
                        predicatedConditions.add(PersistentList.create(or));
                        break;
                    }
                    default: {
                        log.warn("Unmapped match criteria: {}", (Object)matchCriteria);
                    }
                }
                if (!predicatedConditions.isEmpty()) {
                    ArrayList<IPersistentCollection> wrapped = new ArrayList<IPersistentCollection>();
                    wrapped.add(ConditionBuilder.getCruxCondition(predicatedConditions));
                    return wrapped;
                }
            }
        }
        return null;
    }

    static List<IPersistentCollection> buildConditionForPropertyRef(Keyword propertyRef, PropertyComparisonOperator comparator, InstancePropertyValue value, Symbol variable, OMRSRepositoryHelper repositoryHelper, boolean luceneEnabled, boolean luceneRegexes) {
        ArrayList<IPersistentCollection> propertyConditions = new ArrayList<IPersistentCollection>();
        ArrayList<PersistentVector> clauseConditions = new ArrayList<PersistentVector>();
        if (comparator.equals((Object)PropertyComparisonOperator.EQ)) {
            propertyConditions.add(ConditionBuilder.getEqualsConditions(propertyRef, value));
            return propertyConditions;
        }
        Symbol predicate = ConditionBuilder.getPredicateForOperator(comparator);
        if (REGEX_OPERATOR.equals((Object)predicate)) {
            return TextConditionBuilder.buildRegexConditions(propertyRef, value, variable, repositoryHelper, luceneEnabled, luceneRegexes);
        }
        if (IN_OPERATOR.equals((Object)predicate)) {
            Symbol listAsSet = Symbol.intern((String)"las");
            ArrayList<Symbol> forceSet = new ArrayList<Symbol>();
            forceSet.add(SET_OPERATOR);
            Object toCompare = InstancePropertyValueMapping.getValueForComparison(value);
            if (toCompare instanceof List) {
                forceSet.addAll((List)toCompare);
            }
            ArrayList<Object> set = new ArrayList<Object>();
            set.add(PersistentList.create(forceSet));
            set.add(listAsSet);
            PersistentVector enforceSet = PersistentVector.create(set);
            clauseConditions.add(enforceSet);
            ArrayList<Symbol> predicateComparison = new ArrayList<Symbol>();
            predicateComparison.add(predicate);
            predicateComparison.add(listAsSet);
            predicateComparison.add(variable);
            clauseConditions.add(PersistentVector.create((Object[])new Object[]{PersistentList.create(predicateComparison)}));
        } else {
            ArrayList<Object> predicateComparison = new ArrayList<Object>();
            predicateComparison.add(predicate);
            predicateComparison.add(variable);
            predicateComparison.add(InstancePropertyValueMapping.getValueForComparison(value));
            clauseConditions.add(PersistentVector.create((Object[])new Object[]{PersistentList.create(predicateComparison)}));
        }
        PersistentVector propertyToVariable = PersistentVector.create((Object[])new Object[]{CruxQuery.DOC_ID, propertyRef, variable});
        propertyConditions.add((IPersistentCollection)propertyToVariable);
        propertyConditions.addAll(clauseConditions);
        return propertyConditions;
    }

    private static List<IPersistentCollection> getSinglePropertyCondition(PropertyCondition singleCondition, String namespace, Set<String> typeNames, OMRSRepositoryHelper repositoryHelper, String repositoryName, boolean luceneEnabled, boolean luceneRegexes) {
        Set<Keyword> qualifiedSearchProperties;
        SearchProperties nestedConditions = singleCondition.getNestedConditions();
        if (nestedConditions != null) {
            MatchCriteria matchCriteria = nestedConditions.getMatchCriteria();
            return ConditionBuilder.buildPropertyConditions(nestedConditions, namespace, matchCriteria.equals((Object)MatchCriteria.ANY), typeNames, repositoryHelper, repositoryName, luceneEnabled, luceneRegexes);
        }
        String simpleName = singleCondition.getProperty();
        PropertyComparisonOperator comparator = singleCondition.getOperator();
        InstancePropertyValue value = singleCondition.getValue();
        if (InstanceAuditHeaderMapping.KNOWN_PROPERTIES.contains(simpleName)) {
            Keyword propertyRef = ConditionBuilder.getAuditHeaderPropertyRef(namespace, simpleName);
            return ConditionBuilder.buildConditionForPropertyRef(propertyRef, comparator, value, Symbol.intern((String)simpleName), repositoryHelper, luceneEnabled, luceneRegexes);
        }
        List<Object> allPropertyConditions = null;
        if (namespace.startsWith("classifications") && !ClassificationMapping.KNOWN_PROPERTIES.contains(simpleName)) {
            String classificationNamespace = namespace + "." + "classificationProperties";
            HashSet<String> classificationTypes = new HashSet<String>();
            String classificationTypeName = ClassificationMapping.getClassificationNameFromNamespace("classifications", namespace);
            classificationTypes.add(classificationTypeName);
            qualifiedSearchProperties = InstancePropertyValueMapping.getKeywordsForProperty(repositoryName, repositoryHelper, simpleName, classificationNamespace, classificationTypes, value);
        } else {
            qualifiedSearchProperties = InstancePropertyValueMapping.getKeywordsForProperty(repositoryName, repositoryHelper, simpleName, namespace, typeNames, value);
        }
        if (qualifiedSearchProperties.isEmpty()) {
            log.warn("The provided property '{}' (as {}) did not match any of the type definition restrictions: {} -- forcing no results.", new Object[]{simpleName, value, typeNames});
            allPropertyConditions = new ArrayList<IPersistentCollection>(ConditionBuilder.getNoResultsCondition());
        } else if (qualifiedSearchProperties.size() == 1) {
            for (Keyword qualifiedPropertyRef : qualifiedSearchProperties) {
                List<IPersistentCollection> conditionsForOneProperty = ConditionBuilder.buildConditionForPropertyRef(qualifiedPropertyRef, comparator, value, Symbol.intern((String)simpleName), repositoryHelper, luceneEnabled, luceneRegexes);
                allPropertyConditions = new ArrayList<IPersistentCollection>(conditionsForOneProperty);
            }
        } else if (value != null && value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE) && ((PrimitivePropertyValue)value).getPrimitiveDefCategory().equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING)) {
            allPropertyConditions = TextConditionBuilder.buildLuceneOptimizedConditions(simpleName, comparator, value, repositoryHelper, luceneRegexes);
        }
        if (allPropertyConditions == null) {
            allPropertyConditions = new ArrayList();
            List<List<IPersistentCollection>> conditionAggregator = ConditionBuilder.getFallbackConditions(simpleName, comparator, value, qualifiedSearchProperties, repositoryHelper, luceneEnabled, luceneRegexes);
            if (conditionAggregator.size() == 1) {
                allPropertyConditions.addAll((Collection)conditionAggregator.get(0));
            } else {
                ArrayList<Object> or = new ArrayList<Object>();
                or.add(OR_OPERATOR);
                for (List<IPersistentCollection> subList : conditionAggregator) {
                    if (subList.size() == 1) {
                        or.addAll(subList);
                        continue;
                    }
                    ArrayList<Object> andList = new ArrayList<Object>();
                    andList.add(AND_OPERATOR);
                    andList.addAll(subList);
                    or.add(PersistentList.create(andList));
                }
                allPropertyConditions.add(PersistentList.create(or));
            }
        }
        return allPropertyConditions;
    }

    private static List<List<IPersistentCollection>> getFallbackConditions(String simpleName, PropertyComparisonOperator comparator, InstancePropertyValue value, Set<Keyword> qualifiedSearchProperties, OMRSRepositoryHelper repositoryHelper, boolean luceneEnabled, boolean luceneRegexes) {
        ArrayList<List<IPersistentCollection>> allConditionsForProperty = new ArrayList<List<IPersistentCollection>>();
        Symbol symbolForVariable = Symbol.intern((String)simpleName);
        for (Keyword qualifiedPropertyRef : qualifiedSearchProperties) {
            List<IPersistentCollection> conditionsForOneProperty = ConditionBuilder.buildConditionForPropertyRef(qualifiedPropertyRef, comparator, value, symbolForVariable, repositoryHelper, luceneEnabled, luceneRegexes);
            allConditionsForProperty.add(conditionsForOneProperty);
        }
        return allConditionsForProperty;
    }

    private static IPersistentCollection getEqualsConditions(Keyword propertyRef, InstancePropertyValue value) {
        return PersistentVector.create((Object[])new Object[]{CruxQuery.DOC_ID, propertyRef, InstancePropertyValueMapping.getValueForComparison(value)});
    }

    private static Symbol getPredicateForOperator(PropertyComparisonOperator comparator) {
        Symbol toUse = PCO_TO_SYMBOL.getOrDefault(comparator, null);
        if (toUse == null) {
            log.warn("Unmapped comparison operator: {}", (Object)comparator);
        }
        return toUse;
    }

    private static IPersistentCollection getCruxCondition(List<Object> condition) {
        if (condition != null && !condition.isEmpty()) {
            Object first = condition.get(0);
            if (first instanceof Symbol) {
                return PersistentList.create(condition);
            }
            return PersistentVector.create(condition);
        }
        return null;
    }

    private static List<IPersistentCollection> getNoResultsCondition() {
        ArrayList<IPersistentCollection> conditions = new ArrayList<IPersistentCollection>();
        conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{CruxQuery.DOC_ID, Keyword.intern((String)InstanceAuditHeaderMapping.TYPE_DEF_CATEGORY), -1}));
        return conditions;
    }

    private static Keyword getAuditHeaderPropertyRef(String namespace, String propertyName) {
        Keyword propertyRef = namespace != null && namespace.startsWith("classifications") ? Keyword.intern((String)namespace, (String)propertyName) : Keyword.intern((String)propertyName);
        return propertyRef;
    }
}

