/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.model.search;

import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.Keyword;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.List;
import org.odpi.egeria.connectors.juxt.crux.mapping.EntitySummaryMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.juxt.crux.model.search.ConditionBuilder;
import org.odpi.egeria.connectors.juxt.crux.model.search.CruxQuery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;

public class CruxGraphQuery
extends CruxQuery {
    private static final Symbol RELATIONSHIP = Symbol.intern((String)"r");
    private static final Symbol TRANSITIVE = Symbol.intern((String)"t");
    private static final Symbol START = Symbol.intern((String)"s");
    private static final Keyword ENTITY_PROXIES = Keyword.intern((String)RelationshipMapping.ENTITY_PROXIES);
    private static final Symbol QUERY = Symbol.intern((String)"q");

    public void addRelationshipLimiters(String rootEntityGUID, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus) {
        this.addFindElement(RELATIONSHIP);
        this.conditions.add(this.getRelatedToCondition(DOC_ID));
        this.conditions.add(this.getRelatedToCondition(EntitySummaryMapping.getReference(rootEntityGUID)));
        if (relationshipTypeGUIDs != null && !relationshipTypeGUIDs.isEmpty()) {
            this.conditions.addAll(this.getTypeCondition(RELATIONSHIP, TypeDefCategory.RELATIONSHIP_DEF, null, relationshipTypeGUIDs));
        }
        if (limitResultsByStatus != null && !limitResultsByStatus.isEmpty()) {
            this.conditions.addAll(this.getStatusLimiters(RELATIONSHIP, limitResultsByStatus));
        }
    }

    public void addEntityLimiters(List<String> entityTypeGUIDs, List<String> limitResultsByClassification) {
        if (entityTypeGUIDs != null && !entityTypeGUIDs.isEmpty()) {
            this.conditions.addAll(this.getTypeCondition(DOC_ID, TypeDefCategory.ENTITY_DEF, null, entityTypeGUIDs));
        }
        if (limitResultsByClassification != null && !limitResultsByClassification.isEmpty()) {
            this.conditions.addAll(this.getClassificationConditions(limitResultsByClassification));
        }
    }

    public void addRelatedEntitiesNestedQuery(String startingDocId) {
        CruxQuery inner = new CruxQuery();
        Symbol related = Symbol.intern((String)"related");
        ArrayList<Object> clause = new ArrayList<Object>();
        clause.add(related);
        clause.add(startingDocId);
        clause.add(DOC_ID);
        IPersistentList searchClause = PersistentList.create(clause);
        inner.conditions.add((IPersistentCollection)searchClause);
        clause = new ArrayList();
        clause.add(related);
        clause.add(PersistentVector.create((Object[])new Object[]{START}));
        clause.add(DOC_ID);
        IPersistentList ruleClause = PersistentList.create(clause);
        ArrayList<Symbol> recurse = new ArrayList<Symbol>();
        recurse.add(related);
        recurse.add(TRANSITIVE);
        recurse.add(DOC_ID);
        inner.rules.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{ruleClause, this.getRelatedToCondition(START), this.getRelatedToCondition(DOC_ID)}));
        inner.rules.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{ruleClause, this.getRelatedToCondition(START), this.getRelatedToCondition(TRANSITIVE), PersistentList.create(recurse)}));
        ArrayList<Object> nested = new ArrayList<Object>();
        nested.add(QUERY);
        nested.add(inner.getQuery());
        this.conditions.add(PersistentVector.create((Object[])new Object[]{PersistentList.create(nested), PersistentVector.create((Object[])new Object[]{PersistentVector.create((Object[])new Object[]{DOC_ID})})}));
    }

    protected List<IPersistentCollection> getClassificationConditions(List<String> limitByClassifications) {
        ArrayList<IPersistentCollection> classificationConditions = new ArrayList<IPersistentCollection>();
        Keyword classificationsRef = Keyword.intern((String)"classifications");
        if (limitByClassifications.size() == 1) {
            classificationConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, classificationsRef, limitByClassifications.get(0)}));
        } else {
            Symbol setVar = Symbol.intern((String)"cf");
            Symbol classificationVar = Symbol.intern((String)"classification");
            classificationConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, classificationsRef, classificationVar}));
            ArrayList<Object> set = new ArrayList<Object>();
            set.add(ConditionBuilder.SET_OPERATOR);
            set.addAll(limitByClassifications);
            classificationConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{PersistentList.create(set), setVar}));
            ArrayList<Symbol> contains = new ArrayList<Symbol>();
            contains.add(Symbol.intern((String)"contains?"));
            contains.add(setVar);
            contains.add(classificationVar);
            classificationConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{PersistentList.create(contains)}));
        }
        return classificationConditions;
    }

    protected PersistentVector getRelatedToCondition(Symbol variable) {
        return PersistentVector.create((Object[])new Object[]{RELATIONSHIP, ENTITY_PROXIES, variable});
    }

    protected PersistentVector getRelatedToCondition(String literal) {
        return PersistentVector.create((Object[])new Object[]{RELATIONSHIP, ENTITY_PROXIES, literal});
    }
}

