/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.PersistentVector;
import crux.api.CruxDocument;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.egeria.connectors.juxt.crux.auditlog.CruxOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstancePropertiesMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;

public class ClassificationMapping
extends InstanceAuditHeaderMapping {
    private static final String CLASSIFICATION = "classification";
    private static final String N_CLASSIFICATION_TYPE = "type";
    private static final String N_CLASSIFICATION_ORIGIN = "classificationOrigin";
    private static final String N_CLASSIFICATION_ORIGIN_GUID = "classificationOriginGUID";
    public static final String CLASSIFICATION_PROPERTIES_NS = "classificationProperties";
    public static final String N_LAST_CLASSIFICATION_CHANGE = "lastClassificationChange";
    private static final Set<String> KNOWN_PROPERTIES = ClassificationMapping.createKnownProperties();
    private List<Classification> classifications;
    private CruxDocument cruxDoc;
    private final String namespace;

    private static Set<String> createKnownProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add(N_CLASSIFICATION_ORIGIN);
        set.add(N_CLASSIFICATION_ORIGIN_GUID);
        return set;
    }

    public ClassificationMapping(CruxOMRSRepositoryConnector cruxConnector, List<Classification> classifications, String namespace) {
        super(cruxConnector);
        this.classifications = classifications;
        this.namespace = namespace;
    }

    public ClassificationMapping(CruxOMRSRepositoryConnector cruxConnector, CruxDocument cruxDoc, String namespace) {
        super(cruxConnector);
        this.cruxDoc = cruxDoc;
        this.namespace = namespace;
    }

    public static boolean isKnownBaseProperty(String property) {
        return KNOWN_PROPERTIES.contains(property);
    }

    public void addToCruxDoc(CruxDocument.Builder builder) {
        if (this.classifications != null) {
            Date latestChange = null;
            ArrayList<String> classificationNames = new ArrayList<String>();
            for (Classification classification : this.classifications) {
                String classificationName = classification.getName();
                classificationNames.add(classificationName);
                String qualifiedNamespace = this.getNamespaceForClassification(classificationName);
                Date latestClassification = super.buildDoc(builder, (InstanceAuditHeader)classification, qualifiedNamespace);
                if (latestChange == null || latestChange.before(latestClassification)) {
                    latestChange = latestClassification;
                }
                builder.put(ClassificationMapping.getKeyword(qualifiedNamespace, N_CLASSIFICATION_ORIGIN_GUID), (Object)classification.getClassificationOriginGUID());
                builder.put(ClassificationMapping.getKeyword(qualifiedNamespace, N_CLASSIFICATION_ORIGIN), (Object)ClassificationMapping.getSymbolicNameForClassificationOrigin(classification.getClassificationOrigin()));
                InstancePropertiesMapping.addToDoc(this.cruxConnector, builder, classification.getType(), classification.getProperties(), ClassificationMapping.getNamespaceForProperties(qualifiedNamespace));
            }
            builder.put(ClassificationMapping.getKeyword(this.namespace), (Object)PersistentVector.create(classificationNames));
            builder.put(ClassificationMapping.getKeyword(N_LAST_CLASSIFICATION_CHANGE), latestChange);
        }
    }

    public List<Classification> toEgeria() {
        if (this.classifications != null) {
            return this.classifications;
        }
        if (this.cruxDoc == null) {
            return null;
        }
        return this.fromDoc();
    }

    protected List<Classification> fromDoc() {
        ArrayList<Classification> list = new ArrayList<Classification>();
        IPersistentVector classificationNames = (IPersistentVector)this.cruxDoc.get(ClassificationMapping.getKeyword(this.namespace));
        if (classificationNames != null) {
            for (int i = 0; i < classificationNames.length(); ++i) {
                String classificationName = (String)classificationNames.nth(i);
                String namespaceForClassification = this.getNamespaceForClassification(classificationName);
                Classification classification = new Classification();
                classification.setName(classificationName);
                super.fromDoc((InstanceAuditHeader)classification, this.cruxDoc, namespaceForClassification);
                IPersistentMap embeddedType = (IPersistentMap)this.cruxDoc.get(ClassificationMapping.getKeyword(namespaceForClassification, N_CLASSIFICATION_TYPE));
                InstanceType classificationType = (InstanceType)ClassificationMapping.getDeserializedValue(this.cruxConnector, CLASSIFICATION, N_CLASSIFICATION_TYPE, embeddedType, mapper.getTypeFactory().constructType(InstanceType.class));
                InstanceProperties ip = InstancePropertiesMapping.getFromDoc(this.cruxConnector, classificationType, this.cruxDoc, namespaceForClassification + ".classificationProperties");
                if (ip != null) {
                    classification.setProperties(ip);
                }
                String originGuid = (String)this.cruxDoc.get(ClassificationMapping.getKeyword(namespaceForClassification, N_CLASSIFICATION_ORIGIN_GUID));
                classification.setClassificationOriginGUID(originGuid);
                String originSymbolicName = (String)this.cruxDoc.get(ClassificationMapping.getKeyword(namespaceForClassification, N_CLASSIFICATION_ORIGIN));
                ClassificationOrigin classificationOrigin = ClassificationMapping.getClassificationOriginFromSymbolicName(this.cruxConnector, originSymbolicName);
                classification.setClassificationOrigin(classificationOrigin);
                list.add(classification);
            }
        }
        return list.isEmpty() ? null : list;
    }

    public static String getNamespaceForClassification(String root, String classificationName) {
        return root + "." + classificationName;
    }

    public static String getClassificationNameFromNamespace(String root, String qualifiedNamespace) {
        String remainder = qualifiedNamespace.substring(root.length() + 1);
        if (remainder.contains(".")) {
            int firstDot = remainder.indexOf(".");
            return remainder.substring(0, firstDot);
        }
        return remainder;
    }

    private String getNamespaceForClassification(String classificationName) {
        return ClassificationMapping.getNamespaceForClassification(this.namespace, classificationName);
    }

    public static ClassificationOrigin getClassificationOriginFromSymbolicName(CruxOMRSRepositoryConnector cruxConnector, String symbolicName) {
        String methodName = "getClassificationOriginFromSymbolicName";
        for (ClassificationOrigin b : ClassificationOrigin.values()) {
            if (!b.getName().equals(symbolicName)) continue;
            return b;
        }
        cruxConnector.logProblem(ClassificationMapping.class.getName(), "getClassificationOriginFromSymbolicName", CruxOMRSAuditCode.NON_EXISTENT_ENUM, null, "ClassificationOrigin", symbolicName);
        return null;
    }

    public static String getSymbolicNameForClassificationOrigin(ClassificationOrigin co) {
        return co == null ? null : co.getName();
    }

    public static String getNamespaceForProperties(String qualifiedRoot) {
        return qualifiedRoot + ".classificationProperties";
    }
}

