/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import crux.api.CruxDocument;
import java.util.HashSet;
import java.util.Set;
import org.odpi.egeria.connectors.juxt.crux.auditlog.CruxOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;

public class InstanceHeaderMapping
extends InstanceAuditHeaderMapping {
    private static final String INSTANCE_HEADER = "InstanceHeader";
    private static final String INSTANCE_URL = "instanceURL";
    private static final String RE_IDENTIFIED_FROM_GUID = "reIdentifiedFromGUID";
    private static final Set<String> KNOWN_PROPERTIES = InstanceHeaderMapping.createKnownProperties();
    protected InstanceHeader instanceHeader;
    protected CruxDocument cruxDoc;

    private static Set<String> createKnownProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add(INSTANCE_URL);
        set.add(RE_IDENTIFIED_FROM_GUID);
        return set;
    }

    protected InstanceHeaderMapping(CruxOMRSRepositoryConnector cruxConnector, InstanceHeader instanceHeader) {
        super(cruxConnector);
        this.instanceHeader = instanceHeader;
    }

    protected InstanceHeaderMapping(CruxOMRSRepositoryConnector cruxConnector, CruxDocument cruxDoc) {
        super(cruxConnector);
        this.cruxDoc = cruxDoc;
    }

    public CruxDocument toCrux() {
        if (this.cruxDoc == null && this.instanceHeader != null) {
            this.cruxDoc = this.toDoc().build();
        }
        return this.cruxDoc;
    }

    protected CruxDocument.Builder toDoc() {
        CruxDocument.Builder builder = CruxDocument.builder((Object)InstanceHeaderMapping.getGuidReference(this.cruxConnector, this.instanceHeader));
        super.buildDoc(builder, (InstanceAuditHeader)this.instanceHeader);
        builder.put(INSTANCE_URL, (Object)this.instanceHeader.getInstanceURL());
        builder.put(RE_IDENTIFIED_FROM_GUID, (Object)this.instanceHeader.getReIdentifiedFromGUID());
        return builder;
    }

    protected void fromDoc() {
        super.fromDoc((InstanceAuditHeader)this.instanceHeader, this.cruxDoc);
        String methodName = "fromDoc";
        String guid = (String)this.cruxDoc.getId();
        this.instanceHeader.setGUID(guid == null ? null : InstanceHeaderMapping.trimGuidFromReference(guid));
        for (String property : KNOWN_PROPERTIES) {
            String value;
            Object objValue = this.cruxDoc.get(property);
            String string = value = objValue == null ? null : objValue.toString();
            if (INSTANCE_URL.equals(property)) {
                this.instanceHeader.setInstanceURL(value);
                continue;
            }
            if (RE_IDENTIFIED_FROM_GUID.equals(property)) {
                this.instanceHeader.setReIdentifiedFromGUID(value);
                continue;
            }
            this.cruxConnector.logProblem(this.getClass().getName(), "fromDoc", CruxOMRSAuditCode.UNMAPPED_PROPERTY, null, property, INSTANCE_HEADER);
        }
    }

    public static String getGuidReference(CruxOMRSRepositoryConnector cruxConnector, InstanceHeader ih) {
        String methodName = "getGuidReference";
        TypeDefCategory type = ih.getType().getTypeDefCategory();
        if (type.equals((Object)TypeDefCategory.ENTITY_DEF)) {
            return InstanceHeaderMapping.getReference("e", ih.getGUID());
        }
        if (type.equals((Object)TypeDefCategory.RELATIONSHIP_DEF)) {
            return InstanceHeaderMapping.getReference("r", ih.getGUID());
        }
        cruxConnector.logProblem(InstanceHeaderMapping.class.getName(), "getGuidReference", CruxOMRSAuditCode.NON_INSTANCE_RETRIEVAL, null, type.name());
        return null;
    }

    public static String trimGuidFromReference(String reference) {
        return reference.substring(reference.indexOf("_") + 1);
    }

    protected static String getReference(String instanceType, String guid) {
        return instanceType + "_" + guid;
    }
}

