/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import crux.api.CruxDocument;
import java.util.Map;
import java.util.TreeMap;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstancePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;

public class StructPropertyValueMapping
extends InstancePropertyValueMapping {
    public static void addStructPropertyValueToDoc(CruxOMRSRepositoryConnector cruxConnector, InstanceType instanceType, CruxDocument.Builder builder, String propertyName, String namespace, StructPropertyValue value) {
        builder.put(StructPropertyValueMapping.getPropertyValueKeyword(cruxConnector, instanceType, propertyName, namespace), StructPropertyValueMapping.getStructPropertyValueForComparison(cruxConnector, value));
    }

    public static Map<String, Object> getStructPropertyValueForComparison(CruxOMRSRepositoryConnector cruxConnector, StructPropertyValue spv) {
        InstanceProperties values = spv.getAttributes();
        if (values != null && values.getInstanceProperties() != null) {
            TreeMap<String, Object> results = new TreeMap<String, Object>();
            for (Map.Entry entry : values.getInstanceProperties().entrySet()) {
                String key = (String)entry.getKey();
                InstancePropertyValue value = (InstancePropertyValue)entry.getValue();
                Object toCompare = StructPropertyValueMapping.getValueForComparison(cruxConnector, value);
                if (toCompare == null) continue;
                results.put(key, toCompare);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }
}

