/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.repositoryconnector;

import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import com.fasterxml.jackson.databind.ObjectMapper;
import crux.api.Crux;
import crux.api.CruxDocument;
import crux.api.HistoryOptions;
import crux.api.ICruxAPI;
import crux.api.ICruxDatasource;
import crux.api.ICursor;
import crux.api.TransactionInstant;
import crux.api.tx.Transaction;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.odpi.egeria.connectors.juxt.crux.auditlog.CruxOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.crux.auditlog.CruxOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.crux.mapping.Constants;
import org.odpi.egeria.connectors.juxt.crux.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.EntitySummaryMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstanceHeaderMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.juxt.crux.model.PersistenceLayer;
import org.odpi.egeria.connectors.juxt.crux.model.search.CruxGraphQuery;
import org.odpi.egeria.connectors.juxt.crux.model.search.CruxQuery;
import org.odpi.egeria.connectors.juxt.crux.model.search.TextConditionBuilder;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSMetadataCollection;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryTimeoutException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CruxOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    private static final Logger log = LoggerFactory.getLogger(CruxOMRSRepositoryConnector.class);
    private static final String SYNC = "Synchronously";
    private static final String ASYNC = "Asynchronously";
    private ICruxAPI cruxAPI = null;
    private boolean luceneConfigured = false;
    private boolean synchronousIndex = true;
    private boolean luceneRegexes = true;

    public void setMetadataCollectionId(String metadataCollectionId) {
        String methodName = "setMetadataCollectionId";
        this.metadataCollectionId = metadataCollectionId;
        if (metadataCollectionId != null) {
            try {
                this.metadataCollection = new CruxOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, metadataCollectionId, this.auditLog);
            }
            catch (Exception e) {
                throw new OMRSLogicErrorException(OMRSErrorCode.NULL_METADATA_COLLECTION.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), "setMetadataCollectionId", (Throwable)e);
            }
        }
    }

    public synchronized void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.auditLog.logMessage("start", CruxOMRSAuditCode.REPOSITORY_NODE_STARTING.getMessageDefinition());
        File configFile = null;
        Map configProperties = this.connectionProperties.getConfigurationProperties();
        if (configProperties != null && !configProperties.isEmpty()) {
            Object luceneReg;
            Object syncIdx;
            if (configProperties.containsKey("cruxConfig")) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    configFile = File.createTempFile("crux", ".json", new File("./"));
                    Object cruxCfg = configProperties.get("cruxConfig");
                    if (cruxCfg instanceof Map) {
                        Object luceneCfg;
                        Map cruxConfig = (Map)cruxCfg;
                        this.luceneConfigured = cruxConfig.containsKey("crux.lucene/lucene-store");
                        if (this.luceneConfigured && (luceneCfg = cruxConfig.get("crux.lucene/lucene-store")) instanceof Map) {
                            Map luceneConfig = (Map)luceneCfg;
                            HashMap<String, String> indexer = new HashMap<String, String>();
                            indexer.put("crux/module", "crux.lucene.egeria/->egeria-indexer");
                            luceneConfig.put("indexer", indexer);
                            HashMap<String, String> analyzer = new HashMap<String, String>();
                            analyzer.put("crux/module", "crux.lucene.egeria/->ci-analyzer");
                            luceneConfig.put("analyzer", analyzer);
                            cruxConfig.put("crux.lucene/lucene-store", luceneConfig);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Writing configuration to: {}", (Object)configFile.getCanonicalPath());
                        }
                        mapper.writeValue(configFile, (Object)cruxConfig);
                    }
                }
                catch (IOException e) {
                    this.auditLog.logException("start", CruxOMRSAuditCode.CANNOT_READ_CONFIGURATION.getMessageDefinition(e.getClass().getName()), (Throwable)e);
                    throw new ConnectorCheckedException(CruxOMRSErrorCode.CANNOT_READ_CONFIGURATION.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)e);
                }
            }
            if (configProperties.containsKey("syncIndex") && (syncIdx = configProperties.get("syncIndex")) instanceof Boolean) {
                this.synchronousIndex = (Boolean)syncIdx;
            }
            if (configProperties.containsKey("luceneRegexes") && (luceneReg = configProperties.get("luceneRegexes")) instanceof Boolean) {
                this.luceneRegexes = (Boolean)luceneReg;
            }
        }
        try {
            if (configFile == null) {
                this.auditLog.logMessage("start", CruxOMRSAuditCode.REPOSITORY_NODE_STARTING_NO_CONFIG.getMessageDefinition());
                this.cruxAPI = Crux.startNode();
            } else {
                this.auditLog.logMessage("start", CruxOMRSAuditCode.REPOSITORY_NODE_STARTING_WITH_CONFIG.getMessageDefinition());
                this.cruxAPI = Crux.startNode(configFile);
                Files.delete(Paths.get(configFile.getCanonicalPath(), new String[0]));
            }
            Map details = this.cruxAPI.status();
            log.info("crux config details: {}", (Object)details);
            Object version = details.get(Constants.CRUX_VERSION);
            long persistenceVersion = PersistenceLayer.getVersion(this.cruxAPI);
            boolean emptyDataStore = this.isDataStoreEmpty();
            if (persistenceVersion == -1L && emptyDataStore) {
                PersistenceLayer.setVersion(this.cruxAPI, 2L);
            } else if (persistenceVersion != 2L) {
                this.cruxAPI.close();
                throw new ConnectorCheckedException(CruxOMRSErrorCode.PERSISTENCE_LAYER_MISMATCH.getMessageDefinition("" + persistenceVersion, "2"), ((Object)((Object)this)).getClass().getName(), "start");
            }
            ArrayList<String> opts = new ArrayList<String>();
            opts.add(this.synchronousIndex ? "synchronous indexing" : "asynchronous indexing");
            if (this.luceneConfigured) {
                opts.add("Lucene text index");
                if (this.luceneRegexes) {
                    opts.add("Lucene regexes");
                }
            }
            this.auditLog.logMessage("start", CruxOMRSAuditCode.REPOSITORY_SERVICE_STARTED.getMessageDefinition(version == null ? "<null>" : version.toString(), String.join((CharSequence)", ", opts)));
        }
        catch (Exception e) {
            this.auditLog.logException("start", CruxOMRSAuditCode.FAILED_REPOSITORY_STARTUP.getMessageDefinition(e.getClass().getName()), (Throwable)e);
            throw new ConnectorCheckedException(CruxOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)e);
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        super.disconnect();
        try {
            this.cruxAPI.close();
        }
        catch (IOException e) {
            if (this.auditLog != null) {
                this.auditLog.logException("disconnect", CruxOMRSAuditCode.FAILED_REPOSITORY_SHUTDOWN.getMessageDefinition(e.getClass().getName()), (Throwable)e);
            }
            throw new ConnectorCheckedException(CruxOMRSErrorCode.FAILED_DISCONNECT.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "disconnect", (Throwable)e);
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", CruxOMRSAuditCode.REPOSITORY_SERVICE_SHUTDOWN.getMessageDefinition(this.getServerName()));
        }
    }

    public void logProblem(String className, String methodName, CruxOMRSAuditCode code, Throwable cause, String ... params) {
        String location = className + "::" + methodName;
        if (this.auditLog != null) {
            if (cause != null) {
                this.auditLog.logException(location, code.getMessageDefinition(params), cause);
            } else {
                this.auditLog.logMessage(location, code.getMessageDefinition(params));
            }
        } else {
            log.error("No audit log available -- problem during {}: {}", new Object[]{location, code.getMessageDefinition(params), cause});
        }
    }

    public boolean isDataStoreEmpty() {
        CruxQuery query = new CruxQuery();
        ArrayList<IPersistentCollection> conditions = new ArrayList<IPersistentCollection>();
        conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{CruxQuery.DOC_ID, Keyword.intern((String)InstanceAuditHeaderMapping.METADATA_COLLECTION_ID), Symbol.intern((String)"_")}));
        query.addConditions(conditions);
        IPersistentMap q = query.getQuery();
        q = q.assoc((Object)Keyword.intern((String)"limit"), (Object)1);
        log.debug("Querying with: {}", (Object)q);
        Collection results = this.cruxAPI.db().query((Object)q, new Object[0]);
        return results == null || results.isEmpty();
    }

    public void createEntityProxy(EntityProxy entity) {
        Transaction.Builder tx = Transaction.builder();
        this.addCreateEntityProxyStatements(tx, entity);
        TransactionInstant results = this.runTx(tx.build());
        log.debug(" ... results: {}", (Object)results);
    }

    public void addCreateEntityProxyStatements(Transaction.Builder tx, EntityProxy entity) {
        EntityProxyMapping epm = new EntityProxyMapping(this, entity);
        CruxOMRSRepositoryConnector.put(tx, epm.toCrux());
    }

    public EntityDetail createEntity(EntityDetail entity) {
        Transaction.Builder tx = Transaction.builder();
        this.addCreateEntityStatements(tx, entity);
        TransactionInstant results = this.runTx(tx.build());
        log.debug(" ... results: {}", (Object)results);
        return entity;
    }

    public void addCreateEntityStatements(Transaction.Builder tx, EntityDetail entity) {
        EntityDetailMapping edm = new EntityDetailMapping(this, entity);
        CruxOMRSRepositoryConnector.put(tx, edm.toCrux());
    }

    public void addUpdateEntityStatements(Transaction.Builder tx, EntityDetail entity) {
        this.addCreateEntityStatements(tx, entity);
    }

    public void purgeEntity(String guid) {
        Transaction.Builder tx = Transaction.builder();
        this.addPurgeEntityStatements(tx, guid);
        this.runTx(tx.build());
    }

    public void addPurgeEntityStatements(Transaction.Builder tx, String guid) {
        CruxOMRSRepositoryConnector.evict(tx, EntitySummaryMapping.getReference(guid));
    }

    public EntityDetail updateEntity(EntityDetail entity) {
        return this.createEntity(entity);
    }

    public EntityProxy getEntityProxy(String guid) {
        CruxDocument cruxDoc = this.getCruxObjectByReference(EntityProxyMapping.getReference(guid));
        return EntityProxyMapping.getFromDoc(this, cruxDoc);
    }

    public EntitySummary getEntitySummary(String guid) {
        CruxDocument cruxDoc = this.getCruxObjectByReference(EntitySummaryMapping.getReference(guid));
        if (log.isDebugEnabled()) {
            log.debug("Found results: {}", (Object)(cruxDoc == null ? null : cruxDoc.toMap()));
        }
        EntitySummaryMapping esm = new EntitySummaryMapping(this, cruxDoc);
        return esm.toEgeria();
    }

    public EntityDetail getEntity(String guid, Date asOfTime, boolean acceptProxies) throws EntityProxyOnlyException {
        String methodName = "getEntity";
        CruxDocument cruxDoc = this.getCruxObjectByReference(EntityDetailMapping.getReference(guid), asOfTime);
        if (log.isDebugEnabled()) {
            log.debug("Found results: {}", (Object)(cruxDoc == null ? null : cruxDoc.toMap()));
        }
        if (cruxDoc == null) {
            return null;
        }
        if (!acceptProxies && EntityProxyMapping.isOnlyAProxy(cruxDoc)) {
            throw new EntityProxyOnlyException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(guid, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "getEntity");
        }
        EntityDetailMapping edm = new EntityDetailMapping(this, cruxDoc);
        return edm.toEgeria();
    }

    public EntityDetail getEntityByGuid(ICruxDatasource db, String guid) {
        return this.getEntityByRef(db, EntityDetailMapping.getReference(guid));
    }

    private EntityDetail getEntityByRef(ICruxDatasource db, String ref) {
        CruxDocument cruxDoc = this.getCruxObjectByReference(db, ref);
        if (cruxDoc == null) {
            return null;
        }
        EntityDetailMapping edm = new EntityDetailMapping(this, cruxDoc);
        return edm.toEgeria();
    }

    public List<EntityDetail> findEntities(String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) throws TypeErrorException, RepositoryTimeoutException {
        String methodName = "findEntities";
        try {
            Collection<List<?>> cruxResults = this.searchCrux(TypeDefCategory.ENTITY_DEF, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize, "entityProperties", userId);
            log.debug("Found results: {}", cruxResults);
            return this.translateEntityResults(cruxResults, asOfTime);
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(CruxOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "findEntities", (Throwable)e);
        }
    }

    public List<EntityDetail> findEntitiesByText(String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) throws TypeErrorException, RepositoryTimeoutException {
        String methodName = "findEntitiesByText";
        try {
            Collection<List<?>> cruxResults = this.searchCruxText(TypeDefCategory.ENTITY_DEF, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize, "entityProperties", userId);
            log.debug("Found results: {}", cruxResults);
            return this.translateEntityResults(cruxResults, asOfTime);
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(CruxOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "findEntitiesByText", (Throwable)e);
        }
    }

    private List<EntityDetail> translateEntityResults(Collection<List<?>> cruxResults, Date asOfTime) {
        String methodName = "translateEntityResults";
        ArrayList<EntityDetail> results = null;
        if (cruxResults != null) {
            results = new ArrayList<EntityDetail>();
            for (List<?> cruxResult : cruxResults) {
                String docRef = (String)cruxResult.get(0);
                CruxDocument cruxDoc = this.getCruxObjectByReference(docRef, asOfTime);
                if (cruxDoc == null) {
                    this.logProblem(((Object)((Object)this)).getClass().getName(), "translateEntityResults", CruxOMRSAuditCode.MAPPING_FAILURE, null, "entity", docRef, "cannot be retrieved from Crux");
                    continue;
                }
                EntityDetailMapping edm = new EntityDetailMapping(this, cruxDoc);
                EntityDetail ed = edm.toEgeria();
                if (ed != null) {
                    results.add(ed);
                    continue;
                }
                this.logProblem(((Object)((Object)this)).getClass().getName(), "translateEntityResults", CruxOMRSAuditCode.MAPPING_FAILURE, null, "entity", docRef, "cannot be mapped to EntityDetail");
            }
        }
        return results;
    }

    public List<Relationship> findRelationshipsForEntity(String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) throws TypeErrorException, RepositoryErrorException {
        List<Relationship> results;
        String methodName = "findRelationshipsForEntity";
        try (ICruxDatasource db = asOfTime == null ? this.cruxAPI.openDB() : this.cruxAPI.openDB(asOfTime);){
            Collection<List<?>> cruxResults = this.findEntityRelationships(db, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize, userId);
            log.debug("Found results: {}", cruxResults);
            results = this.resultsToList(db, cruxResults);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "findRelationshipsForEntity", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(CruxOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "findRelationshipsForEntity", (Throwable)e);
        }
        return results;
    }

    public List<Relationship> findActiveRelationshipsForEntity(EntityDetail entity, String userId) throws RepositoryErrorException {
        List<Relationship> results;
        String methodName = "findRelationshipsForEntity";
        try (ICruxDatasource db = this.cruxAPI.openDB();){
            Collection<List<?>> cruxResults = this.findEntityRelationships(db, entity.getGUID(), userId, false);
            log.debug("Found results: {}", cruxResults);
            results = this.resultsToList(db, cruxResults);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "findRelationshipsForEntity", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(CruxOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "findRelationshipsForEntity", (Throwable)e);
        }
        return results;
    }

    public List<Relationship> findHomedRelationshipsForEntity(EntityDetail entity, String userId) throws RepositoryErrorException {
        List<Relationship> results;
        String methodName = "findHomedRelationshipsForEntity";
        try (ICruxDatasource db = this.cruxAPI.openDB();){
            Collection<List<?>> cruxResults = this.findHomedEntityRelationships(db, entity, userId);
            log.debug("Found results: {}", cruxResults);
            results = this.resultsToList(db, cruxResults);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "findHomedRelationshipsForEntity", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(CruxOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "findHomedRelationshipsForEntity", (Throwable)e);
        }
        return results;
    }

    public InstanceGraph findNeighborhood(String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level, boolean includeRelationships) throws RepositoryErrorException {
        InstanceGraph instanceGraph;
        String methodName = "findNeighborhood";
        try (ICruxDatasource db = asOfTime == null ? this.cruxAPI.openDB() : this.cruxAPI.openDB(asOfTime);){
            instanceGraph = null;
            LinkedHashSet consolidated = new LinkedHashSet();
            HashSet<String> entityGUIDsRetrieved = new HashSet<String>();
            HashSet<String> relationshipGUIDsRetrieved = new HashSet<String>();
            HashSet<String> entityGUIDsVisited = new HashSet<String>();
            HashSet<String> relationshipGUIDsVisited = new HashSet<String>();
            List<String> nextEntityGUIDs = new ArrayList<String>();
            nextEntityGUIDs.add(entityGUID);
            EntityDetail startingEntity = this.getEntityByGuid(db, entityGUID);
            if (startingEntity != null) {
                entityGUIDsRetrieved.add(entityGUID);
                int levelTraversed = 0;
                if (level < 0) {
                    level = 40;
                }
                if (level > 0) {
                    do {
                        Set<List<?>> nextGraph = this.getNextLevelNeighbors(db, nextEntityGUIDs, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, entityGUIDsVisited, relationshipGUIDsVisited);
                        entityGUIDsVisited.addAll(nextEntityGUIDs);
                        ++levelTraversed;
                        consolidated.addAll(nextGraph);
                        nextEntityGUIDs = this.getEntityGUIDsFromGraphResults(nextGraph);
                        nextEntityGUIDs.removeAll(entityGUIDsVisited);
                    } while (!nextEntityGUIDs.isEmpty() && levelTraversed < level);
                }
                instanceGraph = this.resultsToGraph(startingEntity, db, consolidated, entityGUIDsRetrieved, relationshipGUIDsRetrieved, includeRelationships);
            }
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "findNeighborhood", (Throwable)e);
        }
        return instanceGraph;
    }

    private Set<List<?>> getNextLevelNeighbors(ICruxDatasource db, List<String> startingPoints, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Set<String> entityGUIDsVisited, Set<String> relationshipGUIDsVisited) throws RepositoryTimeoutException {
        String methodName = "getNextLevelNeighbors";
        LinkedHashSet consolidated = new LinkedHashSet();
        try {
            for (String entityGUID : startingPoints) {
                Collection<List<?>> nextDegree = this.findDirectNeighbors(db, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification);
                log.debug("Found neighborhood results: {}", nextDegree);
                for (List<?> candidateTuple : nextDegree) {
                    String candidateEntityRef = this.getEntityRefFromGraphTuple(candidateTuple);
                    String candidateRelationshipRef = this.getRelationshipRefFromGraphTuple(candidateTuple);
                    String entityGuid = InstanceHeaderMapping.trimGuidFromReference(candidateEntityRef);
                    String relationshipGuid = InstanceHeaderMapping.trimGuidFromReference(candidateRelationshipRef);
                    if (entityGUIDsVisited.contains(entityGuid) && relationshipGUIDsVisited.contains(relationshipGuid)) continue;
                    consolidated.add(candidateTuple);
                    entityGUIDsVisited.add(entityGUID);
                    relationshipGUIDsVisited.add(relationshipGuid);
                }
            }
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(CruxOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "getNextLevelNeighbors", (Throwable)e);
        }
        return consolidated;
    }

    public InstanceGraph getTraversalsBetweenEntities(String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws EntityNotKnownException, RepositoryErrorException {
        InstanceGraph instanceGraph;
        String methodName = "getTraversalsBetweenEntities";
        try (ICruxDatasource db = asOfTime == null ? this.cruxAPI.openDB() : this.cruxAPI.openDB(asOfTime);){
            HashSet<String> entityGUIDsVisited = new HashSet<String>();
            HashSet<String> relationshipGUIDsVisited = new HashSet<String>();
            EntityDetail startingEntity = this.getEntityByGuid(db, startEntityGUID);
            if (startingEntity == null) {
                throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(startEntityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "getTraversalsBetweenEntities");
            }
            entityGUIDsVisited.add(startEntityGUID);
            HashSet<String> traversedGuids = new HashSet<String>();
            traversedGuids.add(startEntityGUID);
            Set<List<?>> successfulTraversals = this.traverseToEnd(db, startEntityGUID, endEntityGUID, limitResultsByStatus, traversedGuids, 1);
            instanceGraph = this.resultsToGraph(startingEntity, db, successfulTraversals, entityGUIDsVisited, relationshipGUIDsVisited, true);
            if (instanceGraph != null && instanceGraph.getEntities() != null && instanceGraph.getEntities().size() == 1) {
                instanceGraph = null;
            }
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "getTraversalsBetweenEntities", (Throwable)e);
        }
        return instanceGraph;
    }

    private Set<List<?>> traverseToEnd(ICruxDatasource db, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Set<String> entityGUIDsVisited, int currentDepth) throws RepositoryTimeoutException {
        String methodName = "traverseToEnd";
        LinkedHashSet consolidated = new LinkedHashSet();
        if (currentDepth < 40) {
            try {
                Collection<List<?>> nextLevel = this.findDirectNeighbors(db, startEntityGUID, null, null, limitResultsByStatus, null);
                log.debug("Found traversal results: {}", nextLevel);
                String startRef = EntitySummaryMapping.getReference(startEntityGUID);
                String endRef = EntitySummaryMapping.getReference(endEntityGUID);
                if (nextLevel != null && !nextLevel.isEmpty()) {
                    for (List<?> candidateTuple : nextLevel) {
                        String nextStartGuid;
                        String candidateEntityRef = this.getEntityRefFromGraphTuple(candidateTuple);
                        if (endRef.equals(candidateEntityRef)) {
                            consolidated.add(candidateTuple);
                            continue;
                        }
                        if (startRef.equals(candidateEntityRef) || entityGUIDsVisited.contains(nextStartGuid = InstanceHeaderMapping.trimGuidFromReference(candidateEntityRef))) continue;
                        entityGUIDsVisited.add(nextStartGuid);
                        Set<List<?>> nextTraversal = this.traverseToEnd(db, nextStartGuid, endEntityGUID, limitResultsByStatus, entityGUIDsVisited, currentDepth + 1);
                        if (nextTraversal.isEmpty()) continue;
                        consolidated.add(candidateTuple);
                        consolidated.addAll(nextTraversal);
                    }
                }
            }
            catch (TimeoutException e) {
                throw new RepositoryTimeoutException(CruxOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "traverseToEnd", (Throwable)e);
            }
        }
        return consolidated;
    }

    private InstanceGraph resultsToGraph(EntityDetail startingEntity, ICruxDatasource db, Collection<List<?>> cruxResults, Set<String> entityGUIDsVisited, Set<String> relationshipGUIDsVisited, boolean includeRelationships) {
        String methodName = "resultsToGraph";
        InstanceGraph results = null;
        if (startingEntity != null) {
            results = new InstanceGraph();
            ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
            ArrayList<Relationship> relationships = new ArrayList<Relationship>();
            entities.add(startingEntity);
            entityGUIDsVisited.add(startingEntity.getGUID());
            if (cruxResults != null) {
                for (List<?> cruxResult : cruxResults) {
                    String relationshipRef;
                    String relationshipGuid;
                    String entityRef = this.getEntityRefFromGraphTuple(cruxResult);
                    String entityGuid = InstanceHeaderMapping.trimGuidFromReference(entityRef);
                    if (!entityGUIDsVisited.contains(entityGuid)) {
                        EntityDetail entity = this.getEntityByRef(db, entityRef);
                        entityGUIDsVisited.add(entityGuid);
                        if (entity == null) {
                            this.logProblem(((Object)((Object)this)).getClass().getName(), "resultsToGraph", CruxOMRSAuditCode.MAPPING_FAILURE, null, "entity", entityRef, "cannot be translated to EntityDetail");
                        } else {
                            entities.add(entity);
                        }
                    }
                    if (!includeRelationships || relationshipGUIDsVisited.contains(relationshipGuid = InstanceHeaderMapping.trimGuidFromReference(relationshipRef = this.getRelationshipRefFromGraphTuple(cruxResult)))) continue;
                    Relationship relationship = this.getRelationshipByRef(db, relationshipRef);
                    relationshipGUIDsVisited.add(relationshipGuid);
                    if (relationship == null) {
                        this.logProblem(((Object)((Object)this)).getClass().getName(), "resultsToGraph", CruxOMRSAuditCode.MAPPING_FAILURE, null, "relationship", relationshipRef, "cannot be translated to Relationship");
                        continue;
                    }
                    relationships.add(relationship);
                }
            }
            results.setEntities(entities);
            results.setRelationships(relationships);
        }
        return results;
    }

    private List<String> getEntityGUIDsFromGraphResults(Collection<List<?>> cruxResults) {
        ArrayList<String> list = new ArrayList<String>();
        for (List<?> result : cruxResults) {
            String guid;
            String entityRef = this.getEntityRefFromGraphTuple(result);
            if (entityRef == null || list.contains(guid = InstanceHeaderMapping.trimGuidFromReference(entityRef))) continue;
            list.add(guid);
        }
        return list;
    }

    private String getEntityRefFromGraphTuple(List<?> tuple) {
        return tuple == null ? null : (String)tuple.get(0);
    }

    private String getRelationshipRefFromGraphTuple(List<?> tuple) {
        return tuple == null ? null : (String)tuple.get(1);
    }

    public List<Relationship> findRelationships(String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) throws TypeErrorException, RepositoryErrorException {
        List<Relationship> results;
        String methodName = "findRelationships";
        try (ICruxDatasource db = asOfTime == null ? this.cruxAPI.openDB() : this.cruxAPI.openDB(asOfTime);){
            Collection<List<?>> cruxResults = this.searchCrux(db, TypeDefCategory.RELATIONSHIP_DEF, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize, "relationshipProperties", userId);
            log.debug("Found results: {}", cruxResults);
            results = this.resultsToList(db, cruxResults);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "findRelationships", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(CruxOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "findRelationships", (Throwable)e);
        }
        return results;
    }

    public List<Relationship> findRelationshipsByText(String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) throws TypeErrorException, RepositoryErrorException {
        List<Relationship> results;
        String methodName = "findRelationshipsByText";
        try (ICruxDatasource db = asOfTime == null ? this.cruxAPI.openDB() : this.cruxAPI.openDB(asOfTime);){
            Collection<List<?>> cruxResults = this.searchCruxText(db, TypeDefCategory.RELATIONSHIP_DEF, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize, "relationshipProperties", userId);
            log.debug("Found results: {}", cruxResults);
            results = this.resultsToList(db, cruxResults);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "findRelationshipsByText", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(CruxOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "findRelationshipsByText", (Throwable)e);
        }
        return results;
    }

    private List<Relationship> resultsToList(ICruxDatasource db, Collection<List<?>> cruxResults) {
        String methodName = "resultsToList";
        ArrayList<Relationship> results = null;
        if (cruxResults != null) {
            results = new ArrayList<Relationship>();
            for (List<?> cruxResult : cruxResults) {
                String docRef = (String)cruxResult.get(0);
                Relationship relationship = this.getRelationshipByRef(db, docRef);
                if (relationship == null) {
                    this.logProblem(((Object)((Object)this)).getClass().getName(), "resultsToList", CruxOMRSAuditCode.MAPPING_FAILURE, null, "relationship", docRef, "cannot be translated to Relationship");
                    continue;
                }
                results.add(relationship);
            }
        }
        return results;
    }

    private Relationship getRelationshipByRef(ICruxDatasource db, String ref) {
        CruxDocument cruxDoc = this.getCruxObjectByReference(db, ref);
        if (cruxDoc != null) {
            RelationshipMapping rm = new RelationshipMapping(this, cruxDoc, db);
            return rm.toEgeria();
        }
        return null;
    }

    public Relationship createRelationship(Relationship relationship) {
        Transaction.Builder tx = Transaction.builder();
        this.addCreateRelationshipStatements(tx, relationship);
        TransactionInstant results = this.runTx(tx.build());
        log.debug(" ... results: {}", (Object)results);
        return relationship;
    }

    public void addCreateRelationshipStatements(Transaction.Builder tx, Relationship relationship) {
        RelationshipMapping rm = new RelationshipMapping(this, relationship);
        CruxOMRSRepositoryConnector.put(tx, rm.toCrux());
    }

    public void purgeRelationship(String guid) {
        Transaction.Builder tx = Transaction.builder();
        this.addPurgeRelationshipStatements(tx, guid);
        this.runTx(tx.build());
    }

    public void addPurgeRelationshipStatements(Transaction.Builder tx, String guid) {
        CruxOMRSRepositoryConnector.evict(tx, RelationshipMapping.getReference(guid));
    }

    public Relationship updateRelationship(Relationship relationship) {
        return this.createRelationship(relationship);
    }

    public void addUpdateRelationshipStatements(Transaction.Builder tx, Relationship relationship) {
        this.addCreateRelationshipStatements(tx, relationship);
    }

    public Relationship getRelationship(String guid, Date asOfTime) throws RepositoryErrorException {
        Relationship result;
        String methodName = "getRelationship";
        try (ICruxDatasource db = asOfTime == null ? this.cruxAPI.openDB() : this.cruxAPI.openDB(asOfTime);){
            CruxDocument cruxDoc = this.getCruxObjectByReference(db, RelationshipMapping.getReference(guid));
            if (log.isDebugEnabled()) {
                log.debug("Found results: {}", (Object)(cruxDoc == null ? null : cruxDoc.toMap()));
            }
            RelationshipMapping rm = new RelationshipMapping(this, cruxDoc, db);
            result = rm.toEgeria();
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "getRelationship", (Throwable)e);
        }
        return result;
    }

    public EntityDetail restorePreviousVersionOfEntity(String userId, String guid) throws RepositoryErrorException {
        String docRef = EntitySummaryMapping.getReference(guid);
        List<CruxDocument> history = this.getPreviousVersion(docRef);
        if (history.size() > 1) {
            EntityDetailMapping edmC = new EntityDetailMapping(this, history.get(0));
            EntityDetail current = edmC.toEgeria();
            long currentVersion = current.getVersion();
            List currentClassifications = current.getClassifications();
            EntityDetailMapping edmP = new EntityDetailMapping(this, history.get(1));
            EntityDetail restored = edmP.toEgeria();
            restored.setVersion(currentVersion + 1L);
            restored.setUpdateTime(new Date());
            restored.setUpdatedBy(userId);
            restored.setClassifications(currentClassifications);
            ArrayList<String> maintainedBy = restored.getMaintainedBy();
            if (maintainedBy == null) {
                maintainedBy = new ArrayList<String>();
            }
            if (!maintainedBy.contains(userId)) {
                maintainedBy.add(userId);
                restored.setMaintainedBy(maintainedBy);
            }
            return this.updateEntity(restored);
        }
        return null;
    }

    public Relationship restorePreviousVersionOfRelationship(String userId, String guid) throws RepositoryErrorException {
        String methodName = "restorePreviousVersionOfRelationship";
        String docRef = RelationshipMapping.getReference(guid);
        Relationship restored = null;
        try (ICruxDatasource db = this.cruxAPI.openDB();){
            List<CruxDocument> history = this.getPreviousVersion(db, docRef);
            if (history.size() > 1) {
                RelationshipMapping rmC = new RelationshipMapping(this, history.get(0), db);
                Relationship current = rmC.toEgeria();
                long currentVersion = current.getVersion();
                RelationshipMapping rmP = new RelationshipMapping(this, history.get(1), db);
                restored = rmP.toEgeria();
                restored.setVersion(currentVersion + 1L);
                restored.setUpdateTime(new Date());
                restored.setUpdatedBy(userId);
                ArrayList<String> maintainedBy = restored.getMaintainedBy();
                if (maintainedBy == null) {
                    maintainedBy = new ArrayList<String>();
                }
                if (!maintainedBy.contains(userId)) {
                    maintainedBy.add(userId);
                    restored.setMaintainedBy(maintainedBy);
                }
                restored = this.updateRelationship(restored);
            }
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "restorePreviousVersionOfRelationship", (Throwable)e);
        }
        return restored;
    }

    private List<CruxDocument> getPreviousVersion(String reference) throws RepositoryErrorException {
        List<CruxDocument> results;
        String methodName = "getPreviousVersion";
        HistoryOptions options = HistoryOptions.create((HistoryOptions.SortOrder)HistoryOptions.SortOrder.DESC);
        try (ICursor lazyCursor = this.cruxAPI.db().openEntityHistory((Object)reference, options);){
            results = this.getPreviousVersionFromCursor(lazyCursor, reference);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "getPreviousVersion", (Throwable)e);
        }
        return results;
    }

    private List<CruxDocument> getPreviousVersion(ICruxDatasource db, String reference) throws RepositoryErrorException {
        List<CruxDocument> results;
        String methodName = "getPreviousVersion";
        HistoryOptions options = HistoryOptions.create((HistoryOptions.SortOrder)HistoryOptions.SortOrder.DESC);
        try (ICursor lazyCursor = db.openEntityHistory((Object)reference, options);){
            results = this.getPreviousVersionFromCursor(lazyCursor, reference);
        }
        catch (Exception e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "getPreviousVersion", (Throwable)e);
        }
        return results;
    }

    private List<CruxDocument> getPreviousVersionFromCursor(ICursor<Map<Keyword, ?>> cursor, String reference) {
        Map currentVersionTxn;
        CruxDocument current;
        ArrayList<CruxDocument> results = new ArrayList<CruxDocument>();
        if (cursor != null && cursor.hasNext() && (current = this.getCruxObjectByReference(reference, currentVersionTxn = (Map)cursor.next())) != null) {
            long currentVersion = (Long)current.get(InstanceAuditHeaderMapping.VERSION);
            CruxDocument previous = null;
            while (previous == null && cursor.hasNext()) {
                Map candidateTxn = (Map)cursor.next();
                CruxDocument candidate = this.getCruxObjectByReference(reference, candidateTxn);
                long candidateVersion = (Long)candidate.get(InstanceAuditHeaderMapping.VERSION);
                if (candidateVersion >= currentVersion) continue;
                previous = candidate;
            }
            if (previous != null) {
                results.add(current);
                results.add(previous);
            }
        }
        return results;
    }

    public List<EntityDetail> getPreviousVersionsOfEntity(String guid, Date from, Date to, int offset, int pageSize, HistorySequencingOrder order) throws EntityNotKnownException, RepositoryErrorException {
        boolean noResults;
        String methodName = "getPreviousVersionsOfEntity";
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        String docRef = EntitySummaryMapping.getReference(guid);
        try (ICruxDatasource db = to == null ? this.cruxAPI.openDB() : this.cruxAPI.openDB(to);){
            List<CruxDocument> history = this.getPreviousVersions(db, docRef, from, order);
            noResults = history.isEmpty();
            if (pageSize == 0) {
                pageSize = this.getMaxPageSize();
            }
            int maxResult = offset + pageSize;
            int currentIndex = 0;
            for (CruxDocument version : history) {
                EntityDetailMapping edm;
                EntityDetail detail;
                if (currentIndex >= maxResult) {
                    break;
                }
                if (currentIndex >= offset && (detail = (edm = new EntityDetailMapping(this, version)).toEgeria()) != null) {
                    results.add(detail);
                }
                ++currentIndex;
            }
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "getPreviousVersionsOfEntity", (Throwable)e);
        }
        if (noResults) {
            throw new EntityNotKnownException(CruxOMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(guid), ((Object)((Object)this)).getClass().getName(), "getPreviousVersionsOfEntity");
        }
        return results;
    }

    public List<Relationship> getPreviousVersionsOfRelationship(String guid, Date from, Date to, int offset, int pageSize, HistorySequencingOrder order) throws RelationshipNotKnownException, RepositoryErrorException {
        boolean noResults;
        String methodName = "getPreviousVersionsOfRelationship";
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        String docRef = RelationshipMapping.getReference(guid);
        try (ICruxDatasource db = to == null ? this.cruxAPI.openDB() : this.cruxAPI.openDB(to);){
            List<CruxDocument> history = this.getPreviousVersions(db, docRef, from, order);
            noResults = history.isEmpty();
            if (pageSize == 0) {
                pageSize = this.getMaxPageSize();
            }
            int maxResult = offset + pageSize;
            int currentIndex = 0;
            for (CruxDocument version : history) {
                RelationshipMapping rm;
                Relationship relationship;
                if (currentIndex >= maxResult) {
                    break;
                }
                if (currentIndex >= offset && (relationship = (rm = new RelationshipMapping(this, version, db)).toEgeria()) != null) {
                    results.add(relationship);
                }
                ++currentIndex;
            }
        }
        catch (IOException e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "getPreviousVersionsOfRelationship", (Throwable)e);
        }
        if (noResults) {
            throw new RelationshipNotKnownException(CruxOMRSErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(guid), ((Object)((Object)this)).getClass().getName(), "getPreviousVersionsOfRelationship");
        }
        return results;
    }

    private List<CruxDocument> getPreviousVersions(ICruxDatasource db, String reference, Date earliest, HistorySequencingOrder order) throws RepositoryErrorException {
        List<CruxDocument> results;
        String methodName = "getPreviousVersions";
        HistoryOptions options = HistoryOptions.create((HistoryOptions.SortOrder)HistoryOptions.SortOrder.DESC);
        try (ICursor lazyCursor = db.openEntityHistory((Object)reference, options);){
            results = this.getPreviousVersionsFromCursor(lazyCursor, reference, earliest, order);
        }
        catch (Exception e) {
            throw new RepositoryErrorException(CruxOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "getPreviousVersions", (Throwable)e);
        }
        return results;
    }

    private List<CruxDocument> getPreviousVersionsFromCursor(ICursor<Map<Keyword, ?>> cursor, String reference, Date earliest, HistorySequencingOrder order) {
        ArrayList<CruxDocument> results = new ArrayList<CruxDocument>();
        if (cursor != null) {
            while (cursor.hasNext()) {
                Map version = (Map)cursor.next();
                Date versionValidFrom = (Date)version.get(Constants.CRUX_VALID_TIME);
                int comparator = earliest == null ? 1 : versionValidFrom.compareTo(earliest);
                CruxDocument docVersion = this.getCruxObjectByReference(reference, version);
                if (docVersion != null) {
                    results.add(docVersion);
                }
                if (comparator > 0) continue;
                break;
            }
        }
        if (order.equals((Object)HistorySequencingOrder.FORWARDS)) {
            Collections.reverse(results);
        }
        return results;
    }

    public void saveReferenceCopy(EntityDetail entity) throws EntityConflictException {
        String methodName = "saveReferenceCopy";
        String rcGuid = entity.getGUID();
        String rcMetadataCollectionId = entity.getMetadataCollectionId();
        EntitySummary existingEntity = this.getEntitySummary(rcGuid);
        if (existingEntity == null) {
            this.createEntity(entity);
        } else {
            String exMetadataCollectionId = existingEntity.getMetadataCollectionId();
            if (!rcMetadataCollectionId.equals(exMetadataCollectionId)) {
                throw new EntityConflictException(CruxOMRSErrorCode.METADATA_COLLECTION_CONFLICT.getMessageDefinition(entity.getGUID(), this.repositoryName), ((Object)((Object)this)).getClass().getName(), "saveReferenceCopy");
            }
            this.updateEntity(entity);
        }
    }

    public void addSaveReferenceCopyStatements(Transaction.Builder tx, Relationship relationship) throws RelationshipConflictException, RepositoryErrorException {
        String methodName = "addSaveReferenceCopyStatements";
        String rcGuid = relationship.getGUID();
        String rcMetadataCollectionId = relationship.getMetadataCollectionId();
        Relationship existingRelationship = this.getRelationship(rcGuid, null);
        if (existingRelationship == null) {
            this.addCreateRelationshipStatements(tx, relationship);
        } else {
            String exMetadataCollectionId = existingRelationship.getMetadataCollectionId();
            if (!rcMetadataCollectionId.equals(exMetadataCollectionId)) {
                throw new RelationshipConflictException(CruxOMRSErrorCode.METADATA_COLLECTION_CONFLICT.getMessageDefinition(relationship.getGUID(), this.repositoryName), ((Object)((Object)this)).getClass().getName(), "addSaveReferenceCopyStatements");
            }
            this.addUpdateRelationshipStatements(tx, relationship);
        }
    }

    public CruxDocument getCruxObjectByReference(String reference) {
        return this.getCruxObjectByReference(reference, (Date)null);
    }

    public CruxDocument getCruxObjectByReference(String reference, Date asOfTime) {
        if (asOfTime != null) {
            return this.cruxAPI.db(asOfTime).entity((Object)reference);
        }
        return this.cruxAPI.db().entity((Object)reference);
    }

    public CruxDocument getCruxObjectByReference(ICruxDatasource db, String reference) {
        return db.entity((Object)reference);
    }

    public CruxDocument getCruxObjectByReference(String reference, Map<Keyword, ?> txnDetails) {
        Object oValid = txnDetails.get(Constants.CRUX_VALID_TIME);
        Object oTxn = txnDetails.get(Constants.CRUX_TX_TIME);
        if (oValid instanceof Date && oTxn instanceof Date) {
            return this.cruxAPI.db((Date)oValid, (Date)oTxn).entity((Object)reference);
        }
        return null;
    }

    public Collection<List<?>> searchCrux(TypeDefCategory category, String typeGuid, List<String> subtypeGuids, SearchProperties matchProperties, int fromElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String namespace, String userId) throws TypeErrorException, TimeoutException {
        CruxQuery query = new CruxQuery();
        this.updateQuery(query, category, typeGuid, subtypeGuids, matchProperties, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, namespace, userId);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        Collection results = this.cruxAPI.db(asOfTime).query((Object)q, new Object[0]);
        return this.deduplicateAndPage(results, fromElement, pageSize);
    }

    public Collection<List<?>> searchCrux(ICruxDatasource db, TypeDefCategory category, String typeGuid, List<String> subtypeGuids, SearchProperties matchProperties, int fromElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String namespace, String userId) throws TypeErrorException, TimeoutException {
        CruxQuery query = new CruxQuery();
        this.updateQuery(query, category, typeGuid, subtypeGuids, matchProperties, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, namespace, userId);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        Collection results = db.query((Object)q, new Object[0]);
        return this.deduplicateAndPage(results, fromElement, pageSize);
    }

    public Collection<List<?>> searchCruxText(TypeDefCategory category, String typeGuid, String searchCriteria, int fromElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String namespace, String userId) throws TypeErrorException, TimeoutException {
        CruxQuery query = new CruxQuery();
        this.updateTextQuery(query, category, typeGuid, searchCriteria, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, namespace, userId);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        Collection results = this.cruxAPI.db(asOfTime).query((Object)q, new Object[0]);
        return this.deduplicateAndPage(results, fromElement, pageSize);
    }

    public Collection<List<?>> searchCruxText(ICruxDatasource db, TypeDefCategory category, String typeGuid, String searchCriteria, int fromElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String namespace, String userId) throws TypeErrorException, TimeoutException {
        CruxQuery query = new CruxQuery();
        this.updateTextQuery(query, category, typeGuid, searchCriteria, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, namespace, userId);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        Collection results = db.query((Object)q, new Object[0]);
        return this.deduplicateAndPage(results, fromElement, pageSize);
    }

    public Collection<List<?>> findEntityRelationships(ICruxDatasource db, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) throws TypeErrorException, TimeoutException {
        CruxQuery query = new CruxQuery();
        query.addRelationshipEndpointConditions(EntitySummaryMapping.getReference(entityGUID));
        this.updateQuery(query, TypeDefCategory.RELATIONSHIP_DEF, relationshipTypeGUID, null, null, limitResultsByStatus, null, sequencingProperty, sequencingOrder, null, userId);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        Collection results = db.query((Object)q, new Object[0]);
        return this.deduplicateAndPage(results, fromRelationshipElement, pageSize);
    }

    public Collection<List<?>> findEntityRelationships(ICruxDatasource db, String entityGUID, String userId, boolean includeDeleted) throws TimeoutException {
        String methodName = "findEntityRelationships";
        CruxQuery query = new CruxQuery();
        query.addRelationshipEndpointConditions(EntitySummaryMapping.getReference(entityGUID));
        try {
            if (includeDeleted) {
                query.addTypeCondition(TypeDefCategory.RELATIONSHIP_DEF, null, null);
            } else {
                this.updateQuery(query, TypeDefCategory.RELATIONSHIP_DEF, null, null, null, null, null, null, null, null, userId);
            }
        }
        catch (TypeErrorException e) {
            this.logProblem(((Object)((Object)this)).getClass().getName(), "findEntityRelationships", CruxOMRSAuditCode.UNEXPECTED_RUNTIME_ERROR, e, "unexpected type error when no types are explicitly used", ((Object)((Object)e)).getClass().getName());
        }
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        Collection results = db.query((Object)q, new Object[0]);
        return this.deduplicate(results);
    }

    public Collection<List<?>> findHomedEntityRelationships(ICruxDatasource db, EntityDetail entity, String userId) throws TimeoutException {
        String methodName = "findHomedEntityRelationships";
        CruxQuery query = new CruxQuery();
        query.addRelationshipEndpointConditions(EntitySummaryMapping.getReference(entity.getGUID()));
        SearchProperties matchProperties = new SearchProperties();
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PrimitivePropertyValue metadataCollectionId = new PrimitivePropertyValue();
        metadataCollectionId.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        metadataCollectionId.setPrimitiveValue((Object)entity.getMetadataCollectionId());
        PropertyCondition byMetadataCollectionId = new PropertyCondition();
        byMetadataCollectionId.setProperty("metadataCollectionId");
        byMetadataCollectionId.setOperator(PropertyComparisonOperator.EQ);
        byMetadataCollectionId.setValue((InstancePropertyValue)metadataCollectionId);
        conditions.add(byMetadataCollectionId);
        matchProperties.setConditions(conditions);
        matchProperties.setMatchCriteria(MatchCriteria.ALL);
        try {
            this.updateQuery(query, TypeDefCategory.RELATIONSHIP_DEF, null, null, matchProperties, null, null, null, null, null, userId);
        }
        catch (TypeErrorException e) {
            this.logProblem(((Object)((Object)this)).getClass().getName(), "findHomedEntityRelationships", CruxOMRSAuditCode.UNEXPECTED_RUNTIME_ERROR, e, "unexpected type error when no types are explicitly used", ((Object)((Object)e)).getClass().getName());
        }
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        Collection results = db.query((Object)q, new Object[0]);
        return this.deduplicate(results);
    }

    public Collection<List<?>> findDirectNeighbors(ICruxDatasource db, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification) throws TimeoutException {
        CruxGraphQuery query = new CruxGraphQuery();
        query.addRelationshipLimiters(entityGUID, relationshipTypeGUIDs, limitResultsByStatus);
        query.addEntityLimiters(entityTypeGUIDs, limitResultsByClassification, limitResultsByStatus);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        return db.query((Object)q, new Object[0]);
    }

    void updateQuery(CruxQuery query, TypeDefCategory category, String typeGuid, List<String> subtypeGuids, SearchProperties matchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, String namespace, String userId) throws TypeErrorException {
        Set<String> completeTypeSet = this.getCompleteSetOfTypeNamesForSearch(userId, typeGuid, subtypeGuids, namespace);
        query.addPropertyConditions(matchProperties, namespace, completeTypeSet, this, this.luceneConfigured, this.luceneRegexes);
        query.addTypeCondition(category, typeGuid, subtypeGuids);
        query.addClassificationConditions(matchClassifications, completeTypeSet, this, this.luceneConfigured, this.luceneRegexes);
        query.addSequencing(sequencingOrder, sequencingProperty, namespace, completeTypeSet, this);
        query.addStatusLimiters(limitResultsByStatus, CruxQuery.DOC_ID);
    }

    private void updateTextQuery(CruxQuery query, TypeDefCategory category, String typeGuid, String searchCriteria, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, String namespace, String userId) throws TypeErrorException {
        Set<String> completeTypeSet = this.getCompleteSetOfTypeNamesForSearch(userId, typeGuid, null, namespace);
        if (this.luceneConfigured) {
            query.addConditions(TextConditionBuilder.buildWildcardLuceneCondition(searchCriteria, this, completeTypeSet, namespace, this.luceneRegexes));
        } else {
            query.addConditions(TextConditionBuilder.buildWildcardTextCondition(searchCriteria, this, completeTypeSet, namespace, false, this.luceneRegexes));
        }
        query.addTypeCondition(category, typeGuid, null);
        query.addClassificationConditions(matchClassifications, completeTypeSet, this, this.luceneConfigured, this.luceneRegexes);
        query.addSequencing(sequencingOrder, sequencingProperty, namespace, completeTypeSet, this);
        query.addStatusLimiters(limitResultsByStatus, CruxQuery.DOC_ID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getCompleteSetOfTypeNamesForSearch(String userId, String typeGuid, List<String> subtypeGuids, String namespace) throws TypeErrorException {
        String methodName = "getCompleteListOfTypeNamesForSearch";
        HashSet<String> complete = new HashSet<String>();
        if (namespace == null) return complete;
        if (subtypeGuids != null && !subtypeGuids.isEmpty()) {
            for (String subtypeGuid : subtypeGuids) {
                String typeDefName = this.repositoryHelper.getTypeDef(this.repositoryName, "subtypeGuids", subtypeGuid, "getCompleteListOfTypeNamesForSearch").getName();
                this.addAllSubtypesToSet(complete, typeDefName);
            }
            return complete;
        } else if (typeGuid != null) {
            String typeDefName = this.repositoryHelper.getTypeDef(this.repositoryName, "typeGuid", typeGuid, "getCompleteListOfTypeNamesForSearch").getName();
            this.addAllSubtypesToSet(complete, typeDefName);
            return complete;
        } else if ("relationshipProperties".equals(namespace)) {
            try {
                List typeDefinitions = this.metadataCollection.findTypeDefsByCategory(userId, TypeDefCategory.RELATIONSHIP_DEF);
                if (typeDefinitions == null) return complete;
                for (TypeDef typeDef : typeDefinitions) {
                    String typeDefName = typeDef.getName();
                    this.addAllSubtypesToSet(complete, typeDefName);
                }
                return complete;
            }
            catch (InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
                this.logProblem(((Object)((Object)this)).getClass().getName(), "getCompleteListOfTypeNamesForSearch", CruxOMRSAuditCode.UNEXPECTED_RUNTIME_ERROR, e, "unable to retrieve relationship typedefs", e.getClass().getName());
                return complete;
            }
        } else {
            String typeDefName = "OpenMetadataRoot";
            this.addAllSubtypesToSet(complete, typeDefName);
        }
        return complete;
    }

    private Collection<List<?>> deduplicateAndPage(Collection<List<?>> results, int fromElement, int pageSize) {
        if (results == null || results.isEmpty()) {
            return results;
        }
        ArrayList pageOfResults = new ArrayList();
        HashSet skippedResults = new HashSet();
        int currentIndex = 0;
        pageSize = pageSize > 0 ? pageSize : this.getMaxPageSize();
        int lastResultIndex = fromElement + pageSize;
        for (List<?> singleResult : results) {
            if (currentIndex >= lastResultIndex) break;
            if (currentIndex >= fromElement) {
                if (pageOfResults.contains(singleResult)) continue;
                pageOfResults.add(singleResult);
                ++currentIndex;
                continue;
            }
            if (skippedResults.contains(singleResult)) continue;
            skippedResults.add(singleResult);
            ++currentIndex;
        }
        return pageOfResults;
    }

    Collection<List<?>> deduplicate(Collection<List<?>> results) {
        if (results == null || results.isEmpty()) {
            return results;
        }
        return new ArrayList(new HashSet(results));
    }

    private void addAllSubtypesToSet(Set<String> subtypes, String typeDefName) {
        subtypes.add(typeDefName);
        List subtypesList = this.repositoryHelper.getSubTypesOf(this.repositoryName, typeDefName);
        if (subtypesList != null) {
            subtypes.addAll(subtypesList);
        }
    }

    public TransactionInstant runTx(Transaction statements) {
        if (log.isDebugEnabled()) {
            log.debug("{} transacting with: {}", (Object)(this.synchronousIndex ? SYNC : ASYNC), (Object)statements.toVector());
        }
        TransactionInstant tx = this.cruxAPI.submitTx(statements);
        if (this.synchronousIndex) {
            return this.cruxAPI.awaitTx(tx, null);
        }
        return tx;
    }

    public ICruxAPI getCruxAPI() {
        return this.cruxAPI;
    }

    public static void put(Transaction.Builder tx, CruxDocument cruxDoc) {
        Object timeFromDoc;
        Date txnTime = null;
        Object latestClassificationChange = cruxDoc.get("lastClassificationChange");
        if (latestClassificationChange instanceof Date) {
            txnTime = (Date)latestClassificationChange;
        }
        if ((timeFromDoc = cruxDoc.get(InstanceAuditHeaderMapping.UPDATE_TIME)) instanceof Date) {
            Date updateTime = (Date)timeFromDoc;
            if (txnTime == null || txnTime.before(updateTime)) {
                txnTime = updateTime;
            }
        } else {
            timeFromDoc = cruxDoc.get(InstanceAuditHeaderMapping.CREATE_TIME);
            txnTime = timeFromDoc instanceof Date ? (Date)timeFromDoc : new Date();
        }
        tx.put(cruxDoc, txnTime);
    }

    public static void evict(Transaction.Builder tx, String docRef) {
        tx.evict((Object)docRef);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CruxOMRSRepositoryConnector that = (CruxOMRSRepositoryConnector)((Object)o);
        return this.luceneConfigured == that.luceneConfigured && this.synchronousIndex == that.synchronousIndex && this.luceneRegexes == that.luceneRegexes && Objects.equals(this.cruxAPI, that.cruxAPI);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cruxAPI, this.luceneConfigured, this.synchronousIndex, this.luceneRegexes);
    }
}

