/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import crux.api.CruxDocument;
import org.odpi.egeria.connectors.juxt.crux.auditlog.CruxOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.crux.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.EntitySummaryMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstancePropertiesMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class EntityProxyMapping
extends EntitySummaryMapping {
    private static final String ENTITY_PROXY = "EntityProxy";
    private static final String UNIQUE_PROPERTIES_NS = "uniqueProperties";
    public static final String ENTITY_PROXY_ONLY_MARKER = EntityProxyMapping.getKeyword("e", "proxy");

    public EntityProxyMapping(CruxOMRSRepositoryConnector cruxConnector, EntityProxy entityProxy) {
        super(cruxConnector, (EntitySummary)entityProxy);
    }

    public EntityProxyMapping(CruxOMRSRepositoryConnector cruxConnector, CruxDocument cruxDoc) {
        super(cruxConnector, cruxDoc);
    }

    public EntityProxy toEgeria() {
        if (this.instanceHeader == null && this.cruxDoc != null) {
            this.instanceHeader = new EntityProxy();
            this.fromDoc();
        }
        if (this.instanceHeader != null) {
            return (EntityProxy)this.instanceHeader;
        }
        return null;
    }

    @Override
    protected CruxDocument.Builder toDoc() {
        CruxDocument.Builder builder = super.toDoc();
        builder.put(ENTITY_PROXY_ONLY_MARKER, (Object)true);
        InstancePropertiesMapping.addToDoc(this.cruxConnector, builder, this.instanceHeader.getType(), ((EntityProxy)this.instanceHeader).getUniqueProperties(), UNIQUE_PROPERTIES_NS);
        return builder;
    }

    @Override
    protected void fromDoc() {
        super.fromDoc();
        InstanceProperties uniqueProperties = InstancePropertiesMapping.getFromDoc(this.cruxConnector, this.instanceHeader.getType(), this.cruxDoc, UNIQUE_PROPERTIES_NS);
        ((EntityProxy)this.instanceHeader).setUniqueProperties(uniqueProperties);
    }

    public static EntityProxy getFromDoc(CruxOMRSRepositoryConnector cruxConnector, CruxDocument doc) {
        String methodName = "getFromDoc";
        if (doc == null) {
            return null;
        }
        if (EntityProxyMapping.isOnlyAProxy(doc)) {
            EntityProxyMapping epm = new EntityProxyMapping(cruxConnector, doc);
            return epm.toEgeria();
        }
        EntityDetailMapping edm = new EntityDetailMapping(cruxConnector, doc);
        try {
            return cruxConnector.getRepositoryHelper().getNewEntityProxy(cruxConnector.getRepositoryName(), edm.toEgeria());
        }
        catch (RepositoryErrorException e) {
            cruxConnector.logProblem(EntityProxyMapping.class.getName(), "getFromDoc", CruxOMRSAuditCode.FAILED_RETRIEVAL, e, ENTITY_PROXY, doc.getId().toString(), ((Object)((Object)e)).getClass().getName());
            return null;
        }
    }

    public static String getReference(String guid) {
        return EntitySummaryMapping.getReference(guid);
    }

    public static boolean isOnlyAProxy(CruxDocument doc) {
        Boolean only = (Boolean)doc.get(ENTITY_PROXY_ONLY_MARKER);
        return only != null && only != false;
    }
}

