/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import crux.api.CruxDocument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.odpi.egeria.connectors.juxt.crux.mapping.InstancePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;

public class InstancePropertiesMapping {
    private InstancePropertiesMapping() {
    }

    public static InstanceProperties getFromDoc(CruxOMRSRepositoryConnector cruxConnector, InstanceType type, CruxDocument cruxDoc, String namespace) {
        List validProperties = type.getValidInstanceProperties();
        if (validProperties != null && !validProperties.isEmpty()) {
            TreeMap<String, InstancePropertyValue> values = new TreeMap<String, InstancePropertyValue>();
            for (String propertyName : validProperties) {
                InstancePropertyValue value = InstancePropertyValueMapping.getInstancePropertyValueFromDoc(cruxConnector, cruxDoc, namespace, propertyName);
                if (value == null) continue;
                values.put(propertyName, value);
            }
            InstanceProperties ip = new InstanceProperties();
            ip.setInstanceProperties(values);
            return ip;
        }
        return null;
    }

    public static void addToDoc(CruxOMRSRepositoryConnector cruxConnector, CruxDocument.Builder builder, InstanceType type, InstanceProperties properties, String namespace) {
        HashMap propertyMap;
        if (properties != null) {
            propertyMap = properties.getInstanceProperties();
            if (propertyMap != null) {
                for (Map.Entry entry : propertyMap.entrySet()) {
                    InstancePropertyValueMapping.addInstancePropertyValueToDoc(cruxConnector, type, builder, (String)entry.getKey(), namespace, (InstancePropertyValue)entry.getValue());
                }
            } else {
                propertyMap = new HashMap();
            }
        } else {
            propertyMap = new HashMap();
        }
        List allProperties = type.getValidInstanceProperties();
        if (allProperties != null) {
            for (String propertyName : allProperties) {
                if (propertyMap.containsKey(propertyName)) continue;
                InstancePropertyValueMapping.addInstancePropertyValueToDoc(cruxConnector, type, builder, propertyName, namespace, null);
            }
        }
    }
}

