/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.crux.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import crux.api.CruxDocument;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.odpi.egeria.connectors.juxt.crux.auditlog.CruxOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.crux.mapping.AbstractMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.ArrayPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.EnumPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.MapPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.PrimitivePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.crux.mapping.StructPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.crux.repositoryconnector.CruxOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class InstancePropertyValueMapping
extends AbstractMapping {
    protected InstancePropertyValueMapping() {
        super(null);
    }

    public static Object getValueForComparison(CruxOMRSRepositoryConnector cruxConnector, InstancePropertyValue ipv) {
        Map<String, Object> value = null;
        if (ipv != null) {
            InstancePropertyCategory category = ipv.getInstancePropertyCategory();
            switch (category) {
                case PRIMITIVE: {
                    value = PrimitivePropertyValueMapping.getPrimitiveValueForComparison((PrimitivePropertyValue)ipv);
                    break;
                }
                case ENUM: {
                    value = EnumPropertyValueMapping.getEnumPropertyValueForComparison((EnumPropertyValue)ipv);
                    break;
                }
                case ARRAY: {
                    value = ArrayPropertyValueMapping.getArrayPropertyValueForComparison(cruxConnector, (ArrayPropertyValue)ipv);
                    break;
                }
                case MAP: {
                    value = MapPropertyValueMapping.getMapPropertyValueForComparison(cruxConnector, (MapPropertyValue)ipv);
                    break;
                }
                case STRUCT: {
                    value = StructPropertyValueMapping.getStructPropertyValueForComparison(cruxConnector, (StructPropertyValue)ipv);
                    break;
                }
                default: {
                    cruxConnector.logProblem(InstancePropertyValueMapping.class.getName(), "getValueForComparison", CruxOMRSAuditCode.UNMAPPED_TYPE, null, "InstancePropertyCategory::" + category.name());
                }
            }
        }
        return value;
    }

    public static InstancePropertyValue getInstancePropertyValueFromDoc(CruxOMRSRepositoryConnector cruxConnector, CruxDocument cruxDoc, String namespace, String propertyName) {
        IPersistentMap embeddedValue;
        Object objValue = cruxDoc.get(InstancePropertyValueMapping.getKeyword(namespace, propertyName + ".json"));
        IPersistentMap iPersistentMap = embeddedValue = objValue instanceof IPersistentMap ? (IPersistentMap)objValue : null;
        if (embeddedValue != null) {
            return InstancePropertyValueMapping.getInstancePropertyValue(cruxConnector, namespace, propertyName, embeddedValue);
        }
        return null;
    }

    public static void addInstancePropertyValueToDoc(CruxOMRSRepositoryConnector cruxConnector, InstanceType instanceType, CruxDocument.Builder builder, String propertyName, String namespace, InstancePropertyValue value) {
        builder.put(InstancePropertyValueMapping.getSerializedPropertyKeyword(namespace, propertyName), (Object)InstancePropertyValueMapping.getEmbeddedSerializedForm(cruxConnector, instanceType.getTypeDefName(), propertyName, value));
        if (value != null) {
            InstancePropertyCategory category = value.getInstancePropertyCategory();
            switch (category) {
                case PRIMITIVE: {
                    PrimitivePropertyValueMapping.addPrimitivePropertyValueToDoc(cruxConnector, instanceType, builder, propertyName, namespace, (PrimitivePropertyValue)value);
                    break;
                }
                case ENUM: {
                    EnumPropertyValueMapping.addEnumPropertyValueToDoc(cruxConnector, instanceType, builder, propertyName, namespace, (EnumPropertyValue)value);
                    break;
                }
                case ARRAY: {
                    ArrayPropertyValueMapping.addArrayPropertyValueToDoc(cruxConnector, instanceType, builder, propertyName, namespace, (ArrayPropertyValue)value);
                    break;
                }
                case MAP: {
                    MapPropertyValueMapping.addMapPropertyValueToDoc(cruxConnector, instanceType, builder, propertyName, namespace, (MapPropertyValue)value);
                    break;
                }
                case STRUCT: {
                    StructPropertyValueMapping.addStructPropertyValueToDoc(cruxConnector, instanceType, builder, propertyName, namespace, (StructPropertyValue)value);
                    break;
                }
                default: {
                    cruxConnector.logProblem(InstancePropertyValueMapping.class.getName(), "addInstancePropertyValueToDoc", CruxOMRSAuditCode.UNMAPPED_TYPE, null, "InstancePropertyValueCategory::" + category.name());
                    break;
                }
            }
        } else {
            builder.put(InstancePropertyValueMapping.getPropertyValueKeyword(cruxConnector, instanceType, propertyName, namespace), null);
        }
    }

    protected static String getSerializedPropertyKeyword(String namespace, String propertyName) {
        return InstancePropertyValueMapping.getKeyword(namespace, propertyName + ".json");
    }

    protected static String getPropertyValueKeyword(CruxOMRSRepositoryConnector cruxConnector, InstanceType instanceType, String propertyName, String namespace) {
        HashSet<String> typesToConsider = new HashSet<String>();
        typesToConsider.add(instanceType.getTypeDefName());
        Set<String> names = InstancePropertyValueMapping.getNamesForProperty(cruxConnector, propertyName, namespace, typesToConsider, null);
        String qualified = null;
        if (names.size() > 1) {
            cruxConnector.logProblem(InstancePropertyValueMapping.class.getName(), "getPropertyValueKeyword", CruxOMRSAuditCode.DUPLICATE_PROPERTIES, null, instanceType.getTypeDefName(), propertyName, names.toString());
        }
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name;
            qualified = name = iterator.next();
        }
        return qualified;
    }

    private static InstancePropertyValue getInstancePropertyValue(CruxOMRSRepositoryConnector cruxConnector, String namespace, String property, IPersistentMap jsonValue) {
        return (InstancePropertyValue)InstancePropertyValueMapping.getDeserializedValue(cruxConnector, namespace, property, jsonValue, mapper.getTypeFactory().constructType(InstancePropertyValue.class));
    }

    public static Set<String> getNamesForProperty(CruxOMRSRepositoryConnector cruxConnector, String propertyName, String namespace, Set<String> limitToTypes, InstancePropertyValue value) {
        String methodName = "getNamesForProperty";
        OMRSRepositoryHelper repositoryHelper = cruxConnector.getRepositoryHelper();
        String repositoryName = cruxConnector.getRepositoryName();
        Set validTypesForProperty = repositoryHelper.getAllTypeDefsForProperty(repositoryName, propertyName, "getNamesForProperty");
        TreeSet<String> qualifiedNames = new TreeSet<String>();
        if (validTypesForProperty != null) {
            for (String typeNameWithProperty : validTypesForProperty) {
                String candidateRef = InstancePropertyValueMapping.getFullyQualifiedPropertyNameForValue(namespace, typeNameWithProperty, propertyName);
                if (qualifiedNames.contains(candidateRef)) continue;
                for (String limitToType : limitToTypes) {
                    if (!repositoryHelper.isTypeOf(repositoryName, limitToType, typeNameWithProperty) || !InstancePropertyValueMapping.propertyDefMatchesValueType(cruxConnector, repositoryName, typeNameWithProperty, propertyName, value)) continue;
                    qualifiedNames.add(candidateRef);
                }
            }
        }
        return qualifiedNames;
    }

    public static Set<Keyword> getKeywordsForProperty(CruxOMRSRepositoryConnector cruxConnector, String propertyName, String namespace, Set<String> limitToTypes, InstancePropertyValue value) {
        TreeSet<Keyword> keywords = new TreeSet<Keyword>();
        Set<String> strings = InstancePropertyValueMapping.getNamesForProperty(cruxConnector, propertyName, namespace, limitToTypes, value);
        for (String string : strings) {
            keywords.add(Keyword.intern((String)string));
        }
        return keywords;
    }

    public static String getEndsWithPropertyNameForMatching(String propertyName) {
        return "." + propertyName + ".value";
    }

    private static String getFullyQualifiedPropertyNameForValue(String namespace, String typeName, String propertyName) {
        return InstancePropertyValueMapping.getKeyword(namespace, typeName + InstancePropertyValueMapping.getEndsWithPropertyNameForMatching(propertyName));
    }

    private static boolean propertyDefMatchesValueType(CruxOMRSRepositoryConnector cruxConnector, String repositoryName, String typeDefName, String propertyName, InstancePropertyValue value) {
        if (value == null) {
            return true;
        }
        OMRSRepositoryHelper repositoryHelper = cruxConnector.getRepositoryHelper();
        TypeDef typeDef = repositoryHelper.getTypeDefByName(repositoryName, typeDefName);
        List typeDefProperties = typeDef.getPropertiesDefinition();
        block10: for (TypeDefAttribute typeDefProperty : typeDefProperties) {
            if (!typeDefProperty.getAttributeName().equals(propertyName)) continue;
            AttributeTypeDef atd = typeDefProperty.getAttributeType();
            switch (atd.getCategory()) {
                case PRIMITIVE: {
                    PrimitiveDef pd = (PrimitiveDef)atd;
                    PrimitiveDefCategory pdc = pd.getPrimitiveDefCategory();
                    return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ARRAY) || value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE) && ((PrimitivePropertyValue)value).getPrimitiveDefCategory().equals((Object)pdc);
                }
                case ENUM_DEF: {
                    return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ARRAY) || value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ENUM);
                }
                case COLLECTION: {
                    CollectionDef cd = (CollectionDef)atd;
                    switch (cd.getCollectionDefCategory()) {
                        case OM_COLLECTION_ARRAY: {
                            return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ARRAY);
                        }
                        case OM_COLLECTION_MAP: {
                            return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.MAP);
                        }
                        case OM_COLLECTION_STRUCT: {
                            return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.STRUCT);
                        }
                    }
                    cruxConnector.logProblem(InstancePropertyValueMapping.class.getName(), "propertyDefMatchesValueType", CruxOMRSAuditCode.UNMAPPED_TYPE, null, "CollectionDefCategory::" + cd.getCollectionDefCategory());
                    continue block10;
                }
            }
            cruxConnector.logProblem(InstancePropertyValueMapping.class.getName(), "propertyDefMatchesValueType", CruxOMRSAuditCode.UNMAPPED_TYPE, null, "AttributeTypeDefCategory::" + atd.getCategory());
        }
        return false;
    }
}

