/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.hms.eventmapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.odpi.egeria.connectors.hms.ConnectorColumn;
import org.odpi.egeria.connectors.hms.ConnectorTable;
import org.odpi.egeria.connectors.hms.auditlog.HMSOMRSAuditCode;
import org.odpi.egeria.connectors.hms.auditlog.HMSOMRSErrorCode;
import org.odpi.egeria.connectors.hms.eventmapper.HMSMetaStoreClientFacade;
import org.odpi.egeria.connectors.hms.eventmapper.IMetaStoreClientFacade;
import org.odpi.egeria.connectors.hms.eventmapper.OMRSEventProducer;
import org.odpi.egeria.connectors.hms.helpers.ExceptionHelper;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class HMSOMRSEventProducer
extends OMRSEventProducer {
    public static final String SPARK_SQL_SOURCES_SCHEMA_NUM_PARTS = "spark.sql.sources.schema.numParts";
    public static final String SPARK_SQL_SOURCES_SCHEMA_PART = "spark.sql.sources.schema.part.";
    public static final String SPARK_SQL_SOURCES_SCHEMA = "spark.sql.sources.schema";
    private IMetaStoreClientFacade client = null;
    private final String className = this.getClass().getName();

    public HMSOMRSEventProducer() {
    }

    public HMSOMRSEventProducer(AuditLog auditLog, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryConnector repositoryConnector, OMRSRepositoryEventProcessor repositoryEventProcessor, Map<String, Object> configurationProperties, EndpointProperties endpoint, String userId) throws ConnectorCheckedException {
        super(auditLog, repositoryHelper, repositoryConnector, repositoryEventProcessor, configurationProperties, endpoint, userId);
    }

    public IMetaStoreClientFacade getClient() {
        return this.client;
    }

    public void setClient(IMetaStoreClientFacade client) {
        this.client = client;
    }

    @Override
    protected void connectTo3rdParty() throws RepositoryErrorException, ConnectorCheckedException {
        String configuredDBName;
        String methodName = "connectTo3rdParty";
        Boolean configuredUseSSL = (Boolean)this.configurationProperties.get("useSSL");
        boolean useSSL = false;
        if (configuredUseSSL != null) {
            useSSL = configuredUseSSL;
        }
        String configuredCatName = (String)this.configurationProperties.get("CatalogName");
        String catName = null;
        String dbName = null;
        if (configuredCatName != null) {
            catName = configuredCatName;
        }
        if ((configuredDBName = (String)this.configurationProperties.get("DatabaseName")) != null) {
            dbName = configuredDBName;
        }
        if (useSSL && catName == null && dbName != null) {
            ExceptionHelper.raiseConnectorCheckedException(this.className, HMSOMRSErrorCode.NEED_NAMED_CATALOG_IN_CONFIG, methodName, null, "null");
        }
        String metadata_store_userId = null;
        String configuredMetadataStoreUserId = (String)this.configurationProperties.get("MetadataStoreUserId");
        if (configuredMetadataStoreUserId != null) {
            metadata_store_userId = configuredMetadataStoreUserId;
        }
        String metadata_store_password = null;
        String configuredMetadataStorePassword = (String)this.configurationProperties.get("MetadataStorePassword");
        if (configuredMetadataStorePassword != null) {
            metadata_store_password = configuredMetadataStorePassword;
        }
        if (this.endpoint == null) {
            ExceptionHelper.raiseRepositoryErrorException(this.className, HMSOMRSErrorCode.ENDPOINT_NOT_SUPPLIED_IN_CONFIG, methodName, null, "null");
        } else {
            Configuration conf = new Configuration();
            conf.set("metastore.thrift.uris", this.endpoint.getAddress());
            if (useSSL) {
                conf.set("metastore.use.SSL", "true");
                conf.set("metastore.truststore.path", "file:///" + System.getProperty("java.home") + "/lib/security/cacerts");
                conf.set("metastore.truststore.password", "changeit");
                conf.set("metastore.client.auth.mode", "PLAIN");
                conf.set("metastore.client.plain.username", metadata_store_userId);
                conf.set("metastore.client.plain.password", metadata_store_password);
            }
            conf.set("metastore.execute.setugi", "false");
            try {
                if (this.client == null) {
                    this.client = new HMSMetaStoreClientFacade(conf);
                }
            }
            catch (MetaException e) {
                ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.FAILED_TO_START_CONNECTOR, methodName, null, new String[0]);
            }
            this.metadataCollection = this.repositoryConnector.getMetadataCollection();
            this.metadataCollectionId = this.metadataCollection.getMetadataCollectionId(this.getUserId());
        }
    }

    @Override
    protected List<String> getTableNamesFrom3rdParty(String catName, String dbName) {
        String methodName = "refreshRepository";
        ArrayList<String> tableNames = new ArrayList();
        try {
            tableNames = this.client.getTables(catName, dbName, "*");
        }
        catch (TException e) {
            this.auditLog.logMessage(methodName, HMSOMRSAuditCode.HIVE_GETTABLES_FAILED.getMessageDefinition(e.getMessage()));
        }
        return tableNames;
    }

    @Override
    protected List<String> getAllCatalogNamesFrom3rdParty() throws ConnectorCheckedException {
        String methodName = "getAllCatalogNamesFrom3rdParty";
        ArrayList<String> catNames = new ArrayList();
        try {
            catNames = this.client.getCatalogs();
        }
        catch (TException e) {
            this.auditLog.logMessage(methodName, HMSOMRSAuditCode.HIVE_GETCATALOGS_FAILED.getMessageDefinition(e.getMessage()));
            ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.NO_CATALOGS_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        return catNames;
    }

    @Override
    protected List<String> getDBNamesUnderCatalog(String catalogName) {
        String methodName = "getDBNamesUnderCatalog";
        List<Object> dbNames = new ArrayList();
        try {
            dbNames = catalogName == null ? this.client.getAllDatabases() : this.client.getAllDatabases(catalogName);
        }
        catch (TException e) {
            if (catalogName == null) {
                catalogName = "default";
            }
            this.auditLog.logMessage(methodName, HMSOMRSAuditCode.HIVE_GETDATABASES_FAILED.getMessageDefinition(e.getMessage(), catalogName));
        }
        return dbNames;
    }

    @Override
    protected ConnectorTable getTableFrom3rdParty(String catName, String dbName, String qualifiedName, String tableName) throws ConnectorCheckedException {
        String methodName = "getTableFrom3rdParty";
        ConnectorTable connectorTable = null;
        Table hmsTable = null;
        try {
            hmsTable = this.client.getTable(catName, dbName, tableName);
        }
        catch (TException e) {
            this.auditLog.logMessage(methodName, HMSOMRSAuditCode.HIVE_GETTABLE_FAILED.getMessageDefinition(tableName, e.getMessage()));
        }
        if (hmsTable != null) {
            connectorTable = this.getTableFromHMSTable(qualifiedName, hmsTable);
        }
        return connectorTable;
    }

    private ConnectorTable getTableFromHMSTable(String qualifiedName, Table hmsTable) throws ConnectorCheckedException {
        ConnectorTable connectorTable = new ConnectorTable();
        String tableName = hmsTable.getTableName();
        String tableType = hmsTable.getTableType();
        String tableCanonicalName = qualifiedName + "." + tableName;
        int createTime = hmsTable.getCreateTime();
        connectorTable.setName(tableName);
        connectorTable.setCreateTime(new Date(createTime));
        connectorTable.setQualifiedName(tableCanonicalName);
        connectorTable.setType(tableType);
        if (tableType != null && tableType.equals("EXTERNAL_TABLE")) {
            Map parameters = hmsTable.getParameters();
            String numberOfSchemaPartsString = (String)parameters.get(SPARK_SQL_SOURCES_SCHEMA_NUM_PARTS);
            Object schemaAsJSON = null;
            if (numberOfSchemaPartsString == null) {
                schemaAsJSON = (String)parameters.get(SPARK_SQL_SOURCES_SCHEMA);
            } else {
                Integer numberOfSchemaParts = Integer.valueOf(numberOfSchemaPartsString);
                schemaAsJSON = "";
                for (int i = 0; i < numberOfSchemaParts; ++i) {
                    schemaAsJSON = (String)schemaAsJSON + (String)parameters.get(SPARK_SQL_SOURCES_SCHEMA_PART + i);
                }
            }
            if (schemaAsJSON != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    JsonNode topJsonNode = objectMapper.readTree((String)schemaAsJSON);
                    Iterator iterator = topJsonNode.fieldNames();
                    while (iterator.hasNext()) {
                        JsonNode fieldsJsonNode;
                        String field = (String)iterator.next();
                        if (!field.equals("fields") || !(fieldsJsonNode = topJsonNode.get("fields")).isArray()) continue;
                        ArrayNode fieldsArrayNode = (ArrayNode)fieldsJsonNode;
                        for (int j = 0; j < fieldsArrayNode.size(); ++j) {
                            JsonNode columnJsonNode = fieldsArrayNode.get(j);
                            Iterator columnDetails = columnJsonNode.fields();
                            String columnName = null;
                            String dataType = null;
                            while (columnDetails.hasNext()) {
                                Map.Entry columnDetail = (Map.Entry)columnDetails.next();
                                String columnDetailName = (String)columnDetail.getKey();
                                String columnDetailValue = ((JsonNode)columnDetail.getValue()).asText();
                                if (columnDetailName.equals("name")) {
                                    columnName = columnDetailValue;
                                }
                                if (!columnDetailName.equals("type")) continue;
                                dataType = columnDetailValue;
                            }
                            if (columnName == null || dataType == null) continue;
                            ConnectorColumn column = new ConnectorColumn();
                            column.setName(columnName);
                            column.setQualifiedName(connectorTable.getQualifiedName() + "." + columnName);
                            column.setType(dataType);
                            connectorTable.addColumn(column);
                        }
                    }
                }
                catch (IOException e) {
                    ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.FAILED_TO_GET_COLUMNS_FOR_EXTERNAL_TABLE, tableName, null, new String[0]);
                }
            }
        }
        if (connectorTable.getColumns() == null) {
            Iterator colsIterator = hmsTable.getSd().getColsIterator();
            while (colsIterator.hasNext()) {
                FieldSchema fieldSchema = (FieldSchema)colsIterator.next();
                String columnName = fieldSchema.getName();
                String dataType = fieldSchema.getType();
                ConnectorColumn column = new ConnectorColumn();
                column.setName(columnName);
                column.setQualifiedName(connectorTable.getQualifiedName() + "." + columnName);
                column.setType(dataType);
                connectorTable.addColumn(column);
            }
        }
        return connectorTable;
    }
}

