/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.hms.eventmapper;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.odpi.egeria.connectors.hms.auditlog.HMSOMRSAuditCode;
import org.odpi.egeria.connectors.hms.auditlog.HMSOMRSErrorCode;
import org.odpi.egeria.connectors.hms.eventmapper.HMSOMRSEventProducer;
import org.odpi.egeria.connectors.hms.eventmapper.IMetaStoreClientFacade;
import org.odpi.egeria.connectors.hms.helpers.ExceptionHelper;
import org.odpi.openmetadata.adapters.repositoryservices.caching.repositoryconnector.CachingOMRSRepositoryProxyConnector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapperBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class OMRSDatabasePollingRepositoryEventMapper
extends OMRSRepositoryEventMapperBase {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Map<String, String> typeNameToGuidMap = null;
    private String userId = null;
    private int refreshInterval = 5000;
    protected OMRSMetadataCollection metadataCollection = null;
    private PollingThread pollingThread;
    private HMSOMRSEventProducer omrsEventProducer = null;
    private IMetaStoreClientFacade client = null;
    private boolean testing = false;

    public void setClient(IMetaStoreClientFacade client) {
        this.client = client;
    }

    public synchronized String getUserId() {
        return this.userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        OMRSDatabasePollingRepositoryEventMapper oMRSDatabasePollingRepositoryEventMapper = this;
        synchronized (oMRSDatabasePollingRepositoryEventMapper) {
            Integer configuredRefreshInterval;
            if (this.auditLog != null) {
                this.auditLog.logMessage("start", HMSOMRSAuditCode.EVENT_MAPPER_STARTING.getMessageDefinition());
            }
            if (!(this.repositoryConnector instanceof CachingOMRSRepositoryProxyConnector)) {
                ExceptionHelper.raiseConnectorCheckedException(((Object)((Object)this)).getClass().getName(), HMSOMRSErrorCode.EVENT_MAPPER_IMPROPERLY_INITIALIZED, "start", null, this.repositoryConnector.getServerName());
            }
            this.repositoryHelper = this.repositoryConnector.getRepositoryHelper();
            Map configurationProperties = this.connectionProperties.getConfigurationProperties();
            String userId = this.connectionProperties.getUserId();
            if (userId == null) {
                userId = "OMAGServer";
            }
            this.omrsEventProducer = new HMSOMRSEventProducer(this.auditLog, this.repositoryHelper, this.repositoryConnector, this.repositoryEventProcessor, configurationProperties, this.connectionProperties.getEndpoint(), userId);
            if (configurationProperties != null && (configuredRefreshInterval = (Integer)configurationProperties.get("refreshTimeInterval")) != null) {
                this.refreshInterval = configuredRefreshInterval * 1000 * 60;
            }
            if (this.metadataCollection == null) {
                try {
                    if (this.client != null) {
                        this.omrsEventProducer.setClient(this.client);
                    }
                    this.omrsEventProducer.connectTo3rdParty();
                }
                catch (RepositoryErrorException e) {
                    ExceptionHelper.raiseConnectorCheckedException(((Object)((Object)this)).getClass().getName(), HMSOMRSErrorCode.FAILED_TO_START_CONNECTOR, "start", null, new String[0]);
                }
            }
        }
        this.pollingThread = new PollingThread();
        if (!this.testing) {
            this.pollingThread.start();
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        String methodName = "disconnect";
        this.pollingThread.stop();
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", HMSOMRSAuditCode.EVENT_MAPPER_SHUTDOWN.getMessageDefinition(this.repositoryConnector.getServerName()));
        }
    }

    public void setTesting() {
        this.testing = true;
    }

    public class PollingThread
    implements Runnable {
        void start() {
            Thread worker = new Thread(this);
            worker.start();
        }

        void stop() {
            if (!OMRSDatabasePollingRepositoryEventMapper.this.running.compareAndSet(true, false) && OMRSDatabasePollingRepositoryEventMapper.this.auditLog != null) {
                OMRSDatabasePollingRepositoryEventMapper.this.auditLog.logMessage("stop", HMSOMRSAuditCode.POLLING_THREAD_INFO_ALREADY_STOPPED.getMessageDefinition());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodName = "run";
            if (OMRSDatabasePollingRepositoryEventMapper.this.running.compareAndSet(false, true)) {
                while (OMRSDatabasePollingRepositoryEventMapper.this.running.get()) {
                    try {
                        PollingThread pollingThread = this;
                        synchronized (pollingThread) {
                            if (!OMRSDatabasePollingRepositoryEventMapper.this.omrsEventProducer.execute()) {
                                OMRSDatabasePollingRepositoryEventMapper.this.disconnect();
                            }
                        }
                        if (!OMRSDatabasePollingRepositoryEventMapper.this.running.get()) continue;
                        if (OMRSDatabasePollingRepositoryEventMapper.this.auditLog != null) {
                            OMRSDatabasePollingRepositoryEventMapper.this.auditLog.logMessage("run", HMSOMRSAuditCode.EVENT_MAPPER_POLL_LOOP_PRE_WAIT.getMessageDefinition());
                        }
                        try {
                            Thread.sleep(OMRSDatabasePollingRepositoryEventMapper.this.refreshInterval);
                            if (OMRSDatabasePollingRepositoryEventMapper.this.auditLog == null) continue;
                            OMRSDatabasePollingRepositoryEventMapper.this.auditLog.logMessage("run", HMSOMRSAuditCode.EVENT_MAPPER_POLL_LOOP_POST_WAIT.getMessageDefinition());
                        }
                        catch (InterruptedException e) {
                            if (OMRSDatabasePollingRepositoryEventMapper.this.auditLog == null) continue;
                            OMRSDatabasePollingRepositoryEventMapper.this.auditLog.logMessage("run", HMSOMRSAuditCode.EVENT_MAPPER_POLL_LOOP_INTERRUPTED_EXCEPTION.getMessageDefinition());
                        }
                    }
                    catch (Exception e) {
                        Throwable cause = e.getCause();
                        String msg = "No Exception message";
                        if (e.getMessage() != null) {
                            msg = e.getMessage();
                        }
                        String causeMsg = "No cause message";
                        if (cause != null && cause.getMessage() != null) {
                            causeMsg = cause.getMessage();
                        }
                        if (OMRSDatabasePollingRepositoryEventMapper.this.auditLog == null) continue;
                        OMRSDatabasePollingRepositoryEventMapper.this.auditLog.logMessage("run", HMSOMRSAuditCode.EVENT_MAPPER_POLL_LOOP_GOT_AN_EXCEPTION_WITH_CAUSE.getMessageDefinition(msg, causeMsg));
                    }
                    finally {
                        this.stop();
                    }
                }
            }
        }
    }
}

