/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.hms.eventmapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.odpi.egeria.connectors.hms.ConnectorColumn;
import org.odpi.egeria.connectors.hms.ConnectorTable;
import org.odpi.egeria.connectors.hms.auditlog.HMSOMRSAuditCode;
import org.odpi.egeria.connectors.hms.auditlog.HMSOMRSErrorCode;
import org.odpi.egeria.connectors.hms.helpers.ExceptionHelper;
import org.odpi.egeria.connectors.hms.helpers.MapperHelper;
import org.odpi.egeria.connectors.hms.helpers.SupportedTypes;
import org.odpi.openmetadata.adapters.repositoryservices.caching.repository.CachedRepositoryAccessor;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public abstract class OMRSEventProducer {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Map<String, String> typeNameToGuidMap = null;
    private String userId = null;
    private String qualifiedNamePrefix = "";
    protected String metadataCollectionId = null;
    protected String metadataCollectionName = null;
    protected OMRSMetadataCollection metadataCollection = null;
    private String repositoryName = null;
    private String catName = null;
    private String dbName = null;
    private boolean sendPollEvents = false;
    private boolean includeDeployedSchema = false;
    private boolean cacheIntoCachingRepository = true;
    private String configuredEndpointAddress = null;
    private String databaseGUID;
    Thread worker = null;
    List<Relationship> aboveTableRelationshipList = new ArrayList<Relationship>();
    List<EntityDetail> aboveTableEntityList = new ArrayList<EntityDetail>();
    Map<String, List<EntityDetail>> qualifiedTableNameToEntityMap = new HashMap<String, List<EntityDetail>>();
    Map<String, List<Relationship>> qualifiedTableNameToRelationshipMap = new HashMap<String, List<Relationship>>();
    CachedRepositoryAccessor cachedRepositoryAccessor = null;
    String relationalDBTypeGuid = null;
    MapperHelper mapperHelper = null;
    AuditLog auditLog;
    OMRSRepositoryHelper repositoryHelper;
    OMRSRepositoryConnector repositoryConnector;
    OMRSRepositoryEventProcessor repositoryEventProcessor;
    Map<String, Object> configurationProperties;
    EndpointProperties endpoint;
    Map<String, String> connectionSecuredProperties = null;

    public OMRSEventProducer() {
    }

    public OMRSEventProducer(AuditLog auditLog, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryConnector repositoryConnector, OMRSRepositoryEventProcessor repositoryEventProcessor, Map<String, Object> configurationProperties, EndpointProperties endpoint, String userId) throws ConnectorCheckedException {
        this.auditLog = auditLog;
        this.repositoryHelper = repositoryHelper;
        this.repositoryConnector = repositoryConnector;
        this.repositoryEventProcessor = repositoryEventProcessor;
        this.configurationProperties = configurationProperties;
        this.endpoint = endpoint;
        this.repositoryName = this.repositoryConnector.getRepositoryName();
        this.extractConfigurationProperties(configurationProperties);
        this.userId = userId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getCatName() {
        return this.catName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean isSendPollEvents() {
        return this.sendPollEvents;
    }

    public EndpointProperties getEndpoint() {
        return this.endpoint;
    }

    public Map<String, String> getConnectionSecuredProperties() {
        return this.connectionSecuredProperties;
    }

    protected void extractConfigurationProperties(Map<String, Object> configurationProperties) throws ConnectorCheckedException {
        Boolean configuredIncludeDeployedschema;
        Boolean configuredCache;
        Boolean configuredSendPollEvents;
        String configuredDBName;
        String configuredCatName;
        String methodName = "extractConfigurationProperties";
        if (configurationProperties == null) {
            return;
        }
        String configuredQualifiedNamePrefix = (String)configurationProperties.get("qualifiedNamePrefix");
        if (configuredQualifiedNamePrefix != null) {
            this.qualifiedNamePrefix = configuredQualifiedNamePrefix;
        }
        if ((configuredCatName = (String)configurationProperties.get("CatalogName")) != null) {
            this.catName = configuredCatName;
        }
        if ((configuredDBName = (String)configurationProperties.get("DatabaseName")) != null) {
            this.dbName = configuredDBName;
        }
        if ((configuredSendPollEvents = (Boolean)configurationProperties.get("sendPollEvents")) != null) {
            this.sendPollEvents = configuredSendPollEvents;
        }
        if ((configuredCache = (Boolean)configurationProperties.get("cacheIntoCachingRepository")) != null) {
            this.cacheIntoCachingRepository = configuredCache;
        }
        if ((configuredIncludeDeployedschema = (Boolean)configurationProperties.get("includeDeployedSchema")) != null) {
            this.includeDeployedSchema = configuredIncludeDeployedschema;
        }
        this.configuredEndpointAddress = (String)configurationProperties.get("endpointAddress");
        Map configuredConnectionSecureProperties = null;
        try {
            configuredConnectionSecureProperties = (Map)configurationProperties.get("connectionSecuredProperties");
        }
        catch (ClassCastException classCastException) {
            ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.CONFIG_ERROR_CONNECTION_SECURED_PROPERTIES, methodName, null, new String[0]);
        }
        if (configuredConnectionSecureProperties != null) {
            Set entrySet = configuredConnectionSecureProperties.entrySet();
            this.connectionSecuredProperties = new HashMap<String, String>();
            for (Map.Entry entry : entrySet) {
                this.connectionSecuredProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public synchronized String getUserId() {
        return this.userId;
    }

    protected abstract void connectTo3rdParty() throws RepositoryErrorException, ConnectorCheckedException;

    protected abstract List<String> getTableNamesFrom3rdParty(String var1, String var2);

    protected abstract List<String> getAllCatalogNamesFrom3rdParty() throws ConnectorCheckedException;

    protected abstract List<String> getDBNamesUnderCatalog(String var1);

    protected abstract ConnectorTable getTableFrom3rdParty(String var1, String var2, String var3, String var4) throws ConnectorCheckedException;

    public boolean execute() {
        String methodName = "execute";
        boolean status = false;
        this.mapperHelper = new MapperHelper(this.repositoryHelper, this.userId, this.metadataCollectionId, this.repositoryName, this.metadataCollectionName, this.qualifiedNamePrefix);
        try {
            this.getRequiredTypes();
            this.connectTo3rdParty();
            if (this.dbName != null) {
                this.processDataBase(methodName, this.dbName);
            } else if (this.catName == null) {
                List<String> catNames = this.getAllCatalogNamesFrom3rdParty();
                if (catNames != null) {
                    for (String currentCatName : catNames) {
                        this.processCatalogDatabases(methodName, currentCatName);
                    }
                }
            } else {
                this.processCatalogDatabases(methodName, this.catName);
            }
            status = true;
        }
        catch (ConnectorCheckedException e) {
            Throwable cause;
            String msg = "No Exception message";
            if (e.getMessage() != null) {
                msg = e.getMessage();
            }
            if ((cause = e.getCause()) == null) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage(methodName, HMSOMRSAuditCode.EVENT_MAPPER_POLL_LOOP_GOT_AN_EXCEPTION.getMessageDefinition(msg));
                }
            } else {
                String causeMsg = "No cause message";
                if (cause.getMessage() != null) {
                    causeMsg = cause.getMessage();
                }
                if (this.auditLog != null) {
                    this.auditLog.logMessage(methodName, HMSOMRSAuditCode.EVENT_MAPPER_POLL_LOOP_GOT_AN_EXCEPTION_WITH_CAUSE.getMessageDefinition(msg, causeMsg));
                }
            }
        }
        catch (TypeErrorException typeErrorException) {
        }
        catch (RepositoryErrorException repositoryErrorException) {
            // empty catch block
        }
        return status;
    }

    private void processCatalogDatabases(String methodName, String catNameToProcess) throws ConnectorCheckedException, TypeErrorException {
        List<String> dbNames = this.getDBNamesUnderCatalog(catNameToProcess);
        for (String currentDBName : dbNames) {
            this.processDataBase(methodName, currentDBName);
        }
    }

    private void processDataBase(String methodName, String currentDBName) throws ConnectorCheckedException, TypeErrorException {
        List<String> tableNames;
        this.cachedRepositoryAccessor = new CachedRepositoryAccessor(this.userId, this.repositoryConnector.getServerName(), this.metadataCollection);
        this.aboveTableEntityList = new ArrayList<EntityDetail>();
        this.aboveTableRelationshipList = new ArrayList<Relationship>();
        this.qualifiedTableNameToEntityMap = new HashMap<String, List<EntityDetail>>();
        this.qualifiedTableNameToRelationshipMap = new HashMap<String, List<Relationship>>();
        Object qualifiedName = null;
        qualifiedName = this.catName == null ? currentDBName : this.catName + "." + currentDBName;
        qualifiedName = this.collectEntitiesAndRelationshipsAboveTable(currentDBName, (String)qualifiedName);
        if (this.cacheIntoCachingRepository) {
            this.refreshRepository(this.aboveTableEntityList, this.aboveTableRelationshipList);
        }
        if (this.sendPollEvents) {
            this.issueBatchEvent(this.aboveTableEntityList, this.aboveTableRelationshipList);
        }
        if ((tableNames = this.getTableNamesFrom3rdParty(this.catName, currentDBName)) != null && !tableNames.isEmpty()) {
            for (String tableName : tableNames) {
                ConnectorTable connectorTable = this.getTableFrom3rdParty(this.catName, currentDBName, (String)qualifiedName, tableName);
                this.qualifiedTableNameToEntityMap = new HashMap<String, List<EntityDetail>>();
                this.qualifiedTableNameToRelationshipMap = new HashMap<String, List<Relationship>>();
                this.convertToConnectorTableToEntitiesAndRelationships(methodName, connectorTable);
                String tableQualifiedName = connectorTable.getQualifiedName();
                List<EntityDetail> entityList = this.qualifiedTableNameToEntityMap.get(tableQualifiedName);
                List<Relationship> relationshipList = this.qualifiedTableNameToRelationshipMap.get(tableQualifiedName);
                if (this.cacheIntoCachingRepository) {
                    this.refreshRepository(entityList, relationshipList);
                }
                if (!this.sendPollEvents) continue;
                this.issueBatchEvent(entityList, relationshipList);
            }
        }
    }

    private String collectEntitiesAndRelationshipsAboveTable(String currentDBName, String qualifiedName) throws ConnectorCheckedException {
        String methodName = "collectEntitiesAndRelationshipsAboveTable";
        EntityDetail databaseEntity = this.mapperHelper.getEntityDetailSkeleton(methodName, "Database", currentDBName, (String)qualifiedName, null, false);
        this.databaseGUID = databaseEntity.getGUID();
        this.saveEntityReferenceCopy(databaseEntity);
        this.createConnectionOrientatedEntities((String)qualifiedName, databaseEntity);
        String deployedDatabaseSchemaEntityGuid = null;
        if (this.includeDeployedSchema) {
            qualifiedName = (String)qualifiedName + ".deployed-schema";
            EntityDetail deployedDatabaseSchemaEntity = this.mapperHelper.getEntityDetailSkeleton(methodName, "DeployedDatabaseSchema", "deployed-schema", (String)qualifiedName + ".deployed-schema", null, false);
            this.saveEntityReferenceCopy(deployedDatabaseSchemaEntity);
            deployedDatabaseSchemaEntityGuid = deployedDatabaseSchemaEntity.getGUID();
        }
        qualifiedName = (String)qualifiedName + ".relational-DB-Schema-Type";
        EntityDetail relationalDBTypeEntity = this.mapperHelper.getEntityDetailSkeleton(methodName, "RelationalDBSchemaType", "relational-DB-Schema-Type", (String)qualifiedName, null, false);
        this.saveEntityReferenceCopy(relationalDBTypeEntity);
        this.relationalDBTypeGuid = relationalDBTypeEntity.getGUID();
        if (this.includeDeployedSchema) {
            this.aboveTableRelationshipList.add(this.mapperHelper.createReferenceRelationship("DataContentForDataSet", this.databaseGUID, "Database", deployedDatabaseSchemaEntityGuid, "DeployedDatabaseSchema"));
            this.aboveTableRelationshipList.add(this.mapperHelper.createReferenceRelationship("AssetSchemaType", deployedDatabaseSchemaEntityGuid, "DeployedDatabaseSchema", relationalDBTypeEntity.getGUID(), "RelationalDBSchemaType"));
        } else {
            this.aboveTableRelationshipList.add(this.mapperHelper.createReferenceRelationship("AssetSchemaType", this.databaseGUID, "Database", this.relationalDBTypeGuid, "RelationalDBSchemaType"));
        }
        return qualifiedName;
    }

    private void refreshRepository(List<EntityDetail> entities, List<Relationship> relationships) throws ConnectorCheckedException {
        for (EntityDetail entity : entities) {
            this.cachedRepositoryAccessor.saveEntityReferenceCopyToStore(entity);
        }
        for (Relationship relationship : relationships) {
            this.cachedRepositoryAccessor.saveRelationshipReferenceCopyToStore(relationship);
        }
    }

    private void getRequiredTypes() throws ConnectorCheckedException {
        String methodName = "getRequiredTypes";
        int supportedCount = SupportedTypes.supportedTypeNames.size();
        int typesAvailableCount = 0;
        int retryCount = 0;
        while (typesAvailableCount != supportedCount) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, HMSOMRSAuditCode.EVENT_MAPPER_ACQUIRING_TYPES_LOOP.getMessageDefinition("" + typesAvailableCount, "" + supportedCount, "" + retryCount));
            }
            typesAvailableCount = 0;
            if (this.typeNameToGuidMap == null) {
                this.typeNameToGuidMap = new HashMap<String, String>();
            }
            for (String typeName : SupportedTypes.supportedTypeNames) {
                TypeDef typeDef = this.repositoryHelper.getTypeDefByName("HMSOMRSRepositoryEventMapper", typeName);
                if (typeDef == null) continue;
                if (this.auditLog != null) {
                    this.auditLog.logMessage(methodName, HMSOMRSAuditCode.EVENT_MAPPER_ACQUIRING_TYPES_LOOP_FOUND_TYPE.getMessageDefinition(typeName));
                }
                this.typeNameToGuidMap.put(typeName, typeDef.getGUID());
                ++typesAvailableCount;
            }
            if (typesAvailableCount < supportedCount) {
                try {
                    Thread.sleep(1000L);
                    ++retryCount;
                }
                catch (InterruptedException e) {
                    ++retryCount;
                    if (this.auditLog != null) {
                        this.auditLog.logMessage(methodName, HMSOMRSAuditCode.EVENT_MAPPER_ACQUIRING_TYPES_LOOP_INTERRUPTED_EXCEPTION.getMessageDefinition());
                    }
                }
            } else if (typesAvailableCount == supportedCount && this.auditLog != null) {
                this.auditLog.logMessage(methodName, HMSOMRSAuditCode.EVENT_MAPPER_ACQUIRED_ALL_TYPES.getMessageDefinition());
            }
            if (retryCount != 20) continue;
            ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.EVENT_MAPPER_CANNOT_GET_TYPES, methodName, null, new String[0]);
        }
    }

    private synchronized void convertToConnectorTableToEntitiesAndRelationships(String methodName, ConnectorTable connectorTable) throws ConnectorCheckedException, TypeErrorException {
        String tableQualifiedName = connectorTable.getQualifiedName();
        EntityDetail tableEntity = this.mapperHelper.getEntityDetailSkeleton(methodName, "RelationalTable", connectorTable.getName(), tableQualifiedName, null, true);
        tableEntity.setCreateTime(connectorTable.getCreateTime());
        ArrayList<Classification> tableClassifications = tableEntity.getClassifications();
        if (tableClassifications == null) {
            tableClassifications = new ArrayList<Classification>();
        }
        Classification classification = this.mapperHelper.createTypeEmbeddedClassificationForTable(methodName, tableEntity);
        tableClassifications.add(classification);
        String tableType = connectorTable.getType();
        if (tableType != null && tableType.equals("VIRTUAL_VIEW")) {
            tableClassifications.add(this.mapperHelper.createCalculatedValueClassification("refreshRepository", tableEntity, connectorTable.getHmsViewOriginalText()));
        }
        if (!tableClassifications.isEmpty()) {
            tableEntity.setClassifications(tableClassifications);
        }
        this.saveEntityReferenceCopyForTable(tableEntity, tableQualifiedName);
        String tableGuid = tableEntity.getGUID();
        Relationship relationship = this.mapperHelper.createReferenceRelationship("AttributeForSchema", this.relationalDBTypeGuid, "RelationalDBSchemaType", tableGuid, "RelationalTable");
        this.saveRelationshipReferenceCopyForTable(relationship, tableQualifiedName);
        ListIterator<ConnectorColumn> colsIterator = connectorTable.getColumns().listIterator();
        while (colsIterator.hasNext()) {
            ConnectorColumn connectorColumn = (ConnectorColumn)colsIterator.next();
            String columnName = connectorColumn.getName();
            EntityDetail columnEntity = this.mapperHelper.getEntityDetailSkeleton(methodName, "RelationalColumn", columnName, connectorTable.getQualifiedName() + "." + columnName, null, true);
            String dataType = connectorColumn.getType();
            ArrayList<Classification> columnClassifications = columnEntity.getClassifications();
            if (columnClassifications == null) {
                columnClassifications = new ArrayList<Classification>();
            }
            columnClassifications.add(this.mapperHelper.createTypeEmbeddedClassificationForColumn("refreshRepository", columnEntity, dataType));
            columnEntity.setClassifications(columnClassifications);
            this.saveEntityReferenceCopyForTable(columnEntity, tableQualifiedName);
            relationship = this.mapperHelper.createReferenceRelationship("NestedSchemaAttribute", tableGuid, "RelationalTable", columnEntity.getGUID(), "RelationalColumn");
            this.saveRelationshipReferenceCopyForTable(relationship, tableQualifiedName);
        }
    }

    private void createConnectionOrientatedEntities(String baseCanonicalName, EntityDetail databaseEntity) throws ConnectorCheckedException {
        String methodName = "createConnectionOrientatedEntities";
        String canonicalName = baseCanonicalName + ".connection";
        EntityDetail connectionEntity = this.mapperHelper.getEntityDetailSkeleton(methodName, "Connection", "connection", canonicalName, null, false);
        InstanceProperties resultingProperties = connectionEntity.getProperties();
        if (this.connectionSecuredProperties != null) {
            InstanceProperties mapInstanceProperties = this.repositoryHelper.addStringPropertyMapToInstance("sourceName", null, "securedProperties", this.connectionSecuredProperties, methodName);
            if (mapInstanceProperties != null) {
                MapPropertyValue mapPropertyValue = new MapPropertyValue();
                mapPropertyValue.setMapValues(mapInstanceProperties);
                resultingProperties.setProperty("securedProperties", (InstancePropertyValue)mapPropertyValue);
            }
            connectionEntity.setProperties(resultingProperties);
        }
        this.saveEntityReferenceCopy(connectionEntity);
        canonicalName = baseCanonicalName + ".connectorType";
        EntityDetail connectionTypeEntity = this.mapperHelper.getEntityDetailSkeleton(methodName, "ConnectorType", "connectorType", canonicalName, null, false);
        this.saveEntityReferenceCopy(connectionTypeEntity);
        canonicalName = baseCanonicalName + ".Endpoint";
        EntityDetail endpointEntity = this.mapperHelper.getEntityDetailSkeleton(methodName, "Endpoint", "Endpoint", canonicalName, null, false);
        InstanceProperties epInstanceProperties = endpointEntity.getProperties();
        if (this.configuredEndpointAddress != null) {
            this.repositoryHelper.addStringPropertyToInstance(methodName, epInstanceProperties, "networkAddress", this.configuredEndpointAddress, methodName);
            endpointEntity.setProperties(epInstanceProperties);
        }
        this.saveEntityReferenceCopy(endpointEntity);
        String connectionGuid = connectionEntity.getGUID();
        String databaseGuid = databaseEntity.getGUID();
        String connectionTypeGuid = connectionTypeEntity.getGUID();
        String endPointGuid = endpointEntity.getGUID();
        this.aboveTableRelationshipList.add(this.mapperHelper.createReferenceRelationship("ConnectionToAsset", connectionGuid, "Connection", databaseGuid, "Database"));
        this.aboveTableRelationshipList.add(this.mapperHelper.createReferenceRelationship("ConnectionConnectorType", connectionGuid, "Connection", connectionTypeGuid, "ConnectorType"));
        this.aboveTableRelationshipList.add(this.mapperHelper.createReferenceRelationship("ConnectionEndpoint", connectionGuid, "Connection", endPointGuid, "Endpoint"));
    }

    private void saveEntityReferenceCopy(EntityDetail entityToAdd) {
        this.aboveTableEntityList.add(entityToAdd);
    }

    private void saveEntityReferenceCopyForTable(EntityDetail entityToAdd, String qualifiedTableName) {
        List<EntityDetail> entities = this.qualifiedTableNameToEntityMap.get(qualifiedTableName);
        if (entities == null) {
            entities = new ArrayList<EntityDetail>();
            entities.add(entityToAdd);
            this.qualifiedTableNameToEntityMap.put(qualifiedTableName, entities);
        } else {
            entities.add(entityToAdd);
        }
    }

    private void saveRelationshipReferenceCopyForTable(Relationship relationshipToAdd, String qualifiedTableName) {
        List<Relationship> relationships = this.qualifiedTableNameToRelationshipMap.get(qualifiedTableName);
        if (relationships == null) {
            relationships = new ArrayList<Relationship>();
            relationships.add(relationshipToAdd);
            this.qualifiedTableNameToRelationshipMap.put(qualifiedTableName, relationships);
        } else {
            relationships.add(relationshipToAdd);
        }
    }

    private void issueBatchEvent(List<EntityDetail> entityList, List<Relationship> relationshipList) {
        InstanceGraph instances = new InstanceGraph(entityList, relationshipList);
        this.repositoryEventProcessor.processInstanceBatchEvent("OMRSDatabasePollingRepositoryEventMapper", this.repositoryConnector.getMetadataCollectionId(), this.repositoryConnector.getServerName(), this.repositoryConnector.getServerType(), this.repositoryConnector.getOrganizationName(), instances);
    }
}

