/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.hms.helpers;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.hms.auditlog.HMSOMRSErrorCode;
import org.odpi.egeria.connectors.hms.helpers.ExceptionHelper;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class MapperHelper {
    private OMRSRepositoryHelper repositoryHelper = null;
    private String userId = null;
    private String metadataCollectionId = null;
    private String repositoryName = null;
    private String metadataCollectionName = null;
    private String qualifiedNamePrefix = null;

    public MapperHelper(OMRSRepositoryHelper repositoryHelper, String userId, String metadataCollectionId, String repositoryName, String metadataCollectionName, String qualifiedNamePrefix) {
        this.repositoryHelper = repositoryHelper;
        this.userId = userId;
        this.metadataCollectionId = metadataCollectionId;
        this.repositoryName = repositoryName;
        this.metadataCollectionName = metadataCollectionName;
        this.qualifiedNamePrefix = qualifiedNamePrefix;
    }

    public Relationship createReferenceRelationship(String relationshipTypeName, String end1GUID, String end1TypeName, String end2GUID, String end2TypeName) throws ConnectorCheckedException {
        String methodName = "createReferenceRelationship";
        Relationship relationship = null;
        try {
            relationship = this.repositoryHelper.getSkeletonRelationship(methodName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, this.userId, relationshipTypeName);
            relationship.setMetadataCollectionName(this.metadataCollectionName);
        }
        catch (TypeErrorException e) {
            ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.TYPE_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        String connectionToAssetCanonicalName = end1GUID + "." + relationshipTypeName + "." + end2GUID;
        String relationshipGUID = null;
        try {
            relationshipGUID = Base64.getUrlEncoder().encodeToString(connectionToAssetCanonicalName.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.ENCODING_EXCEPTION, methodName, e, "connectionToAssetCanonicalName", connectionToAssetCanonicalName);
        }
        relationship.setGUID(relationshipGUID);
        EntityProxy entityProxy1 = this.getEntityProxySkeleton(end1GUID, end1TypeName);
        relationship.setEntityOneProxy(entityProxy1);
        EntityProxy entityProxy2 = this.getEntityProxySkeleton(end2GUID, end2TypeName);
        relationship.setEntityTwoProxy(entityProxy2);
        return relationship;
    }

    private EntityProxy getEntityProxySkeleton(String guid, String typeName) throws ConnectorCheckedException {
        String methodName = "getEntityProxySkeleton";
        EntityProxy proxy = new EntityProxy();
        TypeDef typeDefSummary = this.repositoryHelper.getTypeDefByName("getEntityProxySkeleton", typeName);
        InstanceType type = null;
        try {
            if (typeDefSummary == null) {
                throw new TypeErrorException(HMSOMRSErrorCode.TYPEDEF_NAME_NOT_KNOWN.getMessageDefinition(this.repositoryName, methodName, typeName), this.getClass().getName(), methodName);
            }
            type = this.repositoryHelper.getNewInstanceType(methodName, (TypeDefSummary)typeDefSummary);
        }
        catch (TypeErrorException e) {
            ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.TYPE_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        proxy.setType(type);
        proxy.setGUID(guid);
        proxy.setMetadataCollectionId(this.metadataCollectionId);
        proxy.setMetadataCollectionName(this.metadataCollectionName);
        return proxy;
    }

    public EntityDetail getEntityDetailSkeleton(String originalMethodName, String typeName, String name, String qualifiedNameSuffix, Map<String, String> attributeMap, boolean generateUniqueVersion) throws ConnectorCheckedException {
        String methodName = "getEntityDetail";
        String qualifiedName = this.qualifiedNamePrefix + qualifiedNameSuffix;
        String guid = null;
        try {
            guid = Base64.getUrlEncoder().encodeToString(qualifiedName.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.ENCODING_EXCEPTION, methodName, e, "canonicalName", qualifiedName);
        }
        InstanceProperties initialProperties = this.repositoryHelper.addStringPropertyToInstance(methodName, null, "name", name, methodName);
        initialProperties = this.repositoryHelper.addStringPropertyToInstance(methodName, initialProperties, "qualifiedName", qualifiedName, methodName);
        if (attributeMap != null && !attributeMap.keySet().isEmpty()) {
            this.addPropertiesToInstanceProperties(initialProperties, attributeMap);
        }
        EntityDetail entityToAdd = new EntityDetail();
        entityToAdd.setProperties(initialProperties);
        entityToAdd.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
        entityToAdd.setMetadataCollectionId(this.metadataCollectionId);
        entityToAdd.setMetadataCollectionName(this.metadataCollectionName);
        TypeDef typeDef = this.repositoryHelper.getTypeDefByName(methodName, typeName);
        try {
            if (typeDef == null) {
                throw new TypeErrorException(HMSOMRSErrorCode.TYPEDEF_NAME_NOT_KNOWN.getMessageDefinition(this.metadataCollectionName, methodName, typeName), this.getClass().getName(), originalMethodName);
            }
            InstanceType instanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, (TypeDefSummary)typeDef);
            entityToAdd.setType(instanceType);
        }
        catch (TypeErrorException e) {
            ExceptionHelper.raiseConnectorCheckedException(this.getClass().getName(), HMSOMRSErrorCode.TYPE_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        entityToAdd.setGUID(guid);
        entityToAdd.setStatus(InstanceStatus.ACTIVE);
        long version = 1L;
        if (generateUniqueVersion) {
            version = System.currentTimeMillis();
        }
        entityToAdd.setVersion(version);
        return entityToAdd;
    }

    void addPropertiesToInstanceProperties(InstanceProperties properties, Map<String, String> attributeMap) {
        String methodName = "addPropertiesToInstanceProperties";
        if (attributeMap != null) {
            Set<Map.Entry<String, String>> entrySet = attributeMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                this.repositoryHelper.addStringPropertyToInstance(methodName, properties, entry.getKey(), entry.getValue(), methodName);
            }
        }
    }

    public Classification createCalculatedValueClassification(String apiName, EntityDetail entity, String formula) throws TypeErrorException {
        String methodName = "createCalculatedValueClassification";
        Classification classification = this.repositoryHelper.getSkeletonClassification(methodName, this.userId, "CalculatedValue", entity.getType().getTypeDefName());
        InstanceProperties initialProperties = this.repositoryHelper.addStringPropertyToInstance(methodName, null, "formula", formula, methodName);
        classification.setProperties(initialProperties);
        this.repositoryHelper.addClassificationToEntity(apiName, entity, classification, methodName);
        return classification;
    }

    public Classification createTypeEmbeddedClassificationForColumn(String apiName, EntityDetail entity, String dataType) throws TypeErrorException {
        return this.createTypeEmbeddedClassification(apiName, "RelationalColumnType", entity, dataType);
    }

    public Classification createTypeEmbeddedClassificationForTable(String apiName, EntityDetail entity) throws TypeErrorException {
        return this.createTypeEmbeddedClassification(apiName, "RelationalTableType", entity, null);
    }

    private Classification createTypeEmbeddedClassification(String apiName, String type, EntityDetail entity, String dataType) throws TypeErrorException {
        String methodName = "createTypeEmbeddedClassification";
        Classification classification = this.repositoryHelper.getSkeletonClassification(methodName, this.userId, "TypeEmbeddedAttribute", entity.getType().getTypeDefName());
        InstanceProperties instanceProperties = new InstanceProperties();
        this.repositoryHelper.addStringPropertyToInstance(apiName, instanceProperties, "schemaTypeName", type, methodName);
        if (dataType != null) {
            this.repositoryHelper.addStringPropertyToInstance(apiName, instanceProperties, "dataType", dataType, methodName);
        }
        classification.setProperties(instanceProperties);
        this.repositoryHelper.addClassificationToEntity(apiName, entity, classification, methodName);
        return classification;
    }
}

