/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.eventmapper.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.OMRSStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSet {
    private static final Logger log = LoggerFactory.getLogger(ChangeSet.class);
    private ObjectMapper objectMapper;
    private IGCRestClient igcRestClient;
    private JsonNode patch;
    private HashMap<String, List<Change>> changesByProperty;

    public ChangeSet(IGCRestClient igcRestClient, Reference asset, OMRSStub stub) {
        block19: {
            this.objectMapper = new ObjectMapper();
            this.changesByProperty = new HashMap();
            this.igcRestClient = igcRestClient;
            boolean bNoStub = false;
            if (stub == null) {
                stub = new OMRSStub();
                stub.setPayload("{}");
                bNoStub = true;
            }
            try {
                JsonNode stubPayload = this.objectMapper.readTree(stub.getPayload());
                if (bNoStub) {
                    if (log.isDebugEnabled()) {
                        log.debug("No existing stub -- calculating differences.");
                    }
                    this.calculateDelta(asset, stubPayload);
                } else {
                    Long stubModified = stubPayload.path("modified_on").asLong(0L);
                    if (stubModified == 0L) {
                        if (log.isDebugEnabled()) {
                            log.debug("No timestamp inside stub -- calculating differences.");
                        }
                        this.calculateDelta(asset, stubPayload);
                    } else {
                        Date assetModified = (Date)this.igcRestClient.getPropertyByName(asset, "modified_on");
                        if (assetModified == null) {
                            if (log.isDebugEnabled()) {
                                log.debug("No timestamp inside asset -- calculating differences.");
                            }
                            this.calculateDelta(asset, stubPayload);
                        } else if (!stubModified.equals(assetModified.getTime())) {
                            if (log.isDebugEnabled()) {
                                log.debug("Modification timestamp of stub ({}) does not match asset ({}) -- calculating differences.", (Object)stubModified, (Object)assetModified.getTime());
                            }
                            this.calculateDelta(asset, stubPayload);
                        } else if (this.igcRestClient.getPagedRelationshipPropertiesForType(asset.getType()).contains("detected_classifications")) {
                            if (log.isDebugEnabled()) {
                                log.debug("Modification timestamps matched, but may be classifications -- calculating differences.");
                            }
                            this.calculateDelta(asset, stubPayload);
                        } else if (log.isDebugEnabled()) {
                            log.debug("Modification timestamps between stub and asset matched -- skipping change calculation.");
                        }
                    }
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block19;
                log.error("Unable to parse JSON for diff operation: {}, {}", new Object[]{asset, stub, e});
            }
        }
    }

    private void calculateDelta(Reference asset, JsonNode stubPayload) throws IOException {
        Object flags = DiffFlags.dontNormalizeOpIntoMoveAndCopy().clone();
        JsonNode currentAsset = this.objectMapper.readTree(this.igcRestClient.getValueAsJSON(asset));
        this.patch = JsonDiff.asJson((JsonNode)stubPayload, (JsonNode)currentAsset, (EnumSet)flags);
        if (log.isDebugEnabled()) {
            log.debug("Found the following changes: {}", (Object)this.patch.toString());
        }
        ArrayNode changes = (ArrayNode)this.patch;
        for (int i = 0; i < changes.size(); ++i) {
            JsonNode consolidatedChange;
            JsonNode change = changes.get(i);
            String changePath = change.path("path").asText();
            Change theChange = null;
            if (changePath.contains("/items/")) {
                if (change.path("value").getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                    theChange = new Change(change, stubPayload);
                } else if (changePath.endsWith("_id")) {
                    consolidatedChange = this.consolidateChangedObject(change, changePath, currentAsset);
                    theChange = new Change(consolidatedChange, stubPayload);
                }
            } else if (!changePath.contains("/paging/")) {
                if (changePath.endsWith("/_id") && !changePath.equals("/_id")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Found an exclusive relationship change: {}", (Object)change.toString());
                    }
                    consolidatedChange = this.consolidateChangedObject(change, changePath, currentAsset);
                    if (log.isDebugEnabled()) {
                        log.debug(" ... consolidated to: {}", (Object)consolidatedChange.toString());
                    }
                    theChange = new Change(consolidatedChange, stubPayload);
                } else {
                    theChange = new Change(change, stubPayload);
                }
            }
            if (theChange == null) continue;
            String igcProperty = theChange.getIgcPropertyName();
            if (!this.changesByProperty.containsKey(igcProperty)) {
                this.changesByProperty.put(igcProperty, new ArrayList());
            }
            this.changesByProperty.get(igcProperty).add(theChange);
        }
    }

    public Set<String> getChangedProperties() {
        return this.changesByProperty.keySet();
    }

    public List<Change> getChangesForProperty(String property) {
        return this.changesByProperty.get(property);
    }

    private JsonNode getObjectFromIndex(String objectPath, JsonNode asset) {
        if (log.isDebugEnabled()) {
            log.debug(" ... retrieving object from index at path: {}", (Object)objectPath);
        }
        if (objectPath.contains("/items")) {
            String arrayIndex = objectPath.substring(objectPath.lastIndexOf(47) + 1);
            String listPath = objectPath.substring(1, objectPath.indexOf("/items"));
            int idx = Integer.parseInt(arrayIndex);
            ArrayNode references = (ArrayNode)asset.path(listPath).path("items");
            return references.get(idx);
        }
        String relationshipPath = objectPath.substring(1);
        if (log.isDebugEnabled()) {
            log.debug(" ... returning object: {}", (Object)asset.path(relationshipPath).toString());
        }
        return asset.path(relationshipPath);
    }

    private JsonNode consolidateChangedObject(JsonNode change, String changePath, JsonNode currentAsset) {
        ObjectNode consolidatedChange = (ObjectNode)change;
        String indexPath = changePath.substring(0, changePath.indexOf("/_id"));
        consolidatedChange.put("path", indexPath);
        JsonNode relatedAsset = this.getObjectFromIndex(indexPath, currentAsset);
        consolidatedChange.set("value", relatedAsset);
        return consolidatedChange;
    }

    public class Change {
        private JsonNode from;
        private String op;
        private String path;
        private JsonNode value;

        public Change(JsonNode patch, JsonNode from) {
            this.from = from;
            this.op = patch.get("op").asText();
            this.path = patch.get("path").asText();
            this.value = patch.get("value");
        }

        public String getOp() {
            return this.op;
        }

        public String getIgcPropertyName() {
            String[] aTokens = this.path.split("/");
            if (aTokens.length > 1) {
                return aTokens[1];
            }
            if (log.isErrorEnabled()) {
                log.error("Unable to find any property in path: {}", (Object)this.path);
            }
            return null;
        }

        public String getIgcPropertyPath() {
            return this.path;
        }

        public Object getNewValue(List<String> referenceListProperties) {
            return this.getValueFromJSON(this.value, referenceListProperties, this.getIgcPropertyPath());
        }

        public Object getOldValue(List<String> referenceListProperties) {
            Object oldValue = null;
            if (!this.getOp().equals("add")) {
                String path = this.getIgcPropertyPath();
                if (path.contains("/items/")) {
                    JsonNode obj = ChangeSet.this.getObjectFromIndex(path, this.from);
                    oldValue = this.getValueFromJSON(obj, referenceListProperties, path);
                } else {
                    String candidatePath = path;
                    if (candidatePath.startsWith("/")) {
                        candidatePath = candidatePath.substring(1);
                    }
                    oldValue = this.getValueFromJSON(this.from.path(candidatePath), referenceListProperties, path);
                }
            }
            return oldValue;
        }

        private Object getValueFromJSON(JsonNode node, List<String> referenceListProperties, String path) {
            Object value = null;
            JsonNodeType jsonType = node.getNodeType();
            switch (jsonType) {
                case NULL: {
                    value = null;
                    break;
                }
                case BOOLEAN: {
                    value = node.asBoolean();
                    break;
                }
                case NUMBER: {
                    value = node.asDouble();
                    break;
                }
                case OBJECT: {
                    if (referenceListProperties.contains(this.getIgcPropertyName()) && !path.contains("/items/")) {
                        value = ChangeSet.this.igcRestClient.readJSONIntoItemList(node.toString());
                        break;
                    }
                    value = ChangeSet.this.igcRestClient.readJSONIntoPOJO(node.toString());
                    break;
                }
                case STRING: {
                    value = node.asText();
                    break;
                }
                default: {
                    if (!log.isWarnEnabled()) break;
                    log.warn("Unhandled value type '{}': {}", (Object)jsonType, (Object)node);
                }
            }
            return value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Change: {");
            sb.append(" op=");
            sb.append(this.op);
            sb.append(", path=");
            sb.append(this.path);
            sb.append(", value=");
            sb.append(this.value.toString());
            sb.append("}");
            return sb.toString();
        }
    }
}

