/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCRelationshipGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.AttributeMappingStore;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ExternalStandardMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGCOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(IGCOMRSMetadataCollection.class);
    private IGCRestClient igcRestClient;
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private IGCRepositoryHelper igcRepositoryHelper;
    private TypeDefStore typeDefStore;
    private AttributeMappingStore attributeMappingStore;

    public IGCOMRSMetadataCollection(IGCOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        if (log.isDebugEnabled()) {
            log.debug("Constructing IGCOMRSMetadataCollection with name: {}", (Object)repositoryName);
        }
        parentConnector.setRepositoryName(repositoryName);
        this.igcRestClient = parentConnector.getIGCRestClient();
        this.igcomrsRepositoryConnector = parentConnector;
        this.igcRepositoryHelper = new IGCRepositoryHelper(this.igcomrsRepositoryConnector, repositoryHelper, this.igcRestClient);
        this.typeDefStore = new TypeDefStore();
        this.attributeMappingStore = new AttributeMappingStore(parentConnector);
    }

    public IGCRepositoryHelper getIgcRepositoryHelper() {
        return this.igcRepositoryHelper;
    }

    public TypeDefGallery getAllTypes(String userId) throws RepositoryErrorException, InvalidParameterException {
        String methodName = "getAllTypes";
        super.basicRequestValidation(userId, "getAllTypes");
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        if (log.isDebugEnabled()) {
            log.debug("Retrieved {} implemented TypeDefs for this repository.", (Object)typeDefs.size());
        }
        typeDefGallery.setTypeDefs(typeDefs);
        List<AttributeTypeDef> attributeTypeDefs = this.attributeMappingStore.getAllAttributeTypeDefs();
        if (log.isDebugEnabled()) {
            log.debug("Retrieved {} implemented AttributeTypeDefs for this repository.", (Object)attributeTypeDefs.size());
        }
        typeDefGallery.setAttributeTypeDefs(attributeTypeDefs);
        return typeDefGallery;
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        super.typeDefCategoryParameterValidation(userId, category, "category", "findTypeDefsByCategory");
        List<TypeDef> typeDefs = new ArrayList<TypeDef>();
        switch (category) {
            case ENTITY_DEF: {
                typeDefs = this.igcRepositoryHelper.getMappedEntityTypes();
                break;
            }
            case RELATIONSHIP_DEF: {
                typeDefs = this.igcRepositoryHelper.getMappedRelationshipTypes();
                break;
            }
            case CLASSIFICATION_DEF: {
                typeDefs = this.igcRepositoryHelper.getMappedClassificationTypes();
            }
        }
        return typeDefs;
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        super.attributeTypeDefCategoryParameterValidation(userId, category, "category", "findAttributeTypeDefsByCategory");
        return this.attributeMappingStore.getAttributeTypeDefsByCategory(category);
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        super.typeDefPropertyParameterValidation(userId, matchCriteria, "matchCriteria", "findTypeDefsByProperty");
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        List<TypeDef> results = new ArrayList<TypeDef>();
        if (matchCriteria != null) {
            Map properties = matchCriteria.getTypeDefProperties();
            for (TypeDef candidate : typeDefs) {
                List candidateProperties = candidate.getPropertiesDefinition();
                for (TypeDefAttribute candidateAttribute : candidateProperties) {
                    String candidateName = candidateAttribute.getAttributeName();
                    if (!properties.containsKey(candidateName)) continue;
                    results.add(candidate);
                }
            }
            results = typeDefs;
        }
        return results;
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException {
        ArrayList<TypeDef> results;
        String methodName = "findTypesByExternalID";
        super.typeDefExternalIDParameterValidation(userId, standard, organization, identifier, "findTypesByExternalID");
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        if (standard == null && organization == null && identifier == null) {
            results = typeDefs;
        } else {
            results = new ArrayList();
            for (TypeDef typeDef : typeDefs) {
                List externalStandardMappings = typeDef.getExternalStandardMappings();
                for (ExternalStandardMapping externalStandardMapping : externalStandardMappings) {
                    String candidateStandard = externalStandardMapping.getStandardName();
                    String candidateOrg = externalStandardMapping.getStandardOrganization();
                    String candidateId = externalStandardMapping.getStandardTypeName();
                    if (standard != null && !standard.equals(candidateStandard) || organization != null && !organization.equals(candidateOrg) || identifier != null && !identifier.equals(candidateId)) continue;
                    results.add(typeDef);
                }
            }
        }
        return results;
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        super.typeDefSearchParameterValidation(userId, searchCriteria, "searchCriteria", "searchForTypeDefs");
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>();
        for (TypeDef candidate : this.igcRepositoryHelper.getMappedEntityTypes()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        for (TypeDef candidate : this.igcRepositoryHelper.getMappedRelationshipTypes()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        for (TypeDef candidate : this.igcRepositoryHelper.getMappedClassificationTypes()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        return typeDefs;
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getTypeDefByGUID");
        TypeDef found = this.typeDefStore.getTypeDefByGUID(guid);
        if (found == null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guid, this.repositoryName);
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getTypeDefByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getAttributeTypeDefByGUID");
        AttributeTypeDef found = this.attributeMappingStore.getAttributeTypeDefByGUID(guid);
        if (found == null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.ATTRIBUTE_TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guid, this.repositoryName);
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getAttributeTypeDefByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getTypeDefByName");
        TypeDef found = this.typeDefStore.getTypeDefByName(name);
        if (found == null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(name, this.repositoryName);
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getTypeDefByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getAttributeTypeDefByName");
        AttributeTypeDef found = this.attributeMappingStore.getAttributeTypeDefByName(name);
        if (found == null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.ATTRIBUTE_TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(name, this.repositoryName);
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getAttributeTypeDefByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException {
        String methodName = "addTypeDef";
        String typeDefParameterName = "newTypeDef";
        super.newTypeDefParameterValidation(userId, newTypeDef, "newTypeDef", "addTypeDef");
        TypeDefCategory typeDefCategory = newTypeDef.getCategory();
        String omrsTypeDefName = newTypeDef.getName();
        if (log.isDebugEnabled()) {
            log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)typeDefCategory.getName());
        }
        StringBuilder sbMapperClassname = new StringBuilder();
        sbMapperClassname.append("org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.");
        switch (typeDefCategory) {
            case RELATIONSHIP_DEF: {
                sbMapperClassname.append("relationships.");
                break;
            }
            case CLASSIFICATION_DEF: {
                sbMapperClassname.append("classifications.");
                break;
            }
            case ENTITY_DEF: {
                sbMapperClassname.append("entities.");
            }
        }
        sbMapperClassname.append(omrsTypeDefName);
        sbMapperClassname.append("Mapper");
        try {
            Class<?> mappingClass = Class.forName(sbMapperClassname.toString());
            if (log.isDebugEnabled()) {
                log.debug(" ... found mapping class: {}", (Object)mappingClass.getCanonicalName());
            }
            boolean success = false;
            switch (typeDefCategory) {
                case RELATIONSHIP_DEF: {
                    success = this.igcRepositoryHelper.addRelationshipMapping(newTypeDef, mappingClass);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    success = this.igcRepositoryHelper.addClassificationMapping(newTypeDef, mappingClass);
                    break;
                }
                case ENTITY_DEF: {
                    success = this.igcRepositoryHelper.addEntityMapping(newTypeDef, mappingClass);
                }
            }
            if (!success) {
                this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(omrsTypeDefName, this.repositoryName);
                throw new TypeDefNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addTypeDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.typeDefStore.addTypeDef(newTypeDef);
        }
        catch (ClassNotFoundException e) {
            this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(omrsTypeDefName, this.repositoryName);
            throw new TypeDefNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addTypeDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        super.newAttributeTypeDefParameterValidation(userId, newAttributeTypeDef, "newAttributeTypeDef", "addAttributeTypeDef");
        AttributeTypeDefCategory attributeTypeDefCategory = newAttributeTypeDef.getCategory();
        String omrsTypeDefName = newAttributeTypeDef.getName();
        if (log.isDebugEnabled()) {
            log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)attributeTypeDefCategory.getName());
        }
        StringBuilder sbMapperClassname = new StringBuilder();
        sbMapperClassname.append("org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.");
        sbMapperClassname.append("attributes.");
        sbMapperClassname.append(omrsTypeDefName);
        sbMapperClassname.append("Mapper");
        try {
            Class<?> mappingClass = Class.forName(sbMapperClassname.toString());
            if (log.isDebugEnabled()) {
                log.debug(" ... found mapping class: {}", (Object)mappingClass.getCanonicalName());
            }
            this.attributeMappingStore.addMapping(newAttributeTypeDef, mappingClass);
        }
        catch (ClassNotFoundException e) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.ATTRIBUTE_TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(omrsTypeDefName, this.repositoryName);
            throw new TypeDefNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addAttributeTypeDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void verifyPropertiesForTypeDef(TypeDef typeDef, Set<String> mappedProperties, List<String> gaps) {
        TypeDefLink superTypeLink;
        List properties = typeDef.getPropertiesDefinition();
        if (properties != null) {
            for (TypeDefAttribute typeDefAttribute : properties) {
                String omrsPropertyName = typeDefAttribute.getAttributeName();
                if (mappedProperties.contains(omrsPropertyName)) continue;
                gaps.add(omrsPropertyName);
            }
        }
        if ((superTypeLink = typeDef.getSuperType()) != null) {
            String superTypeGUID = superTypeLink.getGUID();
            TypeDef superType = this.typeDefStore.getTypeDefByGUID(superTypeGUID);
            if (superType == null) {
                superType = this.typeDefStore.getUnimplementedTypeDefByGUID(superTypeGUID, true);
            }
            if (superType != null) {
                this.verifyPropertiesForTypeDef(superType, mappedProperties, gaps);
            }
        }
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, InvalidTypeDefException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        super.typeDefParameterValidation(userId, typeDef, "typeDef", "verifyTypeDef");
        String guid = typeDef.getGUID();
        if (this.typeDefStore.getUnimplementedTypeDefByGUID(guid, false) != null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(typeDef.getName(), this.repositoryName);
            throw new TypeDefNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "verifyTypeDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (this.typeDefStore.getTypeDefByGUID(guid) != null) {
            ArrayList<String> gaps = new ArrayList<String>();
            Set<String> mappedProperties = new HashSet<String>();
            switch (typeDef.getCategory()) {
                case ENTITY_DEF: {
                    EntityMapping entityMapping = this.igcRepositoryHelper.getEntityMappingByGUID(guid);
                    if (entityMapping == null) break;
                    mappedProperties = entityMapping.getAllMappedOmrsProperties();
                    break;
                }
                case RELATIONSHIP_DEF: {
                    RelationshipMapping relationshipMapping = this.igcRepositoryHelper.getRelationshipMappingByGUID(guid);
                    if (relationshipMapping == null) break;
                    mappedProperties = relationshipMapping.getMappedOmrsPropertyNames();
                    break;
                }
                case CLASSIFICATION_DEF: {
                    ClassificationMapping classificationMapping = this.igcRepositoryHelper.getClassificationMappingByGUID(guid);
                    if (classificationMapping == null) break;
                    mappedProperties = classificationMapping.getMappedOmrsPropertyNames();
                }
            }
            this.verifyPropertiesForTypeDef(typeDef, mappedProperties, gaps);
            if (!gaps.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn("Unable to verify type definition {} due to missing property mappings for: {}", (Object)typeDef.getName(), (Object)String.join((CharSequence)", ", gaps));
                }
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(typeDef.getName(), this.repositoryName);
                throw new TypeDefNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "verifyTypeDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            return true;
        }
        return false;
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, InvalidTypeDefException {
        boolean bImplemented;
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        super.attributeTypeDefParameterValidation(userId, attributeTypeDef, "attributeTypeDef", "verifyAttributeTypeDef");
        switch (attributeTypeDef.getCategory()) {
            case PRIMITIVE: 
            case COLLECTION: {
                bImplemented = true;
                break;
            }
            case ENUM_DEF: {
                bImplemented = this.attributeMappingStore.getAttributeTypeDefByGUID(attributeTypeDef.getGUID()) != null;
                break;
            }
            default: {
                bImplemented = false;
            }
        }
        return bImplemented;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        EntityDetail detail;
        block2: {
            String methodName = "isEntityKnown";
            super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
            detail = null;
            try {
                detail = this.getEntityDetail(userId, guid);
            }
            catch (EntityNotKnownException e) {
                if (!log.isInfoEnabled()) break block2;
                log.info("Entity {} not known to the repository.", (Object)guid, (Object)e);
            }
        }
        return detail;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        IGCEntityGuid igcGuid;
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        if (log.isDebugEnabled()) {
            log.debug("getEntitySummary with guid = {}", (Object)guid);
        }
        if ((igcGuid = IGCEntityGuid.fromGuid(guid)) == null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.ENTITY_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guid, "null", this.repositoryName);
            throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntitySummary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        String igcType = igcGuid.getAssetType();
        String prefix = igcGuid.getGeneratedPrefix();
        if (igcType.equals("main_object")) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.UNSUPPORTED_OBJECT_TYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guid, igcType, this.repositoryName);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntitySummary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        EntityMappingInstance entityMap = this.igcRepositoryHelper.getMappingInstanceForParameters(igcGuid.getAssetType(), igcGuid.getRid(), prefix, userId);
        if (entityMap == null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(prefix + igcType, this.repositoryName);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntitySummary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        EntitySummary summary = EntityMapping.getEntitySummary(entityMap);
        return summary;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        IGCEntityGuid igcGuid = IGCEntityGuid.fromGuid(guid);
        if (igcGuid == null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.ENTITY_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guid, "null", this.repositoryName);
            throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEntityDetail", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return this.igcRepositoryHelper.getEntityDetail(userId, igcGuid);
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<Relationship> alRelationships = new ArrayList<Relationship>();
        if (asOfTime != null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.NO_HISTORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (sequencingProperty != null || sequencingOrder != null && (sequencingOrder.equals((Object)SequencingOrder.PROPERTY_ASCENDING) || sequencingOrder.equals((Object)SequencingOrder.PROPERTY_DESCENDING))) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.NO_RELATIONSHIP_PROPERTIES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new PropertyErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            IGCEntityGuid igcGuid = IGCEntityGuid.fromGuid(entityGUID);
            if (igcGuid == null) {
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.ENTITY_NOT_KNOWN;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(entityGUID, "null", this.repositoryName);
                throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            String rid = igcGuid.getRid();
            String prefix = igcGuid.getGeneratedPrefix();
            String igcType = igcGuid.getAssetType();
            EntityMappingInstance entityMap = this.igcRepositoryHelper.getMappingInstanceForParameters(igcType, rid, prefix, userId);
            if (entityMap != null) {
                alRelationships.addAll(EntityMapping.getMappedRelationships(igcGuid, entityMap, relationshipTypeGUID, fromRelationshipElement, sequencingOrder, pageSize));
            } else {
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(prefix + igcType, this.repositoryName);
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
        return alRelationships.isEmpty() ? null : alRelationships;
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        ArrayList<EntityDetail> entityDetails;
        block8: {
            block9: {
                Identity identity;
                String unqualifiedName;
                String methodName = "findEntitiesByProperty";
                super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                entityDetails = new ArrayList<EntityDetail>();
                if (asOfTime != null) {
                    IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.NO_HISTORY;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
                    throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findEntitiesByProperty", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                if (limitResultsByStatus != null && (limitResultsByStatus.size() != 1 || !limitResultsByStatus.contains(InstanceStatus.ACTIVE))) break block8;
                if (matchProperties == null || matchProperties.getPropertyCount() != 1 || !((String)matchProperties.getPropertyNames().next()).equals("qualifiedName")) break block9;
                String qualifiedNameToFind = (String)((PrimitivePropertyValue)matchProperties.getInstanceProperties().get("qualifiedName")).getPrimitiveValue();
                log.debug("Short-circuiting find to qualifiedName search: {}", (Object)qualifiedNameToFind);
                if (!this.repositoryHelper.isExactMatchRegex(qualifiedNameToFind)) break block8;
                String qualifiedName = unqualifiedName = this.repositoryHelper.getUnqualifiedLiteralString(qualifiedNameToFind);
                String prefix = null;
                if (IGCRepositoryHelper.isQualifiedNameOfGeneratedEntity(unqualifiedName)) {
                    prefix = IGCRepositoryHelper.getPrefixFromGeneratedQualifiedName(unqualifiedName);
                    qualifiedName = IGCRepositoryHelper.getSearchableQualifiedName(unqualifiedName);
                    log.debug(" ... generated name with prefix {} and name: {}", (Object)prefix, (Object)qualifiedName);
                }
                if ((identity = Identity.getFromString((String)qualifiedName, (IGCRestClient)this.igcRestClient)) == null) break block8;
                String igcType = identity.getAssetType();
                EntityMapping mapper = this.igcRepositoryHelper.getEntityMappingByIgcType(igcType, prefix);
                if (mapper != null) {
                    boolean runSearch = true;
                    if (entityTypeGUID != null) {
                        String mappedOmrsTypeName = mapper.getOmrsTypeDefName();
                        TypeDef entityTypeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByProperty");
                        runSearch = this.repositoryHelper.isTypeOf(this.metadataCollectionId, mappedOmrsTypeName, entityTypeDef.getName());
                    }
                    if (runSearch) {
                        this.igcRepositoryHelper.processResultsForMapping(mapper, entityDetails, userId, matchProperties, matchCriteria, fromEntityElement, limitResultsByClassification, sequencingProperty, sequencingOrder, pageSize);
                    } else {
                        log.warn("Unable to confirm that the qualifiedName-embedded type ({}) is a subtype of the requested type ({}) -- skipping qualifiedName search.", (Object)mapper.getOmrsTypeDefName(), (Object)entityTypeGUID);
                    }
                } else {
                    log.warn("Unable to find a mapping for type {} with prefix {} -- skipping qualifiedName search.", (Object)igcType, (Object)prefix);
                }
                break block8;
            }
            List<EntityMapping> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (EntityMapping mapping : mappingsToSearch) {
                if (pageSize != 0 && (pageSize <= 0 || entityDetails.size() >= pageSize)) continue;
                this.igcRepositoryHelper.processResultsForMapping(mapping, entityDetails, userId, matchProperties, matchCriteria, fromEntityElement, limitResultsByClassification, sequencingProperty, sequencingOrder, pageSize);
            }
        }
        return entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        this.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        if (asOfTime != null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.NO_HISTORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findEntitiesByClassification", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            List<EntityMapping> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (EntityMapping mapping : mappingsToSearch) {
                ClassificationMapping foundMapping = null;
                List<ClassificationMapping> classificationMappings = mapping.getClassificationMappers();
                for (ClassificationMapping classificationMapping : classificationMappings) {
                    String candidateName = classificationMapping.getOmrsClassificationType();
                    if (!candidateName.equals(classificationName)) continue;
                    foundMapping = classificationMapping;
                    break;
                }
                if (foundMapping != null) {
                    IGCSearch igcSearch = new IGCSearch();
                    igcSearch.addType(mapping.getIgcAssetType());
                    IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
                    IGCRepositoryHelper.addTypeSpecificConditions(mapping, matchCriteria, null, igcSearchConditionSet);
                    IGCSearchConditionSet baseCriteria = foundMapping.getIGCSearchCriteria(matchClassificationProperties);
                    igcSearchConditionSet.addNestedConditionSet(baseCriteria);
                    IGCSearchSorting igcSearchSorting = null;
                    if (sequencingProperty == null && sequencingOrder != null) {
                        igcSearchSorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
                    }
                    IGCRepositoryHelper.setConditionsFromMatchCriteria(igcSearchConditionSet, matchCriteria);
                    igcSearch.addProperties(mapping.getAllPropertiesForEntityDetail(this.igcRestClient, mapping.getIgcAssetType()));
                    igcSearch.addConditions(igcSearchConditionSet);
                    this.igcRepositoryHelper.setPagingForSearch(igcSearch, fromEntityElement, pageSize);
                    if (igcSearchSorting != null) {
                        igcSearch.addSortingCriteria(igcSearchSorting);
                    }
                    this.igcRepositoryHelper.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), entityDetails, null, null, null, pageSize, userId);
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info("No classification mapping has been implemented for {} on entity {} -- skipping from search.", (Object)classificationName, (Object)mapping.getOmrsTypeDefName());
            }
        }
        return entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        if (asOfTime != null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.NO_HISTORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findEntitiesByPropertyValue", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            String unqualifiedName;
            String qualifiedName;
            Identity identity;
            if (this.repositoryHelper.isExactMatchRegex(searchCriteria) && (identity = Identity.getFromString((String)(qualifiedName = IGCRepositoryHelper.getSearchableQualifiedName(unqualifiedName = this.repositoryHelper.getUnqualifiedLiteralString(searchCriteria))), (IGCRestClient)this.igcRestClient, (boolean)false)) != null) {
                InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.repositoryName, null, "qualifiedName", searchCriteria, "findEntitiesByPropertyValue");
                return this.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, MatchCriteria.ALL, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            }
            List<EntityMapping> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (EntityMapping mapping : mappingsToSearch) {
                if (pageSize != 0 && (pageSize <= 0 || entityDetails.size() >= pageSize)) continue;
                IGCSearch igcSearch = new IGCSearch();
                String igcAssetType = this.igcRepositoryHelper.addTypeToSearch(mapping, igcSearch);
                ArrayList<String> properties = this.igcRestClient.getAllStringPropertiesForType(igcAssetType);
                Set<String> simpleMappedIgcProperties = mapping.getSimpleMappedIgcProperties();
                if (properties != null) {
                    IGCSearchConditionSet classificationLimiters = this.igcRepositoryHelper.getSearchCriteriaForClassifications(igcAssetType, limitResultsByClassification);
                    if (limitResultsByClassification != null && !limitResultsByClassification.isEmpty() && classificationLimiters == null) {
                        if (!log.isInfoEnabled()) continue;
                        log.info("Classification limiters were specified, but none apply to the asset type {}, so excluding this asset type from search.", (Object)igcAssetType);
                        continue;
                    }
                    IGCSearchConditionSet outerConditions = new IGCSearchConditionSet();
                    IGCRepositoryHelper.addTypeSpecificConditions(mapping, MatchCriteria.ALL, null, outerConditions);
                    if (searchCriteria != null && !searchCriteria.equals("")) {
                        if (this.igcRestClient.getIgcVersion().isEqualTo(IGCVersionEnum.V11702)) {
                            ArrayList<String> propertiesWithoutLongDescription = new ArrayList<String>();
                            for (String property : properties) {
                                if (property.equals("long_description")) continue;
                                propertiesWithoutLongDescription.add(property);
                            }
                            properties = propertiesWithoutLongDescription;
                        }
                        IGCSearchConditionSet innerConditions = new IGCSearchConditionSet();
                        innerConditions.setMatchAnyCondition(true);
                        for (String property : properties) {
                            if (!simpleMappedIgcProperties.contains(property)) continue;
                            innerConditions.addCondition(IGCRepositoryHelper.getRegexSearchCondition(this.repositoryHelper, this.repositoryName, "findEntitiesByPropertyValue", property, searchCriteria));
                        }
                        mapping.addComplexStringSearchCriteria(this.repositoryHelper, this.repositoryName, this.igcRestClient, innerConditions, searchCriteria);
                        outerConditions.addNestedConditionSet(innerConditions);
                    }
                    if (classificationLimiters != null) {
                        outerConditions.addNestedConditionSet(classificationLimiters);
                        outerConditions.setMatchAnyCondition(false);
                    }
                    IGCSearchSorting igcSearchSorting = null;
                    if (sequencingProperty == null && sequencingOrder != null) {
                        igcSearchSorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
                    }
                    igcSearch.addConditions(outerConditions);
                    this.igcRepositoryHelper.setPagingForSearch(igcSearch, fromEntityElement, pageSize);
                    if (igcSearchSorting != null) {
                        igcSearch.addSortingCriteria(igcSearchSorting);
                    }
                    igcSearch.addProperties(mapping.getAllPropertiesForEntityDetail(this.igcRestClient, igcAssetType));
                    this.igcRepositoryHelper.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), entityDetails, null, null, searchCriteria, pageSize, userId);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("Unable to find POJO to handle IGC asset type '{}' -- skipping search against this asset type.", (Object)igcAssetType);
            }
        }
        return entityDetails.isEmpty() ? null : entityDetails;
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        Relationship relationship;
        block2: {
            String methodName = "isRelationshipKnown";
            super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
            relationship = null;
            try {
                relationship = this.getRelationship(userId, guid);
            }
            catch (RelationshipNotKnownException e) {
                if (!log.isInfoEnabled()) break block2;
                log.info("Could not find relationship {} in repository.", (Object)guid, (Object)e);
            }
        }
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        Object errorCode;
        Reference proxyTwo;
        Reference proxyOne;
        RelationshipMapping relationshipMapping;
        String relationshipLevelRid;
        IGCRelationshipGuid igcRelationshipGuid;
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        if (log.isDebugEnabled()) {
            log.debug("Looking up relationship: {}", (Object)guid);
        }
        if ((igcRelationshipGuid = IGCRelationshipGuid.fromGuid(guid)) == null) {
            IGCOMRSErrorCode errorCode2 = IGCOMRSErrorCode.RELATIONSHIP_NOT_KNOWN;
            String errorMessage = errorCode2.getErrorMessageId() + errorCode2.getFormattedErrorMessage(guid, this.repositoryName);
            throw new RelationshipNotKnownException(errorCode2.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationship", errorMessage, errorCode2.getSystemAction(), errorCode2.getUserAction());
        }
        String proxyOneRid = igcRelationshipGuid.getRid1();
        String proxyTwoRid = igcRelationshipGuid.getRid2();
        String proxyOneType = igcRelationshipGuid.getAssetType1();
        String proxyTwoType = igcRelationshipGuid.getAssetType2();
        String omrsRelationshipName = igcRelationshipGuid.getRelationshipType();
        ArrayList<RelationshipMapping> mappings = new ArrayList<RelationshipMapping>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        String string = relationshipLevelRid = igcRelationshipGuid.isRelationshipLevelObject() ? proxyOneRid : null;
        if (relationshipLevelRid != null) {
            Reference relationshipAsset = this.igcRestClient.getAssetRefById(relationshipLevelRid);
            String relationshipAssetType = relationshipAsset.getType();
            relationshipMapping = this.igcRepositoryHelper.getRelationshipMappingByTypes(omrsRelationshipName, relationshipAssetType, relationshipAssetType);
            proxyOne = relationshipMapping.getProxyOneAssetFromAsset(relationshipAsset, this.igcRestClient).get(0);
            proxyTwo = relationshipMapping.getProxyTwoAssetFromAsset(relationshipAsset, this.igcRestClient).get(0);
            mappings.add(relationshipMapping);
        } else {
            Reference oneEnd = this.igcRestClient.getAssetRefById(proxyOneRid);
            proxyTwo = this.igcRestClient.getAssetRefById(proxyTwoRid);
            relationshipMapping = this.igcRepositoryHelper.getRelationshipMappingByTypes(omrsRelationshipName, proxyOneType, proxyTwoType);
            proxyOne = relationshipMapping.getProxyOneAssetFromAsset(oneEnd, this.igcRestClient).get(0);
            mappings.add(relationshipMapping);
        }
        if (mappings.isEmpty()) {
            IGCOMRSErrorCode errorCode3 = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode3.getErrorMessageId() + errorCode3.getFormattedErrorMessage(omrsRelationshipName, this.repositoryName);
            throw new RepositoryErrorException(errorCode3.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationship", errorMessage, errorCode3.getSystemAction(), errorCode3.getUserAction());
        }
        Relationship found = null;
        try {
            TypeDef relationshipTypeDef = this.getTypeDefByName(userId, omrsRelationshipName);
            RelationshipMapping.getMappedRelationships(this.igcomrsRepositoryConnector, relationships, mappings, relationshipTypeDef.getGUID(), proxyOne, proxyTwo, userId);
        }
        catch (TypeDefNotKnownException e) {
            IGCOMRSErrorCode errorCode4 = IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED;
            String errorMessage = errorCode4.getErrorMessageId() + errorCode4.getFormattedErrorMessage(omrsRelationshipName, this.repositoryName);
            throw new RepositoryErrorException(errorCode4.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationship", errorMessage, errorCode4.getSystemAction(), errorCode4.getUserAction());
        }
        if (relationships.isEmpty()) {
            errorCode = IGCOMRSErrorCode.RELATIONSHIP_NOT_KNOWN;
            String errorMessage = ((IGCOMRSErrorCode)((Object)errorCode)).getErrorMessageId() + ((IGCOMRSErrorCode)((Object)errorCode)).getFormattedErrorMessage(guid, this.repositoryName);
            throw new RelationshipNotKnownException(((IGCOMRSErrorCode)((Object)errorCode)).getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationship", errorMessage, ((IGCOMRSErrorCode)((Object)errorCode)).getSystemAction(), ((IGCOMRSErrorCode)((Object)errorCode)).getUserAction());
        }
        if (relationships.size() > 1) {
            for (Relationship relationship : relationships) {
                if (!relationship.getGUID().equals(guid)) continue;
                found = relationship;
            }
        } else {
            found = (Relationship)relationships.get(0);
        }
        if (found == null) {
            errorCode = IGCOMRSErrorCode.RELATIONSHIP_NOT_KNOWN;
            String errorMessage = ((IGCOMRSErrorCode)((Object)errorCode)).getErrorMessageId() + ((IGCOMRSErrorCode)((Object)errorCode)).getFormattedErrorMessage(guid, this.repositoryName);
            throw new RelationshipNotKnownException(((IGCOMRSErrorCode)((Object)errorCode)).getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationship", errorMessage, ((IGCOMRSErrorCode)((Object)errorCode)).getSystemAction(), ((IGCOMRSErrorCode)((Object)errorCode)).getUserAction());
        }
        return found;
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        this.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (asOfTime != null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.NO_HISTORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findRelationshipsByProperty", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            List<RelationshipMapping> mappingsToSearch = this.getRelationshipMappingsToSearch(relationshipTypeGUID, userId);
            for (RelationshipMapping mapping : mappingsToSearch) {
                IGCSearch igcSearch = mapping.getComplexIGCSearchCriteria(this.repositoryHelper, this.repositoryName, this.igcRestClient, matchProperties, matchCriteria);
                this.igcRepositoryHelper.setPagingForSearch(igcSearch, fromRelationshipElement, pageSize);
                this.igcRepositoryHelper.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), relationships, pageSize, userId);
            }
        }
        return relationships.isEmpty() ? null : relationships;
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyValue";
        this.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (asOfTime != null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.NO_HISTORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findRelationshipsByPropertyValue", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            List<RelationshipMapping> mappingsToSearch = this.getRelationshipMappingsToSearch(relationshipTypeGUID, userId);
            for (RelationshipMapping mapping : mappingsToSearch) {
                IGCSearch igcSearch = mapping.getComplexIGCSearchCriteria(this.repositoryHelper, this.repositoryName, this.igcRestClient, searchCriteria);
                this.igcRepositoryHelper.setPagingForSearch(igcSearch, fromRelationshipElement, pageSize);
                this.igcRepositoryHelper.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), relationships, pageSize, userId);
            }
        }
        return relationships.isEmpty() ? null : relationships;
    }

    public Map<String, TypeDefAttribute> getTypeDefAttributesForType(String omrsTypeName) {
        return this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeName);
    }

    private List<EntityMapping> getMappingsToSearch(String entityTypeGUID, String userId) throws InvalidParameterException, RepositoryErrorException {
        ArrayList<EntityMapping> mappingsToSearch = new ArrayList<EntityMapping>();
        if (entityTypeGUID == null) {
            for (EntityMapping candidate : this.igcRepositoryHelper.getAllEntityMappings()) {
                if (candidate.getOmrsTypeDefName().equals("Referenceable")) continue;
                mappingsToSearch.add(candidate);
            }
        } else {
            String requestedTypeName;
            EntityMapping mappingExact = this.igcRepositoryHelper.getEntityMappingByGUID(entityTypeGUID);
            if (mappingExact == null) {
                TypeDef unimplemented = this.typeDefStore.getUnimplementedTypeDefByGUID(entityTypeGUID);
                requestedTypeName = unimplemented.getName();
            } else {
                requestedTypeName = mappingExact.getOmrsTypeDefName();
            }
            List<TypeDef> allEntityTypes = this.findTypeDefsByCategory(userId, TypeDefCategory.ENTITY_DEF);
            for (TypeDef typeDef : allEntityTypes) {
                String typeDefName;
                EntityMapping implementedMapping = this.igcRepositoryHelper.getEntityMappingByGUID(typeDef.getGUID());
                if (implementedMapping == null || (typeDefName = typeDef.getName()).equals("Referenceable") || !this.repositoryHelper.isTypeOf(this.metadataCollectionId, typeDefName, requestedTypeName)) continue;
                mappingsToSearch.add(implementedMapping);
            }
        }
        return mappingsToSearch;
    }

    private List<RelationshipMapping> getRelationshipMappingsToSearch(String relationshipTypeGUID, String userId) {
        ArrayList<RelationshipMapping> mappingsToSearch = new ArrayList<RelationshipMapping>();
        if (relationshipTypeGUID == null) {
            for (RelationshipMapping candidate : this.igcRepositoryHelper.getAllRelationshipMappings()) {
                if (candidate.hasSubTypes()) continue;
                mappingsToSearch.add(candidate);
            }
        } else {
            RelationshipMapping mappingExact = this.igcRepositoryHelper.getRelationshipMappingByGUID(relationshipTypeGUID);
            if (mappingExact != null) {
                if (mappingExact.hasSubTypes()) {
                    mappingsToSearch.addAll(mappingExact.getSubTypes());
                } else {
                    mappingsToSearch.add(mappingExact);
                }
            }
        }
        return mappingsToSearch;
    }
}

