/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector;

import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Category;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.update.IGCCreate;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.OMRSStub;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;

public class IGCOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    private static final Logger log = LoggerFactory.getLogger(IGCOMRSRepositoryConnector.class);
    private IGCRestClient igcRestClient;
    private IGCVersionEnum igcVersion;
    private List<String> defaultZones;
    private String defaultGlossaryName;
    private String defaultTermStatus;
    private String defaultGlossaryRID;
    private boolean successfulInit;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        EndpointProperties endpointProperties;
        super.initialize(connectorInstanceId, connectionProperties);
        String methodName = "initialize";
        if (log.isDebugEnabled()) {
            log.debug("Initializing IGCOMRSRepositoryConnector...");
        }
        if ((endpointProperties = connectionProperties.getEndpoint()) == null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.REST_CLIENT_FAILURE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("null");
            throw new OMRSRuntimeException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        String address = endpointProperties.getProtocol() + "://" + endpointProperties.getAddress();
        String igcUser = connectionProperties.getUserId();
        String igcPass = connectionProperties.getClearPassword();
        this.defaultGlossaryName = "Default Glossary";
        this.defaultTermStatus = "CANDIDATE";
        Map proxyProperties = this.connectionBean.getConfigurationProperties();
        if (proxyProperties != null) {
            Object defaultTermStatus;
            Object defaultGlossaryName;
            Object zones = proxyProperties.get("defaultZones");
            if (zones != null) {
                this.defaultZones = (List)zones;
            }
            if ((defaultGlossaryName = proxyProperties.get("defaultGlossaryName")) != null && !defaultGlossaryName.equals("")) {
                this.defaultGlossaryName = (String)defaultGlossaryName;
            }
            if ((defaultTermStatus = proxyProperties.get("defaultTermStatus")) != null && !defaultTermStatus.equals("")) {
                this.defaultTermStatus = (String)defaultTermStatus;
            }
        }
        this.igcRestClient = new IGCRestClient(address, igcUser, igcPass);
        if (this.igcRestClient.isSuccessfullyInitialised()) {
            if (this.getMaxPageSize() > 0) {
                this.igcRestClient.setDefaultPageSize(this.getMaxPageSize());
            }
            this.igcVersion = this.igcRestClient.getIgcVersion();
            try {
                boolean success = this.upsertOMRSBundleZip();
                this.igcRestClient.registerPOJO(OMRSStub.class);
                this.successfulInit = success;
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to create necessary OMRS objects -- failing.", (Throwable)e);
                this.successfulInit = false;
            }
        } else {
            this.successfulInit = false;
        }
        if (!this.successfulInit) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.REST_CLIENT_FAILURE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(address);
            throw new OMRSRuntimeException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public IGCVersionEnum getIGCVersion() {
        return this.igcVersion;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
        if (this.successfulInit) {
            this.metadataCollection = new IGCOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, metadataCollectionId);
        }
    }

    public void disconnect() {
        this.igcRestClient.disconnect();
    }

    public OMRSMetadataCollection getMetadataCollection() {
        if (this.metadataCollection == null) {
            throw new NullPointerException("Local metadata collection id is not set up");
        }
        return this.metadataCollection;
    }

    public IGCRestClient getIGCRestClient() {
        return this.igcRestClient;
    }

    public List<String> getDefaultZones() {
        return this.defaultZones;
    }

    public String getDefaultTermStatus() {
        return this.defaultTermStatus;
    }

    public String getDefaultGlossaryRID() {
        if (this.defaultGlossaryRID == null) {
            IGCSearchCondition byName = new IGCSearchCondition("name", "=", this.defaultGlossaryName);
            IGCSearchCondition noParent = new IGCSearchCondition("parent_category", "isNull", Boolean.valueOf(false));
            IGCSearchConditionSet conditions = new IGCSearchConditionSet(byName);
            conditions.addCondition(noParent);
            IGCSearch igcSearch = new IGCSearch("category", conditions);
            ItemList results = this.igcRestClient.search(igcSearch);
            if (results == null || results.getItems().isEmpty()) {
                IGCCreate igcCreate = new IGCCreate("category");
                igcCreate.addProperty("name", this.defaultGlossaryName);
                this.defaultGlossaryRID = this.igcRestClient.create(igcCreate);
            } else {
                if (results.getItems().size() > 1 && log.isWarnEnabled()) {
                    log.warn("Found multiple entries for default glossary named '{}', returning only the first.", (Object)this.defaultGlossaryName);
                }
                this.defaultGlossaryRID = ((Category)results.getItems().get(0)).getId();
            }
        }
        return this.defaultGlossaryRID;
    }

    private boolean upsertOMRSBundleZip() throws RepositoryErrorException {
        String methodName = "upsertOMRSBundleZip";
        ClassPathResource bundleResource = new ClassPathResource("OMRS.zip");
        boolean success = this.igcRestClient.upsertOpenIgcBundle("OMRS", (AbstractResource)bundleResource);
        if (!success) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.OMRS_BUNDLE_FAILURE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("open");
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "upsertOMRSBundleZip", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return success;
    }
}

