/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMappingInstance {
    private static final Logger log = LoggerFactory.getLogger(EntityMappingInstance.class);
    private EntityMapping mapping;
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private IGCOMRSMetadataCollection igcomrsMetadataCollection;
    private String userId;
    private String igcEntityType;
    private String igcEntityRid;
    private List<String> igcPropertiesToRetrieve;
    private boolean alreadyRetrieved;
    private Reference igcEntity;
    private EntitySummary omrsSummary;
    private EntityDetail omrsDetail;
    private List<Classification> omrsClassifications;
    private List<Relationship> omrsRelationships;

    public EntityMappingInstance(EntityMapping mapping, IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String igcEntityType, String igcEntityRid, String userId) {
        Reference simple;
        this.mapping = mapping;
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
        this.igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        this.igcEntityType = igcEntityType;
        this.igcEntityRid = igcEntityRid;
        this.userId = userId;
        this.omrsRelationships = new ArrayList<Relationship>();
        this.omrsClassifications = new ArrayList<Classification>();
        this.alreadyRetrieved = false;
        if (igcomrsRepositoryConnector.getIGCRestClient().hasModificationDetails(igcEntityType)) {
            for (String property : IGCRestConstants.getModificationProperties()) {
                mapping.addComplexIgcProperty(property);
            }
        }
        if ((simple = mapping.getBaseIgcAssetFromAlternative(igcEntityType, igcEntityRid, igcomrsRepositoryConnector)) != null) {
            this.igcEntityType = simple.getType();
            this.igcEntityRid = simple.getId();
        }
    }

    public EntityMappingInstance(EntityMapping mapping, IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcEntity, String userId) {
        this.mapping = mapping;
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
        this.igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        this.igcEntity = igcEntity;
        this.igcEntityType = igcEntity.getType();
        this.igcEntityRid = igcEntity.getId();
        this.userId = userId;
        this.omrsRelationships = new ArrayList<Relationship>();
        this.omrsClassifications = new ArrayList<Classification>();
        this.alreadyRetrieved = true;
        Reference simple = mapping.getBaseIgcAssetFromAlternative(this.igcEntityType, this.igcEntityRid, igcomrsRepositoryConnector);
        if (simple != null && !simple.getId().equals(this.igcEntityRid)) {
            this.igcEntityType = simple.getType();
            this.igcEntityRid = simple.getId();
            this.alreadyRetrieved = false;
        }
    }

    public final EntityMapping getMapping() {
        return this.mapping;
    }

    public final IGCOMRSRepositoryConnector getRepositoryConnector() {
        return this.igcomrsRepositoryConnector;
    }

    public final IGCOMRSMetadataCollection getMetadataCollection() {
        return this.igcomrsMetadataCollection;
    }

    public final String getUserId() {
        return this.userId;
    }

    public final String getIgcEntityType() {
        return this.igcEntityType;
    }

    public final String getIgcEntityRid() {
        return this.igcEntityRid;
    }

    public final boolean isIgcEntityAlreadyRetrieved() {
        return this.alreadyRetrieved;
    }

    public final Reference getIgcEntity() {
        return this.igcEntity;
    }

    public final void setPropertiesToRetrieveForIgcEntity(List<String> properties) {
        this.igcPropertiesToRetrieve = properties;
    }

    public final void updateOmrsDetailWithProperties(InstanceProperties instanceProperties) {
        this.omrsDetail.setProperties(instanceProperties);
    }

    public final EntitySummary getOmrsSummary() {
        if (this.mapping.isOmrsType(this.igcomrsRepositoryConnector.getIGCRestClient(), this.igcEntity)) {
            return this.omrsSummary;
        }
        return null;
    }

    public final EntityDetail getOmrsDetail() {
        if (this.mapping.isOmrsType(this.igcomrsRepositoryConnector.getIGCRestClient(), this.igcEntity)) {
            return this.omrsDetail;
        }
        return null;
    }

    public List<Classification> getOmrsClassifications() {
        return this.omrsClassifications;
    }

    public List<Relationship> getOmrsRelationships() {
        return this.omrsRelationships;
    }

    public final void initializeEntitySummary() {
        if (this.omrsSummary == null) {
            this.omrsSummary = new EntitySummary();
            IGCEntityGuid igcEntityGuid = this.igcomrsMetadataCollection.getIgcRepositoryHelper().getEntityGuid(this.igcEntityType, this.mapping.getIgcRidPrefix(), this.igcEntityRid);
            this.omrsSummary.setGUID(igcEntityGuid.asGuid());
            if (!(this.alreadyRetrieved || this.igcEntity != null && this.igcEntity.isFullyRetrieved())) {
                this.igcEntity = this.igcomrsRepositoryConnector.getIGCRestClient().getAssetWithSubsetOfProperties(this.igcEntityRid, this.igcEntityType, this.igcPropertiesToRetrieve);
            }
            this.omrsSummary.setInstanceURL(this.igcEntity.getUrl());
        }
    }

    public final void initializeEntityDetail() {
        if (this.omrsDetail == null) {
            try {
                this.omrsDetail = this.igcomrsRepositoryConnector.getRepositoryHelper().getSkeletonEntity(this.igcomrsRepositoryConnector.getRepositoryName(), this.igcomrsRepositoryConnector.getMetadataCollectionId(), InstanceProvenanceType.LOCAL_COHORT, this.userId, this.mapping.getOmrsTypeDefName());
                this.omrsDetail.setStatus(InstanceStatus.ACTIVE);
                IGCEntityGuid igcEntityGuid = this.igcomrsMetadataCollection.getIgcRepositoryHelper().getEntityGuid(this.igcEntityType, this.mapping.getIgcRidPrefix(), this.igcEntityRid);
                this.omrsDetail.setGUID(igcEntityGuid.asGuid());
                if (!(this.alreadyRetrieved || this.igcEntity != null && this.igcEntity.isFullyRetrieved())) {
                    this.igcEntity = this.igcomrsRepositoryConnector.getIGCRestClient().getAssetWithSubsetOfProperties(this.igcEntityRid, this.igcEntityType, this.igcPropertiesToRetrieve);
                }
                this.omrsDetail.setInstanceURL(this.igcEntity.getUrl());
            }
            catch (TypeErrorException e) {
                log.error("Unable to get skeleton detail entity, defaulting to basic summary.", (Throwable)e);
            }
        }
    }

    public final void initializeWithRelationships(SequencingOrder sequencingOrder, int pageSize) {
        if (this.igcEntity == null || !this.igcEntity.isFullyRetrieved()) {
            ArrayList<String> allProperties = new ArrayList<String>();
            List<RelationshipMapping> relationshipMappers = this.mapping.getRelationshipMappers();
            for (RelationshipMapping relationshipMapping : relationshipMappers) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding properties from mapping: {}", (Object)relationshipMapping.getClass().getCanonicalName());
                }
                allProperties.addAll(relationshipMapping.getIgcRelationshipPropertiesForType(this.igcEntityType));
            }
            allProperties.addAll(IGCRestConstants.getModificationProperties());
            IGCSearchSorting sort = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
            this.igcEntity = this.igcomrsRepositoryConnector.getIGCRestClient().getAssetWithSubsetOfProperties(this.igcEntityRid, this.igcEntityType, allProperties, pageSize, sort);
        }
    }
}

