/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes;

import java.util.Date;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttributeMapping {
    private static final Logger log = LoggerFactory.getLogger(AttributeMapping.class);
    private IGCPropertyType igcPropertyType;
    private String omrsAttributeTypeDefName;
    private String igcAssetType;
    private String igcPropertyName;

    public AttributeMapping(IGCPropertyType igcPropertyType, String omrsAttributeTypeDefName) {
        this(null, null, igcPropertyType, omrsAttributeTypeDefName);
    }

    public AttributeMapping(String igcAssetType, String igcPropertyName, IGCPropertyType igcPropertyType, String omrsAttributeTypeDefName) {
        this.igcAssetType = igcAssetType;
        this.igcPropertyName = igcPropertyName;
        this.igcPropertyType = igcPropertyType;
        this.omrsAttributeTypeDefName = omrsAttributeTypeDefName;
    }

    public boolean isForGeneralAttribute() {
        return this.igcAssetType == null;
    }

    public boolean isForSpecificAttribute() {
        return !this.isForGeneralAttribute();
    }

    public String getIgcAssetType() {
        return this.igcAssetType;
    }

    public String getOmrsAttributeTypeDefName() {
        return this.omrsAttributeTypeDefName;
    }

    public IGCPropertyType getIgcPropertyType() {
        return this.igcPropertyType;
    }

    public boolean matchesProperty(String igcAssetType, String igcPropertyName) {
        return false;
    }

    public static InstanceProperties addPrimitivePropertyToInstance(OMRSRepositoryHelper omrsRepositoryHelper, String sourceName, InstanceProperties properties, TypeDefAttribute property, Object propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        block38: {
            resultingProperties = properties;
            if (propertyValue != null) {
                String propertyName = property.getAttributeName();
                if (property.getAttributeType().getCategory() == AttributeTypeDefCategory.PRIMITIVE) {
                    try {
                        PrimitiveDef primitiveDef = (PrimitiveDef)property.getAttributeType();
                        switch (primitiveDef.getPrimitiveDefCategory()) {
                            case OM_PRIMITIVE_TYPE_BOOLEAN: {
                                boolean booleanValue = propertyValue instanceof Boolean ? ((Boolean)propertyValue).booleanValue() : Boolean.valueOf(propertyValue.toString()).booleanValue();
                                resultingProperties = omrsRepositoryHelper.addBooleanPropertyToInstance(sourceName, properties, propertyName, booleanValue, methodName);
                                break;
                            }
                            case OM_PRIMITIVE_TYPE_INT: {
                                Integer intValue = null;
                                if (propertyValue instanceof Integer) {
                                    intValue = (Integer)propertyValue;
                                } else if (propertyValue instanceof Number) {
                                    intValue = ((Number)propertyValue).intValue();
                                } else {
                                    String propertyVal = propertyValue.toString();
                                    if (!propertyVal.equals("")) {
                                        intValue = Integer.valueOf(propertyVal);
                                    }
                                }
                                if (intValue != null) {
                                    resultingProperties = omrsRepositoryHelper.addIntPropertyToInstance(sourceName, properties, propertyName, intValue.intValue(), methodName);
                                    break;
                                }
                                break block38;
                            }
                            case OM_PRIMITIVE_TYPE_LONG: {
                                Long longValue = null;
                                if (propertyValue instanceof Long) {
                                    longValue = (Long)propertyValue;
                                } else if (propertyValue instanceof Number) {
                                    longValue = ((Number)propertyValue).longValue();
                                } else {
                                    String propertyVal = propertyValue.toString();
                                    if (!propertyVal.equals("")) {
                                        longValue = Long.valueOf(propertyVal);
                                    }
                                }
                                if (longValue != null) {
                                    resultingProperties = omrsRepositoryHelper.addLongPropertyToInstance(sourceName, properties, propertyName, longValue.longValue(), methodName);
                                    break;
                                }
                                break block38;
                            }
                            case OM_PRIMITIVE_TYPE_FLOAT: {
                                Float floatValue = null;
                                if (propertyValue instanceof Float) {
                                    floatValue = (Float)propertyValue;
                                } else if (propertyValue instanceof Number) {
                                    floatValue = Float.valueOf(((Number)propertyValue).floatValue());
                                } else {
                                    String propertyVal = propertyValue.toString();
                                    if (!propertyVal.equals("")) {
                                        floatValue = Float.valueOf(propertyVal);
                                    }
                                }
                                if (floatValue != null) {
                                    resultingProperties = omrsRepositoryHelper.addFloatPropertyToInstance(sourceName, properties, propertyName, floatValue.floatValue(), methodName);
                                    break;
                                }
                                break block38;
                            }
                            case OM_PRIMITIVE_TYPE_STRING: {
                                String stringValue = propertyValue instanceof String ? (String)propertyValue : propertyValue.toString();
                                if (stringValue != null && !stringValue.equals("")) {
                                    resultingProperties = omrsRepositoryHelper.addStringPropertyToInstance(sourceName, properties, propertyName, stringValue, methodName);
                                    break;
                                }
                                break block38;
                            }
                            case OM_PRIMITIVE_TYPE_DATE: {
                                if (propertyValue instanceof Date) {
                                    resultingProperties = omrsRepositoryHelper.addDatePropertyToInstance(sourceName, properties, propertyName, (Date)propertyValue, methodName);
                                    break;
                                }
                                if (log.isWarnEnabled()) {
                                    log.warn("Unable to parse date automatically -- must be first converted before passing in: {}", propertyValue);
                                    break;
                                }
                                break block38;
                            }
                            default: {
                                if (log.isErrorEnabled()) {
                                    log.error("Unhandled primitive type {} for {}", (Object)primitiveDef.getPrimitiveDefCategory(), (Object)propertyName);
                                    break;
                                }
                                break block38;
                            }
                        }
                    }
                    catch (ClassCastException e) {
                        if (log.isErrorEnabled()) {
                            log.error("Unable to cast {} to {} for {}", new Object[]{propertyValue, property.getAttributeType(), propertyName});
                        }
                        break block38;
                    }
                    catch (NumberFormatException e) {
                        if (log.isWarnEnabled()) {
                            log.warn("Unable to convert {} to {} for {}", new Object[]{propertyValue, property.getAttributeType(), propertyName});
                        }
                        break block38;
                    }
                }
                if (log.isErrorEnabled()) {
                    log.error("Cannot translate non-primitive property {} this way.", (Object)propertyName);
                }
            }
        }
        return resultingProperties;
    }

    public static String getIgcValueFromPropertyValue(InstancePropertyValue value) throws PropertyErrorException {
        String methodName = "getIgcValueFromPropertyValue";
        String igcValue = null;
        InstancePropertyCategory category = value.getInstancePropertyCategory();
        block0 : switch (category) {
            case PRIMITIVE: {
                PrimitivePropertyValue actualValue = (PrimitivePropertyValue)value;
                PrimitiveDefCategory primitiveType = actualValue.getPrimitiveDefCategory();
                switch (primitiveType) {
                    case OM_PRIMITIVE_TYPE_DATE: {
                        Long epoch = (Long)actualValue.getPrimitiveValue();
                        igcValue = "" + epoch;
                        break block0;
                    }
                }
                igcValue = actualValue.getPrimitiveValue().toString();
                break;
            }
            case ENUM: {
                igcValue = ((EnumPropertyValue)value).getSymbolicName();
                break;
            }
            case ARRAY: {
                igcValue = "[ ";
                Map arrayValues = ((ArrayPropertyValue)value).getArrayValues().getInstanceProperties();
                for (Map.Entry nextEntry : arrayValues.entrySet()) {
                    igcValue = igcValue + "\"" + AttributeMapping.getIgcValueFromPropertyValue((InstancePropertyValue)nextEntry.getValue()) + "\",";
                }
                if (igcValue.endsWith(",")) {
                    igcValue = igcValue.substring(0, igcValue.length() - 1);
                }
                igcValue = igcValue + " ]";
                break;
            }
            default: {
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.PROPERTY_CANNOT_BE_TRANSLATED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(value.toString(), category.getName());
                throw new PropertyErrorException(errorCode.getHTTPErrorCode(), AttributeMapping.class.getName(), "getIgcValueFromPropertyValue", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
        return igcValue;
    }

    public static enum IGCPropertyType {
        STRING,
        BOOLEAN,
        DATETIME,
        NUMBER,
        ENUM,
        STRING_ARRAY,
        NUMBER_ARRAY,
        DATETIME_ARRAY,
        REFERENCE,
        REFERENCE_LIST;

    }
}

