/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Term;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.update.IGCUpdate;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.GovernanceClassificationStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfidentialityMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(ConfidentialityMapper.class);

    public static ConfidentialityMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private ConfidentialityMapper() {
        super("main_object", "assigned_to_terms", "Referenceable", "Confidentiality");
        this.addLiteralPropertyMapping("status", GovernanceClassificationStatusMapper.getInstance(null).getEnumMappingByIgcValue(""));
        this.addLiteralPropertyMapping("confidence", 100);
        this.addLiteralPropertyMapping("steward", null);
        this.addLiteralPropertyMapping("source", null);
        this.addLiteralPropertyMapping("notes", null);
        this.addMappedOmrsProperty("level");
        this.addExcludedIgcAssetType("connector");
        this.addExcludedIgcAssetType("data_connection");
        this.addExcludedIgcAssetType("group");
        this.addExcludedIgcAssetType("information_governance_policy");
        this.addExcludedIgcAssetType("label");
        this.addExcludedIgcAssetType("user");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        String methodName = "addMappedOMRSClassification";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        ItemList assignedToTerms = (ItemList)igcRestClient.getPropertyByName(fromIgcObject, "assigned_to_terms");
        if (assignedToTerms != null) {
            assignedToTerms.getAllPages(igcRestClient);
            for (Reference assignedTerm : assignedToTerms.getItems()) {
                Identity termIdentity = assignedTerm.getIdentity(igcRestClient);
                Identity catIdentity = termIdentity.getParentIdentity();
                if (!catIdentity.toString().endsWith("Confidentiality")) continue;
                InstanceProperties classificationProperties = new InstanceProperties();
                String confidentialityName = assignedTerm.getName();
                int spaceIndex = confidentialityName.indexOf(" ");
                if (spaceIndex > 0) {
                    String level = confidentialityName.substring(0, spaceIndex);
                    if (level != null) {
                        try {
                            int parsedLevel = Integer.parseInt(level);
                            classificationProperties = igcomrsRepositoryConnector.getRepositoryHelper().addIntPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), classificationProperties, "level", parsedLevel, "addMappedOMRSClassification");
                        }
                        catch (NumberFormatException e) {
                            log.error("Unable to detect a level in the Confidentiality classification: {}", (Object)confidentialityName, (Object)e);
                        }
                    }
                    try {
                        Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                        classifications.add(classification);
                    }
                    catch (RepositoryErrorException e) {
                        log.error("Unable to map Confidentiality classification.", (Throwable)e);
                    }
                    continue;
                }
                log.error("Unable to detect a level in the Confidentiality classification: {}", (Object)confidentialityName);
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(InstanceProperties matchClassificationProperties) {
        Map properties;
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("assigned_to_terms.parent_category.name", "=", "Confidentiality");
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        if (matchClassificationProperties != null && (properties = matchClassificationProperties.getInstanceProperties()).containsKey("level")) {
            PrimitivePropertyValue levelValue = (PrimitivePropertyValue)properties.get("level");
            Integer level = (Integer)levelValue.getPrimitiveValue();
            String levelAsString = level.toString() + " ";
            IGCSearchCondition propertyCondition = new IGCSearchCondition("assigned_to_terms.name", "like {0}%", levelAsString);
            igcSearchConditionSet.addCondition(propertyCondition);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
        return igcSearchConditionSet;
    }

    @Override
    public void addClassificationToIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcEntity, String entityGUID, InstanceProperties initialProperties, String userId) throws RepositoryErrorException {
        String methodName = "addClassificationToIGCAsset";
        Map classificationProperties = null;
        if (initialProperties != null) {
            classificationProperties = initialProperties.getInstanceProperties();
        }
        if (classificationProperties == null || classificationProperties.isEmpty()) {
            log.error("Confidentiality classification requires the 'level' property for IGC.");
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_INSUFFICIENT_PROPERTIES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (classificationProperties.size() == 1 && classificationProperties.containsKey("level")) {
            PrimitivePropertyValue levelValue = (PrimitivePropertyValue)classificationProperties.get("level");
            Integer level = (Integer)levelValue.getPrimitiveValue();
            String levelAsString = level.toString() + " ";
            IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
            IGCSearchCondition findTerm = new IGCSearchCondition("name", "like {0}%", levelAsString);
            IGCSearchCondition inConfidentiality = new IGCSearchCondition("parent_category.name", "=", "Confidentiality");
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(findTerm);
            igcSearchConditionSet.addCondition(inConfidentiality);
            igcSearchConditionSet.setMatchAnyCondition(false);
            IGCSearch igcSearch = new IGCSearch("term", igcSearchConditionSet);
            ItemList results = igcRestClient.search(igcSearch);
            if (results == null || results.getPaging().getNumTotal() < 1) {
                if (log.isErrorEnabled()) {
                    log.error("No Confidentiality found with level: {}", (Object)levelAsString);
                }
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_NOT_FOUND;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (results.getPaging().getNumTotal() > 1 && log.isWarnEnabled()) {
                log.warn("Found multiple Confidentiality terms matching {}, taking the first.", (Object)levelAsString);
            }
            String confidentialityTermRid = ((Term)results.getItems().get(0)).getId();
            IGCUpdate igcUpdate = new IGCUpdate(igcEntity.getId());
            igcUpdate.addRelationship("assigned_to_terms", confidentialityTermRid);
            igcUpdate.setRelationshipUpdateMode(IGCUpdate.UpdateMode.APPEND);
            if (!igcRestClient.update(igcUpdate) && log.isErrorEnabled()) {
                log.error("Unable to update entity {} to add classification {}.", (Object)entityGUID, (Object)this.getOmrsClassificationType());
            }
        } else {
            log.error("More than only a 'level' property was provided for the Confidentiality classification.");
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_EXCEEDS_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), this.getIgcAssetType());
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    @Override
    public void removeClassificationFromIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcAsset, String entityGUID, String userId) throws RepositoryErrorException {
        String methodName = "removeClassificationFromIGCAsset";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        IGCSearchCondition thisTerm = new IGCSearchCondition("_id", "=", igcAsset.getId());
        IGCSearchCondition relatedToConfidentiality = new IGCSearchCondition("assigned_to_terms.parent_category.name", "=", "Confidentiality");
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(thisTerm);
        igcSearchConditionSet.addCondition(relatedToConfidentiality);
        igcSearchConditionSet.setMatchAnyCondition(false);
        IGCSearch igcSearch = new IGCSearch("term", igcSearchConditionSet);
        igcSearch.addProperty("assigned_to_terms");
        ItemList thisTermResults = igcRestClient.search(igcSearch);
        if (thisTermResults != null && thisTermResults.getPaging().getNumTotal() > 0) {
            IGCSearchCondition inConfidentiality = new IGCSearchCondition("parent_category.name", "=", "Confidentiality");
            igcSearchConditionSet = new IGCSearchConditionSet(inConfidentiality);
            igcSearch = new IGCSearch("term", igcSearchConditionSet);
            ItemList confidentialityTerms = igcRestClient.search(igcSearch);
            HashSet<String> confidentialityRids = new HashSet<String>();
            if (confidentialityTerms != null) {
                confidentialityTerms.getAllPages(igcRestClient);
                for (Term confidentialityTerm : confidentialityTerms.getItems()) {
                    confidentialityRids.add(confidentialityTerm.getId());
                }
            }
            IGCUpdate igcUpdate = new IGCUpdate(igcAsset.getId());
            ItemList assignedToTerms = (ItemList)igcRestClient.getPropertyByName((Reference)thisTermResults.getItems().get(0), "assigned_to_terms");
            assignedToTerms.getAllPages(igcRestClient);
            boolean bRemovedOne = false;
            for (Reference assignedToTerm : assignedToTerms.getItems()) {
                String assignedRid = assignedToTerm.getId();
                if (confidentialityRids.contains(assignedRid)) {
                    bRemovedOne = true;
                    if (assignedToTerms.getPaging().getNumTotal() != 1) continue;
                    igcUpdate.addRelationship("assigned_to_terms", null);
                    continue;
                }
                igcUpdate.addRelationship("assigned_to_terms", assignedRid);
            }
            if (bRemovedOne) {
                igcUpdate.setRelationshipUpdateMode(IGCUpdate.UpdateMode.REPLACE);
                if (!igcRestClient.update(igcUpdate)) {
                    if (log.isErrorEnabled()) {
                        log.error("Unable to update entity {} to remove classification {}.", (Object)entityGUID, (Object)this.getOmrsClassificationType());
                    }
                    IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_ERROR_UNKNOWN;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
                    throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "removeClassificationFromIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
            }
        }
    }

    private static class Singleton {
        private static final ConfidentialityMapper INSTANCE = new ConfidentialityMapper();

        private Singleton() {
        }
    }
}

