/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Category;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.update.IGCUpdate;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spine_Mapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(Spine_Mapper.class);

    protected Spine_Mapper(String omrsClassificationType) {
        super("term", "referencing_categories", "GlossaryTerm", omrsClassificationType);
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        ItemList candidates = (ItemList)igcRestClient.getPropertyByName(fromIgcObject, "referencing_categories");
        if (candidates != null) {
            candidates.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
            boolean foundSpine = false;
            for (Reference candidate : candidates.getItems()) {
                if (!candidate.getName().equals(this.getOmrsClassificationType())) continue;
                foundSpine = true;
                break;
            }
            if (foundSpine) {
                try {
                    Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, null, fromIgcObject, userId);
                    classifications.add(classification);
                }
                catch (RepositoryErrorException e) {
                    log.error("Unable to map {} classification.", (Object)this.getOmrsClassificationType(), (Object)e);
                }
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(InstanceProperties matchClassificationProperties) {
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("referencing_categories.name", "=", this.getOmrsClassificationType());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        igcSearchConditionSet.setMatchAnyCondition(false);
        return igcSearchConditionSet;
    }

    @Override
    public void addClassificationToIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcEntity, String entityGUID, InstanceProperties initialProperties, String userId) throws RepositoryErrorException {
        String methodName = "addClassificationToIGCAsset";
        Map classificationProperties = null;
        if (initialProperties != null) {
            classificationProperties = initialProperties.getInstanceProperties();
        }
        if (classificationProperties != null && !classificationProperties.isEmpty()) {
            if (log.isErrorEnabled()) {
                log.error("{} classification has no properties, yet properties were included: {}", (Object)this.getOmrsClassificationType(), (Object)initialProperties);
            }
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_EXCEEDS_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), this.getIgcAssetType());
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        IGCSearchCondition findCategory = new IGCSearchCondition("name", "=", this.getOmrsClassificationType());
        IGCSearchCondition findClassifications = new IGCSearchCondition("parent_category.name", "=", "Classifications");
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(findCategory);
        igcSearchConditionSet.addCondition(findClassifications);
        igcSearchConditionSet.setMatchAnyCondition(false);
        IGCSearch igcSearch = new IGCSearch("category", igcSearchConditionSet);
        ItemList results = igcRestClient.search(igcSearch);
        if (results == null || results.getPaging().getNumTotal() < 1) {
            log.error("No Classifications/{} category found -- cannot continue.", (Object)this.getOmrsClassificationType());
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (results.getPaging().getNumTotal() > 1) {
            log.warn("Found multiple {} categories, taking the first.", (Object)this.getOmrsClassificationType());
        }
        String spineCatRid = ((Category)results.getItems().get(0)).getId();
        IGCUpdate igcUpdate = new IGCUpdate(igcEntity.getId());
        igcUpdate.addRelationship("referencing_categories", spineCatRid);
        igcUpdate.setRelationshipUpdateMode(IGCUpdate.UpdateMode.APPEND);
        if (!igcRestClient.update(igcUpdate) && log.isErrorEnabled()) {
            log.error("Unable to update entity {} to add classification {}.", (Object)entityGUID, (Object)this.getOmrsClassificationType());
        }
    }

    @Override
    public void removeClassificationFromIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcAsset, String entityGUID, String userId) throws RepositoryErrorException {
        String methodName = "removeClassificationFromIGCAsset";
        IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_NOT_EDITABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "removeClassificationFromIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

