/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Category;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.update.IGCUpdate;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaMapper.class);

    public static SubjectAreaMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private SubjectAreaMapper() {
        super("category", "assigned_to_terms", "Referenceable", "SubjectArea");
        this.addMappedOmrsProperty("name");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        String methodName = "addMappedOMRSClassifications";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        ItemList assignedToTerms = (ItemList)igcRestClient.getPropertyByName(fromIgcObject, "assigned_to_terms");
        if (assignedToTerms != null) {
            assignedToTerms.getAllPages(igcRestClient);
            if (log.isDebugEnabled()) {
                log.debug("Looking for SubjectArea mapping within {} candidate terms.", (Object)assignedToTerms.getItems().size());
            }
            boolean isSubjectArea = false;
            for (Reference termCandidate : assignedToTerms.getItems()) {
                if (!termCandidate.getName().equals(this.getOmrsClassificationType())) continue;
                isSubjectArea = true;
                break;
            }
            if (isSubjectArea) {
                if (log.isDebugEnabled()) {
                    log.debug(" ... found SubjectArea classification.");
                }
                InstanceProperties classificationProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), null, "name", fromIgcObject.getName(), "addMappedOMRSClassifications");
                try {
                    Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                    classifications.add(classification);
                }
                catch (RepositoryErrorException e) {
                    log.error("Unable to map classification.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(InstanceProperties matchClassificationProperties) {
        Map properties;
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("assigned_to_terms.name", "=", this.getOmrsClassificationType());
        IGCSearchConditionSet subjectArea = new IGCSearchConditionSet(igcSearchCondition);
        IGCSearchConditionSet byName = new IGCSearchConditionSet();
        if (matchClassificationProperties != null && (properties = matchClassificationProperties.getInstanceProperties()).containsKey("name")) {
            PrimitivePropertyValue name = (PrimitivePropertyValue)properties.get("name");
            String subjectAreaName = (String)name.getPrimitiveValue();
            IGCSearchCondition propertyCondition = new IGCSearchCondition("parent_category.name", "=", subjectAreaName);
            byName.addCondition(propertyCondition);
            IGCSearchCondition propertyCondition2 = new IGCSearchCondition("parent_category.parent_category.name", "=", subjectAreaName);
            byName.addCondition(propertyCondition2);
            byName.setMatchAnyCondition(true);
        }
        if (byName.size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(subjectArea);
            igcSearchConditionSet.addNestedConditionSet(byName);
            igcSearchConditionSet.setMatchAnyCondition(false);
            return igcSearchConditionSet;
        }
        return subjectArea;
    }

    @Override
    public void addClassificationToIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcEntity, String entityGUID, InstanceProperties initialProperties, String userId) throws RepositoryErrorException {
        String methodName = "addClassificationToIGCAsset";
        Map classificationProperties = null;
        if (initialProperties != null) {
            classificationProperties = initialProperties.getInstanceProperties();
        }
        if (classificationProperties == null || classificationProperties.isEmpty()) {
            log.error("SubjectArea classification requires the 'name' property for IGC.");
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_INSUFFICIENT_PROPERTIES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (classificationProperties.size() == 1 && classificationProperties.containsKey("name")) {
            String subjectAreaName = (String)((PrimitivePropertyValue)classificationProperties.get("name")).getPrimitiveValue();
            IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
            IGCSearchCondition findCategory = new IGCSearchCondition("name", "=", subjectAreaName);
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(findCategory);
            IGCSearchCondition inSubjectArea = new IGCSearchCondition("assigned_to_terms.name", "=", this.getOmrsClassificationType());
            igcSearchConditionSet.addCondition(inSubjectArea);
            igcSearchConditionSet.setMatchAnyCondition(false);
            IGCSearch igcSearch = new IGCSearch("category", igcSearchConditionSet);
            ItemList results = igcRestClient.search(igcSearch);
            if (results == null || results.getPaging().getNumTotal() < 1) {
                if (log.isErrorEnabled()) {
                    log.error("No SubjectArea found with name: {}", (Object)subjectAreaName);
                }
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_NOT_FOUND;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), entityGUID);
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (results.getPaging().getNumTotal() > 1 && log.isWarnEnabled()) {
                log.warn("Found multiple SubjectArea categories matching {}, taking the first.", (Object)subjectAreaName);
            }
            String subjectAreaCatRid = ((Category)results.getItems().get(0)).getId();
            IGCUpdate igcUpdate = new IGCUpdate(igcEntity.getId());
            igcUpdate.addExclusiveRelationship("parent_category", subjectAreaCatRid);
            if (!igcRestClient.update(igcUpdate) && log.isErrorEnabled()) {
                log.error("Unable to update entity {} to add classification {}.", (Object)entityGUID, (Object)this.getOmrsClassificationType());
            }
        } else {
            log.error("More than only a 'name' property was provided for the SubjectArea classification.");
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.CLASSIFICATION_EXCEEDS_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getOmrsClassificationType(), this.getIgcAssetType());
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationToIGCAsset", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    @Override
    public void removeClassificationFromIGCAsset(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcAsset, String entityGUID, String userId) throws RepositoryErrorException {
        String methodName = "removeClassificationFromIGCAsset";
        this.reportImmutableClassification("removeClassificationFromIGCAsset", entityGUID);
    }

    private static class Singleton {
        private static final SubjectAreaMapper INSTANCE = new SubjectAreaMapper();

        private Singleton() {
        }
    }
}

