/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.CategoryAnchorMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.TermAnchorMapper;

public class GlossaryMapper
extends ReferenceableMapper {
    public static final String IGC_RID_PREFIX = "GL";

    public static GlossaryMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private GlossaryMapper() {
        super("category", "Category", "Glossary", IGC_RID_PREFIX);
        this.addSimplePropertyMapping("name", "displayName");
        this.addSimplePropertyMapping("short_description", "description");
        this.addSimplePropertyMapping("language", "language");
        this.addSimplePropertyMapping("long_description", "usage");
        this.addRelationshipMapper(CategoryAnchorMapper.getInstance(null));
        this.addRelationshipMapper(TermAnchorMapper.getInstance(null));
    }

    public static boolean isGlossary(IGCRestClient igcRestClient, Reference igcObject) {
        String assetType = IGCRestConstants.getAssetTypeForSearch((String)igcObject.getType());
        if (assetType.equals("category")) {
            Identity catIdentity = igcObject.getIdentity(igcRestClient);
            Identity parentIdentity = catIdentity.getParentIdentity();
            return parentIdentity == null && !catIdentity.getName().equals("Classifications");
        }
        return false;
    }

    @Override
    public boolean isOmrsType(IGCRestClient igcRestClient, Reference igcObject) {
        return GlossaryMapper.isGlossary(igcRestClient, igcObject);
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria() {
        IGCSearchCondition rootLevel = new IGCSearchCondition("parent_category", "isNull", Boolean.valueOf(false));
        IGCSearchCondition notClassification = new IGCSearchCondition("name", "=", "Classifications", Boolean.valueOf(true));
        IGCSearchConditionSet conditions = new IGCSearchConditionSet(rootLevel);
        conditions.addCondition(notClassification);
        conditions.setMatchAnyCondition(false);
        return conditions;
    }

    private static class Singleton {
        private static final GlossaryMapper INSTANCE = new GlossaryMapper();

        private Singleton() {
        }
    }
}

