/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.AttachedTagMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.SemanticAssignmentMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceableMapper
extends EntityMapping {
    private static final Logger log = LoggerFactory.getLogger(ReferenceableMapper.class);

    public static ReferenceableMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private ReferenceableMapper() {
        this("main_object", "Main Object", "Referenceable");
    }

    protected ReferenceableMapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName, String igcRidPrefix) {
        this(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, igcRidPrefix, true);
    }

    protected ReferenceableMapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName) {
        this(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, null, true);
    }

    protected ReferenceableMapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName, String igcRidPrefix, boolean includeDefaultRelationships) {
        super(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, igcRidPrefix);
        if (includeDefaultRelationships) {
            this.addRelationshipMapper(SemanticAssignmentMapper.getInstance(null));
            this.addRelationshipMapper(AttachedTagMapper.getInstance(null));
        }
        this.addComplexOmrsProperty("qualifiedName");
        this.addComplexOmrsProperty("additionalProperties");
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        String methodName = "complexPropertyMappings";
        Reference igcEntity = entityMap.getIgcEntity();
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        EntityMapping mapping = entityMap.getMapping();
        OMRSRepositoryHelper omrsRepositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        String qualifiedName = igcEntity.getIdentity(igcomrsRepositoryConnector.getIGCRestClient()).toString();
        if (mapping.igcRidNeedsPrefix()) {
            qualifiedName = IGCRepositoryHelper.getQualifiedNameForGeneratedEntity(mapping.getIgcRidPrefix(), qualifiedName);
        }
        instanceProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), instanceProperties, "qualifiedName", qualifiedName, "complexPropertyMappings");
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        List nonRelationshipProperties = igcRestClient.getNonRelationshipPropertiesForType(igcEntity.getType());
        Set<String> alreadyMapped = mapping.getAllMappedIgcProperties();
        for (ClassificationMapping classificationMapping : mapping.getClassificationMappers()) {
            alreadyMapped.addAll(classificationMapping.getMappedIgcPropertyNames());
        }
        if (nonRelationshipProperties != null) {
            HashSet nonRelationshipsSet = new HashSet(nonRelationshipProperties);
            nonRelationshipsSet.removeAll(alreadyMapped);
            nonRelationshipsSet.removeAll(IGCRestConstants.getModificationProperties());
            for (String propertyName : nonRelationshipsSet) {
                Object propertyValue = igcRestClient.getPropertyByName(igcEntity, propertyName);
                String value = null;
                if (propertyValue instanceof ArrayList) {
                    StringBuilder sb = new StringBuilder();
                    List list = (List)propertyValue;
                    if (!list.isEmpty()) {
                        for (int i = 0; i < list.size() - 1; ++i) {
                            sb.append(list.get(i).toString() + ", ");
                        }
                        sb.append(list.get(list.size() - 1));
                    }
                    value = sb.toString();
                } else if (propertyValue != null) {
                    value = propertyValue.toString();
                }
                if (value == null || value.equals("")) continue;
                additionalProperties.put(propertyName, value);
            }
            instanceProperties = omrsRepositoryHelper.addStringMapPropertyToInstance(repositoryName, instanceProperties, "additionalProperties", additionalProperties, "complexPropertyMappings");
        }
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, InstancePropertyValue value) throws FunctionNotSupportedException {
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("qualifiedName")) {
            if (log.isDebugEnabled()) {
                log.debug("Adding complex search criteria for: qualifiedName");
            }
            String qualifiedName = ((PrimitivePropertyValue)value).getPrimitiveValue().toString();
            String unqualifiedName = repositoryHelper.getUnqualifiedLiteralString(qualifiedName);
            unqualifiedName = IGCRepositoryHelper.getSearchableQualifiedName(unqualifiedName);
            if (log.isDebugEnabled()) {
                log.debug("Looking up identity: {}", (Object)unqualifiedName);
            }
            Identity identity = Identity.getFromString((String)unqualifiedName, (IGCRestClient)igcRestClient);
            boolean skip = false;
            if (repositoryHelper.isContainsRegex(qualifiedName) || repositoryHelper.isStartsWithRegex(qualifiedName) || repositoryHelper.isEndsWithRegex(qualifiedName)) {
                if (identity != null) {
                    if (log.isDebugEnabled()) {
                        log.debug(". . .found identity: {}", (Object)identity.toString());
                    }
                    IGCSearchConditionSet nested = identity.getSearchCriteria();
                    igcSearchConditionSet.addNestedConditionSet(nested);
                } else {
                    if (log.isInfoEnabled()) {
                        log.info("Unable to find identity '{}' -- skipping.", (Object)qualifiedName);
                    }
                    skip = true;
                }
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.REGEX_NOT_IMPLEMENTED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(repositoryName, qualifiedName);
                throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), IGCOMRSMetadataCollection.class.getName(), "addComplexPropertySearchCriteria", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (repositoryHelper.isExactMatchRegex(qualifiedName)) {
                if (identity != null) {
                    String igcType;
                    if (log.isDebugEnabled()) {
                        log.debug(". . .found identity: {}", (Object)identity.toString());
                    }
                    if ((igcType = IGCRestConstants.getAssetTypeForSearch((String)identity.getAssetType())).equals(this.getIgcAssetType()) || this.getOtherIGCAssetTypes().contains(igcType)) {
                        IGCSearchConditionSet nested = identity.getSearchCriteria();
                        igcSearchConditionSet.addNestedConditionSet(nested);
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info("Search type did not match identity type -- skipping.");
                        }
                        skip = true;
                    }
                } else {
                    if (log.isInfoEnabled()) {
                        log.info("Unable to find identity '{}' -- skipping.", (Object)qualifiedName);
                    }
                    skip = true;
                }
            } else {
                IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.REGEX_NOT_IMPLEMENTED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(repositoryName, qualifiedName);
                throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), IGCOMRSMetadataCollection.class.getName(), "addComplexPropertySearchCriteria", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (skip) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding search condition to ensure no results.");
                }
                IGCSearchConditionSet byName = new IGCSearchConditionSet(IGCRestConstants.getConditionToForceNoSearchResults());
                igcSearchConditionSet.addNestedConditionSet(byName);
            }
        } else if (omrsPropertyName.equals("additionalProperties")) {
            if (log.isDebugEnabled()) {
                log.debug("Adding complex search criteria for: additionalProperties");
            }
            Map mapValues = ((MapPropertyValue)value).getMapValues().getInstanceProperties();
            for (Map.Entry nextEntry : mapValues.entrySet()) {
                IGCRepositoryHelper.addIGCSearchConditionFromValue(repositoryHelper, repositoryName, igcSearchConditionSet, (String)nextEntry.getKey(), (InstancePropertyValue)nextEntry.getValue());
            }
        }
    }

    @Override
    public void addComplexStringSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String searchCriteria) throws FunctionNotSupportedException {
        super.addComplexStringSearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, searchCriteria);
        String methodName = "addComplexStringSearchCriteria";
        List stringPropertiesForType = igcRestClient.getAllStringPropertiesForType(IGCRestConstants.getAssetTypeForSearch((String)this.getIgcAssetType()));
        for (String propertyName : this.getComplexMappedIgcProperties()) {
            if (!stringPropertiesForType.contains(propertyName) || propertyName.equals("modified_by") || propertyName.equals("created_by")) continue;
            IGCSearchCondition condition = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexStringSearchCriteria", propertyName, searchCriteria);
            igcSearchConditionSet.addCondition(condition);
        }
    }

    private static class Singleton {
        private static final ReferenceableMapper INSTANCE = new ReferenceableMapper();

        private Singleton() {
        }
    }
}

